/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RXFUNC_H
#define RXFUNC_H
#include <QThread>
#include "sstvparam.h"



extern unsigned int modeComboBoxIndexSSTV;
extern efaxMode modeIndexFAX;

extern bool selectFax;


class syncProcessor;
class filter;
class modeBase;

class rxFunction: public QThread
{
public:
  enum erxState {HUNTING,PROCESSING,RESTART,SYNCLOST,END,WAIT};
	enum erxMode {SSTV,FAX};
	rxFunction();
	~rxFunction();
	void run();
	void retraceVertical(void);
  void syncLost();
  void restart();
	void abort(){abortRun=TRUE;}
  modeBase *currentMode;
	QString *getModeString (void){ return &lastUsedMode;}
  void setFilter(int fIndex);
  bool create(esstvMode m,DSPFLOAT clock);
  void logStatus();
  bool isReadingImage() {return rxState!=HUNTING;}
  bool saveOK();
  void setState(erxState st);


private:
	bool abortRun;
	void init();
  void getData();
	void runSSTV();
	void runFAX();
	unsigned long sampleCounter;
	unsigned long syncPosition;
	short int tempBuf[RXSTRIPE];
	syncProcessor *syncProc;
	filter *rxFilter;
	erxState rxState;
	erxMode  rxMode;
  int bufferCount;
  unsigned long rewindPosition;
	QString lastUsedMode;
  QMutex mutex;
};

#endif
