/***************************************************************************
 *   Copyright (C) 2008 by Johan Maes                                      *
 *   on4qz@telenet.be                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SCOPEPLOT_H
#define SCOPEPLOT_H
#include <QtGui>
#include "ui_plotform.h"
#include <qwt_plot.h>

class QwtPlotCurve;
class QwtPlotMarker;
class QwtPlotPicker;



/**Data  plotting in scope format
  *@author Johan Maes -- ON4QZ 
  */

class scopePlot : public QMainWindow  {
   Q_OBJECT
public: 
	scopePlot(QString title,QWidget *parent=0);
	~scopePlot();
	void setXScaleMultiplier(double mul)
		{
			xPrimeScaleMul=mul;
		}
	void setAlternativeScaleMultiplier(double mul)
		{
			xAltScaleMul=mul;
		}
  void init(QString title=QString::null);
  void plot1D(short int *data, unsigned long len,QString curveName,QString xLabel,QString yLeftLabel);
  void plot1D(double *data, unsigned long len,QString curveName,QString xLabel,QString yLeftLabel);
  void addYR(double *data, unsigned long len,QString curveName,QString yLeftLabel);
  void add3(double *data, unsigned long len,QString curveName);
  void add4(double *data, unsigned long len,QString curveName);
  void plot(QString name,QString xLabel,QString yLeftLabel);
  void plotYR(QString curveName,QString yRightLabel);
	void plot3(QString curveName);
  void plot4(QString curveName);
	void plotData(unsigned int size,
											short int * iData, QString curve1Name,QString xLabel, QString yLLabel,
											double * dData, QString curve2Name, QString yRLabel);
	void plotData(unsigned int size,
											double * dData1, QString curve1Name,QString xLabel, QString yLLabel,
											double * dData2, QString curve2Name, QString yRLabel);
											
											
	void show();
	void plot1DUpdate(double *data);
  void XYL(unsigned int i,int ix,int iy)
    {
      x[i]=(double)ix;
      yl[i]=(double)iy;
    }
  void X(unsigned int i,int ix)
    {
      x[i]=(double)ix;
      
    }
  void YL(unsigned int i,int iy)
    {
      yl[i]=(double)iy;
    }
  void YR(unsigned int i,int iy)
    {
      yr[i]=(double)iy;

    }
  void XYLYR(unsigned int i,int ix,int iyl,int iyr)
    {
      x[i]=(double)ix;
      yl[i]=(double)iyl;
      yr[i]=(double)iyr;
    }

  void XYL(unsigned int i,double ix,double iy)
    {
      x[i]=ix;
      yl[i]=iy;
    }
    
  void X(unsigned int i,double ix)
    {
      x[i]=ix;

    }
  void YL(unsigned int i,double iy)
    {
      yl[i]=iy;
    }
  void YR(unsigned int i,double iy)
    {
      yr[i]=iy;

    }
  void XYLYR(unsigned int i,double ix,double iyl,double iyr)
    {
      x[i]=ix;
      yl[i]=iyl;
      yr[i]=iyr;
    }
  void resize(unsigned long i)
    {
      x.resize(i);
      yl.resize(i);
      yr.resize(i);
    }
	void refresh();
public slots:
	void slotZoom(bool b);
	void slotOffsetChanged(double offset);
	void slotRangeChanged(double range);
//	void pickerMoved(const QPoint &);
	void pickerSelected(const QwtDoublePoint &);
//  void plotMouseMoved(const QMouseEvent &e);
//	void plotMouseReleased(const QMouseEvent &e);
	void legendClicked(QwtPlotItem *pi);
	void slotNext()
		{
			emit next();
		}
	void slotPrevious()
		{
			emit previous();
		}
	void slotSamplesButtton();
signals:
	void next();
	void previous();  
private:
	QwtPlot *plW;
	QToolBar *toolsToolbar;
	QMenu *toolsMenu;
	QAction *zoomAction;
//	plotForm *pl;

	QVector<double> x;
	QVector<double> yl;
	QVector<double> yr;
	QVector<double> c3;
  QVector<double> c4;
	double startPoint;
	double endPoint;
	double dispCenter;

	
	void initActions();
	void initMenuBar();
	void initToolBar();
	void initStatusBar();
	void setupWheels(int size);
	double xScaleMul;
	double xPrimeScaleMul;
	double xAltScaleMul;
	bool setup;
	long int mrk1,mrk2;
	void showMarker();
	bool toggleMarker;
	bool showCrv1;
	bool showCrv2;
	bool showCrv3;
  bool showCrv4;
	Ui::plotForm ui;
	QWidget *wd;

	QwtPlotCurve *curve1; 
	QwtPlotCurve *curve2;
	QwtPlotCurve *curve3;
  QwtPlotCurve *curve4;
	QwtPlotMarker *marker1;
	QwtPlotMarker *marker2;
	QwtLegend *legend;
	QwtPlotPicker *picker;
	double range;

};

#endif
