#ifndef DRMTRANSMITTER_H
#define DRMTRANSMITTER_H

#include "common/GlobalDefinitions.h"
#include "common/DrmTransmitter.h"

struct drmTxParams
{
  int robMode;
  int qam;
  int bandwith;
  int interleaver;
  int protection;
  QString callsign;
  int reedSolomon;
};


class drmTransmitter
{
public:
  drmTransmitter();
  ~drmTransmitter();
  void init(QByteArray *ba, QString name, QString format, drmTxParams params);
  void start(bool startTx);
  double getDuration() {return duration;} // expressed in seconds
  double transmissionTime;
private:
  CDRMTransmitter *DRMTransmitter;
  CParameter* TransmParam ;
  int dataLength;
  double duration;
};

drmTxParams modeToParams(uint mode);
uint paramsToMode(drmTxParams prm);
extern int numTxFrames;

#endif // DRMTRANSMITTER_H
