/***************************************************************************
 *   Copyright (C) 2004 by Johan Maes - ON4QZ                              *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "filterparam.h"



#ifdef DWSBANDPASS
// rFIR
// localSamplingrate = 48000.000000
// number of taps = 360
// Band0 Lower=0.000000, Upper=50.000000, Desired=0.000000, Weight=1.000000
// Band1 Lower=250.000000, Upper=2700.000000, Desired=1.000000, Weight=8.000000
// Band2 Lower=2900.000000, Upper=24000.000000, Desired=0.000000, Weight=2.000000
//Coefficients:
const FILTERPARAMTYPE downSampleFilterParam[DSAMPLEFILTERLEN]=
{
  -0.00151718585312103,
  0.000309665297865725,
  0.000266770230632739,
  0.000220107262717653,
  0.00017069787890033,
  0.000119558768317707,
  6.7937235925543e-05,
  1.73219175796899e-05,
  -3.04504220475478e-05,
  -7.32505140153168e-05,
  -0.000108809984498506,
  -0.000134931038254037,
  -0.000149757016582148,
  -0.000152098343880838,
  -0.00014173987237634,
  -0.000119585246451574,
  -8.77350358596666e-05,
  -5.09192816488034e-05,
  -8.16419424981514e-06,
  2.40226851297579e-05,
  5.3136899043456e-05,
  6.99684228232289e-05,
  6.87817534604667e-05,
  4.87441013458151e-05,
  1.16900843058164e-05,
  -3.89696741104e-05,
  -9.85468390916148e-05,
  -0.000161009867428677,
  -0.000219206981177775,
  -0.000265621897813199,
  -0.000293498241691715,
  -0.000298003921541809,
  -0.000277186705451158,
  -0.000232676836925126,
  -0.000169914967971405,
  -9.62079979300535e-05,
  -2.51125513131256e-05,
  3.69809600262516e-05,
  7.42043577814656e-05,
  7.97817373854275e-05,
  5.02385379851292e-05,
  -1.57991871271694e-05,
  -0.000114437287265163,
  -0.000235897965918837,
  -0.000366102814052958,
  -0.000489103613086259,
  -0.000589210258820819,
  -0.000652743939524249,
  -0.000669783890970928,
  -0.000635975263583453,
  -0.000553949112513262,
  -0.000433593492614785,
  -0.000290988579590895,
  -0.00014832630995168,
  -2.59207759511581e-05,
  5.09331968833574e-05,
  6.84394379409231e-05,
  1.57208894447818e-05,
  -0.000109405205140087,
  -0.000296897689887665,
  -0.000527902720342548,
  -0.000777067132466488,
  -0.00101453005859221,
  -0.00120920779134417,
  -0.001333593463007,
  -0.00136857191046792,
  -0.00130679331314755,
  -0.00115412927772127,
  -0.000929440598646113,
  -0.000663135426651631,
  -0.000394378459673436,
  -0.000163967367349531,
  -1.40577113630792e-05,
  2.71166292762123e-05,
  -6.07346253858535e-05,
  -0.000278313442438686,
  -0.000607429273487369,
  -0.00101549130993907,
  -0.00145608565994414,
  -0.00187440115136921,
  -0.0022154989505,
  -0.00243231081057876,
  -0.00249210523944556,
  -0.00238167905234111,
  -0.00211084486700502,
  -0.00171301174998109,
  -0.00124206062226084,
  -0.000765464268534193,
  -0.000354836981285895,
  -7.91079665324665e-05,
  1.09315658115454e-05,
  -0.000117905256558107,
  -0.00046606643180625,
  -0.00100501188496882,
  -0.00167912001559893,
  -0.00240829932962692,
  -0.00310083785299637,
  -0.00366547762099869,
  -0.00402294472888868,
  -0.00411761180003572,
  -0.0039274117727721,
  -0.00346911661557856,
  -0.00279793021625653,
  -0.00200180220277536,
  -0.00119111041913143,
  -0.000485030551997283,
  3.81268603366552e-06,
  0.000188967667995569,
  1.75771088832494e-05,
  -0.000512433845333963,
  -0.00135691951675416,
  -0.00242506976696957,
  -0.0035879472609761,
  -0.0046981084325413,
  -0.00560605758712609,
  -0.00618109818486136,
  -0.00633169671974863,
  -0.00602029294983547,
  -0.00527087376898266,
  -0.00416920321248404,
  -0.00285489367017525,
  -0.0015052886779112,
  -0.000313107859445306,
  0.000539650875676152,
  0.000908453023733856,
  0.000704485989099417,
  -8.34445326883886e-05,
  -0.00139001723273659,
  -0.0030720685622835,
  -0.00492573659293609,
  -0.00671350908243368,
  -0.00819040896088137,
  -0.00913994430276909,
  -0.0094054510698947,
  -0.00891440529630932,
  -0.0076938432246964,
  -0.00587332975516594,
  -0.00367330078239809,
  -0.00138024590473629,
  0.000688237354624767,
  0.00222495069867272,
  0.00297549107050037,
  0.00277514985073955,
  0.00158149008174527,
  -0.000518003816389104,
  -0.00330261804405544,
  -0.00644305708217242,
  -0.00953836573752198,
  -0.0121613753764521,
  -0.0139192020967903,
  -0.014506083994603,
  -0.01375111070042,
  -0.0116523257225599,
  -0.00839011738751365,
  -0.00431760602103533,
  7.1663663982476e-05,
  0.00419702982579153,
  0.00745975192802291,
  0.00931939464036898,
  0.00936943884289081,
  0.00740391343534496,
  0.00345877565753137,
  -0.00216217557912831,
  -0.00890269263539967,
  -0.015993306828616,
  -0.0225185891488447,
  -0.0275127194995281,
  -0.0300581664238577,
  -0.0293928821975884,
  -0.0250048561965734,
  -0.016704594395921,
  -0.00466807376363805,
  0.0105565992041111,
  0.0280814505817365,
  0.0467469851736764,
  0.0652208053169884,
  0.0821177670264463,
  0.0961283100667419,
  0.106140280278628,
  0.111351899732022,
  0.111349938479372,
  0.106125325195358,
  0.0961012215899245,
  0.082083055541495,
  0.065184044146694,
  0.0467140460518445,
  0.0280577028971195,
  0.0105461819922317,
  -0.0046628081022343,
  -0.016683390465914,
  -0.0249695791797853,
  -0.0293472523705209,
  -0.0300072425912863,
  -0.0274622028497765,
  -0.022474041565934,
  -0.0159593912922312,
  -0.00888254418083573,
  -0.00215697336191281,
  0.00344995890282234,
  0.00738397867095158,
  0.00934286593093756,
  0.00929162187785759,
  0.00743644458315651,
  0.00418330943585274,
  7.14189972924584e-05,
  -0.0043022374712043,
  -0.00835902931430361,
  -0.0116074461548097,
  -0.0136961306275393,
  -0.0144459510742554,
  -0.0138594474412668,
  -0.0121073658888651,
  -0.00949458766305608,
  -0.00641252452164234,
  -0.0032864730910068,
  -0.000515393696874395,
  0.00157328267532868,
  0.00276032738480899,
  0.00295914596667793,
  0.00221238862228927,
  0.000684245970120732,
  -0.00137202854072664,
  -0.00365086284841068,
  -0.00583653949343313,
  -0.00764444661708083,
  -0.00885577187143843,
  -0.00934210271690931,
  -0.0090769334929006,
  -0.00813263733184636,
  -0.00666507779776451,
  -0.0048894076705026,
  -0.00304891264847757,
  -0.00137931307597921,
  -8.27882523334948e-05,
  0.000698828976253759,
  0.000901007241309603,
  0.000535137629629946,
  -0.000310436583942355,
  -0.0014921914829033,
  -0.00282956735303828,
  -0.00413150220327286,
  -0.0052223003458195,
  -0.00596376643057263,
  -0.00627113762676166,
  -0.00612088948511199,
  -0.00555045453310577,
  -0.00465067025277631,
  -0.00355107205618392,
  -0.00239970572091919,
  -0.00134247910335008,
  -0.00050688602184144,
  1.73835459454169e-05,
  0.000186851328593862,
  3.76926627593299e-06,
  -0.000479414621359702,
  -0.00117709065000749,
  -0.00197785315902698,
  -0.00276391086548602,
  -0.00342625426272416,
  -0.0038781081141346,
  -0.00406509683686583,
  -0.0039708255367144,
  -0.00361724368824401,
  -0.0030593974778865,
  -0.00237561549230207,
  -0.00165598131126649,
  -0.000990950721816176,
  -0.000459446555962234,
  -0.000116205262140052,
  1.07715840793517e-05,
  -7.79329491288675e-05,
  -0.000349488231502234,
  -0.000753755485340556,
  -0.00122278280128855,
  -0.00168603625864065,
  -0.00207712192979598,
  -0.00234307978201088,
  -0.0024511361597515,
  -0.00239175337853265,
  -0.0021780316539496,
  -0.0018422541194682,
  -0.00143076173464824,
  -0.000997583010841567,
  -0.000596568116623263,
  -0.000273268167415817,
  -5.96184688626525e-05,
  2.66114681243663e-05,
  -1.37922622490626e-05,
  -0.000160829296086387,
  -0.000386729139522771,
  -0.000650101333555018,
  -0.000910929474657119,
  -0.00113083975447844,
  -0.00128007745727489,
  -0.00134022893970869,
  -0.00130561817736569,
  -0.00118351678315544,
  -0.000992701356832596,
  -0.000760137188210536,
  -0.00051625788278049,
  -0.000290267675160951,
  -0.000106932250570691,
  1.53612523294125e-05,
  6.68551362116988e-05,
  4.97402887713845e-05,
  -2.53066542354481e-05,
  -0.000144772078583238,
  -0.000283937761679862,
  -0.00042297186175046,
  -0.000540233180356209,
  -0.000620062798522562,
  -0.00065285375357642,
  -0.000636080094916979,
  -0.000574023057935788,
  -0.000476379090176037,
  -0.000356492807082752,
  -0.000229652579895355,
  -0.000111382801539256,
  -1.53742280913752e-05,
  4.8877464993403e-05,
  7.7605767545448e-05,
  7.216807749654e-05,
  3.5960542057589e-05,
  -2.44162570500983e-05,
  -9.35294421380662e-05,
  -0.000165168538352502,
  -0.000226161106310923,
  -0.00026941255178708,
  -0.000289641461254719,
  -0.000285266901460065,
  -0.000258185533558317,
  -0.000213088908986053,
  -0.000156536278671508,
  -9.58253134180074e-05,
  -3.79017941126775e-05,
  1.13728141318785e-05,
  4.74365397903835e-05,
  6.69621860673353e-05,
  6.81475404150919e-05,
  5.17802014823365e-05,
  2.34227340762627e-05,
  -7.96541204893464e-06,
  -4.97150185953007e-05,
  -8.5727741580426e-05,
  -0.000116950564089072,
  -0.00013874814150351,
  -0.000149040545002216,
  -0.000146908318755611,
  -0.000132520947558629,
  -0.00010700115323508,
  -7.21290149150481e-05,
  -3.00264108515757e-05,
  1.71059107790105e-05,
  6.7193203421747e-05,
  0.000118437876786714,
  0.000169375448704034,
  0.000218770083443505,
  0.000265605181906194,
  0.000308850143176507,
  -0.0189481367078439
};
#else
// rFIR
// localSamplingrate = 48000.000000
// number of taps = 181
// Band0 Lower=0.000000, Upper=2800.000000, Desired=2.000000, Weight=1.000000
// Band1 Lower=3500.000000, Upper=24000.000000, Desired=0.000000, Weight=10.000000
//Coefficients:
 const FILTERPARAMTYPE downSampleFilterParam[DSAMPLEFILTERLEN]=
{
   -0.000726805371518309,
   0.00212924341308074,
   0.00209607515518649,
   0.00258616863859503,
   0.00312451941666017,
   0.00351845737963003,
   0.00365705393269608,
   0.00347249738871369,
   0.00294091277303658,
   0.0020876784816062,
   0.000989968644394825,
   -0.000229536963193281,
   -0.00141602838562286,
   -0.00240355817861836,
   -0.00303972686902264,
   -0.00321109351395581,
   -0.00286490657890866,
   -0.00202335724664101,
   -0.000787353876891696,
   0.000672176418542286,
   0.00213509217135987,
   0.00336342008182743,
   0.00413819652648567,
   0.00429713243771618,
   0.00376510708747164,
   0.00257360789092004,
   0.000863764615466942,
   -0.001127792766604,
   -0.00309663047609688,
   -0.00472159091592147,
   -0.0056999360876337,
   -0.00583031339786136,
   -0.00501710522705826,
   -0.00331719263251476,
   -0.000939525687925027,
   0.00178104445626093,
   0.00442648054106535,
   0.00655781811862848,
   0.00778470951795523,
   0.00783457506289861,
   0.00660582869791214,
   0.00419854005559208,
   0.000913611071336271,
   -0.00278058458658644,
   -0.00631166219807734,
   -0.00908863549508422,
   -0.0105968380602393,
   -0.0104880827011458,
   -0.00865059863609764,
   -0.00524633117469452,
   -0.000706169042697737,
   0.00431853795460012,
   0.00904473602072652,
   0.0126740048689635,
   0.0145210513202929,
   0.0141339163209834,
   0.0113860335748772,
   0.00652568850180913,
   0.000164013828194059,
   -0.00678721495092159,
   -0.0132450608783663,
   -0.0181056223037124,
   -0.0204244364948377,
   -0.0195817855693473,
   -0.0154088583976291,
   -0.00825851456253797,
   0.00100265183405794,
   0.0110798178134256,
   0.0204127669048817,
   0.0273919133377699,
   0.0306039642231267,
   0.0290707628785015,
   0.0224466971136873,
   0.0111424375360727,
   -0.00364878906373264,
   -0.0200329664559621,
   -0.0356023553816112,
   -0.0477088371694707,
   -0.053792701556172,
   -0.0517250893361419,
   -0.0401198095407566,
   -0.0185705541637443,
   0.0122205143308298,
   0.0504455099076038,
   0.093330253141237,
   0.13739759113622,
   0.178828272483524,
   0.213871703505128,
   0.239265440205684,
   0.252600612879519,
   0.252600612879519,
   0.239265440205684,
   0.213871703505128,
   0.178828272483524,
   0.13739759113622,
   0.093330253141237,
   0.0504455099076038,
   0.0122205143308298,
   -0.0185705541637443,
   -0.0401198095407566,
   -0.0517250893361419,
   -0.053792701556172,
   -0.0477088371694707,
   -0.0356023553816112,
   -0.0200329664559621,
   -0.00364878906373264,
   0.0111424375360727,
   0.0224466971136873,
   0.0290707628785015,
   0.0306039642231267,
   0.0273919133377699,
   0.0204127669048817,
   0.0110798178134256,
   0.00100265183405794,
   -0.00825851456253797,
   -0.0154088583976291,
   -0.0195817855693473,
   -0.0204244364948377,
   -0.0181056223037124,
   -0.0132450608783663,
   -0.00678721495092159,
   0.000164013828194059,
   0.00652568850180913,
   0.0113860335748772,
   0.0141339163209834,
   0.0145210513202929,
   0.0126740048689635,
   0.00904473602072652,
   0.00431853795460012,
   -0.000706169042697737,
   -0.00524633117469452,
   -0.00865059863609764,
   -0.0104880827011458,
   -0.0105968380602393,
   -0.00908863549508422,
   -0.00631166219807734,
   -0.00278058458658644,
   0.000913611071336271,
   0.00419854005559208,
   0.00660582869791214,
   0.00783457506289861,
   0.00778470951795523,
   0.00655781811862848,
   0.00442648054106535,
   0.00178104445626093,
   -0.000939525687925027,
   -0.00331719263251476,
   -0.00501710522705826,
   -0.00583031339786136,
   -0.0056999360876337,
   -0.00472159091592147,
   -0.00309663047609688,
   -0.001127792766604,
   0.000863764615466942,
   0.00257360789092004,
   0.00376510708747164,
   0.00429713243771618,
   0.00413819652648567,
   0.00336342008182743,
   0.00213509217135987,
   0.000672176418542286,
   -0.000787353876891696,
   -0.00202335724664101,
   -0.00286490657890866,
   -0.00321109351395581,
   -0.00303972686902264,
   -0.00240355817861836,
   -0.00141602838562286,
   -0.000229536963193281,
   0.000989968644394825,
   0.0020876784816062,
   0.00294091277303658,
   0.00347249738871369,
   0.00365705393269608,
   0.00351845737963003,
   0.00312451941666017,
   0.00258616863859503,
   0.00209607515518649,
   0.00212924341308074,
   -0.000726805371518309
};


#endif


/*

FIR filter designed with
http://t-filter.appspot.com

sampling frequency: 48000 Hz

* 0 Hz - 12000 Hz
  gain = 1
  desired ripple = 5 dB
  actual ripple = 0.010064305090401647 dB

* 14000 Hz - 24000 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -82.0306697301112 dB

*/

//#define FILTER_TAP_NUM 120

//const FILTERPARAMTYPE downSampleFilterParam[DSFILTERLEN]=
//{
//  -0.00001434671700912554,
//  -0.000020562134651605815,
//  0.00001876751754297483,
//  0.000026445175446795552,
//  -0.00006030588399278963,
//  -0.00005828746852741699,
//  0.00009853296830508344,
//  0.00005931095017311163,
//  -0.00019046483652338048,
//  -0.0000701660667147503,
//  0.0002856339556184428,
//  0.000019827822393580995,
//  -0.0004370075921714892,
//  0.00005539702740416332,
//  0.0005788569954831205,
//  -0.00023331653626705516,
//  -0.0007478536043794683,
//  0.00047687246116682845,
//  0.000857539467749795,
//  -0.0008559863070902277,
//  -0.0009222988328700723,
//  0.001316670320186741,
//  0.0008349709365650639,
//  -0.0019017785484652815,
//  -0.0005943042771593648,
//  0.002521346756232543,
//  0.00008790552871839043,
//  -0.0031717280255955595,
//  0.0006802888305853671,
//  0.0037148625674325287,
//  -0.0017975574392839607,
//  -0.004094961253668418,
//  0.003219684850878581,
//  0.004129426138899979,
//  -0.004972984552710972,
//  -0.0037259328148558325,
//  0.006937428069747955,
//  0.002682000096803343,
//  -0.009048195500263277,
//  -0.0009009328077472075,
//  0.011087098217581621,
//  -0.0018057790712661997,
//  -0.012884014811956659,
//  0.005512716439276536,
//  0.014111394052560285,
//  -0.01038993718341453,
//  -0.0144745570870615,
//  0.016529612471778678,
//  0.013477274536340088,
//  -0.0242188112250576,
//  -0.010528902562796134,
//  0.03391653395396962,
//  0.004470587562008853,
//  -0.046963243031028244,
//  0.007126082872329679,
//  0.06721942081260658,
//  -0.032209836572452265,
//  -0.11187872022628036,
//  0.12057492071696543,
//  0.47614828001783693,
//  0.47614828001783693,
//  0.12057492071696543,
//  -0.11187872022628036,
//  -0.032209836572452265,
//  0.06721942081260658,
//  0.007126082872329679,
//  -0.046963243031028244,
//  0.004470587562008853,
//  0.03391653395396962,
//  -0.010528902562796134,
//  -0.0242188112250576,
//  0.013477274536340088,
//  0.016529612471778678,
//  -0.0144745570870615,
//  -0.01038993718341453,
//  0.014111394052560285,
//  0.005512716439276536,
//  -0.012884014811956659,
//  -0.0018057790712661997,
//  0.011087098217581621,
//  -0.0009009328077472075,
//  -0.009048195500263277,
//  0.002682000096803343,
//  0.006937428069747955,
//  -0.0037259328148558325,
//  -0.004972984552710972,
//  0.004129426138899979,
//  0.003219684850878581,
//  -0.004094961253668418,
//  -0.0017975574392839607,
//  0.0037148625674325287,
//  0.0006802888305853671,
//  -0.0031717280255955595,
//  0.00008790552871839043,
//  0.002521346756232543,
//  -0.0005943042771593648,
//  -0.0019017785484652815,
//  0.0008349709365650639,
//  0.001316670320186741,
//  -0.0009222988328700723,
//  -0.0008559863070902277,
//  0.000857539467749795,
//  0.00047687246116682845,
//  -0.0007478536043794683,
//  -0.00023331653626705516,
//  0.0005788569954831205,
//  0.00005539702740416332,
//  -0.0004370075921714892,
//  0.000019827822393580995,
//  0.0002856339556184428,
//  -0.0000701660667147503,
//  -0.00019046483652338048,
//  0.00005931095017311163,
//  0.00009853296830508344,
//  -0.00005828746852741699,
//  -0.00006030588399278963,
//  0.000026445175446795552,
//  0.00001876751754297483,
//  -0.000020562134651605815,
//  -0.00001434671700912554
//};


//// TFilter design
//const DSPFLOAT downSampleFilterParam[DSFILTERLEN]=
//{
//-0.00031921241370338495,
//0.0004949421700044819,
//0.0013822939416138311,
//0.0024512816581009097,
//0.0031354286516971307,
//0.0029158928250820424,
//0.001661027141044636,
//-0.00017924772122938603,
//-0.001718399835583406,
//-0.0021065617689579345,
//-0.001080218804964031,
//0.0007741897002425456,
//0.0022803276925760932,
//0.002370490501567989,
//0.0008162184718294901,
//-0.0015082994928116908,
//-0.0030838686559974122,
//-0.002712838485381115,
//-0.00039730012077191765,
//0.002503293797487666,
//0.004036292913059631,
//0.002948773728902641,
//-0.0003454610920105798,
//-0.0038302916183060387,
//-0.005089732524335926,
//-0.00295182534778405,
//0.0015276238855431493,
//0.005514356523235612,
//0.006151496449877064,
//0.0025611667129678915,
//-0.0032836542253722617,
//-0.007575527265201513,
//-0.0071042856041813535,
//-0.0015834913875678463,
//0.005769176822509418,
//0.010029690861770824,
//0.007793764701402249,
//-0.00023664441998894463,
//-0.009197251927194018,
//-0.012903337373983267,
//-0.007999288652642442,
//0.003296528685942004,
//0.013945110147450536,
//0.016304461562662808,
//0.007384602945044693,
//-0.008336298315850418,
//-0.020829917188221893,
//-0.020577775461447054,
//-0.005292943361467393,
//0.017139781366637633,
//0.032108329389068505,
//0.026911188696776438,
//-0.0001361030874071249,
//-0.03584756267942592,
//-0.056825628460263636,
//-0.04112767228986162,
//0.01893335449923753,
//0.11004116992869253,
//0.2015954251233985,
//0.25880099591048017,
//0.25880099591048017,
//0.2015954251233985,
//0.11004116992869253,
//0.01893335449923753,
//-0.04112767228986162,
//-0.056825628460263636,
//-0.03584756267942592,
//-0.0001361030874071249,
//0.026911188696776438,
//0.032108329389068505,
//0.017139781366637633,
//-0.005292943361467393,
//-0.020577775461447054,
//-0.020829917188221893,
//-0.008336298315850418,
//0.007384602945044693,
//0.016304461562662808,
//0.013945110147450536,
//0.003296528685942004,
//-0.007999288652642442,
//-0.012903337373983267,
//-0.009197251927194018,
//-0.00023664441998894463,
//0.007793764701402249,
//0.010029690861770824,
//0.005769176822509418,
//-0.0015834913875678463,
//-0.0071042856041813535,
//-0.007575527265201513,
//-0.0032836542253722617,
//0.0025611667129678915,
//0.006151496449877064,
//0.005514356523235612,
//0.0015276238855431493,
//-0.00295182534778405,
//-0.005089732524335926,
//-0.0038302916183060387,
//-0.0003454610920105798,
//0.002948773728902641,
//0.004036292913059631,
//0.002503293797487666,
//-0.00039730012077191765,
//-0.002712838485381115,
//-0.0030838686559974122,
//-0.0015082994928116908,
//0.0008162184718294901,
//0.002370490501567989,
//0.0022803276925760932,
//0.0007741897002425456,
//-0.001080218804964031,
//-0.0021065617689579345,
//-0.001718399835583406,
//-0.00017924772122938603,
//0.001661027141044636,
//0.0029158928250820424,
//0.0031354286516971307,
//0.0024512816581009097,
//0.0013822939416138311,
//0.0004949421700044819,
//-0.00031921241370338495,
//};

// blFIR  Raised cosine
// localSamplingrate = 48000.000000
// number of taps = 120
// corner frequency = 8000.000000
// beta = 0.700000
// window applied
//Coefficients:

//const DSPFLOAT downSampleFilterParam[DSFILTERLEN]=
//{
//    1.10951e-06,
//    1.68217e-07,
//    -3.53568e-11,
//    1.91102e-06,
//    1.89927e-06,
//    2.59551e-11,
//    1.15409e-06,
//    2.97637e-06,
//    9.28531e-11,
//    -2.1707e-06,
//    1.04504e-06,
//    9.87304e-11,
//    -6.71334e-06,
//    -5.23393e-06,
//    -4.59518e-12,
//    -7.0149e-06,
//    -1.20569e-05,
//    -1.65625e-10,
//    3.36226e-06,
//    -9.32791e-06,
//    -2.32704e-10,
//    2.26407e-05,
//    1.16112e-05,
//    -8.50774e-11,
//    3.2786e-05,
//    4.26511e-05,
//    2.10748e-10,
//    6.05424e-06,
//    4.96652e-05,
//    4.01764e-10,
//    -6.63556e-05,
//    -1.08136e-05,
//    2.6107e-10,
//    -0.000136682,
//    -0.000141189,
//    -1.63979e-10,
//    -9.11534e-05,
//    -0.00024146,
//    -5.30812e-10,
//    0.000186548,
//    -9.29759e-05,
//    -4.81928e-10,
//    0.000653162,
//    0.000539686,
//    6.14632e-12,
//    0.000842028,
//    0.0015963,
//    5.48689e-10,
//    -0.0005741,
//    0.00187732,
//    6.65763e-10,
//    -0.00703948,
//    -0.00483539,
//    2.2005e-10,
//    -0.0318124,
//    -0.0807611,
//    -4.31271e-10,
//    0.334861,
//    0.785553,
//          1,
//    0.785553,
//    0.334861,
//    -4.31271e-10,
//    -0.0807611,
//    -0.0318124,
//    2.20049e-10,
//    -0.00483539,
//    -0.00703948,
//    6.65763e-10,
//    0.00187732,
//    -0.0005741,
//    5.48689e-10,
//    0.0015963,
//    0.000842028,
//    6.14623e-12,
//    0.000539686,
//    0.000653162,
//    -4.81928e-10,
//    -9.29759e-05,
//    0.000186548,
//    -5.30812e-10,
//    -0.00024146,
//    -9.11534e-05,
//    -1.63979e-10,
//    -0.000141189,
//    -0.000136682,
//    2.6107e-10,
//    -1.08136e-05,
//    -6.63556e-05,
//    4.01764e-10,
//    4.96652e-05,
//    6.05424e-06,
//    2.10748e-10,
//    4.26511e-05,
//    3.2786e-05,
//    -8.50774e-11,
//    1.16112e-05,
//    2.26407e-05,
//    -2.32704e-10,
//    -9.32791e-06,
//    3.36226e-06,
//    -1.65625e-10,
//    -1.20569e-05,
//    -7.0149e-06,
//    -4.59518e-12,
//    -5.23393e-06,
//    -6.71334e-06,
//    9.87304e-11,
//    1.04504e-06,
//    -2.1707e-06,
//    9.28531e-11,
//    2.97637e-06,
//    1.15409e-06,
//    2.59551e-11,
//    1.89927e-06,
//    1.91102e-06,
//    -3.53568e-11,
//    1.68217e-07,
//    1.10951e-06,
//    -7.38792e-10
//};














 // downSampleFilter filter
// rFIR
// localSamplingrate = 48000.000000
// number of taps = 120
// Band0 Lower=0.000000, Upper=3000.000000, Desired=1.000000, Weight=1.000000
// Band1 Lower=4000.000000, Upper=6500.020000, Desired=0.000000, Weight=1.000000
// Band2 Lower=7000.000000, Upper=23999.000000, Desired=0.000000, Weight=1.000000
//Coefficients:


//const DSPFLOAT downSampleFilterParam[DSFILTERLEN]=
//{
//   0.000302984,
//   0.00251395,
//   0.000720718,
//   0.000752883,
//   0.000313521,
//   -0.000239004,
//   -0.00082934,
//   -0.00132562,
//   -0.00160754,
//   -0.00158137,
//   -0.00119945,
//   -0.000480743,
//   0.000478348,
//   0.00149955,
//   0.00235235,
//   0.00279834,
//   0.00266094,
//   0.00188006,
//   0.00054949,
//   -0.00109067,
//   -0.00270158,
//   -0.00391293,
//   -0.00440711,
//   -0.00398884,
//   -0.00263551,
//   -0.000521475,
//   0.00199194,
//   0.00440711,
//   0.00617188,
//   0.00679615,
//   0.00597685,
//   0.00369732,
//   0.000277493,
//   -0.00365566,
//   -0.00727899,
//   -0.00974173,
//   -0.0103496,
//   -0.00873256,
//   -0.00495604,
//   0.000443261,
//   0.00651177,
//   0.0120219,
//   0.0156842,
//   0.0164019,
//   0.0135302,
//   0.00709349,
//   -0.00211602,
//   -0.0125803,
//   -0.0222385,
//   -0.0288071,
//   -0.0301798,
//   -0.0248006,
//   -0.0119883,
//   0.00786467,
//   0.0332831,
//   0.0618213,
//   0.0903879,
//   0.115644,
//    0.1345,
//   0.144575,
//   0.144575,
//    0.1345,
//   0.115644,
//   0.0903879,
//   0.0618213,
//   0.0332831,
//   0.00786467,
//   -0.0119883,
//   -0.0248006,
//   -0.0301798,
//   -0.0288071,
//   -0.0222385,
//   -0.0125803,
//   -0.00211602,
//   0.00709349,
//   0.0135302,
//   0.0164019,
//   0.0156842,
//   0.0120219,
//   0.00651177,
//   0.000443261,
//   -0.00495604,
//   -0.00873256,
//   -0.0103496,
//   -0.00974173,
//   -0.00727899,
//   -0.00365566,
//   0.000277493,
//   0.00369732,
//   0.00597685,
//   0.00679615,
//   0.00617188,
//   0.00440711,
//   0.00199194,
//   -0.000521475,
//   -0.00263551,
//   -0.00398884,
//   -0.00440711,
//   -0.00391293,
//   -0.00270158,
//   -0.00109067,
//   0.00054949,
//   0.00188006,
//   0.00266094,
//   0.00279834,
//   0.00235235,
//   0.00149955,
//   0.000478348,
//   -0.000480743,
//   -0.00119945,
//   -0.00158137,
//   -0.00160754,
//   -0.00132562,
//   -0.00082934,
//   -0.000239004,
//   0.000313521,
//   0.000752883,
//   0.000720718,
//   0.00251395,
//   0.000302984
//};


 // rFIR
 // localSamplingrate = 12000.000000
 // number of taps = 251
 // Band0 Lower=0.000000, Upper=550.000000, Desired=1.000000, Weight=1.000000
 // Band1 Lower=1050.000000, Upper=5999.000000, Desired=0.000000, Weight=1.000000
 //Coefficients:
 const FILTERPARAMTYPE wide600Hz[RXNUMTAPS]=
 {
    1.02116e-08,
    1.86956e-08,
    2.95997e-08,
    3.67411e-08,
    3.28803e-08,
    9.86893e-09,
    -3.85738e-08,
    -1.13046e-07,
    -2.04568e-07,
    -2.91967e-07,
    -3.42147e-07,
    -3.14635e-07,
    -1.71071e-07,
    1.1124e-07,
    5.23967e-07,
    1.01483e-06,
    1.48207e-06,
    1.78127e-06,
    1.74781e-06,
    1.23487e-06,
    1.62235e-07,
    -1.43354e-06,
    -3.3612e-06,
    -5.2643e-06,
    -6.65105e-06,
    -6.97116e-06,
    -5.73598e-06,
    -2.66528e-06,
    2.16834e-06,
    8.23547e-06,
    1.45259e-05,
    1.96364e-05,
    2.19833e-05,
    2.01253e-05,
    1.31516e-05,
    1.0579e-06,
    -1.4981e-05,
    -3.25401e-05,
    -4.81454e-05,
    -5.77759e-05,
    -5.76296e-05,
    -4.5044e-05,
    -1.93995e-05,
    1.72081e-05,
    5.97375e-05,
    0.000100575,
    0.000130573,
    0.000140686,
    0.000123958,
    7.75329e-05,
    4.21222e-06,
    -8.68583e-05,
    -0.000180729,
    -0.000258554,
    -0.000300753,
    -0.000290988,
    -0.000220288,
    -9.0445e-05,
    8.41753e-05,
    0.000277112,
    0.000452921,
    0.000572765,
    0.000601767,
    0.000516923,
    0.000314004,
    1.18484e-05,
    -0.000347327,
    -0.000702346,
    -0.00098214,
    -0.00111838,
    -0.00105967,
    -0.000784711,
    -0.000311538,
    0.000299689,
    0.000951857,
    0.00152431,
    0.00189303,
    0.00195464,
    0.00164989,
    0.000981973,
    2.52672e-05,
    -0.00107873,
    -0.0021392,
    -0.00294598,
    -0.00330765,
    -0.00309123,
    -0.00225613,
    -0.000874798,
    0.000865638,
    0.00268356,
    0.00424397,
    0.00521526,
    0.00533284,
    0.00445837,
    0.0026227,
    4.24788e-05,
    -0.00289622,
    -0.00568812,
    -0.00778773,
    -0.00870587,
    -0.00810812,
    -0.00589723,
    -0.00226255,
    0.00231648,
    0.00711898,
    0.0112808,
    0.0139308,
    0.0143459,
    0.0121003,
    0.00718252,
    5.75686e-05,
    -0.00834188,
    -0.0167013,
    -0.0234799,
    -0.0271187,
    -0.0262714,
    -0.0200251,
    -0.00807634,
    0.00916805,
    0.0305845,
    0.0544271,
    0.0785142,
    0.100484,
    0.118085,
    0.129463,
    0.133397,
    0.129463,
    0.118085,
    0.100484,
    0.0785142,
    0.0544271,
    0.0305845,
    0.00916805,
    -0.00807634,
    -0.0200251,
    -0.0262714,
    -0.0271187,
    -0.0234799,
    -0.0167013,
    -0.00834188,
    5.75686e-05,
    0.00718252,
    0.0121003,
    0.0143459,
    0.0139308,
    0.0112808,
    0.00711898,
    0.00231648,
    -0.00226255,
    -0.00589723,
    -0.00810812,
    -0.00870587,
    -0.00778773,
    -0.00568812,
    -0.00289622,
    4.24788e-05,
    0.0026227,
    0.00445837,
    0.00533284,
    0.00521526,
    0.00424397,
    0.00268356,
    0.000865638,
    -0.000874798,
    -0.00225613,
    -0.00309123,
    -0.00330765,
    -0.00294598,
    -0.0021392,
    -0.00107873,
    2.52672e-05,
    0.000981973,
    0.00164989,
    0.00195464,
    0.00189303,
    0.00152431,
    0.000951857,
    0.000299689,
    -0.000311538,
    -0.000784711,
    -0.00105967,
    -0.00111838,
    -0.00098214,
    -0.000702346,
    -0.000347327,
    1.18484e-05,
    0.000314004,
    0.000516923,
    0.000601767,
    0.000572765,
    0.000452921,
    0.000277112,
    8.41753e-05,
    -9.0445e-05,
    -0.000220288,
    -0.000290988,
    -0.000300753,
    -0.000258554,
    -0.000180729,
    -8.68583e-05,
    4.21222e-06,
    7.75329e-05,
    0.000123958,
    0.000140686,
    0.000130573,
    0.000100575,
    5.97375e-05,
    1.72081e-05,
    -1.93995e-05,
    -4.5044e-05,
    -5.76296e-05,
    -5.77759e-05,
    -4.81454e-05,
    -3.25401e-05,
    -1.4981e-05,
    1.0579e-06,
    1.31516e-05,
    2.01253e-05,
    2.19833e-05,
    1.96364e-05,
    1.45259e-05,
    8.23547e-06,
    2.16834e-06,
    -2.66528e-06,
    -5.73598e-06,
    -6.97116e-06,
    -6.65105e-06,
    -5.2643e-06,
    -3.3612e-06,
    -1.43354e-06,
    1.62235e-07,
    1.23487e-06,
    1.74781e-06,
    1.78127e-06,
    1.48207e-06,
    1.01483e-06,
    5.23967e-07,
    1.1124e-07,
    -1.71071e-07,
    -3.14635e-07,
    -3.42147e-07,
    -2.91967e-07,
    -2.04568e-07,
    -1.13046e-07,
    -3.85738e-08,
    9.86893e-09,
    3.28803e-08,
    3.67411e-08,
    2.95997e-08,
    1.86956e-08,
    1.02116e-08
 };



 // blFIR  Root Raised Cosine
 // localSamplingrate = 12000.000000
 // number of taps = 251
 // corner frequency = 175.000000
 // beta = 0.600000
 // window applied
 //Coefficients:
 const  FILTERPARAMTYPE wide1200BP[RXNUMTAPS]=
 {
    -0.000609128,
    -0.000552292,
    -0.000480985,
    -0.000395195,
    -0.000294978,
    -0.000180515,
    -5.21677e-05,
    8.9455e-05,
    0.000243425,
    0.000408425,
    0.000582684,
    0.000763914,
    0.000949268,
    0.0011353,
    0.00131798,
    0.00149267,
    0.00165418,
    0.00179686,
    0.00191467,
    0.0020013,
    0.00205037,
    0.00205558,
    0.00201094,
    0.00191099,
    0.00175106,
    0.00152749,
    0.00123794,
    0.000881561,
    0.000459301,
    -2.59536e-05,
    -0.000569184,
    -0.00116312,
    -0.0017982,
    -0.00246251,
    -0.00314192,
    -0.00382017,
    -0.00447909,
    -0.00509894,
    -0.00565873,
    -0.00613672,
    -0.00651091,
    -0.00675969,
    -0.00686239,
    -0.00680006,
    -0.00655616,
    -0.00611727,
    -0.00547384,
    -0.00462086,
    -0.00355856,
    -0.00229294,
    -0.000836296,
    0.000792401,
    0.00256725,
    0.00445533,
    0.00641673,
    0.0084048,
    0.0103666,
    0.0122434,
    0.0139717,
    0.0154841,
    0.0167105,
    0.0175795,
    0.0180201,
    0.017963,
    0.0173428,
    0.0160997,
    0.0141814,
    0.0115451,
    0.00815967,
    0.00400701,
    -0.000915743,
    -0.00659481,
    -0.0129983,
    -0.0200751,
    -0.0277539,
    -0.0359425,
    -0.0445279,
    -0.0533762,
    -0.0623329,
    -0.0712244,
    -0.0798588,
    -0.0880279,
    -0.0955092,
    -0.102069,
    -0.107464,
    -0.111446,
    -0.113765,
    -0.114172,
    -0.112426,
    -0.108292,
    -0.101553,
    -0.0920066,
    -0.079476,
    -0.0638084,
    -0.0448816,
    -0.0226067,
    0.00306903,
    0.0321591,
    0.064636,
    0.10043,
    0.139426,
    0.181466,
    0.226349,
    0.273829,
    0.32362,
    0.375396,
    0.428795,
    0.483422,
    0.538853,
    0.594642,
    0.650321,
    0.705409,
    0.759419,
    0.81186,
    0.862247,
    0.910103,
    0.95497,
    0.996411,
    1.03402,
    1.06742,
    1.09628,
     1.1203,
    1.13925,
    1.15292,
    1.16118,
    1.16394,
    1.16118,
    1.15292,
    1.13925,
     1.1203,
    1.09628,
    1.06742,
    1.03402,
    0.996411,
    0.95497,
    0.910103,
    0.862247,
    0.81186,
    0.759419,
    0.705409,
    0.650321,
    0.594642,
    0.538853,
    0.483422,
    0.428795,
    0.375396,
    0.32362,
    0.273829,
    0.226349,
    0.181466,
    0.139426,
    0.10043,
    0.064636,
    0.0321591,
    0.00306903,
    -0.0226067,
    -0.0448816,
    -0.0638084,
    -0.079476,
    -0.0920066,
    -0.101553,
    -0.108292,
    -0.112426,
    -0.114172,
    -0.113765,
    -0.111446,
    -0.107464,
    -0.102069,
    -0.0955092,
    -0.0880279,
    -0.0798588,
    -0.0712244,
    -0.0623329,
    -0.0533762,
    -0.0445279,
    -0.0359425,
    -0.0277539,
    -0.0200751,
    -0.0129983,
    -0.00659481,
    -0.000915743,
    0.00400701,
    0.00815967,
    0.0115451,
    0.0141814,
    0.0160997,
    0.0173428,
    0.017963,
    0.0180201,
    0.0175795,
    0.0167105,
    0.0154841,
    0.0139717,
    0.0122434,
    0.0103666,
    0.0084048,
    0.00641673,
    0.00445533,
    0.00256725,
    0.000792401,
    -0.000836296,
    -0.00229294,
    -0.00355856,
    -0.00462086,
    -0.00547384,
    -0.00611727,
    -0.00655616,
    -0.00680006,
    -0.00686239,
    -0.00675969,
    -0.00651091,
    -0.00613672,
    -0.00565873,
    -0.00509894,
    -0.00447909,
    -0.00382017,
    -0.00314192,
    -0.00246251,
    -0.0017982,
    -0.00116312,
    -0.000569184,
    -2.59536e-05,
    0.000459301,
    0.000881561,
    0.00123794,
    0.00152749,
    0.00175106,
    0.00191099,
    0.00201094,
    0.00205558,
    0.00205037,
    0.0020013,
    0.00191467,
    0.00179686,
    0.00165418,
    0.00149267,
    0.00131798,
    0.0011353,
    0.000949268,
    0.000763914,
    0.000582684,
    0.000408425,
    0.000243425,
    8.9455e-05,
    -5.21677e-05,
    -0.000180515,
    -0.000294978,
    -0.000395195,
    -0.000480985,
    -0.000552292,
    -0.000609128
 };


 // rFIR
 // localSamplingrate = 48000.000000
 // number of taps = 121
 // Band0 Lower=0.000000, Upper=2700.000000, Desired=1.000000, Weight=1.000000
 // Band1 Lower=3500.000000, Upper=23999.000000, Desired=0.000000, Weight=1.000000
 //Coefficients:
  const  FILTERPARAMTYPE wfFilter[TXWFNUMTAPS]=
 {
    0.00116433,
    -0.00494437,
    -0.00227196,
    -0.00162745,
    -0.00119222,
    -0.000602408,
    0.000154827,
    0.000987978,
    0.00175857,
    0.00231978,
    0.00254186,
    0.00234367,
    0.0017027,
    0.000677718,
    -0.000595763,
    -0.00192037,
    -0.00307107,
    -0.0038171,
    -0.00398386,
    -0.00346983,
    -0.00228737,
    -0.000567514,
    0.00145033,
    0.00344646,
    0.00506842,
    0.00599002,
    0.00597109,
    0.00490811,
    0.00286844,
    9.73674e-05,
    -0.00300691,
    -0.00594212,
    -0.00817976,
    -0.00925143,
    -0.00883636,
    -0.00682964,
    -0.00339026,
    0.00106452,
    0.00589068,
    0.0103035,
    0.0134903,
    0.0147392,
    0.0135693,
    0.00983817,
    0.00380649,
    -0.00385039,
    -0.0120879,
    -0.0196086,
    -0.0250088,
    -0.0269742,
    -0.0244494,
    -0.0168371,
    -0.004072,
    0.0132752,
    0.034055,
    0.0566447,
    0.0790638,
    0.0992571,
    0.115295,
    0.12561,
    0.129165,
    0.12561,
    0.115295,
    0.0992571,
    0.0790638,
    0.0566447,
    0.034055,
    0.0132752,
    -0.004072,
    -0.0168371,
    -0.0244494,
    -0.0269742,
    -0.0250088,
    -0.0196086,
    -0.0120879,
    -0.00385039,
    0.00380649,
    0.00983817,
    0.0135693,
    0.0147392,
    0.0134903,
    0.0103035,
    0.00589068,
    0.00106452,
    -0.00339026,
    -0.00682964,
    -0.00883636,
    -0.00925143,
    -0.00817976,
    -0.00594212,
    -0.00300691,
    9.73674e-05,
    0.00286844,
    0.00490811,
    0.00597109,
    0.00599002,
    0.00506842,
    0.00344646,
    0.00145033,
    -0.000567514,
    -0.00228737,
    -0.00346983,
    -0.00398386,
    -0.0038171,
    -0.00307107,
    -0.00192037,
    -0.000595763,
    0.000677718,
    0.0017027,
    0.00234367,
    0.00254186,
    0.00231978,
    0.00175857,
    0.000987978,
    0.000154827,
    -0.000602408,
    -0.00119222,
    -0.00162745,
    -0.00227196,
    -0.00494437,
    0.00116433
 };

// // blFIR  Raised cosine
// // localSamplingrate = 12000.000000
// // number of taps = 251
// // corner frequency = 750.000000
// // beta = 0.600000
// // window applied
// //Coefficients:
// const  DSPFLOAT  wideVolumeFilter[RXNUMTAPS]=
// {
//    -1.64544e-06,
//    -2.80612e-06,
//    -3.45436e-06,
//    -3.203e-06,
//    -1.96312e-06,
//    2.05821e-19,
//    2.13622e-06,
//    3.79135e-06,
//    4.44443e-06,
//    3.91982e-06,
//    2.49121e-06,
//    8.24608e-07,
//    -2.39152e-07,
//          0,
//    1.79747e-06,
//    4.79367e-06,
//    8.06507e-06,
//    1.04095e-05,
//    1.07867e-05,
//    8.75844e-06,
//    4.75057e-06,
//    -4.21053e-19,
//    -3.83858e-06,
//    -5.31774e-06,
//    -3.83133e-06,
//    4.45013e-09,
//    4.42064e-06,
//    7.05764e-06,
//    5.86252e-06,
//          0,
//    -9.60024e-06,
//    -2.03439e-05,
//    -2.8777e-05,
//    -3.18678e-05,
//    -2.83026e-05,
//    -1.92589e-05,
//    -8.2549e-06,
//    -2.78137e-19,
//    1.42117e-06,
//    -5.6256e-06,
//    -1.92495e-05,
//    -3.42703e-05,
//    -4.38597e-05,
//    -4.21144e-05,
//    -2.66287e-05,
//          0,
//    3.05108e-05,
//    5.52904e-05,
//    6.59811e-05,
//    5.90786e-05,
//    3.8027e-05,
//    1.27283e-05,
//    -3.70396e-06,
//    -1.21098e-19,
//    2.82294e-05,
//    7.55602e-05,
//    0.000127442,
//    0.000164744,
//    0.000170855,
//    0.000138769,
//    7.52615e-05,
//          0,
//    -6.07716e-05,
//    -8.41658e-05,
//    -6.06472e-05,
//    1.49487e-08,
//    6.98882e-05,
//    0.000111706,
//    9.29209e-05,
//    -3.02042e-19,
//    -0.000152851,
//    -0.000324975,
//    -0.000461565,
//    -0.000513668,
//    -0.000458879,
//    -0.000314394,
//    -0.000135826,
//          0,
//    2.38653e-05,
//    -9.53061e-05,
//    -0.000330391,
//    -0.000596491,
//    -0.000775191,
//    -0.00075694,
//    -0.000487457,
//    3.07131e-18,
//    0.000582257,
//    0.00108022,
//    0.00132227,
//    0.00121691,
//    0.000806873,
//    0.000278913,
//    -8.38671e-05,
//          0,
//    0.000690779,
//    0.00192988,
//    0.00340841,
//    0.00462998,
//    0.00506502,
//    0.00435752,
//    0.00251474,
//    1.4594e-18,
//    -0.00233525,
//    -0.00349956,
//    -0.00274763,
//    2.46719e-08,
//    0.00384959,
//    0.0068861,
//    0.00648597,
//          0,
//    -0.0142972,
//    -0.0362032,
//    -0.0628097,
//    -0.0882278,
//    -0.10402,
//    -0.100387,
//    -0.0679779,
//    -3.55038e-18,
//    0.105805,
//    0.245799,
//    0.41008,
//    0.583323,
//    0.74676,
//    0.881013,
//    0.96924,
//          1,
//    0.96924,
//    0.881013,
//    0.74676,
//    0.583323,
//    0.41008,
//    0.245799,
//    0.105805,
//    -3.55038e-18,
//    -0.0679779,
//    -0.100387,
//    -0.10402,
//    -0.0882278,
//    -0.0628097,
//    -0.0362032,
//    -0.0142972,
//          0,
//    0.00648597,
//    0.0068861,
//    0.00384959,
//    2.46719e-08,
//    -0.00274763,
//    -0.00349956,
//    -0.00233525,
//    1.4594e-18,
//    0.00251474,
//    0.00435752,
//    0.00506502,
//    0.00462998,
//    0.00340841,
//    0.00192988,
//    0.000690779,
//          0,
//    -8.38671e-05,
//    0.000278913,
//    0.000806873,
//    0.00121691,
//    0.00132227,
//    0.00108022,
//    0.000582257,
//    3.07131e-18,
//    -0.000487457,
//    -0.00075694,
//    -0.000775191,
//    -0.000596491,
//    -0.000330391,
//    -9.53061e-05,
//    2.38653e-05,
//          0,
//    -0.000135826,
//    -0.000314394,
//    -0.000458879,
//    -0.000513668,
//    -0.000461565,
//    -0.000324975,
//    -0.000152851,
//    -3.02042e-19,
//    9.29209e-05,
//    0.000111706,
//    6.98882e-05,
//    1.49487e-08,
//    -6.06472e-05,
//    -8.41658e-05,
//    -6.07716e-05,
//          0,
//    7.52615e-05,
//    0.000138769,
//    0.000170855,
//    0.000164744,
//    0.000127442,
//    7.55602e-05,
//    2.82294e-05,
//    -1.21098e-19,
//    -3.70396e-06,
//    1.27283e-05,
//    3.8027e-05,
//    5.90786e-05,
//    6.59811e-05,
//    5.52904e-05,
//    3.05108e-05,
//          0,
//    -2.66287e-05,
//    -4.21144e-05,
//    -4.38597e-05,
//    -3.42703e-05,
//    -1.92495e-05,
//    -5.6256e-06,
//    1.42117e-06,
//    -2.78137e-19,
//    -8.2549e-06,
//    -1.92589e-05,
//    -2.83026e-05,
//    -3.18678e-05,
//    -2.8777e-05,
//    -2.03439e-05,
//    -9.60024e-06,
//          0,
//    5.86252e-06,
//    7.05764e-06,
//    4.42064e-06,
//    4.45013e-09,
//    -3.83133e-06,
//    -5.31774e-06,
//    -3.83858e-06,
//    -4.21053e-19,
//    4.75057e-06,
//    8.75844e-06,
//    1.07867e-05,
//    1.04095e-05,
//    8.06507e-06,
//    4.79367e-06,
//    1.79747e-06,
//          0,
//    -2.39152e-07,
//    8.24608e-07,
//    2.49121e-06,
//    3.91982e-06,
//    4.44443e-06,
//    3.79135e-06,
//    2.13622e-06,
//    2.05821e-19,
//    -1.96312e-06,
//    -3.203e-06,
//    -3.45436e-06,
//    -2.80612e-06,
//    -1.64544e-06
// };


//// rFIR
//// localSamplingrate = 11025.000000
//// number of taps = 251
//// Band0 Lower=0.000000, Upper=400.000000, Desired=1.000000, Weight=1.000000
//// Band1 Lower=500.001000, Upper=5512.000000, Desired=0.000000, Weight=10.000000
////Coefficients:


//const  DSPFLOAT  narrowRX[RXNUMTAPS]=
//{
//	 -0.00111256,
//	 -0.000482835,
//	 -0.000555539,
//	 -0.000610215,
//	 -0.000640108,
//	 -0.000639526,
//	 -0.000603611,
//	 -0.000529568,
//	 -0.000416333,
//	 -0.000265628,
//	 -8.12867e-05,
//	 0.00013,
//	 0.000359701,
//	 0.000596908,
//	 0.000829677,
//	 0.00104457,
//	 0.00122841,
//	 0.00136826,
//	 0.00145366,
//	 0.00147624,
//	 0.00143148,
//	 0.00131749,
//	 0.00113691,
//	 0.000896014,
//	 0.000607194,
//	 0.000285308,
//	 -5.19563e-05,
//	 -0.000387275,
//	 -0.000695131,
//	 -0.000958842,
//	 -0.00115846,
//	 -0.00127739,
//	 -0.00130528,
//	 -0.00123462,
//	 -0.00106591,
//	 -0.000804428,
//	 -0.000463007,
//	 -5.92664e-05,
//	 0.000383167,
//	 0.000837539,
//	 0.00127394,
//	 0.0016627,
//	 0.001975,
//	 0.00218602,
//	 0.00227539,
//	 0.00223003,
//	 0.00204437,
//	 0.00172242,
//	 0.00127682,
//	 0.000729308,
//	 0.000108946,
//	 -0.000547891,
//	 -0.00120085,
//	 -0.00180748,
//	 -0.00232648,
//	 -0.00271827,
//	 -0.00295119,
//	 -0.00300112,
//	 -0.00285435,
//	 -0.00251011,
//	 -0.0019793,
//	 -0.00128641,
//	 -0.000467246,
//	 0.000431672,
//	 0.00135632,
//	 0.00224783,
//	 0.00304629,
//	 0.00369428,
//	 0.0041409,
//	 0.00434539,
//	 0.0042804,
//	 0.00393443,
//	 0.00331349,
//	 0.00244167,
//	 0.00136081,
//	 0.000128749,
//	 -0.00118363,
//	 -0.00249613,
//	 -0.00372356,
//	 -0.00478096,
//	 -0.00558948,
//	 -0.00608132,
//	 -0.00620458,
//	 -0.0059281,
//	 -0.00524423,
//	 -0.00417056,
//	 -0.00275136,
//	 -0.00105514,
//	 0.000826848,
//	 0.00278589,
//	 0.00470061,
//	 0.00644423,
//	 0.00789173,
//	 0.00892786,
//	 0.00945467,
//	 0.00939881,
//	 0.00871756,
//	 0.0074038,
//	 0.0054889,
//	 0.00304369,
//	 0.000177241,
//	 -0.00296638,
//	 -0.00621362,
//	 -0.00936894,
//	 -0.012224,
//	 -0.0145674,
//	 -0.0161961,
//	 -0.0169261,
//	 -0.0166028,
//	 -0.015111,
//	 -0.0123822,
//	 -0.0084009,
//	 -0.00320751,
//	 0.00310037,
//	 0.0103705,
//	 0.0184005,
//	 0.0269456,
//	 0.0357282,
//	 0.044449,
//	 0.0528009,
//	 0.0604811,
//	 0.0672059,
//	 0.0727227,
//	 0.0768219,
//	 0.0793463,
//	 0.0801988,
//	 0.0793463,
//	 0.0768219,
//	 0.0727227,
//	 0.0672059,
//	 0.0604811,
//	 0.0528009,
//	 0.044449,
//	 0.0357282,
//	 0.0269456,
//	 0.0184005,
//	 0.0103705,
//	 0.00310037,
//	 -0.00320751,
//	 -0.0084009,
//	 -0.0123822,
//	 -0.015111,
//	 -0.0166028,
//	 -0.0169261,
//	 -0.0161961,
//	 -0.0145674,
//	 -0.012224,
//	 -0.00936894,
//	 -0.00621362,
//	 -0.00296638,
//	 0.000177241,
//	 0.00304369,
//	 0.0054889,
//	 0.0074038,
//	 0.00871756,
//	 0.00939881,
//	 0.00945467,
//	 0.00892786,
//	 0.00789173,
//	 0.00644423,
//	 0.00470061,
//	 0.00278589,
//	 0.000826848,
//	 -0.00105514,
//	 -0.00275136,
//	 -0.00417056,
//	 -0.00524423,
//	 -0.0059281,
//	 -0.00620458,
//	 -0.00608132,
//	 -0.00558948,
//	 -0.00478096,
//	 -0.00372356,
//	 -0.00249613,
//	 -0.00118363,
//	 0.000128749,
//	 0.00136081,
//	 0.00244167,
//	 0.00331349,
//	 0.00393443,
//	 0.0042804,
//	 0.00434539,
//	 0.0041409,
//	 0.00369428,
//	 0.00304629,
//	 0.00224783,
//	 0.00135632,
//	 0.000431672,
//	 -0.000467246,
//	 -0.00128641,
//	 -0.0019793,
//	 -0.00251011,
//	 -0.00285435,
//	 -0.00300112,
//	 -0.00295119,
//	 -0.00271827,
//	 -0.00232648,
//	 -0.00180748,
//	 -0.00120085,
//	 -0.000547891,
//	 0.000108946,
//	 0.000729308,
//	 0.00127682,
//	 0.00172242,
//	 0.00204437,
//	 0.00223003,
//	 0.00227539,
//	 0.00218602,
//	 0.001975,
//	 0.0016627,
//	 0.00127394,
//	 0.000837539,
//	 0.000383167,
//	 -5.92664e-05,
//	 -0.000463007,
//	 -0.000804428,
//	 -0.00106591,
//	 -0.00123462,
//	 -0.00130528,
//	 -0.00127739,
//	 -0.00115846,
//	 -0.000958842,
//	 -0.000695131,
//	 -0.000387275,
//	 -5.19563e-05,
//	 0.000285308,
//	 0.000607194,
//	 0.000896014,
//	 0.00113691,
//	 0.00131749,
//	 0.00143148,
//	 0.00147624,
//	 0.00145366,
//	 0.00136826,
//	 0.00122841,
//	 0.00104457,
//	 0.000829677,
//	 0.000596908,
//	 0.000359701,
//	 0.00013,
//	 -8.12867e-05,
//	 -0.000265628,
//	 -0.000416333,
//	 -0.000529568,
//	 -0.000603611,
//	 -0.000639526,
//	 -0.000640108,
//	 -0.000610215,
//	 -0.000555539,
//	 -0.000482835,
//	 -0.00111256
//};


// // rFIR
// // localSamplingrate = 11025.000000
// // number of taps = 251
// // Band0 Lower=0.000000, Upper=500.000000, Desired=1.000000, Weight=1.000000
// // Band1 Lower=630.000000, Upper=5512.000000, Desired=0.000000, Weight=10.000000
// //Coefficients:
//  const  DSPFLOAT  wideRX[RXNUMTAPS]=
// {
//    0.000300231,
//    -8.20897e-06,
//    -4.11537e-05,
//    -9.46388e-05,
//    -0.000165678,
//    -0.000249422,
//    -0.000339104,
//    -0.000426459,
//    -0.00050217,
//    -0.000556782,
//    -0.000581556,
//    -0.000569598,
//    -0.000516739,
//    -0.000422463,
//    -0.000290329,
//    -0.000128235,
//    5.20287e-05,
//    0.000235434,
//    0.0004051,
//    0.000543697,
//    0.000635391,
//    0.000667432,
//    0.000631989,
//    0.000527203,
//    0.00035825,
//    0.000137199,
//    -0.000117217,
//    -0.000381393,
//    -0.000628444,
//    -0.000831458,
//    -0.000965562,
//    -0.00101162,
//    -0.000955948,
//    -0.000797507,
//    -0.00054387,
//    -0.000213404,
//    0.000165331,
//    0.000557083,
//    0.000921971,
//    0.00122013,
//    0.00141525,
//    0.00147924,
//    0.00139533,
//    0.00116112,
//    0.000789527,
//    0.000308943,
//    -0.000238925,
//    -0.000802116,
//    -0.00132339,
//    -0.00174556,
//    -0.00201774,
//    -0.00210088,
//    -0.00197294,
//    -0.0016322,
//    -0.00109903,
//    -0.000415164,
//    0.000359026,
//    0.00114961,
//    0.00187576,
//    0.00245778,
//    0.00282554,
//    0.00292636,
//    0.00273164,
//    0.00224121,
//    0.00148608,
//    0.000526493,
//    -0.000552233,
//    -0.00164623,
//    -0.00264352,
//    -0.00343428,
//    -0.00392291,
//    -0.00403842,
//    -0.00374381,
//    -0.00304178,
//    -0.00197746,
//    -0.000636259,
//    0.000861911,
//    0.00237298,
//    0.00374158,
//    0.00481658,
//    0.00546654,
//    0.00559482,
//    0.00515159,
//    0.00414242,
//    0.00263122,
//    0.000738094,
//    -0.00136926,
//    -0.00348897,
//    -0.00540332,
//    -0.00689939,
//    -0.00779119,
//    -0.00794022,
//    -0.00727319,
//    -0.00579387,
//    -0.00358894,
//    -0.000825621,
//    0.00225865,
//    0.00537444,
//    0.00820404,
//    0.0104312,
//    0.0117713,
//    0.0120024,
//    0.0109917,
//    0.00871646,
//    0.00527566,
//    0.000892733,
//    -0.00409393,
//    -0.00925022,
//    -0.014076,
//    -0.0180419,
//    -0.0206315,
//    -0.0213845,
//    -0.0199384,
//    -0.0160644,
//    -0.009694,
//    -0.000934707,
//    0.00992761,
//    0.0224406,
//    0.0360101,
//    0.0499371,
//    0.0634635,
//    0.0758241,
//     0.0863,
//    0.0942695,
//    0.0992533,
//    0.100949,
//    0.0992533,
//    0.0942695,
//     0.0863,
//    0.0758241,
//    0.0634635,
//    0.0499371,
//    0.0360101,
//    0.0224406,
//    0.00992761,
//    -0.000934707,
//    -0.009694,
//    -0.0160644,
//    -0.0199384,
//    -0.0213845,
//    -0.0206315,
//    -0.0180419,
//    -0.014076,
//    -0.00925022,
//    -0.00409393,
//    0.000892733,
//    0.00527566,
//    0.00871646,
//    0.0109917,
//    0.0120024,
//    0.0117713,
//    0.0104312,
//    0.00820404,
//    0.00537444,
//    0.00225865,
//    -0.000825621,
//    -0.00358894,
//    -0.00579387,
//    -0.00727319,
//    -0.00794022,
//    -0.00779119,
//    -0.00689939,
//    -0.00540332,
//    -0.00348897,
//    -0.00136926,
//    0.000738094,
//    0.00263122,
//    0.00414242,
//    0.00515159,
//    0.00559482,
//    0.00546654,
//    0.00481658,
//    0.00374158,
//    0.00237298,
//    0.000861911,
//    -0.000636259,
//    -0.00197746,
//    -0.00304178,
//    -0.00374381,
//    -0.00403842,
//    -0.00392291,
//    -0.00343428,
//    -0.00264352,
//    -0.00164623,
//    -0.000552233,
//    0.000526493,
//    0.00148608,
//    0.00224121,
//    0.00273164,
//    0.00292636,
//    0.00282554,
//    0.00245778,
//    0.00187576,
//    0.00114961,
//    0.000359026,
//    -0.000415164,
//    -0.00109903,
//    -0.0016322,
//    -0.00197294,
//    -0.00210088,
//    -0.00201774,
//    -0.00174556,
//    -0.00132339,
//    -0.000802116,
//    -0.000238925,
//    0.000308943,
//    0.000789527,
//    0.00116112,
//    0.00139533,
//    0.00147924,
//    0.00141525,
//    0.00122013,
//    0.000921971,
//    0.000557083,
//    0.000165331,
//    -0.000213404,
//    -0.00054387,
//    -0.000797507,
//    -0.000955948,
//    -0.00101162,
//    -0.000965562,
//    -0.000831458,
//    -0.000628444,
//    -0.000381393,
//    -0.000117217,
//    0.000137199,
//    0.00035825,
//    0.000527203,
//    0.000631989,
//    0.000667432,
//    0.000635391,
//    0.000543697,
//    0.0004051,
//    0.000235434,
//    5.20287e-05,
//    -0.000128235,
//    -0.000290329,
//    -0.000422463,
//    -0.000516739,
//    -0.000569598,
//    -0.000581556,
//    -0.000556782,
//    -0.00050217,
//    -0.000426459,
//    -0.000339104,
//    -0.000249422,
//    -0.000165678,
//    -9.46388e-05,
//    -4.11537e-05,
//    -8.20897e-06,
//    0.000300231
// };

//// rFIR
//// localSamplingrate = 11025.000000
//// number of taps = 251
//// Band0 Lower=0.000000, Upper=999.999000, Desired=0.000000, Weight=10.000000
//// Band1 Lower=1110.000000, Upper=1290.000000, Desired=1.000000, Weight=1.000000
//// Band2 Lower=1400.000000, Upper=5512.000000, Desired=0.000000, Weight=10.000000
////Coefficients:
// const  DSPFLOAT sharp1200BP[RXNUMTAPS]=
//{
//	 -0.000181001,
//	 0.000251417,
//	 -0.000407553,
//	 -0.000113892,
//	 0.000360061,
//	 0.000633657,
//	 0.000641274,
//	 0.000395862,
//	 -5.12681e-05,
//	 -0.000553689,
//	 -0.000879439,
//	 -0.000820056,
//	 -0.00032433,
//	 0.000435928,
//	 0.00111676,
//	 0.00135737,
//	 0.000967803,
//	 5.29504e-05,
//	 -0.00100229,
//	 -0.00169484,
//	 -0.00164687,
//	 -0.000809972,
//	 0.000478952,
//	 0.0016339,
//	 0.00209334,
//	 0.00160099,
//	 0.000349433,
//	 -0.00109484,
//	 -0.00205749,
//	 -0.00208466,
//	 -0.00116866,
//	 0.000247443,
//	 0.00149138,
//	 0.00199728,
//	 0.00158125,
//	 0.000514645,
//	 -0.000639633,
//	 -0.00133383,
//	 -0.00131654,
//	 -0.000735591,
//	 -1.20504e-05,
//	 0.000432654,
//	 0.000430428,
//	 0.000148421,
//	 -5.08362e-05,
//	 0.000116712,
//	 0.000625307,
//	 0.00110932,
//	 0.00107711,
//	 0.000255083,
//	 -0.00114975,
//	 -0.0024561,
//	 -0.00282831,
//	 -0.00176363,
//	 0.00052394,
//	 0.00307314,
//	 0.00457652,
//	 0.00404712,
//	 0.00141358,
//	 -0.00230461,
//	 -0.00538379,
//	 -0.00621703,
//	 -0.00415245,
//	 6.94677e-05,
//	 0.00457672,
//	 0.00721896,
//	 0.00662798,
//	 0.00294486,
//	 -0.00218784,
//	 -0.00638383,
//	 -0.0076732,
//	 -0.00547554,
//	 -0.00088151,
//	 0.00389921,
//	 0.00665079,
//	 0.00624499,
//	 0.00314513,
//	 -0.00092486,
//	 -0.00394617,
//	 -0.00467243,
//	 -0.00320729,
//	 -0.000793654,
//	 0.00102892,
//	 0.00138505,
//	 0.00056018,
//	 -0.000275589,
//	 5.06196e-05,
//	 0.00178544,
//	 0.00389119,
//	 0.00456457,
//	 0.00240679,
//	 -0.00243394,
//	 -0.00790812,
//	 -0.0108727,
//	 -0.00877531,
//	 -0.00135218,
//	 0.00867904,
//	 0.0165229,
//	 0.0175639,
//	 0.00992846,
//	 -0.00402369,
//	 -0.0182552,
//	 -0.0256507,
//	 -0.0215475,
//	 -0.00645296,
//	 0.013569,
//	 0.0293071,
//	 0.0326681,
//	 0.0208103,
//	 -0.00195836,
//	 -0.0256691,
//	 -0.0391028,
//	 -0.0351489,
//	 -0.01453,
//	 0.0140466,
//	 0.0376031,
//	 0.044869,
//	 0.0317345,
//	 0.00350871,
//	 -0.027234,
//	 -0.0463481,
//	 -0.0447258,
//	 -0.0226958,
//	 0.00994727,
//	 0.0383706,
//	 0.0495577,
//	 0.0383706,
//	 0.00994727,
//	 -0.0226958,
//	 -0.0447258,
//	 -0.0463481,
//	 -0.027234,
//	 0.00350871,
//	 0.0317345,
//	 0.044869,
//	 0.0376031,
//	 0.0140466,
//	 -0.01453,
//	 -0.0351489,
//	 -0.0391028,
//	 -0.0256691,
//	 -0.00195836,
//	 0.0208103,
//	 0.0326681,
//	 0.0293071,
//	 0.013569,
//	 -0.00645296,
//	 -0.0215475,
//	 -0.0256507,
//	 -0.0182552,
//	 -0.00402369,
//	 0.00992846,
//	 0.0175639,
//	 0.0165229,
//	 0.00867904,
//	 -0.00135218,
//	 -0.00877531,
//	 -0.0108727,
//	 -0.00790812,
//	 -0.00243394,
//	 0.00240679,
//	 0.00456457,
//	 0.00389119,
//	 0.00178544,
//	 5.06196e-05,
//	 -0.000275589,
//	 0.00056018,
//	 0.00138505,
//	 0.00102892,
//	 -0.000793654,
//	 -0.00320729,
//	 -0.00467243,
//	 -0.00394617,
//	 -0.00092486,
//	 0.00314513,
//	 0.00624499,
//	 0.00665079,
//	 0.00389921,
//	 -0.00088151,
//	 -0.00547554,
//	 -0.0076732,
//	 -0.00638383,
//	 -0.00218784,
//	 0.00294486,
//	 0.00662798,
//	 0.00721896,
//	 0.00457672,
//	 6.94677e-05,
//	 -0.00415245,
//	 -0.00621703,
//	 -0.00538379,
//	 -0.00230461,
//	 0.00141358,
//	 0.00404712,
//	 0.00457652,
//	 0.00307314,
//	 0.00052394,
//	 -0.00176363,
//	 -0.00282831,
//	 -0.0024561,
//	 -0.00114975,
//	 0.000255083,
//	 0.00107711,
//	 0.00110932,
//	 0.000625307,
//	 0.000116712,
//	 -5.08362e-05,
//	 0.000148421,
//	 0.000430428,
//	 0.000432654,
//	 -1.20504e-05,
//	 -0.000735591,
//	 -0.00131654,
//	 -0.00133383,
//	 -0.000639633,
//	 0.000514645,
//	 0.00158125,
//	 0.00199728,
//	 0.00149138,
//	 0.000247443,
//	 -0.00116866,
//	 -0.00208466,
//	 -0.00205749,
//	 -0.00109484,
//	 0.000349433,
//	 0.00160099,
//	 0.00209334,
//	 0.0016339,
//	 0.000478952,
//	 -0.000809972,
//	 -0.00164687,
//	 -0.00169484,
//	 -0.00100229,
//	 5.29504e-05,
//	 0.000967803,
//	 0.00135737,
//	 0.00111676,
//	 0.000435928,
//	 -0.00032433,
//	 -0.000820056,
//	 -0.000879439,
//	 -0.000553689,
//	 -5.12681e-05,
//	 0.000395862,
//	 0.000641274,
//	 0.000633657,
//	 0.000360061,
//	 -0.000113892,
//	 -0.000407553,
//	 0.000251417,
//	 -0.000181001
//};



//// rFIR
//// localSamplingrate = 11025.000000
//// number of taps = 251
//// Band0 Lower=0.000000, Upper=550.000000, Desired=1.000000, Weight=1.000000
//// Band1 Lower=850.000000, Upper=5512.000000, Desired=0.000000, Weight=10.000000
//// demodulator frequency = 1750.000000
////Coefficients:
// const  DSPFLOAT wideVolume[RXNUMTAPS]=
//{
//	 -8.12983e-07,
//	 -6.20807e-07,
//	 -5.71262e-07,
//	 -2.08463e-07,
//	 5.61841e-07,
//	 1.76677e-06,
//	 3.32807e-06,
//	 5.03565e-06,
//	 6.54698e-06,
//	 7.4188e-06,
//	 7.17643e-06,
//	 5.41296e-06,
//	 1.90859e-06,
//	 -3.25452e-06,
//	 -9.60746e-06,
//	 -1.62721e-05,
//	 -2.20201e-05,
//	 -2.54248e-05,
//	 -2.50993e-05,
//	 -1.99967e-05,
//	 -9.71913e-06,
//	 5.22566e-06,
//	 2.32837e-05,
//	 4.18857e-05,
//	 5.77019e-05,
//	 6.70942e-05,
//	 6.67504e-05,
//	 5.43975e-05,
//	 2.94745e-05,
//	 -6.37004e-06,
//	 -4.91004e-05,
//	 -9.25291e-05,
//	 -0.000129015,
//	 -0.000150574,
//	 -0.000150291,
//	 -0.000123799,
//	 -7.05844e-05,
//	 5.16902e-06,
//	 9.44505e-05,
//	 0.000184149,
//	 0.000258662,
//	 0.000302252,
//	 0.000301838,
//	 0.000249793,
//	 0.000146241,
//	 3.42773e-07,
//	 -0.000169823,
//	 -0.000338982,
//	 -0.000477957,
//	 -0.000558161,
//	 -0.000556692,
//	 -0.00046121,
//	 -0.000273687,
//	 -1.22083e-05,
//	 0.000289784,
//	 0.000587038,
//	 0.000828607,
//	 0.000965818,
//	 0.000960953,
//	 0.000795233,
//	 0.000474608,
//	 3.2073e-05,
//	 -0.000474377,
//	 -0.000968335,
//	 -0.00136559,
//	 -0.00158739,
//	 -0.00157453,
//	 -0.00129973,
//	 -0.000776269,
//	 -6.06608e-05,
//	 0.000751585,
//	 0.00153735,
//	 0.00216326,
//	 0.00250687,
//	 0.00247833,
//	 0.00203924,
//	 0.00121491,
//	 9.73382e-05,
//	 -0.0011625,
//	 -0.00237319,
//	 -0.00333006,
//	 -0.00384765,
//	 -0.00379243,
//	 -0.0031105,
//	 -0.00184508,
//	 -0.000139903,
//	 0.00177363,
//	 0.00360499,
//	 0.00504579,
//	 0.00581827,
//	 0.00572385,
//	 0.0046839,
//	 0.00276522,
//	 0.000184684,
//	 -0.00270984,
//	 -0.00548173,
//	 -0.00766633,
//	 -0.00884263,
//	 -0.00870541,
//	 -0.00712658,
//	 -0.00419509,
//	 -0.000226991,
//	 0.00425896,
//	 0.00859967,
//	 0.0120746,
//	 0.0140108,
//	 0.0138925,
//	 0.0114587,
//	 0.00677437,
//	 0.000261833,
//	 -0.00731507,
//	 -0.0149163,
//	 -0.0213353,
//	 -0.0253404,
//	 -0.0258336,
//	 -0.0220032,
//	 -0.0134525,
//	 -0.000284783,
//	 0.0168686,
//	 0.0368837,
//	 0.058241,
//	 0.079175,
//	 0.0978591,
//	 0.112604,
//	 0.122044,
//	 0.125293,
//	 0.122044,
//	 0.112604,
//	 0.0978591,
//	 0.079175,
//	 0.058241,
//	 0.0368837,
//	 0.0168686,
//	 -0.000284783,
//	 -0.0134525,
//	 -0.0220032,
//	 -0.0258336,
//	 -0.0253404,
//	 -0.0213353,
//	 -0.0149163,
//	 -0.00731507,
//	 0.000261833,
//	 0.00677437,
//	 0.0114587,
//	 0.0138925,
//	 0.0140108,
//	 0.0120746,
//	 0.00859967,
//	 0.00425896,
//	 -0.000226991,
//	 -0.00419509,
//	 -0.00712658,
//	 -0.00870541,
//	 -0.00884263,
//	 -0.00766633,
//	 -0.00548173,
//	 -0.00270984,
//	 0.000184684,
//	 0.00276522,
//	 0.0046839,
//	 0.00572385,
//	 0.00581827,
//	 0.00504579,
//	 0.00360499,
//	 0.00177363,
//	 -0.000139903,
//	 -0.00184508,
//	 -0.0031105,
//	 -0.00379243,
//	 -0.00384765,
//	 -0.00333006,
//	 -0.00237319,
//	 -0.0011625,
//	 9.73382e-05,
//	 0.00121491,
//	 0.00203924,
//	 0.00247833,
//	 0.00250687,
//	 0.00216326,
//	 0.00153735,
//	 0.000751585,
//	 -6.06608e-05,
//	 -0.000776269,
//	 -0.00129973,
//	 -0.00157453,
//	 -0.00158739,
//	 -0.00136559,
//	 -0.000968335,
//	 -0.000474377,
//	 3.2073e-05,
//	 0.000474608,
//	 0.000795233,
//	 0.000960953,
//	 0.000965818,
//	 0.000828607,
//	 0.000587038,
//	 0.000289784,
//	 -1.22083e-05,
//	 -0.000273687,
//	 -0.00046121,
//	 -0.000556692,
//	 -0.000558161,
//	 -0.000477957,
//	 -0.000338982,
//	 -0.000169823,
//	 3.42773e-07,
//	 0.000146241,
//	 0.000249793,
//	 0.000301838,
//	 0.000302252,
//	 0.000258662,
//	 0.000184149,
//	 9.44505e-05,
//	 5.16902e-06,
//	 -7.05844e-05,
//	 -0.000123799,
//	 -0.000150291,
//	 -0.000150574,
//	 -0.000129015,
//	 -9.25291e-05,
//	 -4.91004e-05,
//	 -6.37004e-06,
//	 2.94745e-05,
//	 5.43975e-05,
//	 6.67504e-05,
//	 6.70942e-05,
//	 5.77019e-05,
//	 4.18857e-05,
//	 2.32837e-05,
//	 5.22566e-06,
//	 -9.71913e-06,
//	 -1.99967e-05,
//	 -2.50993e-05,
//	 -2.54248e-05,
//	 -2.20201e-05,
//	 -1.62721e-05,
//	 -9.60746e-06,
//	 -3.25452e-06,
//	 1.90859e-06,
//	 5.41296e-06,
//	 7.17643e-06,
//	 7.4188e-06,
//	 6.54698e-06,
//	 5.03565e-06,
//	 3.32807e-06,
//	 1.76677e-06,
//	 5.61841e-07,
//	 -2.08463e-07,
//	 -5.71262e-07,
//	 -6.20807e-07,
//	 -8.12983e-07
//};
// const DSPFLOAT veryWideVolume[RXNUMTAPS]=
//{
//	 1.64357e-05,
//	 -4.23193e-05,
//	 -4.14901e-05,
//	 -4.74921e-05,
//	 -4.96931e-05,
//	 -4.33244e-05,
//	 -2.66581e-05,
//	 -7.16336e-07,
//	 3.07848e-05,
//	 6.18288e-05,
//	 8.51506e-05,
//	 9.37278e-05,
//	 8.25922e-05,
//	 5.04016e-05,
//	 5.18827e-07,
//	 -5.8932e-05,
//	 -0.000116071,
//	 -0.000157418,
//	 -0.000170751,
//	 -0.0001482,
//	 -8.87869e-05,
//	 1.59863e-07,
//	 0.000103401,
//	 0.000199998,
//	 0.00026727,
//	 0.000285688,
//	 0.000243843,
//	 0.0001422,
//	 -5.26495e-06,
//	 -0.000172346,
//	 -0.000324768,
//	 -0.000426854,
//	 -0.000449283,
//	 -0.000376571,
//	 -0.000212291,
//	 1.92053e-05,
//	 0.000275638,
//	 0.000503917,
//	 0.000650668,
//	 0.000673945,
//	 0.000553971,
//	 0.000299992,
//	 -4.82102e-05,
//	 -0.000425738,
//	 -0.000753809,
//	 -0.000955647,
//	 -0.000973745,
//	 -0.000783958,
//	 -0.000405082,
//	 0.000101089,
//	 0.000638559,
//	 0.00109458,
//	 0.00136236,
//	 0.00136503,
//	 0.00107529,
//	 0.000526322,
//	 -0.000189418,
//	 -0.000934401,
//	 -0.00155146,
//	 -0.00189586,
//	 -0.00186775,
//	 -0.00143799,
//	 -0.00066103,
//	 0.000329022,
//	 0.00133993,
//	 0.0021574,
//	 0.00258906,
//	 0.00250785,
//	 0.00188506,
//	 0.000805333,
//	 -0.000541519,
//	 -0.00189182,
//	 -0.00295802,
//	 -0.00348805,
//	 -0.00332229,
//	 -0.00243558,
//	 -0.000954212,
//	 0.000857982,
//	 0.00264405,
//	 0.00402195,
//	 0.00466364,
//	 0.00436938,
//	 0.00312112,
//	 0.00110175,
//	 -0.00132647,
//	 -0.00368338,
//	 -0.00546249,
//	 -0.00623577,
//	 -0.00575096,
//	 -0.00399989,
//	 -0.00124154,
//	 0.0020292,
//	 0.00516496,
//	 0.00748838,
//	 0.00843175,
//	 0.00766589,
//	 0.005191,
//	 0.00136708,
//	 -0.0031274,
//	 -0.0074065,
//	 -0.010541,
//	 -0.0117467,
//	 -0.0105615,
//	 -0.00697387,
//	 -0.00147219,
//	 0.00500105,
//	 0.0111914,
//	 0.0157512,
//	 0.0175002,
//	 0.0156816,
//	 0.0101648,
//	 0.0015515,
//	 -0.0088417,
//	 -0.0191334,
//	 -0.0271425,
//	 -0.0307308,
//	 -0.0281698,
//	 -0.0184676,
//	 -0.00160082,
//	 0.0213961,
//	 0.0485054,
//	 0.0769597,
//	 0.103604,
//	 0.125334,
//	 0.139537,
//	 0.144475,
//	 0.139537,
//	 0.125334,
//	 0.103604,
//	 0.0769597,
//	 0.0485054,
//	 0.0213961,
//	 -0.00160082,
//	 -0.0184676,
//	 -0.0281698,
//	 -0.0307308,
//	 -0.0271425,
//	 -0.0191334,
//	 -0.0088417,
//	 0.0015515,
//	 0.0101648,
//	 0.0156816,
//	 0.0175002,
//	 0.0157512,
//	 0.0111914,
//	 0.00500105,
//	 -0.00147219,
//	 -0.00697387,
//	 -0.0105615,
//	 -0.0117467,
//	 -0.010541,
//	 -0.0074065,
//	 -0.0031274,
//	 0.00136708,
//	 0.005191,
//	 0.00766589,
//	 0.00843175,
//	 0.00748838,
//	 0.00516496,
//	 0.0020292,
//	 -0.00124154,
//	 -0.00399989,
//	 -0.00575096,
//	 -0.00623577,
//	 -0.00546249,
//	 -0.00368338,
//	 -0.00132647,
//	 0.00110175,
//	 0.00312112,
//	 0.00436938,
//	 0.00466364,
//	 0.00402195,
//	 0.00264405,
//	 0.000857982,
//	 -0.000954212,
//	 -0.00243558,
//	 -0.00332229,
//	 -0.00348805,
//	 -0.00295802,
//	 -0.00189182,
//	 -0.000541519,
//	 0.000805333,
//	 0.00188506,
//	 0.00250785,
//	 0.00258906,
//	 0.0021574,
//	 0.00133993,
//	 0.000329022,
//	 -0.00066103,
//	 -0.00143799,
//	 -0.00186775,
//	 -0.00189586,
//	 -0.00155146,
//	 -0.000934401,
//	 -0.000189418,
//	 0.000526322,
//	 0.00107529,
//	 0.00136503,
//	 0.00136236,
//	 0.00109458,
//	 0.000638559,
//	 0.000101089,
//	 -0.000405082,
//	 -0.000783958,
//	 -0.000973745,
//	 -0.000955647,
//	 -0.000753809,
//	 -0.000425738,
//	 -4.82102e-05,
//	 0.000299992,
//	 0.000553971,
//	 0.000673945,
//	 0.000650668,
//	 0.000503917,
//	 0.000275638,
//	 1.92053e-05,
//	 -0.000212291,
//	 -0.000376571,
//	 -0.000449283,
//	 -0.000426854,
//	 -0.000324768,
//	 -0.000172346,
//	 -5.26495e-06,
//	 0.0001422,
//	 0.000243843,
//	 0.000285688,
//	 0.00026727,
//	 0.000199998,
//	 0.000103401,
//	 1.59863e-07,
//	 -8.87869e-05,
//	 -0.0001482,
//	 -0.000170751,
//	 -0.000157418,
//	 -0.000116071,
//	 -5.8932e-05,
//	 5.18827e-07,
//	 5.04016e-05,
//	 8.25922e-05,
//	 9.37278e-05,
//	 8.51506e-05,
//	 6.18288e-05,
//	 3.07848e-05,
//	 -7.16336e-07,
//	 -2.66581e-05,
//	 -4.33244e-05,
//	 -4.96931e-05,
//	 -4.74921e-05,
//	 -4.14901e-05,
//	 -4.23193e-05,
//	 1.64357e-05
//};

// // blFIR  Raised cosine
// // localSamplingrate = 11025.000000
// // number of taps = 251
// // corner frequency = 400.000000
// // beta = 0.600000
// // window applied
// // demodulator frequency = 1900.000000
// //Coefficients:
//  const DSPFLOAT narrowRXBLFIR[RXNUMTAPS]=
// {
//    -9.43009e-07,
//    5.86068e-08,
//    2.59295e-06,
//    6.51998e-06,
//    1.15194e-05,
//    1.71102e-05,
//    2.26892e-05,
//    2.75867e-05,
//    3.11375e-05,
//    3.27613e-05,
//    3.20439e-05,
//    2.88109e-05,
//    2.31824e-05,
//    1.55969e-05,
//    6.79757e-06,
//    -2.2262e-06,
//    -1.03411e-05,
//    -1.64097e-05,
//    -1.94538e-05,
//    -1.88235e-05,
//    -1.43458e-05,
//    -6.42942e-06,
//    3.89847e-06,
//    1.50404e-05,
//    2.49686e-05,
//    3.14515e-05,
//    3.23475e-05,
//    2.59321e-05,
//    1.12168e-05,
//    -1.17913e-05,
//    -4.19352e-05,
//    -7.69e-05,
//    -0.000113373,
//    -0.000147376,
//    -0.000174744,
//    -0.000191702,
//    -0.000195469,
//    -0.000184804,
//    -0.000160398,
//    -0.000125046,
//    -8.35194e-05,
//    -4.21352e-05,
//    -8.02811e-06,
//    1.18057e-05,
//    1.15857e-05,
//    -1.21957e-05,
//    -5.98941e-05,
//    -0.000128166,
//    -0.00020988,
//    -0.000294572,
//    -0.000369439,
//    -0.00042083,
//    -0.000436057,
//    -0.000405344,
//    -0.000323618,
//    -0.00019189,
//    -1.79507e-05,
//    0.000183806,
//    0.000393536,
//    0.000588041,
//    0.000743654,
//    0.000839602,
//    0.000861438,
//    0.000804074,
//    0.000673905,
//    0.00048961,
//    0.000281309,
//    8.79499e-05,
//    -4.69626e-05,
//    -8.09498e-05,
//    2.11247e-05,
//    0.000280781,
//    0.000700568,
//    0.0012605,
//    0.0019171,
//    0.00260546,
//    0.00324473,
//    0.00374659,
//    0.00402614,
//    0.00401415,
//    0.00366917,
//    0.00298774,
//    0.00201128,
//    0.000827827,
//    -0.000432323,
//    -0.00160758,
//    -0.00252251,
//    -0.00301058,
//    -0.00294038,
//    -0.00224255,
//    -0.000934317,
//    0.000861952,
//    0.00290941,
//    0.00485956,
//    0.00626926,
//    0.00663259,
//    0.00542685,
//    0.00217056,
//    -0.00351075,
//    -0.011816,
//    -0.0227036,
//    -0.0358372,
//    -0.0505484,
//    -0.0658229,
//    -0.0803145,
//    -0.0923896,
//    -0.100202,
//    -0.101798,
//    -0.0952396,
//    -0.078749,
//    -0.0508547,
//    -0.0105335,
//    0.0426651,
//    0.108522,
//    0.186092,
//    0.273685,
//    0.368909,
//    0.46875,
//    0.569709,
//    0.667969,
//    0.759603,
//    0.840785,
//    0.908018,
//    0.95833,
//    0.989462,
//          1,
//    0.989462,
//    0.95833,
//    0.908018,
//    0.840785,
//    0.759603,
//    0.667969,
//    0.569709,
//    0.46875,
//    0.368909,
//    0.273685,
//    0.186092,
//    0.108522,
//    0.0426651,
//    -0.0105335,
//    -0.0508547,
//    -0.078749,
//    -0.0952396,
//    -0.101798,
//    -0.100202,
//    -0.0923896,
//    -0.0803145,
//    -0.0658229,
//    -0.0505484,
//    -0.0358372,
//    -0.0227036,
//    -0.011816,
//    -0.00351075,
//    0.00217056,
//    0.00542685,
//    0.00663259,
//    0.00626926,
//    0.00485956,
//    0.00290941,
//    0.000861952,
//    -0.000934317,
//    -0.00224255,
//    -0.00294038,
//    -0.00301058,
//    -0.00252251,
//    -0.00160758,
//    -0.000432323,
//    0.000827827,
//    0.00201128,
//    0.00298774,
//    0.00366917,
//    0.00401415,
//    0.00402614,
//    0.00374659,
//    0.00324473,
//    0.00260546,
//    0.0019171,
//    0.0012605,
//    0.000700568,
//    0.000280781,
//    2.11247e-05,
//    -8.09498e-05,
//    -4.69626e-05,
//    8.79499e-05,
//    0.000281309,
//    0.00048961,
//    0.000673905,
//    0.000804074,
//    0.000861438,
//    0.000839602,
//    0.000743654,
//    0.000588041,
//    0.000393536,
//    0.000183806,
//    -1.79507e-05,
//    -0.00019189,
//    -0.000323618,
//    -0.000405344,
//    -0.000436057,
//    -0.00042083,
//    -0.000369439,
//    -0.000294572,
//    -0.00020988,
//    -0.000128166,
//    -5.98941e-05,
//    -1.21957e-05,
//    1.15857e-05,
//    1.18057e-05,
//    -8.02811e-06,
//    -4.21352e-05,
//    -8.35194e-05,
//    -0.000125046,
//    -0.000160398,
//    -0.000184804,
//    -0.000195469,
//    -0.000191702,
//    -0.000174744,
//    -0.000147376,
//    -0.000113373,
//    -7.69e-05,
//    -4.19352e-05,
//    -1.17913e-05,
//    1.12168e-05,
//    2.59321e-05,
//    3.23475e-05,
//    3.14515e-05,
//    2.49686e-05,
//    1.50404e-05,
//    3.89847e-06,
//    -6.42942e-06,
//    -1.43458e-05,
//    -1.88235e-05,
//    -1.94538e-05,
//    -1.64097e-05,
//    -1.03411e-05,
//    -2.2262e-06,
//    6.79757e-06,
//    1.55969e-05,
//    2.31824e-05,
//    2.88109e-05,
//    3.20439e-05,
//    3.27613e-05,
//    3.11375e-05,
//    2.75867e-05,
//    2.26892e-05,
//    1.71102e-05,
//    1.15194e-05,
//    6.51998e-06,
//    2.59295e-06,
//    5.86068e-08,
//    -9.43009e-07
// };

//  // blFIR  Raised cosine
//  // localSamplingrate = 12000.000000
//  // number of taps = 251
//  // corner frequency = 500.000000
//  // beta = 0.700000
//  // window applied
//  const DSPFLOAT wideRXBLFIR[RXNUMTAPS]=
//  {
//     6.78868e-06,
//     7.62652e-06,
//     7.3611e-06,
//     5.89395e-06,
//     3.33524e-06,
//     1.60138e-10,
//     -3.63027e-06,
//     -6.98132e-06,
//     -9.48175e-06,
//     -1.06723e-05,
//     -1.03077e-05,
//     -8.43229e-06,
//     -5.41094e-06,
//     -1.90134e-06,
//     1.23557e-06,
//     3.08018e-06,
//     2.83336e-06,
//     -7.55651e-10,
//     -5.46557e-06,
//     -1.30733e-05,
//     -2.18248e-05,
//     -3.03406e-05,
//     -3.70925e-05,
//     -4.0704e-05,
//     -4.02644e-05,
//     -3.5593e-05,
//     -2.73867e-05,
//     -1.7202e-05,
//     -7.24703e-06,
//     -1.63e-09,
//     2.28199e-06,
//     -1.89402e-06,
//     -1.28279e-05,
//     -2.93639e-05,
//     -4.89128e-05,
//     -6.77847e-05,
//     -8.18086e-05,
//     -8.71484e-05,
//     -8.11663e-05,
//     -6.31571e-05,
//     -3.47725e-05,
//     -1.22628e-09,
//     3.5357e-05,
//     6.46837e-05,
//     8.18541e-05,
//     8.26343e-05,
//     6.58754e-05,
//     3.42194e-05,
//     -5.90498e-06,
//     -4.5097e-05,
//     -7.25517e-05,
//     -7.81545e-05,
//     -5.47315e-05,
//     8.4255e-10,
//     8.22444e-05,
//     0.000182046,
//     0.000284521,
//     0.00037229,
//     0.000428806,
//     0.000441971,
//     0.000407341,
//     0.000330171,
//     0.000225707,
//     0.000117409,
//     3.31634e-05,
//     2.85785e-09,
//     3.82104e-05,
//     0.000155948,
//     0.000345618,
//     0.000582967,
//     0.000829548,
//     0.00103851,
//     0.00116306,
//     0.00116619,
//     0.00102993,
//     0.000762039,
//     0.00039841,
//     2.79295e-09,
//     -0.000356014,
//     -0.000589978,
//     -0.000636324,
//     -0.000460149,
//     -7.0336e-05,
//     0.000473995,
//     0.00106621,
//     0.00156515,
//     0.00181749,
//     0.00168694,
//     0.00108532,
//     7.96117e-10,
//     -0.00148873,
//     -0.00320568,
//     -0.00489779,
//     -0.00627071,
//     -0.00704213,
//     -0.00700509,
//     -0.00609177,
//     -0.00442574,
//     -0.00235059,
//     -0.00042436,
//     0.000627163,
//     -1.18464e-09,
//     -0.00306066,
//     -0.00910697,
//     -0.0183266,
//     -0.0303951,
//     -0.0443657,
//     -0.0586203,
//     -0.0708981,
//     -0.0784119,
//     -0.0780524,
//     -0.0666671,
//     -0.0413915,
//     -1.94497e-09,
//     0.0587624,
//     0.134907,
//     0.227025,
//     0.332237,
//     0.44628,
//     0.563746,
//     0.678442,
//     0.783855,
//     0.873667,
//     0.942288,
//     0.985332,
//           1,
//     0.985332,
//     0.942288,
//     0.873667,
//     0.783855,
//     0.678442,
//     0.563746,
//     0.44628,
//     0.332237,
//     0.227025,
//     0.134907,
//     0.0587624,
//     -1.94497e-09,
//     -0.0413915,
//     -0.0666671,
//     -0.0780524,
//     -0.0784119,
//     -0.0708981,
//     -0.0586203,
//     -0.0443657,
//     -0.0303951,
//     -0.0183266,
//     -0.00910697,
//     -0.00306066,
//     -1.18464e-09,
//     0.000627163,
//     -0.00042436,
//     -0.00235059,
//     -0.00442574,
//     -0.00609177,
//     -0.00700509,
//     -0.00704213,
//     -0.00627071,
//     -0.00489779,
//     -0.00320568,
//     -0.00148873,
//     7.96117e-10,
//     0.00108532,
//     0.00168694,
//     0.00181749,
//     0.00156515,
//     0.00106621,
//     0.000473995,
//     -7.0336e-05,
//     -0.000460149,
//     -0.000636324,
//     -0.000589978,
//     -0.000356014,
//     2.79295e-09,
//     0.00039841,
//     0.000762039,
//     0.00102993,
//     0.00116619,
//     0.00116306,
//     0.00103851,
//     0.000829548,
//     0.000582967,
//     0.000345618,
//     0.000155948,
//     3.82104e-05,
//     2.85785e-09,
//     3.31634e-05,
//     0.000117409,
//     0.000225707,
//     0.000330171,
//     0.000407341,
//     0.000441971,
//     0.000428806,
//     0.00037229,
//     0.000284521,
//     0.000182046,
//     8.22444e-05,
//     8.4255e-10,
//     -5.47315e-05,
//     -7.81545e-05,
//     -7.25517e-05,
//     -4.5097e-05,
//     -5.90498e-06,
//     3.42194e-05,
//     6.58754e-05,
//     8.26343e-05,
//     8.18541e-05,
//     6.46837e-05,
//     3.5357e-05,
//     -1.22628e-09,
//     -3.47725e-05,
//     -6.31571e-05,
//     -8.11663e-05,
//     -8.71484e-05,
//     -8.18086e-05,
//     -6.77847e-05,
//     -4.89128e-05,
//     -2.93639e-05,
//     -1.28279e-05,
//     -1.89402e-06,
//     2.28199e-06,
//     -1.63e-09,
//     -7.24703e-06,
//     -1.7202e-05,
//     -2.73867e-05,
//     -3.5593e-05,
//     -4.02644e-05,
//     -4.0704e-05,
//     -3.70925e-05,
//     -3.03406e-05,
//     -2.18248e-05,
//     -1.30733e-05,
//     -5.46557e-06,
//     -7.55651e-10,
//     2.83336e-06,
//     3.08018e-06,
//     1.23557e-06,
//     -1.90134e-06,
//     -5.41094e-06,
//     -8.43229e-06,
//     -1.03077e-05,
//     -1.06723e-05,
//     -9.48175e-06,
//     -6.98132e-06,
//     -3.63027e-06,
//     1.60138e-10,
//     3.33524e-06,
//     5.89395e-06,
//     7.3611e-06,
//     7.62652e-06,
//     6.78868e-06
//  };



//const DSPFLOAT f800TX[TXNUMTAPS]=
//{

//};

DSPFLOAT calculateGain(const DSPFLOAT *fp,unsigned int len)
{
	unsigned int i;
	DSPFLOAT fs=0.;
	for(i=0;i<len;i++)
		{
			fs+=fp[i];
		}
	return fs;
}

sfilters filterStruct[NUMRXFILTERS]=
{
//	{"800 Hz",narrowRX,1900},
//	{"1000 Hz",wideRX,1900},
   {"600Hz Video",wide600Hz,1700},
//   {"600Hz Video",wide600Hz,1700},

};

