/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MODEBASE_H
#define MODEBASE_H
#include "../sstvparam.h"
#include "widgets/imageviewer.h"
#include <math.h>

#define stHUNT			 0
#define stColorLine0 1 
#define stColorLine1 2
#define stColorLine2 3
#define stColorLine3 4
#define stColorLine4 5
#define stG1				 6
#define stG2				 7
#define stRepTone		 8
#define stWaitVIS		 9
#define stSTART			10
#define stWaitSync	11
#define stFP				12
#define stBP				13
#define stSync			14
#define st1900B			15
#define st1900E     16
#define stWAIT      17
#define stHALF      18
#define stFULL      19
#define stBITS			20



class imageViewer;

class modeBase
{
public:
	enum embState {MBERROR,MBSETUPLINE,MBPIXELS,MBSYNC,MBENDOFLINE,MBEOIMAGE,MBRXWAIT,MBTXGAP,MBTXGAPROBOT};
	enum eModeBase {MBRUNNING,MBENDOFIMAGE};
	modeBase(esstvMode m,unsigned int len,bool tx);
	virtual ~modeBase();
  /*!
    \brief initialize mode specific items

    This function is called by modeInit(), and can overwrite some or all of the local parameters. At least it should set the visible length.
    \param[in] clock  can be the rxClock or the txClock
*/
	virtual void setupParams(double clock)=0;

	virtual bool getPixels();
	virtual unsigned long adjustSyncPosition(unsigned long syncPos)
		{
			return syncPos;
		}

	void redrawFast(bool r);
  virtual eModeBase process(int *demod,unsigned int syncPos=0,bool goToSync=false);
  void init(DSPFLOAT clk);
	unsigned char *debugStatePtr;
  void abort();
  esstvMode getMode() { return mode;}
  eModeBase transmitImage(imageViewer *iv);
  void setRxSampleCounter(int sc) { rxSampleCounter=sc;}
  void saveImage();
  int receivedLines() {return displayLineCounter;}
  int imageLines() {return activeSSTVParam->numberOfDisplayLines;}
  int imagePixels() {return activeSSTVParam->numberOfPixels;}
protected:
	DSPFLOAT visibleLineLength;
	esstvMode mode;
	bool transmit;
	bool fastRedraw;
	DSPFLOAT fp;
	DSPFLOAT bp;
	DSPFLOAT blank;
	DSPFLOAT syncDuration;
	DSPFLOAT localClock;

  int sample;
  DSPFLOAT start;
  sSSTVParam *activeSSTVParam;


	unsigned int marker;
	unsigned int syncPosition;
	unsigned int syncEndPosition;
	unsigned int lineCounter;
	unsigned int displayLineCounter;
	unsigned int pixelCounter;
	unsigned int sampleCounter;
	embState state;
	unsigned int subLine;
	unsigned int length;

	unsigned char *greenArrayPtr;
	unsigned char *blueArrayPtr;
	unsigned char *redArrayPtr;
	unsigned char *yArrayPtr;
	unsigned char *pixelArrayPtr;
	unsigned int *pixelPositionTable;
	unsigned char debugState;

	DSPFLOAT txFreq;
	unsigned int txDur;
	void deleteBuffers();
	virtual void showLine();
	void combineColors();
	void yuvConversion(unsigned char *array);
  void grayConversion();
  /*!
      \brief setup the rx mode timing for one subline  at a time.

      Each line is subdivided in subLines. A subLine can be a pixel line, a delay or a sync. This function is called from the receive function in the modebase.
      \param subLine  active phase in the reception of a image line
  */
  virtual embState rxSetupLine()=0;

/**
      \brief setup the tx mode timing for one subline  at a time.

      Each line is subdivided in subLines. A subLine can be a pixel line, a delay or a sync. This function is called from transmit function in the modebase.
      \param subln  active phase in the reception of a image line
  */
  virtual embState txSetupLine()=0;

  virtual void getLine();
  void getLineY(bool evenodd);
  void getLineBW();
  int rxSampleCounter;


private:
  void sendPixelBuffer();
  bool abortRun;
  imageViewer *txImPtr;



};

#endif
