% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_outer.R
\name{plotConv}
\alias{plotConv}
\title{Plot Convergence of BMA Sampler}
\usage{
plotConv(bmao, include.legend = TRUE, add.grid = TRUE, ...)
}
\arguments{
\item{bmao}{an object of class 'bma' - see \code{\link{bms}}}

\item{include.legend}{whether to include a \code{\link{legend}} in the plot}

\item{add.grid}{whether to include a \code{\link{grid}} in the plot}

\item{\dots}{other parameters for \code{\link{matplot}}}
}
\description{
Plots the posterior model probabilites based on 1) marginal likelihoods and
2) MCMC frequencies for the best models in a 'bma' object and details the
sampler's convergence by their correlation
}
\details{
A call to bms with a MCMC sampler (e.g.
\code{bms(datafls,mcmc="bd",nmodel=100)} uses a Metropolis-Hastings
algorithm to sample through the model space: the frequency of how often
models are drawn converges to the distribution of their posterior marginal
likelihoods.\cr While sampling, each 'bma' object stores the best models
encountered by its sampling chain with their marginal likelihood and their
MCMC frequencies.\cr \code{plotConv} compares the MCMC frequencies to
marginal likelihoods, and thus visualizes how well the sampler has
converged.
}
\note{
\code{plotConv} is also used by \code{\link{plot.bma}}
}
\examples{


data(datafls)
mm=bms(datafls[,1:12],user.int=FALSE)

plotConv(mm)

#is similar to
matplot(pmp.bma(mm),type="l")

}
\seealso{
\code{\link{pmp.bma}} for posterior model probabilites based on the
two concepts, \code{\link{bms}} for creating objects of class 'bma'

Check \url{http://bms.zeugner.eu} for additional help.
}
\keyword{aplot}
