% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeClusterMPI.R
\name{makeClusterMPI}
\alias{makeClusterMPI}
\title{Create a Message Passing Interface (MPI) cluster of \R workers for parallel processing}
\usage{
makeClusterMPI(
  workers,
  ...,
  autoStop = FALSE,
  verbose = getOption("future.debug", FALSE)
)
}
\arguments{
\item{workers}{The number workers (as a positive integer).}

\item{\dots}{Optional arguments passed to
\code{\link[parallel:makeCluster]{makeCluster}(workers, type = "MPI", ...)}.}

\item{autoStop}{If TRUE, the cluster will be automatically stopped}

\item{verbose}{If TRUE, informative messages are outputted.}
}
\value{
An object of class \code{"FutureMPIcluster"} consisting
of a list of \code{"MPInode"} workers.
}
\description{
The \code{makeClusterMPI()} function creates an MPI cluster of \R workers
for parallel processing.  This function utilizes
\code{makeCluster(..., type = "MPI")} of the \pkg{parallel} package and
tweaks the cluster in an attempt to avoid
\code{\link[parallel:stopCluster]{stopCluster()}} from hanging (1).
\emph{WARNING: This function is very much in a beta version and should
only be used if \code{parallel::makeCluster(..., type = "MPI")} fails.}
}
\details{
\emph{Creating MPI clusters requires the \strong{Rmpi} package.}
}
\references{
\enumerate{
\item R-sig-hpc thread \href{https://stat.ethz.ch/pipermail/r-sig-hpc/2017-September/002065.html}{Rmpi: mpi.close.Rslaves() 'hangs'} on 2017-09-28.
}
}
\seealso{
\code{\link[=makeClusterPSOCK]{makeClusterPSOCK()}} and
\code{\link[parallel:makeCluster]{parallel::makeCluster}()}.
}
