% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSD.clusterplot.R
\name{singleclusterplot}
\alias{singleclusterplot}
\alias{LSD.singleclusterplot}
\title{Visualize two-dimensional data clusters (add to an existing plot)}
\usage{
singleclusterplot(
  input,
  at = NULL,
  fromto = c(0.05, 0.95),
  colpal = "standardheat",
  simulate = FALSE,
  daltonize = FALSE,
  cvd = "p",
  nrcol = 25,
  outer.col = "lightgrey",
  rev = FALSE,
  alpha = NULL,
  quartiles.col = c("grey", "black", "grey"),
  add.quartiles = TRUE
)
}
\arguments{
\item{input}{matrix or list with numerical entries.}

\item{at}{a integer vector containing the x-positions corresponding to the columns of 'input'.}

\item{fromto}{a numeric vector containing the range of quantiles (between 0 and 1) to be plotted.}

\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}).}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{nrcol}{a non-negative integer specifying the number of colors to be used (defaults to 25, if not specified).}

\item{outer.col}{R built-in color to be used for outlier lines (lines outside of 'fromto').}

\item{rev}{logical: if \code{TRUE} (\code{FALSE} by default), a reversed colorpalette is used.}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{quartiles.col}{a character vector containing three R built-in colors for quartile lines (c('0.25','0.5','0.75')).}

\item{add.quartiles}{logical: if \code{TRUE} (by default), lines are plotted corresponding to the quartiles.}
}
\description{
Depict a numeric matrix or list utilizing the underlying distribution quantiles of one dimension in a color encoded fashion (add to an existing plot).
}
\examples{
samples = 100
probes = 200
clus = matrix(rnorm(probes*samples,sd=1),ncol=probes)

clus = rbind(
	t(t(clus)+sin(1:probes/10))+1:nrow(clus)/samples,
	t(t(clus)+sin(pi/2+1:probes/10))+1:nrow(clus)/samples)

emptyplot(xlim = c(1,ncol(clus)),ylim = range(clus))
singleclusterplot(clus)
axis(1)
axis(2)
box()
}
\seealso{
\code{\link{clusterplot}}, \code{\link{align}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\author{
Achim Tresch, Bjoern Schwalb
}
\keyword{cluster}
