% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{phreg_lt}
\alias{phreg_lt}
\title{Lu-Tsiatis More Efficient Log-Rank for Randomized studies with baseline covariates}
\usage{
phreg_lt(
  formula,
  data,
  augmentR = NULL,
  treat.model = ~+1,
  augmentC = NULL,
  km = TRUE,
  cens.code = 0,
  level = 0.95,
  cens.model = NULL,
  typeII = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with 'Surv' outcome (see \code{coxph}) and treatment (randomization 0/1)}

\item{data}{data frame}

\item{augmentR}{formula for the randomization augmentation  (~age+sex)}

\item{treat.model}{propensity score model, default is ~+1, assuming RCT study}

\item{augmentC}{formula for the censoring augmentation  (~age+sex)}

\item{km}{use Kaplan-Meier for the censoring weights (stratified on treatment)}

\item{cens.code}{censoring code}

\item{level}{of confidence intervals}

\item{cens.model, }{default is censoring model ~strata(treatment) but any model can be used to make censoring martingales}

\item{typeII}{if 1 then computes also alternative formulae that are based on the censoring martingale rather than the robust processes of  Lu-Tsiatis computations.}

\item{...}{Additional arguments to phreg function}
}
\description{
Efficient implementation of the Lu-Tsiatis improvement using baseline covariates. Results
almost equivalent with the speffSurv function of the speff2trial function. A dynamic 
censoring augmentation regression is also computed to gain even more from the censoring augmentation.
}
\examples{
## Lu, Tsiatis simulation
data <- mets:::simLT(0.7,100)

out <- phreg_lt(Surv(time,status)~Z,data=data,augmentR=~X,augmentC=~factor(Z):X)
out$coefs
}
\references{
Lu, Tsiatis (2008), Improving the efficiency of the log-rank test using auxiliary covariates, Biometrika, 679--694
}
\author{
Thomas Scheike
}
