% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_dimensions.R
\name{rdb_dimensions}
\alias{rdb_dimensions}
\title{Download list of dimensions for datasets of DBnomics providers.}
\usage{
rdb_dimensions(
  provider_code = NULL,
  dataset_code = NULL,
  use_readLines = getOption("rdbnomics.use_readLines"),
  curl_config = getOption("rdbnomics.curl_config"),
  simplify = FALSE,
  ...
)
}
\arguments{
\item{provider_code}{Character string (default \code{NULL}). DBnomics code
of one or multiple providers. If \code{NULL}, the providers are firstly
dowloaded with the function \code{\link{rdb_providers}} and then the
datasets are requested.}

\item{dataset_code}{Character string (default \code{NULL}). DBnomics code
of one or multiple datasets of a provider. If \code{NULL}, the datasets
codes are dowloaded with the function \code{\link{rdb_datasets}} and then
the dimensions are requested.}

\item{use_readLines}{Logical (default \code{FALSE}). If \code{TRUE}, then
the data are requested and read with the base function \code{readLines} i.e.
through the default R internet connection. This can be used to get round the
error \code{Could not resolve host: api.db.nomics.world}.}

\item{curl_config}{Named list (default \code{NULL}). If not
\code{NULL}, it is used to configure a proxy connection. This
configuration is passed to the function \code{curl_fetch_memory} of the package
\pkg{curl}. A temporary \code{curl_handle} object is created internally
with arguments equal to the provided list in \code{curl_config}.\cr
For \code{curl_fetch_memory} arguments see \code{\link[curl]{curl_fetch}}.
For available curl options see \code{\link[curl]{curl_options}},
\code{names(curl_options())} and
\href{https://curl.haxx.se/libcurl/c/curl_easy_setopt.html}{libcurl}.}

\item{simplify}{Logical (default \code{FALSE}). If \code{TRUE}, when the
dimensions are requested for only one provider and one dataset then a
named list of \code{data.table}s is returned, not a nested named list of
\code{data.table}s.}

\item{...}{Additionals arguments.}
}
\value{
A nested named list of \code{data.table}s or a named list of
\code{data.table}s.
}
\description{
\code{rdb_dimensions} downloads the list of dimensions (if they exist) for
available datasets of a selection of providers from
\href{https://db.nomics.world/}{DBnomics}.
}
\details{
By default, the function returns a nested named list of \code{data.table}s
containing the dimensions of datasets for providers from
\href{https://db.nomics.world/}{DBnomics}.
}
\examples{
\dontrun{
rdb_dimensions(provider_code = "IMF", dataset_code = "WEO:2019-10")

rdb_dimensions(provider_code = "IMF", dataset_code = "WEO:2019-10", simplify = TRUE)

rdb_dimensions(provider_code = "IMF")

# /!\ It is very long !
options(rdbnomics.progress_bar_dimensions = TRUE)
rdb_dimensions()
options(rdbnomics.progress_bar_dimensions = FALSE)

rdb_dimensions(
  provider_code = "IMF", dataset_code = "WEO:2019-10",
  use_readLines = TRUE
)

rdb_dimensions(
  provider_code = "IMF", dataset_code = "WEO:2019-10",
  curl_config = list(proxy = "<proxy>", proxyport = <port>)
)
}
}
\seealso{
\code{\link{rdb_providers}}, \code{\link{rdb_last_updates}},
\code{\link{rdb_datasets}}, \code{\link{rdb_series}}
}
\author{
Sebastien Galais
}
