% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionally.R
\name{opt}
\alias{opt}
\title{Consult an option, then default}
\description{
Arguments that appear like so in the usage:\preformatted{f(..., arg = opt(DEFAULT), ...)
}

get their value according to this logic:\preformatted{user-specified value or, if not given,
  getOption("reprex.arg") or if does not exist,
    DEFAULT
}

It's shorthand for:\preformatted{f(..., arg = getOption("reprex.arg", DEFAULT), ...)
}

This is not an exported function and should not be called directly.
}
\details{
Many of the arguments of \code{\link[=reprex]{reprex()}} use \code{opt()}. If you don't like the
official defaults, override them in your \code{.Rprofile}. Here's an example for
someone who dislikes the "Created by ..." string, always wants session info,
prefers to restyle their code, uses a winky face comment string, and likes
the tidyverse startup message.\preformatted{options(
  reprex.advertise = FALSE,
  reprex.si = TRUE,
  reprex.style = TRUE,
  reprex.comment = "#;-)",
  reprex.tidyverse_quiet = FALSE
)
}
}
