% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_messages.R
\name{direct_messages}
\alias{direct_messages}
\title{Get direct messages sent to and received by the authenticating user from the
past 30 days}
\usage{
direct_messages(
  n = 50,
  cursor = NULL,
  next_cursor = NULL,
  parse = TRUE,
  token = NULL,
  retryonratelimit = NULL,
  verbose = TRUE
)
}
\arguments{
\item{n}{Desired number of results to return. Results are downloaded
in pages when \code{n} is large; the default value will download a single
page. Set \code{n = Inf} to download as many results as possible.

The Twitter API rate limits the number of requests you can perform
in each 15 minute period. The easiest way to download more than that is
to use \code{retryonratelimit = TRUE}.

You are not guaranteed to get exactly \code{n} results back. You will get
fewer results when tweets have been deleted or if you hit a rate limit.
You will get more results if you ask for a number of tweets that's not
a multiple of page size, e.g. if you request \code{n = 150} and the page
size is 200, you'll get 200 results back.}

\item{cursor}{Which page of results to return. The default will return
the first page; you can supply the result from a previous call to
continue pagination from where it left off.}

\item{next_cursor}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{cursor} instead.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{token}{Use this to override authentication for
a single API call. In many cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{retryonratelimit}{If \code{TRUE}, and a rate limit is exhausted, will wait
until it refreshes. Most Twitter rate limits refresh every 15 minutes.
If \code{FALSE}, and the rate limit is exceeded, the function will terminate
early with a warning; you'll still get back all results received up to
that point. The default value, \code{NULL}, consults the option
\code{rtweet.retryonratelimit} so that you can globally set it to \code{TRUE},
if desired.

If you expect a query to take hours or days to perform, you should not
rely solely on \code{retryonratelimit} because it does not handle other common
failure modes like temporarily losing your internet connection.}

\item{verbose}{Show progress bars and other messages indicating current
progress?}
}
\value{
A list with one element for each page of results.
}
\description{
Returns all Direct Message events (both sent and received) within the last 30
days. Sorted in reverse-chronological order. Includes detailed information
about the sender and recipient.
}
\examples{
\dontrun{

## get my direct messages
dms <- direct_messages()

## inspect data structure
str(dms)

}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/v1/direct-messages/sending-and-receiving/api-reference/list-events}
}
