% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-helpers.R
\docType{data}
\name{vars_select_helpers}
\alias{vars_select_helpers}
\title{List of selection helpers}
\format{An object of class \code{list} of length 8.}
\usage{
vars_select_helpers
}
\description{
This list contains all selection helpers exported in tidyselect. It
is useful when you want to embed the helpers in your API without
having to track addition of new helpers in tidyselect.
}
\examples{
# You can easily embed the helpers by burying them in the scopes of
# input quosures. For this example we need an environment where
# tidyselect is not attached:
local(envir = baseenv(), {
  vars <- c("foo", "bar", "baz")
  helpers <- tidyselect::vars_select_helpers

  my_select <- function(...) {
    quos <- rlang::quos(...)
    quos <- lapply(quos, rlang::env_bury, !!! helpers)

    tidyselect::vars_select(vars, !!! quos)
  }

  # The user can now call my_select() with helpers without having
  # to attach tidyselect:
  my_select(starts_with("b"))
})
}
\keyword{datasets}
