#!/usr/bin/perl -w

# ***********************************************************************
#   Open SigComp -- Implementation of RFC 3320 Signaling Compression
#
#   Copyright 2005 Estacado Systems, LLC
#
#   Your use of this code is governed by the license under which it
#   has been provided to you. Unless you have a written and signed
#   document from Estacado Systems, LLC stating otherwise, your license
#   is as provided by the GNU General Public License version 2, a copy
#   of which is available in this project in the file named "LICENSE."
#   Alternately, a copy of the licence is available by writing to
#   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#   Boston, MA 02110-1307 USA
#
#   Unless your use of this code is goverened by a written and signed
#   contract containing provisions to the contrary, this program is
#   distributed WITHOUT ANY WARRANTY; without even the implied warranty
#   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#   license for additional details.
#
#   To discuss alternate licensing terms, contact info@estacado.net
# ***********************************************************************

$year = (gmtime)[5]+1900;

$copyright = <<EOT
/* ***********************************************************************
   Open SigComp -- Implementation of RFC 3320 Signaling Compression

   Copyright $year Estacado Systems, LLC

   Your use of this code is governed by the license under which it
   has been provided to you. Unless you have a written and signed
   document from Estacado Systems, LLC stating otherwise, your license
   is as provided by the GNU General Public License version 2, a copy
   of which is available in this project in the file named "LICENSE."
   Alternately, a copy of the licence is available by writing to
   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02110-1307 USA

   Unless your use of this code is goverened by a written and signed
   contract containing provisions to the contrary, this program is
   distributed WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   license for additional details.

   To discuss alternate licensing terms, contact info\@estacado.net
 *********************************************************************** */
EOT
;

$inputfile = shift || &usage;
$class = shift || &usage;
$symbols = shift || undef($symbols);
$header = $class . ".h";
$cpp = $class . ".cpp";

if (defined($symbols))
{
  open (SYMBOLS,$symbols) || die "$0: Could not read $symbols: $!";
  @symbols = <SYMBOLS>;
  close (SYMBOLS);
  chop @symbols;
  $symbols = join (",\n        ",@symbols);
  $symbols =~ y/a-z/A-Z/;
}
else
{
  $symbols = "/* Symbols not defined */";
}

open (INPUT, $inputfile) || die "$0: Could not read $inputfile: $!";
binmode(INPUT);
open (HEADER, '>'.$header) || die "$0: Could not write $outputfile: $!";
open (CPP, '>'.$cpp) || die "$0: Could not write $outputfile: $!";

print HEADER <<EOT
/*
  NOTE: THIS FILE IS AUTOMATICALLY GENERATED. Do not edit
  it by hand.
 */

#ifndef __OSC_$class
#define __OSC_$class 1

$copyright

#include "Types.h"

namespace osc
{
  class $class
  {
    public:
      static osc::byte_t *getBytecodes();
      static osc::u16 getSize();
      static osc::u16 getLocation();

      enum
      {
        $symbols
      };

    private:
      $class();
      $class(${class} const &);
      ${class}& operator=(${class} const &);
    
      static osc::byte_t bytecodes[];
  };
}
#endif
EOT
;

close (HEADER);

print CPP <<EOT
/*
  NOTE: THIS FILE IS AUTOMATICALLY GENERATED. Do not edit
  it by hand.
 */

$copyright

#include "$header"

osc::byte_t osc::${class}::bytecodes[] =
{
EOT
;
while (read(INPUT, $buffer, 1))
{
  push(@bytes, sprintf("0x%2.2X",unpack("C", $buffer)));
}
$bytes = "  ".join(",", @bytes)."\n";
$bytes =~ s/(0x..,){10}/$&\n  /g;
print CPP $bytes;
print CPP <<EOT
};

osc::byte_t *
osc::${class}::getBytecodes()
{
  return bytecodes+2;
}

osc::u16
osc::${class}::getSize()
{
  return sizeof(bytecodes)-2;
}

osc::u16
osc::${class}::getLocation()
{
  return (bytecodes[1]&0x0f) * 64 + 64;
}
EOT
;

sub usage
{
  die "usage: $0 <infile> <outfile> [symbolfile]\n";
}

