#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t N;
Float u_ex (const point& x) { return - 1./12 + (x[0]*(1-x[0]) + x[1]*(1-x[1]) + x[2]*(1-x[2]))/(2.*N); }
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  Float error_linf_expected = (argc > 1) ? atof(argv[1]) : 1e+38;
  field uh; din >> uh;
  const space& Xh = uh.get_space();
  N = Xh.get_geo().dimension();
  field pi_h_u = interpolate(Xh, u_ex);
  field eh = pi_h_u - uh;
  trial u (Xh); test v (Xh);
  form  m  = integrate (u*v);
  form  a  = integrate (dot(grad(u),grad(v)));
  derr << "error_l2    "  << sqrt(m(eh,eh)) << endl
       << "error_h1    "  << sqrt(a(eh,eh)) << endl
       << "error_linf  "  << eh.max_abs() << endl;
  return (eh.max_abs() <= error_linf_expected) ? 0 : 1;
}
