module LibXML
  module XML
    class Schema
      module Types
        XML_SCHEMA_TYPE_BASIC            = 1 # A built-in datatype
        XML_SCHEMA_TYPE_ANY              = 2
        XML_SCHEMA_TYPE_FACET            = 3
        XML_SCHEMA_TYPE_SIMPLE           = 4
        XML_SCHEMA_TYPE_COMPLEX          = 5
        XML_SCHEMA_TYPE_SEQUENCE         = 6
        XML_SCHEMA_TYPE_CHOICE           = 7
        XML_SCHEMA_TYPE_ALL              = 8
        XML_SCHEMA_TYPE_SIMPLE_CONTENT   = 9
        XML_SCHEMA_TYPE_COMPLEX_CONTENT  = 10
        XML_SCHEMA_TYPE_UR               = 11
        XML_SCHEMA_TYPE_RESTRICTION      = 12
        XML_SCHEMA_TYPE_EXTENSION        = 13
        XML_SCHEMA_TYPE_ELEMENT          = 14
        XML_SCHEMA_TYPE_ATTRIBUTE        = 15
        XML_SCHEMA_TYPE_ATTRIBUTEGROUP   = 16
        XML_SCHEMA_TYPE_GROUP            = 17
        XML_SCHEMA_TYPE_NOTATION         = 18
        XML_SCHEMA_TYPE_LIST             = 19
        XML_SCHEMA_TYPE_UNION            = 20
        XML_SCHEMA_TYPE_ANY_ATTRIBUTE    = 21
        XML_SCHEMA_TYPE_IDC_UNIQUE       = 22
        XML_SCHEMA_TYPE_IDC_KEY          = 23
        XML_SCHEMA_TYPE_IDC_KEYREF       = 24
        XML_SCHEMA_TYPE_PARTICLE         = 25
        XML_SCHEMA_TYPE_ATTRIBUTE_USE    = 26
        XML_SCHEMA_FACET_MININCLUSIVE    = 1000
        XML_SCHEMA_FACET_MINEXCLUSIVE    = 1001
        XML_SCHEMA_FACET_MAXINCLUSIVE    = 1002
        XML_SCHEMA_FACET_MAXEXCLUSIVE    = 1003
        XML_SCHEMA_FACET_TOTALDIGITS     = 1004
        XML_SCHEMA_FACET_FRACTIONDIGITS  = 1005
        XML_SCHEMA_FACET_PATTERN         = 1006
        XML_SCHEMA_FACET_ENUMERATION     = 1007
        XML_SCHEMA_FACET_WHITESPACE      = 1008
        XML_SCHEMA_FACET_LENGTH          = 1009
        XML_SCHEMA_FACET_MAXLENGTH       = 1010
        XML_SCHEMA_FACET_MINLENGTH       = 1011
        XML_SCHEMA_EXTRA_QNAMEREF        = 2000
        XML_SCHEMA_EXTRA_ATTR_USE_PROHIB = 2001
      end

      class Namespaces < Array
        def find_by_href(href)
          find { |n| n.href == href }
        end

        def find_by_prefix(prefix)
          find { |n| n.prefix == prefix }
        end
      end

      def namespaces
        Namespaces.new(_namespaces.uniq { |n| n.href })
      end

      def self.cached(location)
        @_schemas ||= {}
        @_schemas[location] ||= new(location)
      end
    end
  end
end