/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.sablecc.sablecc.GenAlts;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveAstIds;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAstProd;
import org.sablecc.sablecc.node.Start;

public class GenUtils
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveAstIds ast_ids;
    private File pkgDir;
    private String pkgName;
    private String mainProduction;

    public GenUtils(ResolveAstIds resolveAstIds) {
        this.ast_ids = resolveAstIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("utils.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open utils.txt.");
        }
        this.pkgDir = new File(resolveAstIds.astIds.pkgDir, "node");
        String string = this.pkgName = resolveAstIds.astIds.pkgName.equals("") ? "node" : resolveAstIds.astIds.pkgName + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    public void caseAAstProd(AAstProd aAstProd) {
        if (this.mainProduction == null) {
            this.mainProduction = (String)this.ast_ids.ast_names.get(aAstProd);
        }
    }

    public void outStart(Start start) {
        if (this.mainProduction != null) {
            this.createStart();
        }
        this.createEOF();
        this.createNode();
        this.createToken();
        this.create("Switch");
        this.create("Switchable");
    }

    public void createStart() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Start.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Start.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "Start", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "analysis" : this.ast_ids.astIds.pkgName + ".analysis", this.mainProduction, GenAlts.nodeName(this.mainProduction)});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Start.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createEOF() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "EOF.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "EOF.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "EOF", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "analysis" : this.ast_ids.astIds.pkgName + ".analysis"});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "EOF.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createNode() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Node.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Node.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "Node", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "analysis" : this.ast_ids.astIds.pkgName + ".analysis"});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Node.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createToken() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Token.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Token.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "Token", new String[]{this.pkgName});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Token.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void create(String string) {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, string + ".java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, string + ".java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, string, new String[]{this.pkgName});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, string + ".java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

