/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : ScalingDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/20
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __SCALINGDLG_H__
#define __SCALINGDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

struct _SCALING_DLG
{
	gint value;
	gdouble x_pos;			/* 原点　Ｘ */
	gdouble y_pos;			/* 原点　Ｙ */
	gdouble coefficient;	/* 係数 */

	GtkWidget *x_pos_entry;
	GtkWidget *y_pos_entry;
	GtkWidget *coefficient_entry;
	GtkWidget *parent;			
	GtkWidget *dialog;			
};
typedef struct _SCALING_DLG SCALING_DLG;



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _SCALINGDLG_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _SCALINGDLG_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
gint ScalingDialog(SCALING_DLG *scaling_dlg);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __SCALINGDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : ScalingDlg.h
 * ====================================================================
 */
