/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd.basic;

import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.output.xsd.basic.Annotation;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SingleAttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.Structure;
import com.thaiopensource.relaxng.output.xsd.basic.StructureVisitor;
import com.thaiopensource.util.Equal;
import com.thaiopensource.xml.util.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
extends SingleAttributeUse
implements Structure {
    private final Name name;
    private final SimpleType type;

    public Attribute(SourceLocation sourceLocation, Annotation annotation, Name name, SimpleType simpleType) {
        super(sourceLocation, annotation);
        this.name = name;
        this.type = simpleType;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public SimpleType getType() {
        return this.type;
    }

    @Override
    public <T> T accept(AttributeUseVisitor<T> attributeUseVisitor) {
        return attributeUseVisitor.visitAttribute(this);
    }

    @Override
    public <T> T accept(StructureVisitor<T> structureVisitor) {
        return structureVisitor.visitAttribute(this);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        return Equal.equal(this.type, attribute.type) && this.name.equals(attribute.name);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode() ^ this.name.hashCode();
        if (this.type != null) {
            n ^= this.type.hashCode();
        }
        return n;
    }

    @Override
    public boolean isOptional() {
        return false;
    }
}

