#define XERR
#include "mammo.ih"

//Mammo:
//     costs:          64   
//
//      #                default:
//     systematicError:  0.1   
//
//     Dose:           
//       #            mean   spread    dist
//       bi-rad: a     3       1       Normal
//       bi-rad: b     3       1       Normal
//       bi-rad: c     3       1       Normal
//       bi-rad: d     3       1       Normal
//
//      M: 
//       #            proportion   spread      dist    
//       bi-rad: a      .061        .021       Normal
//       bi-rad: b      .163        .045       Normal
//       bi-rad: c      .400        .106       Normal
//       bi-rad: d      .826        .088       Normal
//
//      Beta:
//       #         mean    spread      dist
//       nr: 1     -4.38    .002       Normal
//       nr: 2       .49    .0005      Normal
//       nr: 3     -1.34    .0074      Normal
//       nr: 4     -7.18    .0340      Normal
//
//     Specificity:
//       #           range      proporion   spread  dist
//       ageGroup:   0 - 40     .961        .005    Normal
//       ageGroup:  40 - *      .965        .005    Normal

Mammo::Mammo(Tumor const &tumor)
:
    ModBase("Mammo"),
    d_tumor(tumor),
    d_base{ "Modalities:", "Mammo:", "" }
{
    costBase(d_base);                        // ModBase members
    setSystematicError();                    // must be before doseBase

    d_base.resize(4);

    doseBase(d_dose, d_base);                // ModBase members
    specificityBase(d_specVect, d_base);    
    setM();
    setBeta();
}

//Modalities:
//
//  Mammo:
//      costs:          64   
//
//      #      bi-rad:  a       b       c       d             
//      dose:           3       3       3       3  
//      m:             .136    .136    .136    .136
//
//      #             ageGroup
//      specificity:  0 - 40:  .961     40 - *: .965
//
//      #       1      2   3      4      
//      beta:  -4.38  .49  -1.34  -7.18  
//
//      #                default:
//      # systematicError:  0.1 

