1.1 Live Coding

# Live Coding


Uno degli aspetti più divertenti di Sonic Pi è che ti permette di scrivere e *modificare codice live* per fare musica, proprio come se suonassi una chitarra dal vivo. Questo significa che dopo un po’ di pratica puoi salire sul palco ed esibirti con Sonic Pi.


## Libera la tua mente


Prima di entrare nel vivo del funzionamento di Sonic Pi, vorrei farti capire meglio cosa vuol dire live code. Per il momento non ti preoccupare se non capisci molto (o anche nulla) di quello che vedremo. Mettiti solo comodo e divertiti...


## Un live loop

Allora cominciamo, copia il codice qui di seguito in uno dei workspace che trovi qui sopra:

```
live_loop :flibble do
sample :bd_haus, rate: 1
sleep 0.5
end
```


Ora premi il tasto `Run` e sentirai un bel suono di cassa che batte il tempo. Per fermare il suono basta premere sul tasto `Stop`. Però, per il momento, non premerlo ancora… Segui invece questi passaggi:

1. Assicurati che il suono della cassa sia ancora attivo.
2. Cambia il valore di `sleep` da `0.5` a qualcosa di più grande di `1`.
3. Premi di nuovo il tasto `Run`.
4. Nota come è cambiata la velocità della batteria.
5. Infine, *ricorda questo momento*: questa è la prima volta che hai fatto live coding con Sonic Pi ed è probabile che non sarà l’ultima...


Ok, fin qui era abbastanza semplice. Adesso aggiungi qualcos’altro al mix. Sopra `sample :bd_haus` aggiungi l’istruzione `sample :ambi_choir, rate: 0.3`. Il tuo codice dovrebbe apparire così:

```
live_loop :flibble do
sample :ambi_choir, rate: 0.3
sample :bd_haus, rate: 1
sleep 1
end
```


E adesso, sbizzarrisciti. Cambia il parametro `rate:` - cosa succede se usi valori grandi, o piccoli, o negativi? Guarda cosa succede se cambi il valore di `rate:` del campione `:ambi_choir` anche di pochissimo (diciamo 0.29). E che succede se scegli un valore molto piccolo per `sleep`? Guarda se riesci a farlo così veloce da provocare un errore perché il computer non riesce a stargli dietro. (Se succede, basta scegliere un valore di `sleep`più grande e premere di nuovo `Run`)

Prova a inserire all’inizio di una delle istruzioni `sample` un `#`:

```
live_loop :flibble do
sample :ambi_choir, rate: 0.3
#  sample :bd_haus, rate: 1
sleep 1
end

```


Fai caso a come  il  `#` dice al computer di ignorare quello che c’è scritto dopo, e di conseguenza non sentiamo più il campione. In Sonic Pi possiamo usare i commenti per togliere o reinserire elementi al mix.

Infine, ecco qualcosa di divertente con cui giocare. Prendi il codice qui sotto e copialo in un workspace vuoto. Poi, non cercare di capire altro, se non che ci sono due loop - due cose che suonano nello stesso tempo. Quindi, fai quello che sai fare meglio: provare e sperimentare. Ecco alcuni suggerimenti:

* Prova a cambiare i valori scritti in blu di `rate:` e ascolta il suono del campione che cambia.
* Prova a cambiare i tempi di `sleep` e senti come tutti e due i loop possono girare a differenti velocità.
* Prova a “s-commentare” l’istruzione sample (togli il `#`) e goditi il suono della chitarra al contrario.
* Prova a cambiare uno qualsiasi dei valori scritti in blu di `mix` con numeri che vanno da `0` (tutto fuori dal mix)  a `1` (tutto nell mix).

Ricordati di premere `Run` e sentirai il cambiamento non appena il loop viene suonato di nuovo. Se fai qualche errore, non preoccuparti: premi `stop`, cancelli il codice nel workspace, copi di nuovo il codice originale e sei pronto per ricominciare. Sbagliare è il modo più veloce per imparare.

```
live_loop :guit do
with_fx :echo, mix: 0.3, phase: 0.25 do
sample :guit_em9, rate: 0.5
end
#  sample :guit_em9, rate: -0.5
sleep 8
end

live_loop :boom do
with_fx :reverb, room: 1 do
sample :bd_boom, amp: 10, rate: 1
end
sleep 8
end
```


Suona e fai esperimenti finché non avrai soddisfatto la tua curiosità su come funziona tutto questo e avrai cominciato a chiederti che altro ci puoi fare. A quel punto sei pronto per continuare a leggere il tutorial.

Allora, che aspetti?


