/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MKDIRPARAM_H
#define _SC_MKDIRPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/ClientTypes.h"

/**
 * Parameter class for MkdirCmd.
 */
class MkdirParam : public ScParam
{
public:
  MkdirParam( const svn::Paths& pathsOrUrls ) : _pathsOrUrls(pathsOrUrls)
  {
  }

  const svn::Paths& getPathsOrUrls() const
  {
    return _pathsOrUrls;
  }

  ScParamAccept(MkdirParam);

private:
  svn::Paths _pathsOrUrls;
};

#endif // _SC_MKDIRPARAM_H
