/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TEXTMODELIMPL_H
#define _TEXTMODELIMPL_H

// sc
#include "TextModel.h"
#include "LineTarget.h"


class TextModelImpl : public TextModel, public LineTarget
{
public:
  TextModelImpl(const sc::String& sourceName);
  virtual ~TextModelImpl();

  void clear();

  //@{
  /** TextModel */
  const sc::String& getSourceName();

  const Line& getLine( sc::Size lineNr );
  BlockInfo getBlockInfo( int block );
  sc::Size getLineCnt();
  sc::Size getColumnCnt();
  LineEnd getLineEnd();
  unsigned int getTabWidth();

  int replaceBlock( int block, TextModel* src );

  const Cursor& getCursor();
  const Cursor& getCursor2();
  void setCursor( const Cursor& c );
  void setCursor2( const Cursor& c );
  Cursor moveCursorRight( bool moveC2 );
  Cursor moveCursorLeft( bool moveC2 );
  Cursor moveCursorDown( bool moveC2 );
  Cursor moveCursorUp( bool moveC2 );
  int getLastColumn();
  void setLastColumn( int col );
  Cursor calcNearestCursorPos( const Cursor& c );

  void addText( const sc::String& s );
  void removeTextLeft();
  void removeTextRight();
  sc::String getHighlightedText();

  void undo();
  void redo();
  bool hasUndo();
  void clearUndo();
  //@}

  //@{
  /** LineTarget */
  bool addLine( const Line& );

class Member;

private:
  Member* M;
};

#endif // _TEXTMODELIMPL_H
