/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ColorSettingsInfo.h"
#include "ColorSettingsWidget.h"
#include "ColorSettings.h"

// sys
#include <algorithm>


ColorSettingsInfo::ColorSettingsInfo( const QString& title, const QString& id, ColorSettings* cs, int sortIndex )
: _title(title), _id(id), _sortIndex(sortIndex), _cs(cs)
{
  _cs->getColors(_modColors);
  _newColors = _modColors;
}

ColorSettingsInfo::~ColorSettingsInfo()
{
}

const QString& ColorSettingsInfo::getTitle()
{
  return _title;
}

const QString& ColorSettingsInfo::getSettingsId()
{
  return _id;
}

void ColorSettingsInfo::initWidgetData( SettingsWidget* sw )
{
  ColorSettingsWidget* psw = dynamic_cast<ColorSettingsWidget*>(sw);
  psw->setColors(_newColors);
}

void ColorSettingsInfo::storeWidgetData( SettingsWidget* sw )
{
  ColorSettingsWidget* psw = dynamic_cast<ColorSettingsWidget*>(sw);

  _newColors.clear();
  psw->getColors(_newColors);
}

bool smaller( const Color& c1, const Color& c2 )
{
  return c1._name < c2._name;
}

bool ColorSettingsInfo::isModified()
{
  std::sort(_modColors.begin(),_modColors.end(), smaller);
  std::sort(_newColors.begin(),_newColors.end(), smaller);

  Colors::iterator itMod = _modColors.begin();  
  Colors::iterator itNew = _newColors.begin();

  for( /*itMod*/; itMod != _modColors.end(); itMod++, itNew++ )
  {
    const Color& c1 = *itMod;
    const Color& c2 = *itNew;

    if( c1._name          != c2._name          ||
        c1._color.red()   != c2._color.red()   ||
        c1._color.green() != c2._color.green() ||
        c1._color.blue()  != c2._color.blue()
      )
    {
      return true;
    }
  }

  return false;
}

void ColorSettingsInfo::ok()
{
  apply();
}

void ColorSettingsInfo::apply()
{
  _cs->setColors(_newColors);
  _modColors = _newColors;
}

void ColorSettingsInfo::cancel()
{
  // nop
}

int ColorSettingsInfo::getSortIndex()
{
  return _sortIndex;
}
