/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SINGLE_TEXT_WIDGET_H
#define _SINGLE_TEXT_WIDGET_H

// sc
#include "TextViewWidget.h"
#include "util/String.h"
class TextWidget;
class TextLineNrWidget;
class TextModel;
class DiffInfoModel;

// qt
class QLineEdit;


class SingleTextWidget : public TextViewWidget
{
  typedef TextViewWidget super;
  Q_OBJECT 

public:
  SingleTextWidget( QWidget *parent=0, const char *name=0 );
  virtual ~SingleTextWidget();

  void setModel( TextModel* model );
  void setModel( DiffInfoModel* info );
  void setLabel( const sc::String& l );

  TextWidget* getText() const;

  void jumpToLine( int line );
  void jumpToBlock( int block );

  void enableSelection( bool enable );
  void setEditable( bool editable );

  void update();

  void setAcceptDrops(bool on);

protected:
  QSize getScrollSizeHint();
  QSize getScrollSizeCurr();

public slots:
  void vsbChange(int);
  void hsbChange(int);
  void xChange(int);
  void yChange(int);
  void sizeChanged();

private:
  TextWidget*        _text;
  TextLineNrWidget*  _line;
  QLineEdit*         _label;
};


#endif // _SINGLE_TEXT_WIDGET_H

