//#include <iostream>
#include <cstring>
#include <map>



#include <QStringList>
#include "enc.h"


std::map <UTF16TEXT, char> create_UTF16_to_CP1251()
{
std::map <UTF16TEXT, char> UTF16_to_CP1251;
UTF16_to_CP1251[0x0020] = 0x20;  // SPACE
UTF16_to_CP1251[0x0021] = 0x21;  // EXCLAMATION MARK
UTF16_to_CP1251[0x0022] = 0x22;  // QUOTATION MARK
UTF16_to_CP1251[0x0023] = 0x23;  // NUMBER SIGN
UTF16_to_CP1251[0x0024] = 0x24;  // DOLLAR SIGN
UTF16_to_CP1251[0x0025] = 0x25;  // PERCENT SIGN
UTF16_to_CP1251[0x0026] = 0x26;  // AMPERSAND
UTF16_to_CP1251[0x0027] = 0x27;  // APOSTROPHE
UTF16_to_CP1251[0x0028] = 0x28;  // LEFT PARENTHESIS
UTF16_to_CP1251[0x0029] = 0x29;  // RIGHT PARENTHESIS
UTF16_to_CP1251[0x002A] = 0x2A;  // ASTERISK
UTF16_to_CP1251[0x002B] = 0x2B;  // PLUS SIGN
UTF16_to_CP1251[0x002C] = 0x2C;  // COMMA
UTF16_to_CP1251[0x002D] = 0x2D;  // HYPHEN-MINUS
UTF16_to_CP1251[0x002E] = 0x2E;  // FULL STOP
UTF16_to_CP1251[0x002F] = 0x2F;  // SOLIDUS
UTF16_to_CP1251[0x0030] = 0x30;  // DIGIT ZERO
UTF16_to_CP1251[0x0031] = 0x31;  // DIGIT ONE
UTF16_to_CP1251[0x0032] = 0x32;  // DIGIT TWO
UTF16_to_CP1251[0x0033] = 0x33;  // DIGIT THREE
UTF16_to_CP1251[0x0034] = 0x34;  // DIGIT FOUR
UTF16_to_CP1251[0x0035] = 0x35;  // DIGIT FIVE
UTF16_to_CP1251[0x0036] = 0x36;  // DIGIT SIX
UTF16_to_CP1251[0x0037] = 0x37;  // DIGIT SEVEN
UTF16_to_CP1251[0x0038] = 0x38;  // DIGIT EIGHT
UTF16_to_CP1251[0x0039] = 0x39;  // DIGIT NINE
UTF16_to_CP1251[0x003A] = 0x3A;  // COLON
UTF16_to_CP1251[0x003B] = 0x3B;  // SEMICOLON
UTF16_to_CP1251[0x003C] = 0x3C;  // LESS-THAN SIGN
UTF16_to_CP1251[0x003D] = 0x3D;  // EQUALS SIGN
UTF16_to_CP1251[0x003E] = 0x3E;  // GREATER-THAN SIGN
UTF16_to_CP1251[0x003F] = 0x3F;  // QUESTION MARK
UTF16_to_CP1251[0x0040] = 0x40;  // COMMERCIAL AT
UTF16_to_CP1251[0x0041] = 0x41;  // LATIN CAPITAL LETTER A
UTF16_to_CP1251[0x0042] = 0x42;  // LATIN CAPITAL LETTER B
UTF16_to_CP1251[0x0043] = 0x43;  // LATIN CAPITAL LETTER C
UTF16_to_CP1251[0x0044] = 0x44;  // LATIN CAPITAL LETTER D
UTF16_to_CP1251[0x0045] = 0x45;  // LATIN CAPITAL LETTER E
UTF16_to_CP1251[0x0046] = 0x46;  // LATIN CAPITAL LETTER F
UTF16_to_CP1251[0x0047] = 0x47;  // LATIN CAPITAL LETTER G
UTF16_to_CP1251[0x0048] = 0x48;  // LATIN CAPITAL LETTER H
UTF16_to_CP1251[0x0049] = 0x49;  // LATIN CAPITAL LETTER I
UTF16_to_CP1251[0x004A] = 0x4A;  // LATIN CAPITAL LETTER J
UTF16_to_CP1251[0x004B] = 0x4B;  // LATIN CAPITAL LETTER K
UTF16_to_CP1251[0x004C] = 0x4C;  // LATIN CAPITAL LETTER L
UTF16_to_CP1251[0x004D] = 0x4D;  // LATIN CAPITAL LETTER M
UTF16_to_CP1251[0x004E] = 0x4E;  // LATIN CAPITAL LETTER N
UTF16_to_CP1251[0x004F] = 0x4F;  // LATIN CAPITAL LETTER O
UTF16_to_CP1251[0x0050] = 0x50;  // LATIN CAPITAL LETTER P
UTF16_to_CP1251[0x0051] = 0x51;  // LATIN CAPITAL LETTER Q
UTF16_to_CP1251[0x0052] = 0x52;  // LATIN CAPITAL LETTER R
UTF16_to_CP1251[0x0053] = 0x53;  // LATIN CAPITAL LETTER S
UTF16_to_CP1251[0x0054] = 0x54;  // LATIN CAPITAL LETTER T
UTF16_to_CP1251[0x0055] = 0x55;  // LATIN CAPITAL LETTER U
UTF16_to_CP1251[0x0056] = 0x56;  // LATIN CAPITAL LETTER V
UTF16_to_CP1251[0x0057] = 0x57;  // LATIN CAPITAL LETTER W
UTF16_to_CP1251[0x0058] = 0x58;  // LATIN CAPITAL LETTER X
UTF16_to_CP1251[0x0059] = 0x59;  // LATIN CAPITAL LETTER Y
UTF16_to_CP1251[0x005A] = 0x5A;  // LATIN CAPITAL LETTER Z
UTF16_to_CP1251[0x005B] = 0x5B;  // LEFT SQUARE BRACKET
UTF16_to_CP1251[0x005C] = 0x5C;  // REVERSE SOLIDUS
UTF16_to_CP1251[0x005D] = 0x5D;  // RIGHT SQUARE BRACKET
UTF16_to_CP1251[0x005E] = 0x5E;  // CIRCUMFLEX ACCENT
UTF16_to_CP1251[0x005F] = 0x5F;  // LOW LINE
UTF16_to_CP1251[0x0060] = 0x60;  // GRAVE ACCENT
UTF16_to_CP1251[0x0061] = 0x61;  // LATIN SMALL LETTER A
UTF16_to_CP1251[0x0062] = 0x62;  // LATIN SMALL LETTER B
UTF16_to_CP1251[0x0063] = 0x63;  // LATIN SMALL LETTER C
UTF16_to_CP1251[0x0064] = 0x64;  // LATIN SMALL LETTER D
UTF16_to_CP1251[0x0065] = 0x65;  // LATIN SMALL LETTER E
UTF16_to_CP1251[0x0066] = 0x66;  // LATIN SMALL LETTER F
UTF16_to_CP1251[0x0067] = 0x67;  // LATIN SMALL LETTER G
UTF16_to_CP1251[0x0068] = 0x68;  // LATIN SMALL LETTER H
UTF16_to_CP1251[0x0069] = 0x69;  // LATIN SMALL LETTER I
UTF16_to_CP1251[0x006A] = 0x6A;  // LATIN SMALL LETTER J
UTF16_to_CP1251[0x006B] = 0x6B;  // LATIN SMALL LETTER K
UTF16_to_CP1251[0x006C] = 0x6C;  // LATIN SMALL LETTER L
UTF16_to_CP1251[0x006D] = 0x6D;  // LATIN SMALL LETTER M
UTF16_to_CP1251[0x006E] = 0x6E;  // LATIN SMALL LETTER N
UTF16_to_CP1251[0x006F] = 0x6F;  // LATIN SMALL LETTER O
UTF16_to_CP1251[0x0070] = 0x70;  // LATIN SMALL LETTER P
UTF16_to_CP1251[0x0071] = 0x71;  // LATIN SMALL LETTER Q
UTF16_to_CP1251[0x0072] = 0x72;  // LATIN SMALL LETTER R
UTF16_to_CP1251[0x0073] = 0x73;  // LATIN SMALL LETTER S
UTF16_to_CP1251[0x0074] = 0x74;  // LATIN SMALL LETTER T
UTF16_to_CP1251[0x0075] = 0x75;  // LATIN SMALL LETTER U
UTF16_to_CP1251[0x0076] = 0x76;  // LATIN SMALL LETTER V
UTF16_to_CP1251[0x0077] = 0x77;  // LATIN SMALL LETTER W
UTF16_to_CP1251[0x0078] = 0x78;  // LATIN SMALL LETTER X
UTF16_to_CP1251[0x0079] = 0x79;  // LATIN SMALL LETTER Y
UTF16_to_CP1251[0x007A] = 0x7A;  // LATIN SMALL LETTER Z
UTF16_to_CP1251[0x007B] = 0x7B;  // LEFT CURLY BRACKET
UTF16_to_CP1251[0x007C] = 0x7C;  // VERTICAL LINE
UTF16_to_CP1251[0x007D] = 0x7D;  // RIGHT CURLY BRACKET
UTF16_to_CP1251[0x007E] = 0x7E;  // TILDE
UTF16_to_CP1251[0x0401] = 0xF0;  // CYRILLIC CAPITAL LETTER IO
UTF16_to_CP1251[0x0410] = 0xC0;  // CYRILLIC CAPITAL LETTER A
UTF16_to_CP1251[0x0411] = 0xC1;  // CYRILLIC CAPITAL LETTER BE
UTF16_to_CP1251[0x0412] = 0xC2;  // CYRILLIC CAPITAL LETTER VE
UTF16_to_CP1251[0x0413] = 0xC3;  // CYRILLIC CAPITAL LETTER GHE
UTF16_to_CP1251[0x0414] = 0xC4;  // CYRILLIC CAPITAL LETTER DE
UTF16_to_CP1251[0x0415] = 0xC5;  // CYRILLIC CAPITAL LETTER IE
UTF16_to_CP1251[0x0416] = 0xC6;  // CYRILLIC CAPITAL LETTER ZHE
UTF16_to_CP1251[0x0417] = 0xC7;  // CYRILLIC CAPITAL LETTER ZE
UTF16_to_CP1251[0x0418] = 0xC8;  // CYRILLIC CAPITAL LETTER I
UTF16_to_CP1251[0x0419] = 0xC9;  // CYRILLIC CAPITAL LETTER SHORT I
UTF16_to_CP1251[0x041A] = 0xCA;  // CYRILLIC CAPITAL LETTER KA
UTF16_to_CP1251[0x041B] = 0xCB;  // CYRILLIC CAPITAL LETTER EL
UTF16_to_CP1251[0x041C] = 0xCC;  // CYRILLIC CAPITAL LETTER EM
UTF16_to_CP1251[0x041D] = 0xCD;  // CYRILLIC CAPITAL LETTER EN
UTF16_to_CP1251[0x041E] = 0xCE;  // CYRILLIC CAPITAL LETTER O
UTF16_to_CP1251[0x041F] = 0xCF;  // CYRILLIC CAPITAL LETTER PE
UTF16_to_CP1251[0x0420] = 0xD0;  // CYRILLIC CAPITAL LETTER ER
UTF16_to_CP1251[0x0421] = 0xD1;  // CYRILLIC CAPITAL LETTER ES
UTF16_to_CP1251[0x0422] = 0xD2;  // CYRILLIC CAPITAL LETTER TE
UTF16_to_CP1251[0x0423] = 0xD3;  // CYRILLIC CAPITAL LETTER U
UTF16_to_CP1251[0x0424] = 0xD4;  // CYRILLIC CAPITAL LETTER EF
UTF16_to_CP1251[0x0425] = 0xD5;  // CYRILLIC CAPITAL LETTER HA
UTF16_to_CP1251[0x0426] = 0xD6;  // CYRILLIC CAPITAL LETTER TSE
UTF16_to_CP1251[0x0427] = 0xD7;  // CYRILLIC CAPITAL LETTER CHE
UTF16_to_CP1251[0x0428] = 0xD8;  // CYRILLIC CAPITAL LETTER SHA
UTF16_to_CP1251[0x0429] = 0xD9;  // CYRILLIC CAPITAL LETTER SHCHA
UTF16_to_CP1251[0x042A] = 0xDA;  // CYRILLIC CAPITAL LETTER HARD SIGN
UTF16_to_CP1251[0x042B] = 0xDB;  // CYRILLIC CAPITAL LETTER YERU
UTF16_to_CP1251[0x042C] = 0xDC;  // CYRILLIC CAPITAL LETTER SOFT SIGN
UTF16_to_CP1251[0x042D] = 0xDD;  // CYRILLIC CAPITAL LETTER E
UTF16_to_CP1251[0x042E] = 0xDE;  // CYRILLIC CAPITAL LETTER YU
UTF16_to_CP1251[0x042F] = 0xDF;  // CYRILLIC CAPITAL LETTER YA
UTF16_to_CP1251[0x0430] = 0xE0;  // CYRILLIC SMALL LETTER A
UTF16_to_CP1251[0x0431] = 0xE1;  // CYRILLIC SMALL LETTER BE
UTF16_to_CP1251[0x0432] = 0xE2;  // CYRILLIC SMALL LETTER VE
UTF16_to_CP1251[0x0433] = 0xE3;  // CYRILLIC SMALL LETTER GHE
UTF16_to_CP1251[0x0434] = 0xE4;  // CYRILLIC SMALL LETTER DE
UTF16_to_CP1251[0x0435] = 0xE5;  // CYRILLIC SMALL LETTER IE
UTF16_to_CP1251[0x0436] = 0xE6;  // CYRILLIC SMALL LETTER ZHE
UTF16_to_CP1251[0x0437] = 0xE7;  // CYRILLIC SMALL LETTER ZE
UTF16_to_CP1251[0x0438] = 0xE8;  // CYRILLIC SMALL LETTER I
UTF16_to_CP1251[0x0439] = 0xE9;  // CYRILLIC SMALL LETTER SHORT I
UTF16_to_CP1251[0x043A] = 0xEA;  // CYRILLIC SMALL LETTER KA
UTF16_to_CP1251[0x043B] = 0xEB;  // CYRILLIC SMALL LETTER EL
UTF16_to_CP1251[0x043C] = 0xEC;  // CYRILLIC SMALL LETTER EM
UTF16_to_CP1251[0x043D] = 0xED;  // CYRILLIC SMALL LETTER EN
UTF16_to_CP1251[0x043E] = 0xEE;  // CYRILLIC SMALL LETTER O
UTF16_to_CP1251[0x043F] = 0xEF;  // CYRILLIC SMALL LETTER PE
UTF16_to_CP1251[0x0440] = 0xF0;  // CYRILLIC SMALL LETTER ER
UTF16_to_CP1251[0x0441] = 0xF1;  // CYRILLIC SMALL LETTER ES
UTF16_to_CP1251[0x0442] = 0xF2;  // CYRILLIC SMALL LETTER TE
UTF16_to_CP1251[0x0443] = 0xF3;  // CYRILLIC SMALL LETTER U
UTF16_to_CP1251[0x0444] = 0xF4;  // CYRILLIC SMALL LETTER EF
UTF16_to_CP1251[0x0445] = 0xF5;  // CYRILLIC SMALL LETTER HA
UTF16_to_CP1251[0x0446] = 0xF6;  // CYRILLIC SMALL LETTER TSE
UTF16_to_CP1251[0x0447] = 0xF7;  // CYRILLIC SMALL LETTER CHE
UTF16_to_CP1251[0x0448] = 0xF8;  // CYRILLIC SMALL LETTER SHA
UTF16_to_CP1251[0x0449] = 0xF9;  // CYRILLIC SMALL LETTER SHCHA
UTF16_to_CP1251[0x044A] = 0xFA;  // CYRILLIC SMALL LETTER HARD SIGN
UTF16_to_CP1251[0x044B] = 0xFB;  // CYRILLIC SMALL LETTER YERU
UTF16_to_CP1251[0x044C] = 0xFC;  // CYRILLIC SMALL LETTER SOFT SIGN
UTF16_to_CP1251[0x044D] = 0xFD;  // CYRILLIC SMALL LETTER E
UTF16_to_CP1251[0x044E] = 0xFE;  // CYRILLIC SMALL LETTER YU
UTF16_to_CP1251[0x044F] = 0xFF;  // CYRILLIC SMALL LETTER YA
UTF16_to_CP1251[0x0a] = 0x0a;    // Keep newline character
UTF16_to_CP1251[0x0d] =  0x0d;    // Keep carriage return character
UTF16_to_CP1251[0x401] = 0xA8;    // Ё
UTF16_to_CP1251[0x451] = 0xB8 ;    // ё
UTF16_to_CP1251[0x2013] = 0x96;    // малый пробел
UTF16_to_CP1251[0x2014] = 0x97;    // большой пробел

return UTF16_to_CP1251;
};

//ok
UTF16TEXT cp1251_to_utf16[256] = {
    // 0x00 - 0x7F: Соответствуют символам ASCII
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
    0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,
    // 0x80 - 0xFF: Символы CP1251
    0x0402, 0x0403, 0x201A, 0x0453, 0x201E, 0x2026, 0x2020, 0x2021,
    0x20AC, 0x2030, 0x0409, 0x2039, 0x040A, 0x040C, 0x040B, 0x040F,
    0x0452, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
    0x0020, 0x2122, 0x0459, 0x203A, 0x045A, 0x045C, 0x045B, 0x045F,
    0x00A0, 0x040E, 0x045E, 0x0408, 0x00A4, 0x0490, 0x00A6, 0x00A7,
    0x0401, 0x00A9, 0x0404, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x0407,
    0x00B0, 0x00B1, 0x0406, 0x0456, 0x0491, 0x00B5, 0x00B6, 0x00B7,
    0x0451, 0x2116, 0x0454, 0x00BB, 0x0458, 0x0405, 0x0455, 0x0457,
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
    0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
    0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
    0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
    0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F
};

//ok
/*
std::map<UTF16TEXT, char> UTF16_to_CP1251 = {
    {0x0020, 0x20},  // SPACE
    {0x0021, 0x21},  // EXCLAMATION MARK
    {0x0022, 0x22},  // QUOTATION MARK
    {0x0023, 0x23},  // NUMBER SIGN
    {0x0024, 0x24},  // DOLLAR SIGN
    {0x0025, 0x25},  // PERCENT SIGN
    {0x0026, 0x26},  // AMPERSAND
    {0x0027, 0x27},  // APOSTROPHE
    {0x0028, 0x28},  // LEFT PARENTHESIS
    {0x0029, 0x29},  // RIGHT PARENTHESIS
    {0x002A, 0x2A},  // ASTERISK
    {0x002B, 0x2B},  // PLUS SIGN
    {0x002C, 0x2C},  // COMMA
    {0x002D, 0x2D},  // HYPHEN-MINUS
    {0x002E, 0x2E},  // FULL STOP
    {0x002F, 0x2F},  // SOLIDUS
    {0x0030, 0x30},  // DIGIT ZERO
    {0x0031, 0x31},  // DIGIT ONE
    {0x0032, 0x32},  // DIGIT TWO
    {0x0033, 0x33},  // DIGIT THREE
    {0x0034, 0x34},  // DIGIT FOUR
    {0x0035, 0x35},  // DIGIT FIVE
    {0x0036, 0x36},  // DIGIT SIX
    {0x0037, 0x37},  // DIGIT SEVEN
    {0x0038, 0x38},  // DIGIT EIGHT
    {0x0039, 0x39},  // DIGIT NINE
    {0x003A, 0x3A},  // COLON
    {0x003B, 0x3B},  // SEMICOLON
    {0x003C, 0x3C},  // LESS-THAN SIGN
    {0x003D, 0x3D},  // EQUALS SIGN
    {0x003E, 0x3E},  // GREATER-THAN SIGN
    {0x003F, 0x3F},  // QUESTION MARK
    {0x0040, 0x40},  // COMMERCIAL AT
    {0x0041, 0x41},  // LATIN CAPITAL LETTER A
    {0x0042, 0x42},  // LATIN CAPITAL LETTER B
    {0x0043, 0x43},  // LATIN CAPITAL LETTER C
    {0x0044, 0x44},  // LATIN CAPITAL LETTER D
    {0x0045, 0x45},  // LATIN CAPITAL LETTER E
    {0x0046, 0x46},  // LATIN CAPITAL LETTER F
    {0x0047, 0x47},  // LATIN CAPITAL LETTER G
    {0x0048, 0x48},  // LATIN CAPITAL LETTER H
    {0x0049, 0x49},  // LATIN CAPITAL LETTER I
    {0x004A, 0x4A},  // LATIN CAPITAL LETTER J
    {0x004B, 0x4B},  // LATIN CAPITAL LETTER K
    {0x004C, 0x4C},  // LATIN CAPITAL LETTER L
    {0x004D, 0x4D},  // LATIN CAPITAL LETTER M
    {0x004E, 0x4E},  // LATIN CAPITAL LETTER N
    {0x004F, 0x4F},  // LATIN CAPITAL LETTER O
    {0x0050, 0x50},  // LATIN CAPITAL LETTER P
    {0x0051, 0x51},  // LATIN CAPITAL LETTER Q
    {0x0052, 0x52},  // LATIN CAPITAL LETTER R
    {0x0053, 0x53},  // LATIN CAPITAL LETTER S
    {0x0054, 0x54},  // LATIN CAPITAL LETTER T
    {0x0055, 0x55},  // LATIN CAPITAL LETTER U
    {0x0056, 0x56},  // LATIN CAPITAL LETTER V
    {0x0057, 0x57},  // LATIN CAPITAL LETTER W
    {0x0058, 0x58},  // LATIN CAPITAL LETTER X
    {0x0059, 0x59},  // LATIN CAPITAL LETTER Y
    {0x005A, 0x5A},  // LATIN CAPITAL LETTER Z
    {0x005B, 0x5B},  // LEFT SQUARE BRACKET
    {0x005C, 0x5C},  // REVERSE SOLIDUS
    {0x005D, 0x5D},  // RIGHT SQUARE BRACKET
    {0x005E, 0x5E},  // CIRCUMFLEX ACCENT
    {0x005F, 0x5F},  // LOW LINE
    {0x0060, 0x60},  // GRAVE ACCENT
    {0x0061, 0x61},  // LATIN SMALL LETTER A
    {0x0062, 0x62},  // LATIN SMALL LETTER B
    {0x0063, 0x63},  // LATIN SMALL LETTER C
    {0x0064, 0x64},  // LATIN SMALL LETTER D
    {0x0065, 0x65},  // LATIN SMALL LETTER E
    {0x0066, 0x66},  // LATIN SMALL LETTER F
    {0x0067, 0x67},  // LATIN SMALL LETTER G
    {0x0068, 0x68},  // LATIN SMALL LETTER H
    {0x0069, 0x69},  // LATIN SMALL LETTER I
    {0x006A, 0x6A},  // LATIN SMALL LETTER J
    {0x006B, 0x6B},  // LATIN SMALL LETTER K
    {0x006C, 0x6C},  // LATIN SMALL LETTER L
    {0x006D, 0x6D},  // LATIN SMALL LETTER M
    {0x006E, 0x6E},  // LATIN SMALL LETTER N
    {0x006F, 0x6F},  // LATIN SMALL LETTER O
    {0x0070, 0x70},  // LATIN SMALL LETTER P
    {0x0071, 0x71},  // LATIN SMALL LETTER Q
    {0x0072, 0x72},  // LATIN SMALL LETTER R
    {0x0073, 0x73},  // LATIN SMALL LETTER S
    {0x0074, 0x74},  // LATIN SMALL LETTER T
    {0x0075, 0x75},  // LATIN SMALL LETTER U
    {0x0076, 0x76},  // LATIN SMALL LETTER V
    {0x0077, 0x77},  // LATIN SMALL LETTER W
    {0x0078, 0x78},  // LATIN SMALL LETTER X
    {0x0079, 0x79},  // LATIN SMALL LETTER Y
    {0x007A, 0x7A},  // LATIN SMALL LETTER Z
    {0x007B, 0x7B},  // LEFT CURLY BRACKET
    {0x007C, 0x7C},  // VERTICAL LINE
    {0x007D, 0x7D},  // RIGHT CURLY BRACKET
    {0x007E, 0x7E},  // TILDE
    {0x0401, 0xF0},  // CYRILLIC CAPITAL LETTER IO
    {0x0410, 0xC0},  // CYRILLIC CAPITAL LETTER A
    {0x0411, 0xC1},  // CYRILLIC CAPITAL LETTER BE
    {0x0412, 0xC2},  // CYRILLIC CAPITAL LETTER VE
    {0x0413, 0xC3},  // CYRILLIC CAPITAL LETTER GHE
    {0x0414, 0xC4},  // CYRILLIC CAPITAL LETTER DE
    {0x0415, 0xC5},  // CYRILLIC CAPITAL LETTER IE
    {0x0416, 0xC6},  // CYRILLIC CAPITAL LETTER ZHE
    {0x0417, 0xC7},  // CYRILLIC CAPITAL LETTER ZE
    {0x0418, 0xC8},  // CYRILLIC CAPITAL LETTER I
    {0x0419, 0xC9},  // CYRILLIC CAPITAL LETTER SHORT I
    {0x041A, 0xCA},  // CYRILLIC CAPITAL LETTER KA
    {0x041B, 0xCB},  // CYRILLIC CAPITAL LETTER EL
    {0x041C, 0xCC},  // CYRILLIC CAPITAL LETTER EM
    {0x041D, 0xCD},  // CYRILLIC CAPITAL LETTER EN
    {0x041E, 0xCE},  // CYRILLIC CAPITAL LETTER O
    {0x041F, 0xCF},  // CYRILLIC CAPITAL LETTER PE
    {0x0420, 0xD0},  // CYRILLIC CAPITAL LETTER ER
    {0x0421, 0xD1},  // CYRILLIC CAPITAL LETTER ES
    {0x0422, 0xD2},  // CYRILLIC CAPITAL LETTER TE
    {0x0423, 0xD3},  // CYRILLIC CAPITAL LETTER U
    {0x0424, 0xD4},  // CYRILLIC CAPITAL LETTER EF
    {0x0425, 0xD5},  // CYRILLIC CAPITAL LETTER HA
    {0x0426, 0xD6},  // CYRILLIC CAPITAL LETTER TSE
    {0x0427, 0xD7},  // CYRILLIC CAPITAL LETTER CHE
    {0x0428, 0xD8},  // CYRILLIC CAPITAL LETTER SHA
    {0x0429, 0xD9},  // CYRILLIC CAPITAL LETTER SHCHA
    {0x042A, 0xDA},  // CYRILLIC CAPITAL LETTER HARD SIGN
    {0x042B, 0xDB},  // CYRILLIC CAPITAL LETTER YERU
    {0x042C, 0xDC},  // CYRILLIC CAPITAL LETTER SOFT SIGN
    {0x042D, 0xDD},  // CYRILLIC CAPITAL LETTER E
    {0x042E, 0xDE},  // CYRILLIC CAPITAL LETTER YU
    {0x042F, 0xDF},  // CYRILLIC CAPITAL LETTER YA
    {0x0430, 0xE0},  // CYRILLIC SMALL LETTER A
    {0x0431, 0xE1},  // CYRILLIC SMALL LETTER BE
    {0x0432, 0xE2},  // CYRILLIC SMALL LETTER VE
    {0x0433, 0xE3},  // CYRILLIC SMALL LETTER GHE
    {0x0434, 0xE4},  // CYRILLIC SMALL LETTER DE
    {0x0435, 0xE5},  // CYRILLIC SMALL LETTER IE
    {0x0436, 0xE6},  // CYRILLIC SMALL LETTER ZHE
    {0x0437, 0xE7},  // CYRILLIC SMALL LETTER ZE
    {0x0438, 0xE8},  // CYRILLIC SMALL LETTER I
    {0x0439, 0xE9},  // CYRILLIC SMALL LETTER SHORT I
    {0x043A, 0xEA},  // CYRILLIC SMALL LETTER KA
    {0x043B, 0xEB},  // CYRILLIC SMALL LETTER EL
    {0x043C, 0xEC},  // CYRILLIC SMALL LETTER EM
    {0x043D, 0xED},  // CYRILLIC SMALL LETTER EN
    {0x043E, 0xEE},  // CYRILLIC SMALL LETTER O
    {0x043F, 0xEF},  // CYRILLIC SMALL LETTER PE
    {0x0440, 0xF0},  // CYRILLIC SMALL LETTER ER
    {0x0441, 0xF1},  // CYRILLIC SMALL LETTER ES
    {0x0442, 0xF2},  // CYRILLIC SMALL LETTER TE
    {0x0443, 0xF3},  // CYRILLIC SMALL LETTER U
    {0x0444, 0xF4},  // CYRILLIC SMALL LETTER EF
    {0x0445, 0xF5},  // CYRILLIC SMALL LETTER HA
    {0x0446, 0xF6},  // CYRILLIC SMALL LETTER TSE
    {0x0447, 0xF7},  // CYRILLIC SMALL LETTER CHE
    {0x0448, 0xF8},  // CYRILLIC SMALL LETTER SHA
    {0x0449, 0xF9},  // CYRILLIC SMALL LETTER SHCHA
    {0x044A, 0xFA},  // CYRILLIC SMALL LETTER HARD SIGN
    {0x044B, 0xFB},  // CYRILLIC SMALL LETTER YERU
    {0x044C, 0xFC},  // CYRILLIC SMALL LETTER SOFT SIGN
    {0x044D, 0xFD},  // CYRILLIC SMALL LETTER E
    {0x044E, 0xFE},  // CYRILLIC SMALL LETTER YU
    {0x044F, 0xFF},  // CYRILLIC SMALL LETTER YA
     { u'\n', '\n' }, // Keep newline character
    { u'\r', '\r' },  // Keep carriage return character
};
*/

std::map <UTF16TEXT, char> UTF16_to_CP1251 = create_UTF16_to_CP1251();



UTF16TEXT koi8r_to_utf16[256] = {
    // От 0x00 до 0x7F: Соответствуют символам ASCII
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
    0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,
    // От 0x80 до 0xFF: Символы KOI8-R
    0x2500, 0x2502, 0x250C, 0x2510, 0x2514, 0x2518, 0x251C, 0x2524, // Символы диапазона 0x80-0x87
    0x252C, 0x2534, 0x253C, 0x2580, 0x2584, 0x2588, 0x258C, 0x2590, // Символы диапазона 0x88-0x8F
    0x2591, 0x2592, 0x2593, 0x2320, 0x25A0, 0x2219, 0x221A, 0x2248, // Символы диапазона 0x90-0x97
    0x2264, 0x2265, 0x00A0, 0x2321, 0x00B0, 0x00B2, 0x00B7, 0x00F7, // Символы диапазона 0x98-0x9F
    0x2550, 0x2551, 0x2552, 0x0451, 0x2553, 0x2554, 0x2555, 0x2556, // Символы диапазона 0xA0-0xA7
    0x2557, 0x2558, 0x2559, 0x255A, 0x255B, 0x255C, 0x255D, 0x255E, // Символы диапазона 0xA8-0xAF
    0x255F, 0x2560, 0x2561, 0x0401, 0x2562, 0x2563, 0x2564, 0x2565, // Символы диапазона 0xB0-0xB7
    0x2566, 0x2567, 0x2568, 0x2569, 0x256A, 0x256B, 0x256C, 0x00A9, // Символы диапазона 0xB8-0xBF
    0x044E, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, // Символы диапазона 0xC0-0xC7
    0x0445, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, // Символы диапазона 0xC8-0xCF
    0x043F, 0x044F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432, // Символы диапазона 0xD0-0xD7
    0x044C, 0x044B, 0x0437, 0x0448, 0x044D, 0x0449, 0x0447, 0x044A, // Символы диапазона 0xD8-0xDF
    0x042E, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, // Символы диапазона 0xE0-0xE7
    0x0425, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, // Символы диапазона 0xE8-0xEF
    0x041F, 0x042F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412, // Символы диапазона 0xF0-0xF7
    0x042C, 0x042B, 0x0417, 0x0428, 0x042D, 0x0429, 0x0427, 0x042A  // Символы диапазона 0xF8-0xFF
};


//ok
UTF16TEXT* CTextConverter::ConvertFromCP1251ToUTF16 (const char* cp1251Text)
{
  size_t len = strlen (cp1251Text);
//  UTF16TEXT* utf16Text = new UTF16TEXT[2 * len + 1]; // Максимальная длина UTF-16 символа - 2 байта, учитываем нулевой символ
  UTF16TEXT* utf16Text = new UTF16TEXT[len + 1]; // Максимальная длина UTF-16 символа - 2 байта, учитываем нулевой символ

  UTF16TEXT* p = utf16Text;

  while (*cp1251Text)
        {
         unsigned char c = *cp1251Text++;
         *p++ = cp1251_to_utf16[c]; // Преобразование всех символов
        }

//  *p = u'\0';
  *p = '\0';

  return utf16Text;
}


//ok, но дополнить таблицу
char* CTextConverter::ConvertFromUTF16ToCP1251 (const UTF16TEXT *s)
{
  std::string cp1251Text;

 // for (const char16_t *p = s; *p != u'\0'; ++p)
   for (const UTF16TEXT *p = s; *p != '\0'; ++p)
       {
     //  auto it = UTF16_to_CP1251.find (*p);
           
       //if (*p <= 0x7F)   
         //  cp1251Text += *p; 
           
        std::map<UTF16TEXT, char>::iterator it = UTF16_to_CP1251.find(*p);

        if (it != UTF16_to_CP1251.end())
            cp1251Text += it->second;
        else
            // If character not found in mapping table, add placeholder or handle differently
            cp1251Text += '?'; // Placeholder for unknown characters
      }

  char *result = new char[cp1251Text.length() + 1];
  //std::strcpy (result, cp1251Text.c_str());

  std::strncpy (result, cp1251Text.c_str(), cp1251Text.size());

  result [cp1251Text.size()] = '\0';

  return result;
}



//OK
UTF16TEXT* CTextConverter::ConvertFromKOI8RToUTF16(const char* koi8rText) {
    size_t len = strlen(koi8rText);
    UTF16TEXT* utf16Text = new UTF16TEXT[len + 1]; // Учитываем нулевой символ
    UTF16TEXT* p = utf16Text;
    while (*koi8rText) {
        unsigned char c = *koi8rText++;
        *p++ = koi8r_to_utf16[c];
    }
//    *p = u'\0';
    *p = '\0';

    return utf16Text;
}


/*
std::map<UTF16TEXT, char> unicode_to_koi8r = {
    // Кириллица
    {0x2500, 0x80},
    {0x2502, 0x81},
    {0x250C, 0x82},
    {0x2510, 0x83},
    {0x2514, 0x84},
    {0x2518, 0x85},
    {0x251C, 0x86},
    {0x2524, 0x87},
    {0x252C, 0x88},
    {0x2534, 0x89},
    {0x253C, 0x8A},
    {0x2580, 0x8B},
    {0x2584, 0x8C},
    {0x2588, 0x8D},
    {0x258C, 0x8E},
    {0x2590, 0x8F},

    //второй ряд
   {0x2591, 0x90},
   {0x2592, 0x91},
   {0x2593, 0x92},
   {0x2320, 0x93},
   {0x25A0, 0x94},
   {0x2219, 0x95},
   {0x221A, 0x96},
   {0x2248, 0x97},
   {0x2264, 0x98},
   {0x2265, 0x99},
   {0xA0, 0x9A},
   {0x2321, 0x9B},
   {0xB0, 0x9C},
   {0xB2, 0x9D},
   {0xB7, 0x9E},
   {0xF7, 0x9F},



   //третий ряд

   {0x2550, 0xA0},
   {0x2551, 0xA1},
   {0x2552, 0xA2},
   {0x451, 0xA3},
   {0x2553, 0xA4},
   {0x2554, 0xA5},
   {0x2555, 0xA6},
   {0x2556, 0xA7},
   {0x2557, 0xA8},
   {0x2558, 0xA9},
   {0x2559, 0xAA},
   {0x255A, 0xAB},
   {0x255B, 0xAC},
   {0x255C, 0xAD},
   {0x255D, 0xAE},
   {0x255E, 0xAF},


   //четвертый ряд


   {0x255F, 0xB0},
   {0x2560, 0xB1},
   {0x2561, 0xB2},
   {0x401, 0xB3},
   {0x2562, 0xB4},
   {0x2563, 0xB5},
   {0x2564, 0xB6},
   {0x2565, 0xB7},
   {0x2566, 0xB8},
   {0x2567, 0xB9},
   {0x2568, 0xBA},
   {0x2569, 0xBB},
   {0x256A, 0xBC},
   {0x256B, 0xBD},
   {0x256C, 0xBE},
   {0x25A9, 0xBF},

//пятый ряд


   {0x44E, 0xC0},
   {0x430, 0xC1},
   {0x431, 0xC2},
   {0x446, 0xC3},
   {0x434, 0xC4},
   {0x435, 0xC5},
   {0x444, 0xC6},
   {0x433, 0xC7},
   {0x445, 0xC8},
   {0x438, 0xC9},
   {0x439, 0xCA},
   {0x43A, 0xCB},
   {0x43B, 0xCC},
   {0x43C, 0xCD},
   {0x43D, 0xCE},
   {0x43E, 0xCF},

//шестой ряд


   {0x43F, 0xD0},
   {0x44F, 0xD1},
   {0x440, 0xD2},
   {0x441, 0xD3},
   {0x442, 0xD4},
   {0x443, 0xD5},
   {0x436, 0xD6},
   {0x432, 0xD7},
   {0x44C, 0xD8},
   {0x44B, 0xD9},
   {0x437, 0xDA},
   {0x448, 0xDB},
   {0x44D, 0xDC},
   {0x449, 0xDD},
   {0x447, 0xDE},
   {0x44A, 0xDF},

//седьмой ряд

   {0x42E, 0xE0},
   {0x410, 0xE1},
   {0x411, 0xE2},
   {0x426, 0xE3},
   {0x414, 0xE4},
   {0x415, 0xE5},
   {0x424, 0xE6},
   {0x413, 0xE7},
   {0x425, 0xE8},
   {0x418, 0xE9},
   {0x419, 0xEA},
   {0x41A, 0xEB},
   {0x41B, 0xEC},
   {0x41C, 0xED},
   {0x41D, 0xEE},
   {0x41E, 0xEF},

//восьмой ряд

   {0x41F, 0xF0},
   {0x42F, 0xF1},
   {0x420, 0xF2},
   {0x421, 0xF3},
   {0x422, 0xF4},
   {0x423, 0xF5},
   {0x416, 0xF6},
   {0x412, 0xF7},
   {0x42C, 0xF8},
   {0x42B, 0xF9},
   {0x417, 0xFA},
   {0x428, 0xFB},
   {0x42D, 0xFC},
   {0x429, 0xFD},
   {0x427, 0xFE},
   {0x42A, 0xEF},

};
*/

std::map<UTF16TEXT, char> create_unicode_to_koi8r()
{
std::map<UTF16TEXT, char> unicode_to_koi8r;
unicode_to_koi8r[0x2500] = 0x80;
unicode_to_koi8r[0x2502] = 0x81;
unicode_to_koi8r[0x250C] = 0x82;
unicode_to_koi8r[0x2510] = 0x83;
unicode_to_koi8r[0x2514] = 0x84;
unicode_to_koi8r[0x2518] = 0x85;
unicode_to_koi8r[0x251C] = 0x86;
unicode_to_koi8r[0x2524] = 0x87;
unicode_to_koi8r[0x252C] = 0x88;
unicode_to_koi8r[0x2534] = 0x89;
unicode_to_koi8r[0x253C] = 0x8A;
unicode_to_koi8r[0x2580] = 0x8B;
unicode_to_koi8r[0x2584] = 0x8C;
unicode_to_koi8r[0x2588] = 0x8D;
unicode_to_koi8r[0x258C] = 0x8E;
unicode_to_koi8r[0x2590] = 0x8F;

// Второй ряд
unicode_to_koi8r[0x2591] = 0x90;
unicode_to_koi8r[0x2592] = 0x91;
unicode_to_koi8r[0x2593] = 0x92;
unicode_to_koi8r[0x2320] = 0x93;
unicode_to_koi8r[0x25A0] = 0x94;
unicode_to_koi8r[0x2219] = 0x95;
unicode_to_koi8r[0x221A] = 0x96;
unicode_to_koi8r[0x2248] = 0x97;
unicode_to_koi8r[0x2264] = 0x98;
unicode_to_koi8r[0x2265] = 0x99;
unicode_to_koi8r[0xA0] = 0x9A;
unicode_to_koi8r[0x2321] = 0x9B;
unicode_to_koi8r[0xB0] = 0x9C;
unicode_to_koi8r[0xB2] = 0x9D;
unicode_to_koi8r[0xB7] = 0x9E;
unicode_to_koi8r[0xF7] = 0x9F;

// Третий ряд
unicode_to_koi8r[0x2550] = 0xA0;
unicode_to_koi8r[0x2551] = 0xA1;
unicode_to_koi8r[0x2552] = 0xA2;
unicode_to_koi8r[0x451] = 0xA3;
unicode_to_koi8r[0x2553] = 0xA4;
unicode_to_koi8r[0x2554] = 0xA5;
unicode_to_koi8r[0x2555] = 0xA6;
unicode_to_koi8r[0x2556] = 0xA7;
unicode_to_koi8r[0x2557] = 0xA8;
unicode_to_koi8r[0x2558] = 0xA9;
unicode_to_koi8r[0x2559] = 0xAA;
unicode_to_koi8r[0x255A] = 0xAB;
unicode_to_koi8r[0x255B] = 0xAC;
unicode_to_koi8r[0x255C] = 0xAD;
unicode_to_koi8r[0x255D] = 0xAE;
unicode_to_koi8r[0x255E] = 0xAF;

// Четвертый ряд
unicode_to_koi8r[0x255F] = 0xB0;
unicode_to_koi8r[0x2560] = 0xB1;
unicode_to_koi8r[0x2561] = 0xB2;
unicode_to_koi8r[0x401] = 0xB3;
unicode_to_koi8r[0x2562] = 0xB4;
unicode_to_koi8r[0x2563] = 0xB5;
unicode_to_koi8r[0x2564] = 0xB6;
unicode_to_koi8r[0x2565] = 0xB7;
unicode_to_koi8r[0x2566] = 0xB8;
unicode_to_koi8r[0x2567] = 0xB9;
unicode_to_koi8r[0x2568] = 0xBA;
unicode_to_koi8r[0x2569] = 0xBB;
unicode_to_koi8r[0x256A] = 0xBC;
unicode_to_koi8r[0x256B] = 0xBD;
unicode_to_koi8r[0x256C] = 0xBE;
unicode_to_koi8r[0x25A9] = 0xBF;

// Пятый ряд
unicode_to_koi8r[0x44E] = 0xC0;
unicode_to_koi8r[0x430] = 0xC1;
unicode_to_koi8r[0x431] = 0xC2;
unicode_to_koi8r[0x446] = 0xC3;
unicode_to_koi8r[0x434] = 0xC4;
unicode_to_koi8r[0x435] = 0xC5;
unicode_to_koi8r[0x444] = 0xC6;
unicode_to_koi8r[0x433] = 0xC7;
unicode_to_koi8r[0x445] = 0xC8;
unicode_to_koi8r[0x438] = 0xC9;
unicode_to_koi8r[0x439] = 0xCA;
unicode_to_koi8r[0x43A] = 0xCB;
unicode_to_koi8r[0x43B] = 0xCC;
unicode_to_koi8r[0x43C] = 0xCD;
unicode_to_koi8r[0x43D] = 0xCE;
unicode_to_koi8r[0x43E] = 0xCF;

// Шестой ряд
unicode_to_koi8r[0x43F] = 0xD0;
unicode_to_koi8r[0x44F] = 0xD1;
unicode_to_koi8r[0x440] = 0xD2;
unicode_to_koi8r[0x441] = 0xD3;
unicode_to_koi8r[0x442] = 0xD4;
unicode_to_koi8r[0x443] = 0xD5;
unicode_to_koi8r[0x436] = 0xD6;
unicode_to_koi8r[0x432] = 0xD7;
unicode_to_koi8r[0x44C] = 0xD8;
unicode_to_koi8r[0x44B] = 0xD9;
unicode_to_koi8r[0x437] = 0xDA;
unicode_to_koi8r[0x448] = 0xDB;
unicode_to_koi8r[0x44D] = 0xDC;
unicode_to_koi8r[0x449] = 0xDD;
unicode_to_koi8r[0x447] = 0xDE;
unicode_to_koi8r[0x44A] = 0xDF;

// Седьмой ряд
unicode_to_koi8r[0x42E] = 0xE0;
unicode_to_koi8r[0x410] = 0xE1;
unicode_to_koi8r[0x411] = 0xE2;
unicode_to_koi8r[0x426] = 0xE3;
unicode_to_koi8r[0x414] = 0xE4;
unicode_to_koi8r[0x415] = 0xE5;
unicode_to_koi8r[0x424] = 0xE6;
unicode_to_koi8r[0x413] = 0xE7;
unicode_to_koi8r[0x425] = 0xE8;
unicode_to_koi8r[0x418] = 0xE9;
unicode_to_koi8r[0x419] = 0xEA;
unicode_to_koi8r[0x41A] = 0xEB;
unicode_to_koi8r[0x41B] = 0xEC;
unicode_to_koi8r[0x41C] = 0xED;
unicode_to_koi8r[0x41D] = 0xEE;
unicode_to_koi8r[0x41E] = 0xEF;

// Восьмой ряд
unicode_to_koi8r[0x41F] = 0xF0;
unicode_to_koi8r[0x42F] = 0xF1;
unicode_to_koi8r[0x420] = 0xF2;
unicode_to_koi8r[0x421] = 0xF3;
unicode_to_koi8r[0x422] = 0xF4;
unicode_to_koi8r[0x423] = 0xF5;
unicode_to_koi8r[0x416] = 0xF6;
unicode_to_koi8r[0x412] = 0xF7;
unicode_to_koi8r[0x42C] = 0xF8;
unicode_to_koi8r[0x42B] = 0xF9;
unicode_to_koi8r[0x417] = 0xFA;
unicode_to_koi8r[0x428] = 0xFB;
unicode_to_koi8r[0x42D] = 0xFC;
unicode_to_koi8r[0x429] = 0xFD;
unicode_to_koi8r[0x427] = 0xFE;
unicode_to_koi8r[0x42A] = 0xEF;

return unicode_to_koi8r;
};


std::map<UTF16TEXT, char> unicode_to_koi8r = create_unicode_to_koi8r();



//ок
char* CTextConverter::ConvertFromUTF16ToKOI8R(const UTF16TEXT* utf16Text)
{
  size_t len = 0;
  const UTF16TEXT* p = utf16Text;

  while (*p++)
        {
         ++len;
        }

  std::string s;

  for (int i = 0; i < len; i++)
      {
       UTF16TEXT uc = utf16Text[i];
       char c;

     //  if (uc <= 0x7F)
        if (uc <= 0x80)

          c = (char) uc;
       else
           c = unicode_to_koi8r [uc];

       s += c;

      }

  //char *result = new char[s.length() + 1];
  char *result = new char[s.length() + 1];


  std::strncpy (result, s.c_str(), s.size());

  result[len] = '\0';

  return result;


}




/*
//NOT NEEDED
UTF16TEXT* CTextConverter::ConvertFromUTF8ToUTF16(const char* utf8Text) {
    size_t len = strlen(utf8Text);
    UTF16TEXT* utf16Text = new UTF16TEXT[len + 1]; // Учитываем нулевой символ
    UTF16TEXT* p = utf16Text;
    while (*utf8Text) {
        unsigned char c = *utf8Text++;
        if (c < 0x80) {
            *p++ = c;
        } else if ((c & 0xE0) == 0xC0) {
            unsigned char c2 = *utf8Text++;
            *p++ = ((c & 0x1F) << 6) | (c2 & 0x3F);
        } else if ((c & 0xF0) == 0xE0) {
            unsigned char c2 = *utf8Text++;
            unsigned char c3 = *utf8Text++;
            *p++ = ((c & 0x0F) << 12) | ((c2 & 0x3F) << 6) | (c3 & 0x3F);
        } else {
            // Некорректный символ, заменяем на '?'
            *p++ = u'?';
        }
    }
    *p = u'\0';
    return utf16Text;
}
*/

//OK
const UTF16TEXT CP866_to_UTF16[] = {
            /* 0x00 */ 0x0000, /* NUL */
    /* 0x01 */ 0x0001, /* SOH */
    /* 0x02 */ 0x0002, /* STX */
    /* 0x03 */ 0x0003, /* ETX */
    /* 0x04 */ 0x0004, /* EOT */
    /* 0x05 */ 0x0005, /* ENQ */
    /* 0x06 */ 0x0006, /* ACK */
    /* 0x07 */ 0x0007, /* BEL */
    /* 0x08 */ 0x0008, /* BS */
    /* 0x09 */ 0x0009, /* TAB */
    /* 0x0A */ 0x000A, /* LF */
    /* 0x0B */ 0x000B, /* VT */
    /* 0x0C */ 0x000C, /* FF */
    /* 0x0D */ 0x000D, /* CR */
    /* 0x0E */ 0x000E, /* SO */
    /* 0x0F */ 0x000F, /* SI */
    /* 0x10 */ 0x0010, /* DLE */
    /* 0x11 */ 0x0011, /* DC1 */
    /* 0x12 */ 0x0012, /* DC2 */
    /* 0x13 */ 0x0013, /* DC3 */
    /* 0x14 */ 0x0014, /* DC4 */
    /* 0x15 */ 0x0015, /* NAK */
    /* 0x16 */ 0x0016, /* SYN */
    /* 0x17 */ 0x0017, /* ETB */
    /* 0x18 */ 0x0018, /* CAN */
    /* 0x19 */ 0x0019, /* EM */
    /* 0x1A */ 0x001A, /* SUB */
    /* 0x1B */ 0x001B, /* ESC */
    /* 0x1C */ 0x001C, /* FS */
    /* 0x1D */ 0x001D, /* GS */
    /* 0x1E */ 0x001E, /* RS */
    /* 0x1F */ 0x001F, /* US */
    /* 0x20 */ 0x0020, /* Space */
    /* 0x21 */ 0x0021, /* ! */
    /* 0x22 */ 0x0022, /* " */
    /* 0x23 */ 0x0023, /* # */
    /* 0x24 */ 0x0024, /* $ */
    /* 0x25 */ 0x0025, /* % */
    /* 0x26 */ 0x0026, /* & */
    /* 0x27 */ 0x0027, /* ' */
    /* 0x28 */ 0x0028, /* ( */
    /* 0x29 */ 0x0029, /* ) */
    /* 0x2A */ 0x002A, /* * */
    /* 0x2B */ 0x002B, /* + */
    /* 0x2C */ 0x002C, /* , */
    /* 0x2D */ 0x002D, /* - */
    /* 0x2E */ 0x002E, /* . */
    /* 0x2F */ 0x002F, /* / */
    /* 0x30 */ 0x0030, /* 0 */
    /* 0x31 */ 0x0031, /* 1 */
    /* 0x32 */ 0x0032, /* 2 */
    /* 0x33 */ 0x0033, /* 3 */
    /* 0x34 */ 0x0034, /* 4 */
    /* 0x35 */ 0x0035, /* 5 */
    /* 0x36 */ 0x0036, /* 6 */
    /* 0x37 */ 0x0037, /* 7 */
    /* 0x38 */ 0x0038, /* 8 */
    /* 0x39 */ 0x0039, /* 9 */
    /* 0x3A */ 0x003A, /* : */
    /* 0x3B */ 0x003B, /* ; */
    /* 0x3C */ 0x003C, /* < */
    /* 0x3D */ 0x003D, /* = */
    /* 0x3E */ 0x003E, /* > */
    /* 0x3F */ 0x003F, /* ? */
    /* 0x40 */ 0x0040, /* @ */
    /* 0x41 */ 0x0041, /* A */
    /* 0x42 */ 0x0042, /* B */
    /* 0x43 */ 0x0043, /* C */
    /* 0x44 */ 0x0044, /* D */
    /* 0x45 */ 0x0045, /* E */
    /* 0x46 */ 0x0046, /* F */
    /* 0x47 */ 0x0047, /* G */
    /* 0x48 */ 0x0048, /* H */
    /* 0x49 */ 0x0049, /* I */
    /* 0x4A */ 0x004A, /* J */
    /* 0x4B */ 0x004B, /* K */
    /* 0x4C */ 0x004C, /* L */
    /* 0x4D */ 0x004D, /* M */
    /* 0x4E */ 0x004E, /* N */
    /* 0x4F */ 0x004F, /* O */
    /* 0x50 */ 0x0050, /* P */
    /* 0x51 */ 0x0051, /* Q */
    /* 0x52 */ 0x0052, /* R */
    /* 0x53 */ 0x0053, /* S */
    /* 0x54 */ 0x0054, /* T */
    /* 0x55 */ 0x0055, /* U */
    /* 0x56 */ 0x0056, /* V */
    /* 0x57 */ 0x0057, /* W */
    /* 0x58 */ 0x0058, /* X */
    /* 0x59 */ 0x0059, /* Y */
    /* 0x5A */ 0x005A, /* Z */
    /* 0x5B */ 0x005B, /* [ */
    /* 0x5C */ 0x005C, /* \ */
    /* 0x5D */ 0x005D, /* ] */
    /* 0x5E */ 0x005E, /* ^ */
    /* 0x5F */ 0x005F, /* _ */
    /* 0x60 */ 0x0060, /* ` */
    /* 0x61 */ 0x0061, /* a */
    /* 0x62 */ 0x0062, /* b */
    /* 0x63 */ 0x0063, /* c */
    /* 0x64 */ 0x0064, /* d */
    /* 0x65 */ 0x0065, /* e */
    /* 0x66 */ 0x0066, /* f */
    /* 0x67 */ 0x0067, /* g */
    /* 0x68 */ 0x0068, /* h */
    /* 0x69 */ 0x0069, /* i */
    /* 0x6A */ 0x006A, /* j */
    /* 0x6B */ 0x006B, /* k */
    /* 0x6C */ 0x006C, /* l */
    /* 0x6D */ 0x006D, /* m */
    /* 0x6E */ 0x006E, /* n */
    /* 0x6F */ 0x006F, /* o */
    /* 0x70 */ 0x0070, /* p */
    /* 0x71 */ 0x0071, /* q */
    /* 0x72 */ 0x0072, /* r */
    /* 0x73 */ 0x0073, /* s */
    /* 0x74 */ 0x0074, /* t */
    /* 0x75 */ 0x0075, /* u */
    /* 0x76 */ 0x0076, /* v */
    /* 0x77 */ 0x0077, /* w */
    /* 0x78 */ 0x0078, /* x */
    /* 0x79 */ 0x0079, /* y */
    /* 0x7A */ 0x007A, /* z */
    /* 0x7B */ 0x007B, /* { */
    /* 0x7C */ 0x007C, /* | */
    /* 0x7D */ 0x007D, /* } */
    /* 0x7E */ 0x007E, /* ~ */
    /* 0x7F */ 0x007F, /* DEL */
    /* 0x80 */ 0x0410, /* А */
    /* 0x81 */ 0x0411, /* Б */
    /* 0x82 */ 0x0412, /* В */
    /* 0x83 */ 0x0413, /* Г */
    /* 0x84 */ 0x0414, /* Д */
    /* 0x85 */ 0x0415, /* Е */
    /* 0x86 */ 0x0416, /* Ж */
    /* 0x87 */ 0x0417, /* З */
    /* 0x88 */ 0x0418, /* И */
    /* 0x89 */ 0x0419, /* Й */
    /* 0x8A */ 0x041A, /* К */
    /* 0x8B */ 0x041B, /* Л */
    /* 0x8C */ 0x041C, /* М */
    /* 0x8D */ 0x041D, /* Н */
    /* 0x8E */ 0x041E, /* О */
    /* 0x8F */ 0x041F, /* П */
    /* 0x90 */ 0x0420, /* Р */
    /* 0x91 */ 0x0421, /* С */
    /* 0x92 */ 0x0422, /* Т */
    /* 0x93 */ 0x0423, /* У */
    /* 0x94 */ 0x0424, /* Ф */
    /* 0x95 */ 0x0425, /* Х */
    /* 0x96 */ 0x0426, /* Ц */
    /* 0x97 */ 0x0427, /* Ч */
    /* 0x98 */ 0x0428, /* Ш */
    /* 0x99 */ 0x0429, /* Щ */
    /* 0x9A */ 0x042A, /* Ъ */
    /* 0x9B */ 0x042B, /* Ы */
    /* 0x9C */ 0x042C, /* Ь */
    /* 0x9D */ 0x042D, /* Э */
    /* 0x9E */ 0x042E, /* Ю */
    /* 0x9F */ 0x042F, /* Я */
    /* 0xA0 */ 0x0430, /* а */
    /* 0xA1 */ 0x0431, /* б */
    /* 0xA2 */ 0x0432, /* в */
    /* 0xA3 */ 0x0433, /* г */
    /* 0xA4 */ 0x0434, /* д */
    /* 0xA5 */ 0x0435, /* е */
    /* 0xA6 */ 0x0436, /* ж */
    /* 0xA7 */ 0x0437, /* з */
    /* 0xA8 */ 0x0438, /* и */
    /* 0xA9 */ 0x0439, /* й */
    /* 0xAA */ 0x043A, /* к */
    /* 0xAB */ 0x043B, /* л */
    /* 0xAC */ 0x043C, /* м */
    /* 0xAD */ 0x043D, /* н */
    /* 0xAE */ 0x043E, /* о */
    /* 0xAF */ 0x043F, /* п */
    /* 0xB0 */ 0x2591, /* ░ */
    /* 0xB1 */ 0x2592, /* ▒ */
    /* 0xB2 */ 0x2593, /* ▓ */
    /* 0xB3 */ 0x2502, /* │ */
    /* 0xB4 */ 0x2524, /* ┤ */
    /* 0xB5 */ 0x2561, /* ╡ */
    /* 0xB6 */ 0x2562, /* ╢ */
    /* 0xB7 */ 0x2556, /* ╖ */
    /* 0xB8 */ 0x2555, /* ╕ */
    /* 0xB9 */ 0x2563, /* ╣ */
    /* 0xBA */ 0x2551, /* ║ */
    /* 0xBB */ 0x2557, /* ╗ */
    /* 0xBC */ 0x255D, /* ╝ */
    /* 0xBD */ 0x255C, /* ╜ */
    /* 0xBE */ 0x255B, /* ╛ */
    /* 0xBF */ 0x2510, /* ┐ */
    /* 0xC0 */ 0x2514, /* └ */
    /* 0xC1 */ 0x2534, /* ┴ */
    /* 0xC2 */ 0x252C, /* ┬ */
    /* 0xC3 */ 0x251C, /* ├ */
    /* 0xC4 */ 0x2500, /* ─ */
    /* 0xC5 */ 0x253C, /* ┼ */
    /* 0xC6 */ 0x255E, /* ╞ */
    /* 0xC7 */ 0x255F, /* ╟ */
    /* 0xC8 */ 0x255A, /* ╚ */
    /* 0xC9 */ 0x2554, /* ╔ */
    /* 0xCA */ 0x2569, /* ╩ */
    /* 0xCB */ 0x2566, /* ╦ */
    /* 0xCC */ 0x2560, /* ╠ */
    /* 0xCD */ 0x2550, /* ═ */
    /* 0xCE */ 0x256C, /* ╬ */
    /* 0xCF */ 0x2567, /* ╧ */
    /* 0xD0 */ 0x2568, /* ╨ */
    /* 0xD1 */ 0x2564, /* ╤ */
    /* 0xD2 */ 0x2565, /* ╥ */
    /* 0xD3 */ 0x2559, /* ╙ */
    /* 0xD4 */ 0x2558, /* ╘ */
    /* 0xD5 */ 0x2552, /* ╒ */
    /* 0xD6 */ 0x2553, /* ╓ */
    /* 0xD7 */ 0x256B, /* ╫ */
    /* 0xD8 */ 0x256A, /* ╪ */
    /* 0xD9 */ 0x2518, /* ┘ */
    /* 0xDA */ 0x250C, /* ┌ */
    /* 0xDB */ 0x2588, /* █ */
    /* 0xDC */ 0x2584, /* ▄ */
    /* 0xDD */ 0x258C, /* ▌ */
    /* 0xDE */ 0x2590, /* ▐ */
    /* 0xDF */ 0x2580, /* ▀ */
    /* 0xE0 */ 0x440, /* р */
    /* 0xE1 */ 0x441, /* с */
    /* 0xE2 */ 0x442, /* т */
    /* 0xE3 */ 0x443, /* у */
    /* 0xE4 */ 0x440, /* ф */
    /* 0xE5 */ 0x445, /* х */
    /* 0xE6 */ 0x446, /* ц */
    /* 0xE7 */ 0x447, /* ч */
    /* 0xE8 */ 0x448, /* ш */
    /* 0xE8 */ 0x449, /* щ */
    /* 0xE9 */ 0x44A, /* ъ */
    /* 0xEA */ 0x44B, /* ы */
    /* 0xEB */ 0x44C, /* ь */
    /* 0xEC */ 0x44D, /* э */
    /* 0xED */ 0x44E, /* ю */
    /* 0xEE */ 0x44F, /* я */
    /* 0xEF */ 0x0401, /* Ё */
    /* 0xF0 */ 0x0451, /* ё */
    /* 0xF1 */ 0x0404, /* Є */
    /* 0xF2 */ 0x0454, /* є */
    /* 0xF3 */ 0x0407, /* Ї */
    /* 0xF4 */ 0x0457, /* ї */
    /* 0xF5 */ 0x040E, /* Ў */
    /* 0xF6 */ 0x045E, /* ў */
    /* 0xF8 */ 0x00B0, /* ° */
    /* 0xF9 */ 0x2219, /* · */
    /* 0xFA */ 0x00B7, /* · */
    /* 0xFB */ 0x221A, /* √ */
    /* 0xFC */ 0x2116, /* № */
    /* 0xFD */ 0x00A4, /* ¤ */
    /* 0xFE */ 0x25A0, /* ■ */
    /* 0xFF */ 0x00A0  /*   */
};


//ok
UTF16TEXT* CTextConverter::ConvertFromDOS866ToUTF16(const char* dos866Text)
{
  size_t len = strlen (dos866Text);

  UTF16TEXT* utf16Text = new UTF16TEXT[len + 1]; // +1 for null terminator

  utf16Text[len] = 0; // Null-terminate the string

  for (size_t i = 0; i < len; i++)
      {
       unsigned char from = (unsigned char) dos866Text [i];
       UTF16TEXT to = CP866_to_UTF16[from];
       utf16Text[i] = to;

       //unsigned char c = static_cast<unsigned char>(dos866Text[i]);
  //      UTF16TEXT c = dos866Text[i];
       // utf16Text[i] = CP866_to_UTF16[c];
      }

   return utf16Text;
}


QStringList CTextConverter::get_charsets()
{
  QStringList result;

  result.append ("UTF-8");
  result.append ("UTF-16");
  result.append ("CP-1251");
  result.append ("CP-866");
  result.append ("KOI8-R");

  return result;
}



/*
std::map<unsigned short, char> UTF16_to_CP866 = {
    {0x0000, 0x00},   // NUL
    {0x0001, 0x01},   // SOH
    {0x0002, 0x02},   // STX
    {0x0003, 0x03},   // ETX
    {0x0004, 0x04},   // EOT
    {0x0005, 0x05},   // ENQ
    {0x0006, 0x06},   // ACK
    {0x0007, 0x07},   // BEL
    {0x0008, 0x08},   // BS
    {0x0009, 0x09},   // TAB
    {0x000A, 0x0A},   // LF
    {0x000B, 0x0B},   // VT
    {0x000C, 0x0C},   // FF
    {0x000D, 0x0D},   // CR
    {0x000E, 0x0E},   // SO
    {0x000F, 0x0F},   // SI
    {0x0010, 0x10},   // DLE
    {0x0011, 0x11},   // DC1
    {0x0012, 0x12},   // DC2
    {0x0013, 0x13},   // DC3
    {0x0014, 0x14},   // DC4
    {0x0015, 0x15},   // NAK
    {0x0016, 0x16},   // SYN
    {0x0017, 0x17},   // ETB
    {0x0018, 0x18},   // CAN
    {0x0019, 0x19},   // EM
    {0x001A, 0x1A},   // SUB
    {0x001B, 0x1B},   // ESC
    {0x001C, 0x1C},   // FS
    {0x001D, 0x1D},   // GS
    {0x001E, 0x1E},   // RS
    {0x001F, 0x1F},   // US
    {0x0020, 0x20},   // Space
    {0x0021, 0x21},   // !
    {0x0022, 0x22},   // "
    {0x0023, 0x23},   // #
    {0x0024, 0x24},   // $
    {0x0025, 0x25},   // %
    {0x0026, 0x26},   // &
    {0x0027, 0x27},   // '
    {0x0028, 0x28},   // (
    {0x0029, 0x29},   // )
    {0x002A, 0x2A},   // *
    {0x002B, 0x2B},   // +
    {0x002C, 0x2C},   // ,
    {0x002D, 0x2D},   // -
    {0x002E, 0x2E},   // .
    {0x002F, 0x2F},   // /
    {0x0030, 0x30},   // 0
    {0x0031, 0x31},   // 1
    {0x0032, 0x32},   // 2
    {0x0033, 0x33},   // 3
    {0x0034, 0x34},   // 4
    {0x0035, 0x35},   // 5
    {0x0036, 0x36},   // 6
    {0x0037, 0x37},   // 7
    {0x0038, 0x38},   // 8
    {0x0039, 0x39},   // 9
    {0x003A, 0x3A},   // :
    {0x003B, 0x3B},   // ;
    {0x003C, 0x3C},   // <
    {0x003D, 0x3D},   // =
    {0x003E, 0x3E},   // >
    {0x003F, 0x3F},   // ?
    {0x0040, 0x40},   // @
    {0x0041, 0x41},   // A
    {0x0042, 0x42},   // B
    {0x0043, 0x43},   // C
    {0x0044, 0x44},   // D
    {0x0045, 0x45},   // E
    {0x0046, 0x46},   // F
    {0x0047, 0x47},   // G
    {0x0048, 0x48},   // H
    {0x0049, 0x49},   // I
    {0x004A, 0x4A},   // J
    {0x004B, 0x4B},   // K
    {0x004C, 0x4C},   // L
    {0x004D, 0x4D},   // M
    {0x004E, 0x4E},   // N
    {0x004F, 0x4F},   // O
    {0x0050, 0x50},   // P
    {0x0051, 0x51},   // Q
    {0x0052, 0x52},   // R
    {0x0053, 0x53},   // S
    {0x0054, 0x54},   // T
    {0x0055, 0x55},   // U
    {0x0056, 0x56},   // V
    {0x0057, 0x57},   // W
    {0x0058, 0x58},   // X
    {0x0059, 0x59},   // Y
    {0x005A, 0x5A},   // Z
    {0x005B, 0x5B},   // [
    {0x005C, 0x5C},   // slash
    {0x005D, 0x5D},   // ]
    {0x005E, 0x5E},   // ^
    {0x005F, 0x5F},   // _
    {0x0060, 0x60},   // `
    {0x0061, 0x61},   // a
    {0x0062, 0x62},   // b
    {0x0063, 0x63},   // c
    {0x0064, 0x64},   // d
    {0x0065, 0x65},   // e
    {0x0066, 0x66},   // f
    {0x0067, 0x67},   // g
    {0x0068, 0x68},   // h
    {0x0069, 0x69},   // i
    {0x006A, 0x6A},   // j
    {0x006B, 0x6B},   // k
    {0x006C, 0x6C},   // l
    {0x006D, 0x6D},   // m
    {0x006E, 0x6E},   // n
    {0x006F, 0x6F},   // o
    {0x0070, 0x70},   // p
    {0x0071, 0x71},   // q
    {0x0072, 0x72},   // r
    {0x0073, 0x73},   // s
    {0x0074, 0x74},   // t
    {0x0075, 0x75},   // u
    {0x0076, 0x76},   // v
    {0x0077, 0x77},   // w
    {0x0078, 0x78},   // x
    {0x0079, 0x79},   // y
    {0x007A, 0x7A},   // z
    {0x007B, 0x7B},   // {
    {0x007C, 0x7C},   // |
    {0x007D, 0x7D},   // }
    {0x007E, 0x7E},   // ~
    {0x007F, 0x7F},   // DEL
    {0x0410, 0x80},   // А
    {0x0411, 0x81},   // Б
    {0x0412, 0x82},   // В
    {0x0413, 0x83},   // Г
    {0x0414, 0x84},   // Д
    {0x0415, 0x85},   // Е
    {0x0416, 0x86},   // Ж
    {0x0417, 0x87},   // З
    {0x0418, 0x88},   // И
    {0x0419, 0x89},   // Й
    {0x041A, 0x8A},   // К
    {0x041B, 0x8B},   // Л
    {0x041C, 0x8C},   // М
    {0x041D, 0x8D},   // Н
    {0x041E, 0x8E},   // О
    {0x041F, 0x8F},   // П
    {0x0420, 0x90},   // Р
    {0x0421, 0x91},   // С
    {0x0422, 0x92},   // Т
    {0x0423, 0x93},   // У
    {0x0424, 0x94},   // Ф
    {0x0425, 0x95},   // Х
    {0x0426, 0x96},   // Ц
    {0x0427, 0x97},   // Ч
    {0x0428, 0x98},   // Ш
    {0x0429, 0x99},   // Щ
    {0x042A, 0x9A},   // Ъ
    {0x042B, 0x9B},   // Ы
    {0x042C, 0x9C},   // Ь
    {0x042D, 0x9D},   // Э
    {0x042E, 0x9E},   // Ю
    {0x042F, 0x9F},   // Я
    {0x0430, 0xA0},   // а
    {0x0431, 0xA1},   // б
    {0x0432, 0xA2},   // в
    {0x0433, 0xA3},   // г
    {0x0434, 0xA4},   // д
    {0x0435, 0xA5},   // е
    {0x0436, 0xA6},   // ж
    {0x0437, 0xA7},   // з
    {0x0438, 0xA8},   // и
    {0x0439, 0xA9},   // й
    {0x043A, 0xAA},   // к
    {0x043B, 0xAB},   // л
    {0x043C, 0xAC},   // м
    {0x043D, 0xAD},   // н
    {0x043E, 0xAE},   // о
    {0x043F, 0xAF},   // п
    {0x2591, 0xB0},   // ░
    {0x2592, 0xB1},   // ▒
    {0x2593, 0xB2},   // ▓
    {0x2502, 0xB3},   // │
    {0x2524, 0xB4},   // ┤
    {0x2561, 0xB5},   // ╡
    {0x2562, 0xB6},   // ╢
    {0x2556, 0xB7},   // ╖
    {0x2555, 0xB8},   // ╕
    {0x2563, 0xB9},   // ╣
    {0x2551, 0xBA},   // ║
    {0x2557, 0xBB},   // ╗
    {0x255D, 0xBC},   // ╝
    {0x255C, 0xBD},   // ╜
    {0x255B, 0xBE},   // ╛
    {0x2510, 0xBF},   // ┐
    {0x2514, 0xC0},   // └
    {0x2534, 0xC1},   // ┴
    {0x252C, 0xC2},   // ┬
    {0x251C, 0xC3},   // ├
    {0x2500, 0xC4},   // ─
    {0x253C, 0xC5},   // ┼
    {0x255E, 0xC6},   // ╞
    {0x255F, 0xC7},   // ╟
    {0x255A, 0xC8},   // ╚
    {0x2554, 0xC9},   // ╔
    {0x2569, 0xCA},   // ╩
    {0x2566, 0xCB},   // ╦
    {0x2560, 0xCC},   // ╠
    {0x2550, 0xCD},   // ═
    {0x256C, 0xCE},   // ╬
    {0x2567, 0xCF},   // ╧
    {0x2568, 0xD0},   // ╨
    {0x2564, 0xD1},   // ╤
    {0x2565, 0xD2},   // ╥
    {0x2559, 0xD3},   // ╙
    {0x2558, 0xD4},   // ╘
    {0x2552, 0xD5},   // ╒
    {0x2553, 0xD6},   // ╓
    {0x256B, 0xD7},   // ╫
    {0x256A, 0xD8},   // ╪
    {0x2518, 0xD9},   // ┘
    {0x250C, 0xDA},   // ┌
    {0x2588, 0xDB},   // █
    {0x2584, 0xDC},   // ▄
    {0x258C, 0xDD},   // ▌
    {0x2590, 0xDE},   // ▐
    {0x2580, 0xDF},   // ▀
    {0x0440, 0xE0},   // р
    {0x0441, 0xE1},   // с
    {0x0442, 0xE2},   // т
    {0x0443, 0xE3},   // у
    {0x0444, 0xE4},   // ф
    {0x0445, 0xE5},   // х
    {0x0446, 0xE6},   // ц
    {0x0447, 0xE7},   // ч
    {0x0448, 0xE8},   // ш
    {0x0449, 0xE9},   // щ
    {0x044A, 0xEA},   // ъ
    {0x044B, 0xEB},   // ы
    {0x044C, 0xEC},   // ь
    {0x044D, 0xED},   // э
    {0x044E, 0xEE},   // ю
    {0x044F, 0xEF},   // я
    {0x0401, 0xF0},   // Ё
    {0x0451, 0xF1},   // ё
    {0x0404, 0xF2},   // Є
    {0x0454, 0xF3},   // є
    {0x0407, 0xF4},   // Ї
    {0x0457, 0xF5},   // ї
    {0x040E, 0xF6},   // Ў
    {0x045E, 0xF7},   // ў
    {0x00B0, 0xF8},   // °
    {0x2219, 0xF9},   // ∙
    {0x00B7, 0xFA},   // ·
    {0x221A, 0xFB},   // √
    {0x2116, 0xFC},   // №
    {0x00A4, 0xFD},   // ¤
    {0x25A0, 0xFE},   // ■
    {0x00A0, 0xFF}    // NBSP
};
*/


std::map<UTF16TEXT, char> create_UTF16_to_CP866()
{

  std::map<UTF16TEXT, char> UTF16_to_CP866;
    // Заполнение map оператором []
    UTF16_to_CP866[0x0000] = 0x00;   // NUL
    UTF16_to_CP866[0x0001] = 0x01;   // SOH
    UTF16_to_CP866[0x0002] = 0x02;   // STX
    UTF16_to_CP866[0x0003] = 0x03;   // ETX
    UTF16_to_CP866[0x0004] = 0x04;   // EOT
    UTF16_to_CP866[0x0005] = 0x05;   // ENQ
    UTF16_to_CP866[0x0006] = 0x06;   // ACK
    UTF16_to_CP866[0x0007] = 0x07;   // BEL
    UTF16_to_CP866[0x0008] = 0x08;   // BS
    UTF16_to_CP866[0x0009] = 0x09;   // TAB
    UTF16_to_CP866[0x000A] = 0x0A;   // LF
    UTF16_to_CP866[0x000B] = 0x0B;   // VT
    UTF16_to_CP866[0x000C] = 0x0C;   // FF
    UTF16_to_CP866[0x000D] = 0x0D;   // CR
    UTF16_to_CP866[0x000E] = 0x0E;   // SO
    UTF16_to_CP866[0x000F] = 0x0F;   // SI
    UTF16_to_CP866[0x0010] = 0x10;   // DLE
    UTF16_to_CP866[0x0011] = 0x11;   // DC1
    UTF16_to_CP866[0x0012] = 0x12;   // DC2
    UTF16_to_CP866[0x0013] = 0x13;   // DC3
    UTF16_to_CP866[0x0014] = 0x14;   // DC4
    UTF16_to_CP866[0x0015] = 0x15;   // NAK
    UTF16_to_CP866[0x0016] = 0x16;   // SYN
    UTF16_to_CP866[0x0017] = 0x17;   // ETB
    UTF16_to_CP866[0x0018] = 0x18;   // CAN
    UTF16_to_CP866[0x0019] = 0x19;   // EM
    UTF16_to_CP866[0x001A] = 0x1A;   // SUB
    UTF16_to_CP866[0x001B] = 0x1B;   // ESC
    UTF16_to_CP866[0x001C] = 0x1C;   // FS
    UTF16_to_CP866[0x001D] = 0x1D;   // GS
    UTF16_to_CP866[0x001E] = 0x1E;   // RS
    UTF16_to_CP866[0x001F] = 0x1F;   // US
    UTF16_to_CP866[0x0020] = 0x20;   // Space
    UTF16_to_CP866[0x0021] = 0x21;   // !
    UTF16_to_CP866[0x0022] = 0x22;   // "
    UTF16_to_CP866[0x0023] = 0x23;   // #
    UTF16_to_CP866[0x0024] = 0x24;   // $
    UTF16_to_CP866[0x0025] = 0x25;   // %
    UTF16_to_CP866[0x0026] = 0x26;   // &
    UTF16_to_CP866[0x0027] = 0x27;   // '
    UTF16_to_CP866[0x0028] = 0x28;   // (
    UTF16_to_CP866[0x0029] = 0x29;   // )
    UTF16_to_CP866[0x002A] = 0x2A;   // *
    UTF16_to_CP866[0x002B] = 0x2B;   // +
    UTF16_to_CP866[0x002C] = 0x2C;   // ,
    UTF16_to_CP866[0x002D] = 0x2D;   // -
    UTF16_to_CP866[0x002E] = 0x2E;   // .
    UTF16_to_CP866[0x002F] = 0x2F;   // /
    UTF16_to_CP866[0x0030] = 0x30;   // 0
    UTF16_to_CP866[0x0031] = 0x31;   // 1
    UTF16_to_CP866[0x0032] = 0x32;   // 2
    UTF16_to_CP866[0x0033] = 0x33;   // 3
    UTF16_to_CP866[0x0034] = 0x34;   // 4
    UTF16_to_CP866[0x0035] = 0x35;   // 5
    UTF16_to_CP866[0x0036] = 0x36;   // 6
    UTF16_to_CP866[0x0037] = 0x37;   // 7
    UTF16_to_CP866[0x0038] = 0x38;   // 8
    UTF16_to_CP866[0x0039] = 0x39;   // 9
    UTF16_to_CP866[0x003A] = 0x3A;   // :
    UTF16_to_CP866[0x003B] = 0x3B;   // ;
    UTF16_to_CP866[0x003C] = 0x3C;   // <
    UTF16_to_CP866[0x003D] = 0x3D;   // =
    UTF16_to_CP866[0x003E] = 0x3E;   // >
    UTF16_to_CP866[0x003F] = 0x3F;   // ?
    UTF16_to_CP866[0x0040] = 0x40;   // @
    UTF16_to_CP866[0x0041] = 0x41;   // A
    UTF16_to_CP866[0x0042] = 0x42;   // B
    UTF16_to_CP866[0x0043] = 0x43;   // C
    UTF16_to_CP866[0x0044] = 0x44;   // D
    UTF16_to_CP866[0x0045] = 0x45;   // E
    UTF16_to_CP866[0x0046] = 0x46;   // F
    UTF16_to_CP866[0x0047] = 0x47;   // G
    UTF16_to_CP866[0x0048] = 0x48;   // H
    UTF16_to_CP866[0x0049] = 0x49;   // I
    UTF16_to_CP866[0x004A] = 0x4A;   // J
    UTF16_to_CP866[0x004B] = 0x4B;   // K
    UTF16_to_CP866[0x004C] = 0x4C;   // L
    UTF16_to_CP866[0x004D] = 0x4D;   // M
    UTF16_to_CP866[0x004E] = 0x4E;   // N
    UTF16_to_CP866[0x004F] = 0x4F;   // O
    UTF16_to_CP866[0x0050] = 0x50;   // P
    UTF16_to_CP866[0x0051] = 0x51;   // Q
    UTF16_to_CP866[0x0052] = 0x52;   // R
    UTF16_to_CP866[0x0053] = 0x53;   // S
    UTF16_to_CP866[0x0054] = 0x54;   // T
    UTF16_to_CP866[0x0055] = 0x55;   // U
    UTF16_to_CP866[0x0056] = 0x56;   // V
    UTF16_to_CP866[0x0057] = 0x57;   // W
    UTF16_to_CP866[0x0058] = 0x58;   // X
    UTF16_to_CP866[0x0059] = 0x59;   // Y
    UTF16_to_CP866[0x005A] = 0x5A;   // Z
    UTF16_to_CP866[0x005B] = 0x5B;   // [
    UTF16_to_CP866[0x005C] = 0x5C;   // slash
    UTF16_to_CP866[0x005D] = 0x5D;   // ]
    UTF16_to_CP866[0x005E] = 0x5E;   // ^
    UTF16_to_CP866[0x005F] = 0x5F;   // _
    UTF16_to_CP866[0x0060] = 0x60;   // `
    UTF16_to_CP866[0x0061] = 0x61;   // a
    UTF16_to_CP866[0x0062] = 0x62;   // b
    UTF16_to_CP866[0x0063] = 0x63;   // c
    UTF16_to_CP866[0x0064] = 0x64;   // d
    UTF16_to_CP866[0x0065] = 0x65;   // e
    UTF16_to_CP866[0x0066] = 0x66;   // f
    UTF16_to_CP866[0x0067] = 0x67;   // g
    UTF16_to_CP866[0x0068] = 0x68;   // h
    UTF16_to_CP866[0x0069] = 0x69;   // i
    UTF16_to_CP866[0x006A] = 0x6A;   // j
    UTF16_to_CP866[0x006B] = 0x6B;   // k
    UTF16_to_CP866[0x006C] = 0x6C;   // l
    UTF16_to_CP866[0x006D] = 0x6D;   // m
    UTF16_to_CP866[0x006E] = 0x6E;   // n
    UTF16_to_CP866[0x006F] = 0x6F;   // o
    UTF16_to_CP866[0x0070] = 0x70;   // p
    UTF16_to_CP866[0x0071] = 0x71;   // q
    UTF16_to_CP866[0x0072] = 0x72;   // r
    UTF16_to_CP866[0x0073] = 0x73;   // s
    UTF16_to_CP866[0x0074] = 0x74;   // t
    UTF16_to_CP866[0x0075] = 0x75;   // u
    UTF16_to_CP866[0x0076] = 0x76;   // v
    UTF16_to_CP866[0x0077] = 0x77;   // w
    UTF16_to_CP866[0x0078] = 0x78;   // x
    UTF16_to_CP866[0x0079] = 0x79;   // y
    UTF16_to_CP866[0x007A] = 0x7A;   // z
    UTF16_to_CP866[0x007B] = 0x7B;   // {
    UTF16_to_CP866[0x007C] = 0x7C;   // |
    UTF16_to_CP866[0x007D] = 0x7D;   // }
    UTF16_to_CP866[0x007E] = 0x7E;   // ~
    UTF16_to_CP866[0x007F] = 0x7F;   // DEL
    UTF16_to_CP866[0x0410] = 0x80;   // А
    UTF16_to_CP866[0x0411] = 0x81;   // Б
    UTF16_to_CP866[0x0412] = 0x82;   // В
    UTF16_to_CP866[0x0413] = 0x83;   // Г
    UTF16_to_CP866[0x0414] = 0x84;   // Д
    UTF16_to_CP866[0x0415] = 0x85;   // Е
    UTF16_to_CP866[0x0416] = 0x86;   // Ж
    UTF16_to_CP866[0x0417] = 0x87;   // З
    UTF16_to_CP866[0x0418] = 0x88;   // И
    UTF16_to_CP866[0x0419] = 0x89;   // Й
    UTF16_to_CP866[0x041A] = 0x8A;   // К
    UTF16_to_CP866[0x041B] = 0x8B;   // Л
    UTF16_to_CP866[0x041C] = 0x8C;   // М
    UTF16_to_CP866[0x041D] = 0x8D;   // Н
    UTF16_to_CP866[0x041E] = 0x8E;   // О
    UTF16_to_CP866[0x041F] = 0x8F;   // П
    UTF16_to_CP866[0x0420] = 0x90;   // Р
    UTF16_to_CP866[0x0421] = 0x91;   // С
    UTF16_to_CP866[0x0422] = 0x92;   // Т
    UTF16_to_CP866[0x0423] = 0x93;   // У
    UTF16_to_CP866[0x0424] = 0x94;   // Ф
    UTF16_to_CP866[0x0425] = 0x95;   // Х
    UTF16_to_CP866[0x0426] = 0x96;   // Ц
    UTF16_to_CP866[0x0427] = 0x97;   // Ч
    UTF16_to_CP866[0x0428] = 0x98;   // Ш
    UTF16_to_CP866[0x0429] = 0x99;   // Щ
    UTF16_to_CP866[0x042A] = 0x9A;   // Ъ
    UTF16_to_CP866[0x042B] = 0x9B;   // Ы
    UTF16_to_CP866[0x042C] = 0x9C;   // Ь
    UTF16_to_CP866[0x042D] = 0x9D;   // Э
    UTF16_to_CP866[0x042E] = 0x9E;   // Ю
    UTF16_to_CP866[0x042F] = 0x9F;   // Я
    UTF16_to_CP866[0x0430] = 0xA0;   // а
    UTF16_to_CP866[0x0431] = 0xA1;   // б
    UTF16_to_CP866[0x0432] = 0xA2;   // в
    UTF16_to_CP866[0x0433] = 0xA3;   // г
    UTF16_to_CP866[0x0434] = 0xA4;   // д
    UTF16_to_CP866[0x0435] = 0xA5;   // е
    UTF16_to_CP866[0x0436] = 0xA6;   // ж
    UTF16_to_CP866[0x0437] = 0xA7;   // з
    UTF16_to_CP866[0x0438] = 0xA8;   // и
    UTF16_to_CP866[0x0439] = 0xA9;   // й
    UTF16_to_CP866[0x043A] = 0xAA;   // к
    UTF16_to_CP866[0x043B] = 0xAB;   // л
    UTF16_to_CP866[0x043C] = 0xAC;   // м
    UTF16_to_CP866[0x043D] = 0xAD;   // н
    UTF16_to_CP866[0x043E] = 0xAE;   // о
    UTF16_to_CP866[0x043F] = 0xAF;   // п
    UTF16_to_CP866[0x2591] = 0xB0;   // ░
    UTF16_to_CP866[0x2592] = 0xB1;   // ▒
    UTF16_to_CP866[0x2593] = 0xB2;   // ▓
    UTF16_to_CP866[0x2502] = 0xB3;   // │
    UTF16_to_CP866[0x2524] = 0xB4;   // ┤
    UTF16_to_CP866[0x2561] = 0xB5;   // ╡
    UTF16_to_CP866[0x2562] = 0xB6;   // ╢
    UTF16_to_CP866[0x2556] = 0xB7;   // ╖
    UTF16_to_CP866[0x2555] = 0xB8;   // ╕
    UTF16_to_CP866[0x2563] = 0xB9;   // ╣
    UTF16_to_CP866[0x2551] = 0xBA;   // ║
    UTF16_to_CP866[0x2557] = 0xBB;   // ╗
    UTF16_to_CP866[0x255D] = 0xBC;   // ╝
    UTF16_to_CP866[0x255C] = 0xBD;   // ╜
    UTF16_to_CP866[0x255B] = 0xBE;   // ╛
    UTF16_to_CP866[0x2510] = 0xBF;   // ┐
    UTF16_to_CP866[0x2514] = 0xC0;   // └
    UTF16_to_CP866[0x2534] = 0xC1;   // ┴
    UTF16_to_CP866[0x252C] = 0xC2;   // ┬
    UTF16_to_CP866[0x251C] = 0xC3;   // ├
    UTF16_to_CP866[0x2500] = 0xC4;   // ─
    UTF16_to_CP866[0x253C] = 0xC5;   // ┼
    UTF16_to_CP866[0x255E] = 0xC6;   // ╞
    UTF16_to_CP866[0x255F] = 0xC7;   // ╟
    UTF16_to_CP866[0x255A] = 0xC8;   // ╚
    UTF16_to_CP866[0x2554] = 0xC9;   // ╔
    UTF16_to_CP866[0x2569] = 0xCA;   // ╩
    UTF16_to_CP866[0x2566] = 0xCB;   // ╦
    UTF16_to_CP866[0x2560] = 0xCC;   // ╠
    UTF16_to_CP866[0x2550] = 0xCD;   // ═
    UTF16_to_CP866[0x256C] = 0xCE;   // ╬
    UTF16_to_CP866[0x2567] = 0xCF;   // ╧
    UTF16_to_CP866[0x2568] = 0xD0;   // ╨
    UTF16_to_CP866[0x2564] = 0xD1;   // ╤
    UTF16_to_CP866[0x2565] = 0xD2;   // ╥
    UTF16_to_CP866[0x2559] = 0xD3;   // ╙
    UTF16_to_CP866[0x2558] = 0xD4;   // ╘
    UTF16_to_CP866[0x2552] = 0xD5;   // ╒
    UTF16_to_CP866[0x2553] = 0xD6;   // ╓
    UTF16_to_CP866[0x256B] = 0xD7;   // ╫
    UTF16_to_CP866[0x256A] = 0xD8;   // ╪
    UTF16_to_CP866[0x2518] = 0xD9;   // ┘
    UTF16_to_CP866[0x250C] = 0xDA;   // ┌
    UTF16_to_CP866[0x2588] = 0xDB;   // █
    UTF16_to_CP866[0x2584] = 0xDC;   // ▄
    UTF16_to_CP866[0x258C] = 0xDD;   // ▌
    UTF16_to_CP866[0x2590] = 0xDE;   // ▐
    UTF16_to_CP866[0x2580] = 0xDF;   // ▀
    UTF16_to_CP866[0x0440] = 0xE0;   // р
    UTF16_to_CP866[0x0441] = 0xE1;   // с
    UTF16_to_CP866[0x0442] = 0xE2;   // т
    UTF16_to_CP866[0x0443] = 0xE3;   // у
    UTF16_to_CP866[0x0444] = 0xE4;   // ф
    UTF16_to_CP866[0x0445] = 0xE5;   // х
    UTF16_to_CP866[0x0446] = 0xE6;   // ц
    UTF16_to_CP866[0x0447] = 0xE7;   // ч
    UTF16_to_CP866[0x0448] = 0xE8;   // ш
    UTF16_to_CP866[0x0449] = 0xE9;   // щ
    UTF16_to_CP866[0x044A] = 0xEA;   // ъ
    UTF16_to_CP866[0x044B] = 0xEB;   // ы
    UTF16_to_CP866[0x044C] = 0xEC;   // ь
    UTF16_to_CP866[0x044D] = 0xED;   // э
    UTF16_to_CP866[0x044E] = 0xEE;   // ю
    UTF16_to_CP866[0x044F] = 0xEF;   // я
    UTF16_to_CP866[0x0401] = 0xF0;   // Ё
    UTF16_to_CP866[0x0451] = 0xF1;   // ё
    UTF16_to_CP866[0x0404] = 0xF2;   // Є
    UTF16_to_CP866[0x0454] = 0xF3;   // є
    UTF16_to_CP866[0x0407] = 0xF4;   // Ї
    UTF16_to_CP866[0x0457] = 0xF5;   // ї
    UTF16_to_CP866[0x040E] = 0xF6;   // Ў
    UTF16_to_CP866[0x045E] = 0xF7;   // ў
    UTF16_to_CP866[0x00B0] = 0xF8;   // °
    UTF16_to_CP866[0x2219] = 0xF9;   // ∙
    UTF16_to_CP866[0x00B7] = 0xFA;   // ·
    UTF16_to_CP866[0x221A] = 0xFB;   // √
    UTF16_to_CP866[0x2116] = 0xFC;   // №
    UTF16_to_CP866[0x00A4] = 0xFD;   // ¤
    UTF16_to_CP866[0x25A0] = 0xFE;   // ■
    UTF16_to_CP866[0x00A0] = 0xFF;   //

    // Вывод содержимого map
    //for (const auto& pair : UTF16_to_CP866) {
    //    std::cout << std::hex << pair.first << ": " << std::hex << static_cast<int>(pair.second) << std::endl;
    //}

    return UTF16_to_CP866;
}


std::map<UTF16TEXT, char> UTF16_to_CP866 = create_UTF16_to_CP866();

//портится верхняя часть таблицы?
char* CTextConverter::ConvertFromUTF16ToCP866(const UTF16TEXT* utf16Text)
{
  size_t len = 0;
  const UTF16TEXT* p = utf16Text;

  while (*p++)
        {
         ++len;
        }

  std::string s;

  for (int i = 0; i < len; i++)
      {
       UTF16TEXT uc = utf16Text[i];
       char c;

      c = UTF16_to_CP866 [uc];

       s += c;
      }

  char *result = new char[s.length() + 1];


 // std::cout << s << std::endl;

  std::strncpy (result, s.c_str(), s.size());

  result[len] = '\0';

 // std::cout << result << std::endl;


  return result;
}




std::string ConvertUTF16ToUTF8(const UTF16TEXT* utf16_text)
{
    std::string utf8_text;

    // Итерируемся по массиву UTF-16 до тех пор, пока не достигнем нулевого символа
    //for (int i = 0; utf16_text[i] != u'\0'; ++i) {
      for (int i = 0; utf16_text[i] != '\0'; ++i) {

        UTF16TEXT unicode_value = utf16_text[i];

        // Если символ меньше или равен 0x7F, он в кодировке ASCII и представляется в UTF-8 одним байтом
        if (unicode_value <= 0x7F) {
            utf8_text.push_back(static_cast<char>(unicode_value));
        } else if (unicode_value <= 0x7FF) {
            // Если символ в диапазоне 0x80 - 0x7FF, он представляется в UTF-8 двумя байтами
            utf8_text.push_back(static_cast<char>(0xC0 | (unicode_value >> 6))); // Первый байт
            utf8_text.push_back(static_cast<char>(0x80 | (unicode_value & 0x3F))); // Второй байт
        } else {
            // В противном случае символ представляется в UTF-8 тремя байтами
            utf8_text.push_back(static_cast<char>(0xE0 | (unicode_value >> 12))); // Первый байт
            utf8_text.push_back(static_cast<char>(0x80 | ((unicode_value >> 6) & 0x3F))); // Второй байт
            utf8_text.push_back(static_cast<char>(0x80 | (unicode_value & 0x3F))); // Третий байт
        }
    }

    return utf8_text;
}
