/* gui.c generated by valac 0.34.7, the Vala compiler
 * generated from gui.vala, do not modify */

/*
 *    Copyright (C) 1999, 2000,
 *    Dirk-Jan C. Binnema <djcb@dds.nl>,
 *    Arjan Scherpenisse <acscherp@wins.uva.nl>
 *    Copyright (C) 2016 Colin Watson <cjwatson@debian.org>
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* The main user interface. */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TG_TYPE_INPUT_STATUS (tg_input_status_get_type ())

#define TG_TYPE_GUI (tg_gui_get_type ())
#define TG_GUI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_GUI, TgGui))
#define TG_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_GUI, TgGuiClass))
#define TG_IS_GUI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_GUI))
#define TG_IS_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_GUI))
#define TG_GUI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_GUI, TgGuiClass))

typedef struct _TgGui TgGui;
typedef struct _TgGuiClass TgGuiClass;
typedef struct _TgGuiPrivate TgGuiPrivate;

#define TG_TYPE_CHANNEL (tg_channel_get_type ())
#define TG_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_CHANNEL, TgChannel))
#define TG_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_CHANNEL, TgChannelClass))
#define TG_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_CHANNEL))
#define TG_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_CHANNEL))
#define TG_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_CHANNEL, TgChannelClass))

typedef struct _TgChannel TgChannel;
typedef struct _TgChannelClass TgChannelClass;

#define TG_TYPE_PIXPACK (tg_pixpack_get_type ())
#define TG_PIXPACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_PIXPACK, TgPixpack))
#define TG_PIXPACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_PIXPACK, TgPixpackClass))
#define TG_IS_PIXPACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_PIXPACK))
#define TG_IS_PIXPACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_PIXPACK))
#define TG_PIXPACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_PIXPACK, TgPixpackClass))

typedef struct _TgPixpack TgPixpack;
typedef struct _TgPixpackClass TgPixpackClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define TG_TYPE_PREFS (tg_prefs_get_type ())
#define TG_PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_PREFS, TgPrefs))
#define TG_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_PREFS, TgPrefsClass))
#define TG_IS_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_PREFS))
#define TG_IS_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_PREFS))
#define TG_PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_PREFS, TgPrefsClass))

typedef struct _TgPrefs TgPrefs;
typedef struct _TgPrefsClass TgPrefsClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	TG_INPUT_STATUS_NEW,
	TG_INPUT_STATUS_CONTINUED
} TgInputStatus;

struct _TgGui {
	GObject parent_instance;
	TgGuiPrivate * priv;
};

struct _TgGuiClass {
	GObjectClass parent_class;
};

struct _TgGuiPrivate {
	gchar** _channel_children;
	gint _channel_children_length1;
	gint __channel_children_size_;
	gchar* _current_channel_uuid;
	gint _zoom_factor;
	gboolean _paging_enabled;
	gint _paging_interval;
	gint _page_number;
	gint _subpage_number;
	TgChannel* _current_channel;
	GtkBuilder* builder;
	GtkWindow* _window;
	GtkEntry* entry;
	TgPixpack* pixpack;
	GtkProgressBar* progress_bar;
	GtkStatusbar* status_bar;
	GMenu* channel_menu;
	GSettings* settings;
	guint* logo_timer_id;
	guint* kb_timer_id;
	TgInputStatus kb_status;
	guint* page_timer_id;
	gint page_progress;
	GSList* channels;
};

typedef enum  {
	TG_HTTP_ERROR_PIXBUF,
	TG_HTTP_ERROR_VFS,
	TG_HTTP_ERROR_HTTPQUERY
} TgHttpError;
#define TG_HTTP_ERROR tg_http_error_quark ()

static gpointer tg_gui_parent_class = NULL;

#define TG_notfound_pixmap "/org/gnome/telegnome/pixmaps/testbeeld.png"
#define TG_logo_pixmap "/org/gnome/telegnome/pixmaps/telegnome-logo.png"
#define TG_main_ui "/org/gnome/telegnome/telegnome.ui"
#define TG_kb_timeout 2500
#define TG_logo_timeout 7500
GType tg_input_status_get_type (void) G_GNUC_CONST;
GType tg_gui_get_type (void) G_GNUC_CONST;
GType tg_channel_get_type (void) G_GNUC_CONST;
GType tg_pixpack_get_type (void) G_GNUC_CONST;
#define TG_GUI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TG_TYPE_GUI, TgGuiPrivate))
enum  {
	TG_GUI_DUMMY_PROPERTY,
	TG_GUI_CHANNEL_CHILDREN,
	TG_GUI_CURRENT_CHANNEL_UUID,
	TG_GUI_ZOOM_FACTOR,
	TG_GUI_PAGING_ENABLED,
	TG_GUI_PAGING_INTERVAL,
	TG_GUI_PAGE_NUMBER,
	TG_GUI_SUBPAGE_NUMBER,
	TG_GUI_CURRENT_CHANNEL,
	TG_GUI_WINDOW
};
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
TgGui* tg_gui_new (GtkApplication* app, GSettings* settings);
TgGui* tg_gui_construct (GType object_type, GtkApplication* app, GSettings* settings);
static void tg_gui_set_window (TgGui* self, GtkWindow* value);
GtkWindow* tg_gui_get_window (TgGui* self);
static gboolean __lambda4_ (TgGui* self, GdkEventKey* event);
static gboolean tg_gui_on_keypress (TgGui* self, GdkEventKey* event);
static gboolean ___lambda4__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void __lambda5_ (TgGui* self);
static void tg_gui_on_goto_page (TgGui* self);
static void ___lambda5__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda6_ (TgGui* self);
static void ___lambda6__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda7_ (TgGui* self);
static void tg_gui_on_prev_page (TgGui* self);
static void ___lambda7__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda8_ (TgGui* self);
static void tg_gui_on_next_page (TgGui* self);
static void ___lambda8__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda9_ (TgGui* self);
static void tg_gui_on_home (TgGui* self);
static void ___lambda9__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda10_ (TgGui* self);
static void tg_gui_on_toggle_paging (TgGui* self);
static void ___lambda10__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void tg_gui_refresh_channel_menu (TgGui* self);
static TgChannel* tg_gui_channel_find_by_uuid (TgGui* self, const gchar* uuid);
const gchar* tg_gui_get_current_channel_uuid (TgGui* self);
static void tg_gui_update_title_bar (TgGui* self);
static void tg_gui_update_entry (TgGui* self, gint page_nr, gint subpage_nr);
void tg_pixpack_load_image_from_resource (TgPixpack* self, const gchar* resource_path);
gint tg_gui_get_page_number (TgGui* self);
static gboolean tg_gui_logo_timer (TgGui* self);
static gboolean _tg_gui_logo_timer_gsource_func (gpointer self);
static guint* _uint_dup (guint* self);
TgChannel* tg_gui_get_current_channel (TgGui* self);
const gchar* tg_channel_get_name (TgChannel* self);
const gchar* tg_channel_get_description (TgChannel* self);
static void tg_gui_get_the_page (TgGui* self);
const gchar* tg_channel_get_uuid (TgChannel* self);
static void tg_gui_channel_select (TgGui* self, TgChannel* channel);
void tg_gui_change_state_set_channel (TgGui* self, GSimpleAction* action, GVariant* value);
void tg_gui_set_current_channel_uuid (TgGui* self, const gchar* value);
void tg_gui_set_page_number (TgGui* self, gint value);
void tg_gui_set_subpage_number (TgGui* self, gint value);
static void tg_gui_populate_channel_menu (TgGui* self);
static gchar* tg_gui_get_default_channel_value (TgGui* self, GKeyFile* file, const gchar* group, const gchar* key, gboolean missing_ok);
static void tg_gui_reload_channels (TgGui* self);
gchar** tg_gui_get_channel_children (TgGui* self, int* result_length1);
TgChannel* tg_channel_new (const gchar* uuid);
TgChannel* tg_channel_construct (GType object_type, const gchar* uuid);
TgChannel* tg_channel_new_with_parameters (const gchar* name, const gchar* description, const gchar* page_url, const gchar* subpage_url, const gchar* country);
TgChannel* tg_channel_construct_with_parameters (GType object_type, const gchar* name, const gchar* description, const gchar* page_url, const gchar* subpage_url, const gchar* country);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void tg_gui_print_in_statusbar (TgGui* self, const gchar* status);
static gboolean tg_gui_pager_timer (TgGui* self);
gint tg_gui_get_paging_interval (TgGui* self);
gboolean tg_gui_get_paging_enabled (TgGui* self);
void tg_gui_set_paging_enabled (TgGui* self, gboolean value);
static gboolean _tg_gui_pager_timer_gsource_func (gpointer self);
static void tg_gui_update_page (TgGui* self);
gint tg_gui_get_subpage_number (TgGui* self);
GQuark tg_http_error_quark (void);
GdkPixbuf* tg_http_get_image (TgGui* gui, GError** error);
void tg_pixpack_load_image (TgPixpack* self, GdkPixbuf* pixbuf);
void tg_gui_activate_quit (TgGui* self, GSimpleAction* action, GVariant* parameter);
void tg_gui_activate_help_contents (TgGui* self, GSimpleAction* action, GVariant* parameter);
void tg_gui_activate_about (TgGui* self, GSimpleAction* action, GVariant* parameter);
static void tg_gui_refresh_timer (TgGui* self);
void tg_gui_activate_preferences (TgGui* self, GSimpleAction* action, GVariant* parameter);
TgPrefs* tg_prefs_new (TgGui* gui);
TgPrefs* tg_prefs_construct (GType object_type, TgGui* gui);
GType tg_prefs_get_type (void) G_GNUC_CONST;
void tg_prefs_show (TgPrefs* self);
static gint64* _int64_dup (gint64* self);
static gboolean tg_gui_keyboard_timer (TgGui* self);
static gboolean _tg_gui_keyboard_timer_gsource_func (gpointer self);
void tg_gui_set_channel_children (TgGui* self, gchar** value, int value_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
gint tg_gui_get_zoom_factor (TgGui* self);
void tg_gui_set_zoom_factor (TgGui* self, gint value);
void tg_gui_set_paging_interval (TgGui* self, gint value);
static void tg_gui_finalize (GObject* obj);
static void _vala_tg_gui_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tg_gui_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType tg_input_status_get_type (void) {
	static volatile gsize tg_input_status_type_id__volatile = 0;
	if (g_once_init_enter (&tg_input_status_type_id__volatile)) {
		static const GEnumValue values[] = {{TG_INPUT_STATUS_NEW, "TG_INPUT_STATUS_NEW", "new"}, {TG_INPUT_STATUS_CONTINUED, "TG_INPUT_STATUS_CONTINUED", "continued"}, {0, NULL, NULL}};
		GType tg_input_status_type_id;
		tg_input_status_type_id = g_enum_register_static ("TgInputStatus", values);
		g_once_init_leave (&tg_input_status_type_id__volatile, tg_input_status_type_id);
	}
	return tg_input_status_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean __lambda4_ (TgGui* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = tg_gui_on_keypress (self, _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean ___lambda4__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = __lambda4_ ((TgGui*) self, event);
	return result;
}


static void __lambda5_ (TgGui* self) {
	tg_gui_on_goto_page (self);
}


static void ___lambda5__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	__lambda5_ ((TgGui*) self);
}


static void __lambda6_ (TgGui* self) {
	tg_gui_on_goto_page (self);
}


static void ___lambda6__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda6_ ((TgGui*) self);
}


static void __lambda7_ (TgGui* self) {
	tg_gui_on_prev_page (self);
}


static void ___lambda7__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda7_ ((TgGui*) self);
}


static void __lambda8_ (TgGui* self) {
	tg_gui_on_next_page (self);
}


static void ___lambda8__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda8_ ((TgGui*) self);
}


static void __lambda9_ (TgGui* self) {
	tg_gui_on_home (self);
}


static void ___lambda9__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda9_ ((TgGui*) self);
}


static void __lambda10_ (TgGui* self) {
	tg_gui_on_toggle_paging (self);
}


static void ___lambda10__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda10_ ((TgGui*) self);
}


static gboolean _tg_gui_logo_timer_gsource_func (gpointer self) {
	gboolean result;
	result = tg_gui_logo_timer ((TgGui*) self);
	return result;
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


static gpointer __uint_dup0 (gpointer self) {
	return self ? _uint_dup (self) : NULL;
}


TgGui* tg_gui_construct (GType object_type, GtkApplication* app, GSettings* settings) {
	TgGui * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkApplication* _tmp4_ = NULL;
	GtkWindow* _tmp5_ = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkEntry* _tmp8_ = NULL;
	GtkBuilder* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	TgPixpack* _tmp11_ = NULL;
	GtkBuilder* _tmp12_ = NULL;
	GObject* _tmp13_ = NULL;
	GtkProgressBar* _tmp14_ = NULL;
	GtkBuilder* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GtkStatusbar* _tmp17_ = NULL;
	GtkWindow* _tmp18_ = NULL;
	GtkEntry* _tmp19_ = NULL;
	GtkToolButton* goto_button = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	GtkToolButton* _tmp22_ = NULL;
	GtkToolButton* _tmp23_ = NULL;
	GtkToolButton* prev_button = NULL;
	GtkBuilder* _tmp24_ = NULL;
	GObject* _tmp25_ = NULL;
	GtkToolButton* _tmp26_ = NULL;
	GtkToolButton* _tmp27_ = NULL;
	GtkToolButton* next_button = NULL;
	GtkBuilder* _tmp28_ = NULL;
	GObject* _tmp29_ = NULL;
	GtkToolButton* _tmp30_ = NULL;
	GtkToolButton* _tmp31_ = NULL;
	GtkToolButton* home_button = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	GtkToolButton* _tmp34_ = NULL;
	GtkToolButton* _tmp35_ = NULL;
	GtkToggleToolButton* paging_button = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkToggleToolButton* _tmp38_ = NULL;
	GtkToggleToolButton* _tmp39_ = NULL;
	GtkApplication* _tmp40_ = NULL;
	GMenu* _tmp41_ = NULL;
	GMenu* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	GSettings* _tmp44_ = NULL;
	GSettings* _tmp45_ = NULL;
	GSettings* _tmp46_ = NULL;
	GSettings* _tmp47_ = NULL;
	GSettings* _tmp48_ = NULL;
	GSettings* _tmp49_ = NULL;
	GSettings* _tmp50_ = NULL;
	GSettings* _tmp51_ = NULL;
	GtkWindow* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	TgChannel* _tmp55_ = NULL;
	TgPixpack* _tmp56_ = NULL;
	gint _tmp57_ = 0;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (TgGui*) g_object_new (object_type, NULL);
	_tmp0_ = g_type_name (TG_TYPE_PIXPACK);
	_vala_assert (g_strcmp0 (_tmp0_, "") != 0, "typeof (Pixpack).name() != \"\"");
	_tmp1_ = gtk_builder_new_from_resource (TG_main_ui);
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp1_;
	_tmp2_ = self->priv->builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "main_window");
	tg_gui_set_window (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL);
	_tmp4_ = app;
	_tmp5_ = self->priv->_window;
	gtk_application_add_window (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "page_entry");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp7_) : NULL);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp8_;
	_tmp9_ = self->priv->builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "pixpack");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, TG_TYPE_PIXPACK) ? ((TgPixpack*) _tmp10_) : NULL);
	_g_object_unref0 (self->priv->pixpack);
	self->priv->pixpack = _tmp11_;
	_tmp12_ = self->priv->builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "progress_bar");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gtk_progress_bar_get_type ()) ? ((GtkProgressBar*) _tmp13_) : NULL);
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = _tmp14_;
	_tmp15_ = self->priv->builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "status_bar");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_statusbar_get_type ()) ? ((GtkStatusbar*) _tmp16_) : NULL);
	_g_object_unref0 (self->priv->status_bar);
	self->priv->status_bar = _tmp17_;
	_tmp18_ = self->priv->_window;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "key-press-event", (GCallback) ___lambda4__gtk_widget_key_press_event, self, 0);
	_tmp19_ = self->priv->entry;
	g_signal_connect_object (_tmp19_, "activate", (GCallback) ___lambda5__gtk_entry_activate, self, 0);
	_tmp20_ = self->priv->builder;
	_tmp21_ = gtk_builder_get_object (_tmp20_, "goto_button");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp21_) : NULL);
	goto_button = _tmp22_;
	_tmp23_ = goto_button;
	g_signal_connect_object (_tmp23_, "clicked", (GCallback) ___lambda6__gtk_tool_button_clicked, self, 0);
	_tmp24_ = self->priv->builder;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "prev_button");
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp25_) : NULL);
	prev_button = _tmp26_;
	_tmp27_ = prev_button;
	g_signal_connect_object (_tmp27_, "clicked", (GCallback) ___lambda7__gtk_tool_button_clicked, self, 0);
	_tmp28_ = self->priv->builder;
	_tmp29_ = gtk_builder_get_object (_tmp28_, "next_button");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp29_) : NULL);
	next_button = _tmp30_;
	_tmp31_ = next_button;
	g_signal_connect_object (_tmp31_, "clicked", (GCallback) ___lambda8__gtk_tool_button_clicked, self, 0);
	_tmp32_ = self->priv->builder;
	_tmp33_ = gtk_builder_get_object (_tmp32_, "home_button");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp33_) : NULL);
	home_button = _tmp34_;
	_tmp35_ = home_button;
	g_signal_connect_object (_tmp35_, "clicked", (GCallback) ___lambda9__gtk_tool_button_clicked, self, 0);
	_tmp36_ = self->priv->builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "paging_button");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp37_) : NULL);
	paging_button = _tmp38_;
	_tmp39_ = paging_button;
	g_signal_connect_object ((GtkToolButton*) _tmp39_, "clicked", (GCallback) ___lambda10__gtk_tool_button_clicked, self, 0);
	_tmp40_ = app;
	_tmp41_ = gtk_application_get_menu_by_id (_tmp40_, "channels");
	_tmp42_ = _g_object_ref0 (_tmp41_);
	_g_object_unref0 (self->priv->channel_menu);
	self->priv->channel_menu = _tmp42_;
	_tmp43_ = settings;
	_tmp44_ = _g_object_ref0 (_tmp43_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp44_;
	_tmp45_ = settings;
	g_settings_bind (_tmp45_, "channel-children", (GObject*) self, "channel_children", G_SETTINGS_BIND_DEFAULT);
	_tmp46_ = settings;
	g_settings_bind (_tmp46_, "current-channel", (GObject*) self, "current_channel_uuid", G_SETTINGS_BIND_DEFAULT);
	_tmp47_ = settings;
	g_settings_bind (_tmp47_, "zoom-factor", (GObject*) self, "zoom_factor", G_SETTINGS_BIND_DEFAULT);
	_tmp48_ = settings;
	g_settings_bind (_tmp48_, "paging-enabled", (GObject*) self, "paging_enabled", G_SETTINGS_BIND_DEFAULT);
	_tmp49_ = settings;
	g_settings_bind (_tmp49_, "paging-interval", (GObject*) self, "paging_interval", G_SETTINGS_BIND_DEFAULT);
	_tmp50_ = settings;
	g_settings_bind (_tmp50_, "current-page-number", (GObject*) self, "page_number", G_SETTINGS_BIND_DEFAULT);
	_tmp51_ = settings;
	g_settings_bind (_tmp51_, "current-subpage-number", (GObject*) self, "subpage_number", G_SETTINGS_BIND_DEFAULT);
	_tmp52_ = self->priv->_window;
	gtk_widget_show_all ((GtkWidget*) _tmp52_);
	_g_free0 (self->priv->kb_timer_id);
	self->priv->kb_timer_id = NULL;
	self->priv->kb_status = TG_INPUT_STATUS_NEW;
	__g_slist_free__g_object_unref0_0 (self->priv->channels);
	self->priv->channels = NULL;
	tg_gui_refresh_channel_menu (self);
	_tmp53_ = tg_gui_get_current_channel_uuid (self);
	_tmp54_ = _tmp53_;
	_tmp55_ = tg_gui_channel_find_by_uuid (self, _tmp54_);
	_g_object_unref0 (self->priv->_current_channel);
	self->priv->_current_channel = _tmp55_;
	tg_gui_update_title_bar (self);
	tg_gui_update_entry (self, 0, 0);
	_tmp56_ = self->priv->pixpack;
	tg_pixpack_load_image_from_resource (_tmp56_, TG_logo_pixmap);
	_tmp57_ = self->priv->_page_number;
	if (_tmp57_ > 0) {
		guint _tmp58_ = 0U;
		guint* _tmp59_ = NULL;
		_tmp58_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) TG_logo_timeout, _tg_gui_logo_timer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp59_ = __uint_dup0 (&_tmp58_);
		_g_free0 (self->priv->logo_timer_id);
		self->priv->logo_timer_id = _tmp59_;
	} else {
		_g_free0 (self->priv->logo_timer_id);
		self->priv->logo_timer_id = NULL;
	}
	_g_object_unref0 (paging_button);
	_g_object_unref0 (home_button);
	_g_object_unref0 (next_button);
	_g_object_unref0 (prev_button);
	_g_object_unref0 (goto_button);
	return self;
}


TgGui* tg_gui_new (GtkApplication* app, GSettings* settings) {
	return tg_gui_construct (TG_TYPE_GUI, app, settings);
}


static void tg_gui_update_title_bar (TgGui* self) {
	TgChannel* _tmp0_ = NULL;
	TgChannel* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tg_gui_get_current_channel (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gchar* name = NULL;
		TgChannel* _tmp2_ = NULL;
		TgChannel* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* desc = NULL;
		TgChannel* _tmp7_ = NULL;
		TgChannel* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_ = NULL;
		_tmp2_ = tg_gui_get_current_channel (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = tg_channel_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		name = _tmp6_;
		_tmp7_ = tg_gui_get_current_channel (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = tg_channel_get_description (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		desc = _tmp11_;
		_tmp13_ = name;
		if (_tmp13_ != NULL) {
			const gchar* _tmp14_ = NULL;
			_tmp14_ = desc;
			_tmp12_ = _tmp14_ != NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gchar* title = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			GtkWindow* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			_tmp15_ = _ ("TeleGNOME: %s (%s)");
			_tmp16_ = name;
			_tmp17_ = desc;
			_tmp18_ = g_strdup_printf (_tmp15_, _tmp16_, _tmp17_);
			title = _tmp18_;
			_tmp19_ = self->priv->_window;
			_tmp20_ = title;
			gtk_window_set_title (_tmp19_, _tmp20_);
			_g_free0 (title);
		}
		_g_free0 (desc);
		_g_free0 (name);
	}
}


/**
 * logo_timer:
 *
 * Remove the logo from the screen and go to a page.
 */
static gboolean tg_gui_logo_timer (TgGui* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	tg_gui_get_the_page (self);
	_g_free0 (self->priv->logo_timer_id);
	self->priv->logo_timer_id = NULL;
	result = FALSE;
	return result;
}


static TgChannel* tg_gui_channel_find_by_uuid (TgGui* self, const gchar* uuid) {
	TgChannel* result = NULL;
	GSList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = self->priv->channels;
	{
		GSList* channel_collection = NULL;
		GSList* channel_it = NULL;
		channel_collection = _tmp0_;
		for (channel_it = channel_collection; channel_it != NULL; channel_it = channel_it->next) {
			TgChannel* _tmp1_ = NULL;
			TgChannel* channel = NULL;
			_tmp1_ = _g_object_ref0 ((TgChannel*) channel_it->data);
			channel = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				TgChannel* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				_tmp2_ = uuid;
				_tmp3_ = channel;
				_tmp4_ = tg_channel_get_uuid (_tmp3_);
				_tmp5_ = _tmp4_;
				if (g_strcmp0 (_tmp2_, _tmp5_) == 0) {
					result = channel;
					return result;
				}
				_g_object_unref0 (channel);
			}
		}
	}
	result = NULL;
	return result;
}


static void tg_gui_channel_select (TgGui* self, TgChannel* channel) {
	TgChannel* _tmp0_ = NULL;
	TgChannel* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_current_channel);
	self->priv->_current_channel = _tmp1_;
	tg_gui_update_title_bar (self);
}


void tg_gui_change_state_set_channel (TgGui* self, GSimpleAction* action, GVariant* value) {
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = value;
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
	tg_gui_set_current_channel_uuid (self, _tmp1_);
	tg_gui_set_page_number (self, 100);
	tg_gui_set_subpage_number (self, 0);
	tg_gui_get_the_page (self);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void tg_gui_populate_channel_menu (TgGui* self) {
	GMenu* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channel_menu;
	g_menu_remove_all (_tmp0_);
	_tmp1_ = self->priv->channels;
	{
		GSList* channel_collection = NULL;
		GSList* channel_it = NULL;
		channel_collection = _tmp1_;
		for (channel_it = channel_collection; channel_it != NULL; channel_it = channel_it->next) {
			TgChannel* _tmp2_ = NULL;
			TgChannel* channel = NULL;
			_tmp2_ = _g_object_ref0 ((TgChannel*) channel_it->data);
			channel = _tmp2_;
			{
				gchar* action = NULL;
				TgChannel* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				GMenu* _tmp8_ = NULL;
				TgChannel* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				_tmp3_ = channel;
				_tmp4_ = tg_channel_get_uuid (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = string_to_string (_tmp5_);
				_tmp7_ = g_strconcat ("app.set-channel::", _tmp6_, NULL);
				action = _tmp7_;
				_tmp8_ = self->priv->channel_menu;
				_tmp9_ = channel;
				_tmp10_ = tg_channel_get_name (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = action;
				g_menu_append (_tmp8_, _tmp11_, _tmp12_);
				_g_free0 (action);
				_g_object_unref0 (channel);
			}
		}
	}
}


static gchar* tg_gui_get_default_channel_value (TgGui* self, GKeyFile* file, const gchar* group, const gchar* key, gboolean missing_ok) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp1_ = file;
		_tmp2_ = group;
		_tmp3_ = key;
		_tmp4_ = g_key_file_get_string (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		gboolean _tmp6_ = FALSE;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = missing_ok;
		if (_tmp6_) {
			result = NULL;
			_g_error_free0 (e);
			return result;
		} else {
			g_assert_not_reached ();
		}
		_g_error_free0 (e);
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
 * reload_channels:
 *
 * Load all the channels from settings and store them in the
 * "channels" property.
 */
static gint _vala_g_bytes_get_length (GBytes* self) {
	gint result;
	gsize _tmp0_ = 0UL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_bytes_get_size (self);
	result = (gint) _tmp0_;
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void tg_gui_reload_channels (TgGui* self) {
	gchar* current_uuid = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GSList* _tmp8_ = NULL;
	const gchar* _tmp54_ = NULL;
	TgChannel* _tmp56_ = NULL;
	TgChannel* _tmp57_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tg_gui_get_current_channel_uuid (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	current_uuid = _tmp2_;
	__g_slist_free__g_object_unref0_0 (self->priv->channels);
	self->priv->channels = NULL;
	_tmp3_ = tg_gui_get_channel_children (self, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	{
		gchar** uuid_collection = NULL;
		gint uuid_collection_length1 = 0;
		gint _uuid_collection_size_ = 0;
		gint uuid_it = 0;
		uuid_collection = _tmp4_;
		uuid_collection_length1 = _tmp4__length1;
		for (uuid_it = 0; uuid_it < _tmp4__length1; uuid_it = uuid_it + 1) {
			gchar* _tmp5_ = NULL;
			gchar* uuid = NULL;
			_tmp5_ = g_strdup (uuid_collection[uuid_it]);
			uuid = _tmp5_;
			{
				const gchar* _tmp6_ = NULL;
				TgChannel* _tmp7_ = NULL;
				_tmp6_ = uuid;
				_tmp7_ = tg_channel_new (_tmp6_);
				self->priv->channels = g_slist_append (self->priv->channels, _tmp7_);
				_g_free0 (uuid);
			}
		}
	}
	_tmp8_ = self->priv->channels;
	if (_tmp8_ == NULL) {
		gchar** children = NULL;
		gchar** _tmp9_ = NULL;
		gint children_length1 = 0;
		gint _children_size_ = 0;
		GBytes* bytes = NULL;
		GKeyFile* file = NULL;
		GKeyFile* _tmp13_ = NULL;
		GKeyFile* _tmp21_ = NULL;
		gsize _tmp22_;
		gchar** _tmp23_ = NULL;
		GSettings* _tmp52_ = NULL;
		gchar** _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		_tmp9_ = g_new0 (gchar*, 0 + 1);
		children = _tmp9_;
		children_length1 = 0;
		_children_size_ = children_length1;
		{
			GBytes* _tmp10_ = NULL;
			GBytes* _tmp11_ = NULL;
			GBytes* _tmp12_ = NULL;
			_tmp11_ = g_resources_lookup_data ("/org/gnome/telegnome/default-channels.cfg", G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error_);
			_tmp10_ = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp12_ = _tmp10_;
			_tmp10_ = NULL;
			_g_bytes_unref0 (bytes);
			bytes = _tmp12_;
			_g_bytes_unref0 (_tmp10_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_bytes_unref0 (bytes);
			children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (current_uuid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = g_key_file_new ();
		file = _tmp13_;
		{
			GKeyFile* _tmp14_ = NULL;
			GBytes* _tmp15_ = NULL;
			gsize _tmp16_;
			guint8* _tmp17_ = NULL;
			GBytes* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp14_ = file;
			_tmp15_ = bytes;
			_tmp17_ = g_bytes_get_data (_tmp15_, &_tmp16_);
			_tmp18_ = bytes;
			_tmp19_ = _vala_g_bytes_get_length (_tmp18_);
			_tmp20_ = _tmp19_;
			g_key_file_load_from_data (_tmp14_, (const gchar*) _tmp17_, (gsize) _tmp20_, G_KEY_FILE_NONE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_key_file_unref0 (file);
			_g_bytes_unref0 (bytes);
			children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (current_uuid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp21_ = file;
		_tmp23_ = g_key_file_get_groups (_tmp21_, &_tmp22_);
		{
			gchar** group_collection = NULL;
			gint group_collection_length1 = 0;
			gint _group_collection_size_ = 0;
			gint group_it = 0;
			group_collection = _tmp23_;
			group_collection_length1 = _tmp22_;
			for (group_it = 0; group_it < _tmp22_; group_it = group_it + 1) {
				const gchar* group = NULL;
				group = group_collection[group_it];
				{
					gchar* name = NULL;
					GKeyFile* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* description = NULL;
					GKeyFile* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* page_url = NULL;
					GKeyFile* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					gchar* subpage_url = NULL;
					GKeyFile* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* country = NULL;
					GKeyFile* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					TgChannel* channel = NULL;
					const gchar* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					const gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					TgChannel* _tmp44_ = NULL;
					TgChannel* _tmp45_ = NULL;
					TgChannel* _tmp46_ = NULL;
					gchar** _tmp47_ = NULL;
					gint _tmp47__length1 = 0;
					TgChannel* _tmp48_ = NULL;
					const gchar* _tmp49_ = NULL;
					const gchar* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					_tmp24_ = file;
					_tmp25_ = group;
					_tmp26_ = tg_gui_get_default_channel_value (self, _tmp24_, _tmp25_, "Name", FALSE);
					name = _tmp26_;
					_tmp27_ = file;
					_tmp28_ = group;
					_tmp29_ = tg_gui_get_default_channel_value (self, _tmp27_, _tmp28_, "Description", FALSE);
					description = _tmp29_;
					_tmp30_ = file;
					_tmp31_ = group;
					_tmp32_ = tg_gui_get_default_channel_value (self, _tmp30_, _tmp31_, "PageURL", FALSE);
					page_url = _tmp32_;
					_tmp33_ = file;
					_tmp34_ = group;
					_tmp35_ = tg_gui_get_default_channel_value (self, _tmp33_, _tmp34_, "SubpageURL", TRUE);
					subpage_url = _tmp35_;
					_tmp36_ = file;
					_tmp37_ = group;
					_tmp38_ = tg_gui_get_default_channel_value (self, _tmp36_, _tmp37_, "Country", FALSE);
					country = _tmp38_;
					_tmp39_ = name;
					_tmp40_ = description;
					_tmp41_ = page_url;
					_tmp42_ = subpage_url;
					_tmp43_ = country;
					_tmp44_ = tg_channel_new_with_parameters (_tmp39_, _tmp40_, _tmp41_, _tmp42_, _tmp43_);
					channel = _tmp44_;
					_tmp45_ = channel;
					_tmp46_ = _g_object_ref0 (_tmp45_);
					self->priv->channels = g_slist_append (self->priv->channels, _tmp46_);
					_tmp47_ = children;
					_tmp47__length1 = children_length1;
					_tmp48_ = channel;
					_tmp49_ = tg_channel_get_uuid (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup (_tmp50_);
					_vala_array_add1 (&children, &children_length1, &_children_size_, _tmp51_);
					_g_object_unref0 (channel);
					_g_free0 (country);
					_g_free0 (subpage_url);
					_g_free0 (page_url);
					_g_free0 (description);
					_g_free0 (name);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp52_ = self->priv->settings;
		_tmp53_ = children;
		_tmp53__length1 = children_length1;
		g_settings_set_strv (_tmp52_, "channel-children", _tmp53_);
		_g_key_file_unref0 (file);
		_g_bytes_unref0 (bytes);
		children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp54_ = current_uuid;
	if (_tmp54_ != NULL) {
		const gchar* _tmp55_ = NULL;
		_tmp55_ = current_uuid;
		tg_gui_set_current_channel_uuid (self, _tmp55_);
	}
	_tmp56_ = tg_gui_get_current_channel (self);
	_tmp57_ = _tmp56_;
	if (_tmp57_ == NULL) {
		GSList* _tmp58_ = NULL;
		gconstpointer _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		_tmp58_ = self->priv->channels;
		_tmp59_ = _tmp58_->data;
		_tmp60_ = tg_channel_get_uuid ((TgChannel*) _tmp59_);
		_tmp61_ = _tmp60_;
		tg_gui_set_current_channel_uuid (self, _tmp61_);
		tg_gui_set_page_number (self, 100);
		tg_gui_set_subpage_number (self, 0);
		_tmp62_ = current_uuid;
		if (_tmp62_ != NULL) {
			tg_gui_get_the_page (self);
		}
	}
	_g_free0 (current_uuid);
}


static void tg_gui_refresh_channel_menu (TgGui* self) {
	g_return_if_fail (self != NULL);
	tg_gui_reload_channels (self);
	tg_gui_populate_channel_menu (self);
}


/**
 * print_in_statusbar:
 * @status: A status string.
 *
 * Print a string in the status bar.
 */
static void tg_gui_print_in_statusbar (TgGui* self, const gchar* status) {
	guint context_id = 0U;
	GtkStatusbar* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkStatusbar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status_bar;
	_tmp1_ = gtk_statusbar_get_context_id (_tmp0_, "errors");
	context_id = _tmp1_;
	_tmp2_ = self->priv->status_bar;
	_tmp3_ = context_id;
	gtk_statusbar_remove_all (_tmp2_, _tmp3_);
	_tmp4_ = status;
	if (_tmp4_ != NULL) {
		GtkStatusbar* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		const gchar* _tmp7_ = NULL;
		_tmp5_ = self->priv->status_bar;
		_tmp6_ = context_id;
		_tmp7_ = status;
		gtk_statusbar_push (_tmp5_, _tmp6_, _tmp7_);
	}
}


static gboolean tg_gui_pager_timer (TgGui* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkProgressBar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->page_progress;
	_tmp1_ = self->priv->_paging_interval;
	self->priv->page_progress = _tmp0_ + (_tmp1_ / 100);
	_tmp2_ = self->priv->progress_bar;
	_tmp3_ = self->priv->page_progress;
	_tmp4_ = self->priv->_paging_interval;
	gtk_progress_bar_set_fraction (_tmp2_, _tmp3_ / ((gdouble) _tmp4_));
	_tmp5_ = self->priv->page_progress;
	_tmp6_ = self->priv->_paging_interval;
	if (_tmp5_ >= _tmp6_) {
		GtkProgressBar* _tmp7_ = NULL;
		self->priv->page_progress = 0;
		_tmp7_ = self->priv->progress_bar;
		gtk_progress_bar_set_fraction (_tmp7_, 0.0);
		tg_gui_on_next_page (self);
	}
	result = TRUE;
	return result;
}


static gboolean _tg_gui_pager_timer_gsource_func (gpointer self) {
	gboolean result;
	result = tg_gui_pager_timer ((TgGui*) self);
	return result;
}


static void tg_gui_on_toggle_paging (TgGui* self) {
	GtkProgressBar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp0_, 0.0);
	_tmp1_ = self->priv->_paging_enabled;
	if (_tmp1_) {
		guint* _tmp2_ = NULL;
		_tmp2_ = self->priv->page_timer_id;
		if (_tmp2_ != NULL) {
			guint* _tmp3_ = NULL;
			_tmp3_ = self->priv->page_timer_id;
			g_source_remove (*_tmp3_);
		}
		_g_free0 (self->priv->page_timer_id);
		self->priv->page_timer_id = NULL;
		tg_gui_set_paging_enabled (self, FALSE);
	} else {
		gint _tmp4_ = 0;
		guint _tmp5_ = 0U;
		guint* _tmp6_ = NULL;
		_tmp4_ = self->priv->_paging_interval;
		_tmp5_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (_tmp4_ / 100), _tg_gui_pager_timer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp6_ = __uint_dup0 (&_tmp5_);
		_g_free0 (self->priv->page_timer_id);
		self->priv->page_timer_id = _tmp6_;
		tg_gui_set_paging_enabled (self, TRUE);
	}
	self->priv->page_progress = 0;
}


static void tg_gui_update_page (TgGui* self) {
	gint old_page = 0;
	gint _tmp0_ = 0;
	gint old_subpage = 0;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_page_number;
	old_page = _tmp0_;
	_tmp1_ = self->priv->_subpage_number;
	old_subpage = _tmp1_;
	{
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		TgPixpack* _tmp3_ = NULL;
		_tmp2_ = tg_http_get_image (self, &_inner_error_);
		pixbuf = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == TG_HTTP_ERROR) {
				goto __catch3_tg_http_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->pixpack;
		tg_pixpack_load_image (_tmp3_, pixbuf);
		_g_object_unref0 (pixbuf);
	}
	goto __finally3;
	__catch3_tg_http_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		if (g_error_matches (_tmp4_, TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF)) {
			gint _tmp5_ = 0;
			_tmp5_ = self->priv->_subpage_number;
			if (_tmp5_ == 0) {
				tg_gui_set_subpage_number (self, 1);
			} else {
				tg_gui_set_subpage_number (self, 0);
			}
			{
				GdkPixbuf* pixbuf = NULL;
				GdkPixbuf* _tmp6_ = NULL;
				TgPixpack* _tmp7_ = NULL;
				GdkPixbuf* _tmp8_ = NULL;
				_tmp6_ = tg_http_get_image (self, &_inner_error_);
				pixbuf = _tmp6_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == TG_HTTP_ERROR) {
						goto __catch4_tg_http_error;
					}
					_g_error_free0 (e);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp7_ = self->priv->pixpack;
				_tmp8_ = pixbuf;
				tg_pixpack_load_image (_tmp7_, _tmp8_);
				_g_object_unref0 (pixbuf);
			}
			goto __finally4;
			__catch4_tg_http_error:
			{
				GError* e2 = NULL;
				gint _tmp9_ = 0;
				e2 = _inner_error_;
				_inner_error_ = NULL;
				_tmp9_ = self->priv->_subpage_number;
				if (_tmp9_ != 1) {
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					_tmp10_ = self->priv->_page_number;
					tg_gui_set_page_number (self, _tmp10_ + 1);
					tg_gui_set_subpage_number (self, 1);
					_tmp11_ = self->priv->_page_number;
					_tmp12_ = self->priv->_subpage_number;
					tg_gui_update_entry (self, _tmp11_, _tmp12_);
					tg_gui_get_the_page (self);
				} else {
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					TgPixpack* _tmp16_ = NULL;
					_tmp13_ = _ ("Web server error: Wrong page number?");
					tg_gui_print_in_statusbar (self, _tmp13_);
					tg_gui_set_page_number (self, old_page);
					tg_gui_set_subpage_number (self, old_subpage);
					_tmp14_ = self->priv->_page_number;
					_tmp15_ = self->priv->_subpage_number;
					tg_gui_update_entry (self, _tmp14_, _tmp15_);
					_tmp16_ = self->priv->pixpack;
					tg_pixpack_load_image_from_resource (_tmp16_, TG_notfound_pixmap);
				}
				_g_error_free0 (e2);
			}
			__finally4:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_error_free0 (e);
				_g_error_free0 (e);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			GError* _tmp17_ = NULL;
			_tmp17_ = e;
			if (g_error_matches (_tmp17_, TG_HTTP_ERROR, TG_HTTP_ERROR_VFS)) {
				const gchar* _tmp18_ = NULL;
				_tmp18_ = _ ("Error making HTTP connection");
				tg_gui_print_in_statusbar (self, _tmp18_);
			} else {
				GError* _tmp19_ = NULL;
				_tmp19_ = e;
				if (g_error_matches (_tmp19_, TG_HTTP_ERROR, TG_HTTP_ERROR_HTTPQUERY)) {
					const gchar* _tmp20_ = NULL;
					_tmp20_ = _ ("Internal error in HTTP query code");
					tg_gui_print_in_statusbar (self, _tmp20_);
				} else {
					g_assert_not_reached ();
				}
			}
		}
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * update_entry:
 *
 * Update the entry box with the current values of page and subpage.
 */
static void tg_gui_update_entry (TgGui* self, gint page_nr, gint subpage_nr) {
	gchar* full_num = NULL;
	gint _tmp0_ = 0;
	GtkEntry* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = subpage_nr;
	if (_tmp0_ > 0) {
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp1_ = page_nr;
		_tmp2_ = g_strdup_printf ("%i", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = subpage_nr;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp3_, "/", _tmp6_, NULL);
		_g_free0 (full_num);
		full_num = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp3_);
	} else {
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		_tmp8_ = page_nr;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_g_free0 (full_num);
		full_num = _tmp9_;
	}
	_tmp10_ = self->priv->entry;
	_tmp11_ = full_num;
	gtk_entry_set_text (_tmp10_, _tmp11_);
	_g_free0 (full_num);
}


/**
 * get_the_page:
 *
 * Try to get the page, and do something smart if it fails.
 */
static void tg_gui_get_the_page (TgGui* self) {
	guint* _tmp0_ = NULL;
	TgChannel* _tmp2_ = NULL;
	TgChannel* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logo_timer_id;
	if (_tmp0_ != NULL) {
		guint* _tmp1_ = NULL;
		_tmp1_ = self->priv->logo_timer_id;
		g_source_remove (*_tmp1_);
	}
	_g_free0 (self->priv->logo_timer_id);
	self->priv->logo_timer_id = NULL;
	_tmp2_ = tg_gui_get_current_channel (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		tg_gui_update_page (self);
	}
	_tmp4_ = self->priv->_page_number;
	_tmp5_ = self->priv->_subpage_number;
	tg_gui_update_entry (self, _tmp4_, _tmp5_);
	tg_gui_print_in_statusbar (self, NULL);
}


void tg_gui_activate_quit (TgGui* self, GSimpleAction* action, GVariant* parameter) {
	GApplication* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_application_get_default ();
	g_application_quit (_tmp0_);
}


void tg_gui_activate_help_contents (TgGui* self, GSimpleAction* action, GVariant* parameter) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		_tmp0_ = self->priv->_window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		gtk_show_uri (_tmp1_, "help:telegnome", (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("gui.vala:441: Error displaying help: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void tg_gui_activate_about (TgGui* self, GSimpleAction* action, GVariant* parameter) {
	GtkDialog* about = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "about_dialog");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL);
	about = _tmp2_;
	gtk_dialog_run (about);
	gtk_widget_hide ((GtkWidget*) about);
	_g_object_unref0 (about);
}


static void tg_gui_refresh_timer (TgGui* self) {
	gdouble perc = 0.0;
	GtkProgressBar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GtkProgressBar* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	gint _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar;
	_tmp1_ = gtk_progress_bar_get_fraction (_tmp0_);
	perc = _tmp1_;
	_tmp2_ = self->priv->progress_bar;
	_tmp3_ = perc;
	gtk_progress_bar_set_fraction (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->_paging_enabled;
	if (_tmp4_) {
		guint* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		guint _tmp7_ = 0U;
		guint* _tmp8_ = NULL;
		_tmp5_ = self->priv->page_timer_id;
		g_source_remove (*_tmp5_);
		_tmp6_ = self->priv->_paging_interval;
		_tmp7_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (_tmp6_ / 100), _tg_gui_pager_timer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp8_ = __uint_dup0 (&_tmp7_);
		_g_free0 (self->priv->page_timer_id);
		self->priv->page_timer_id = _tmp8_;
	}
	_tmp9_ = self->priv->_paging_interval;
	_tmp10_ = perc;
	self->priv->page_progress = (gint) ((_tmp9_ / 100) * _tmp10_);
}


void tg_gui_activate_preferences (TgGui* self, GSimpleAction* action, GVariant* parameter) {
	TgPrefs* _tmp0_ = NULL;
	TgPrefs* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = tg_prefs_new (self);
	_tmp1_ = _tmp0_;
	tg_prefs_show (_tmp1_);
	_g_object_unref0 (_tmp1_);
	tg_gui_refresh_channel_menu (self);
	tg_gui_refresh_timer (self);
}


static void tg_gui_on_next_page (TgGui* self) {
	gint _tmp0_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_subpage_number;
	if (_tmp0_ == 0) {
		gint _tmp1_ = 0;
		_tmp1_ = self->priv->_page_number;
		tg_gui_set_page_number (self, _tmp1_ + 1);
	} else {
		gint _tmp2_ = 0;
		_tmp2_ = self->priv->_subpage_number;
		tg_gui_set_subpage_number (self, _tmp2_ + 1);
	}
	_tmp3_ = self->priv->_page_number;
	_tmp4_ = self->priv->_subpage_number;
	tg_gui_update_entry (self, _tmp3_, _tmp4_);
	tg_gui_get_the_page (self);
}


static void tg_gui_on_prev_page (TgGui* self) {
	gint _tmp0_ = 0;
	gint _tmp2_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_subpage_number;
	if (_tmp0_ > 0) {
		gint _tmp1_ = 0;
		_tmp1_ = self->priv->_subpage_number;
		tg_gui_set_subpage_number (self, _tmp1_ - 1);
	}
	_tmp2_ = self->priv->_subpage_number;
	if (_tmp2_ == 0) {
		gint _tmp3_ = 0;
		_tmp3_ = self->priv->_page_number;
		tg_gui_set_page_number (self, _tmp3_ - 1);
	}
	_tmp4_ = self->priv->_page_number;
	_tmp5_ = self->priv->_subpage_number;
	tg_gui_update_entry (self, _tmp4_, _tmp5_);
	tg_gui_get_the_page (self);
}


static void tg_gui_on_home (TgGui* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	tg_gui_set_page_number (self, 100);
	tg_gui_set_subpage_number (self, 0);
	_tmp0_ = self->priv->_page_number;
	_tmp1_ = self->priv->_subpage_number;
	tg_gui_update_entry (self, _tmp0_, _tmp1_);
	tg_gui_get_the_page (self);
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gint64* _int64_dup (gint64* self) {
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}


static gpointer __int64_dup0 (gpointer self) {
	return self ? _int64_dup (self) : NULL;
}


static void tg_gui_on_goto_page (TgGui* self) {
	gchar* entry_text = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	gint64* new_page = NULL;
	gint64 new_subpage = 0LL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint64* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->kb_status = TG_INPUT_STATUS_NEW;
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	entry_text = _tmp2_;
	_tmp3_ = entry_text;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "/", 2);
	tokens = _tmp5_;
	tokens_length1 = _vala_array_length (_tmp4_);
	_tokens_size_ = tokens_length1;
	new_page = NULL;
	new_subpage = (gint64) 0;
	_tmp6_ = tokens;
	_tmp6__length1 = tokens_length1;
	if (_tmp6__length1 >= 1) {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		gboolean _tmp10_ = FALSE;
		gint64 _tmp11_ = 0LL;
		gint64* _tmp12_ = NULL;
		_tmp7_ = tokens;
		_tmp7__length1 = tokens_length1;
		_tmp8_ = _tmp7_[0];
		_tmp10_ = int64_try_parse (_tmp8_, &_tmp9_);
		_g_free0 (new_page);
		_tmp11_ = _tmp9_;
		_tmp12_ = __int64_dup0 (&_tmp11_);
		new_page = _tmp12_;
		if (!_tmp10_) {
			_g_free0 (new_page);
			new_page = NULL;
		}
	}
	_tmp13_ = tokens;
	_tmp13__length1 = tokens_length1;
	if (_tmp13__length1 >= 2) {
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		const gchar* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
		gboolean _tmp17_ = FALSE;
		_tmp14_ = tokens;
		_tmp14__length1 = tokens_length1;
		_tmp15_ = _tmp14_[1];
		_tmp17_ = int64_try_parse (_tmp15_, &_tmp16_);
		new_subpage = _tmp16_;
		if (!_tmp17_) {
			_g_free0 (new_page);
			new_page = NULL;
		}
	}
	_tmp18_ = new_page;
	if (_tmp18_ == NULL) {
		const gchar* _tmp19_ = NULL;
		_tmp19_ = _ ("Error in page entry");
		tg_gui_print_in_statusbar (self, _tmp19_);
	} else {
		gint64* _tmp20_ = NULL;
		gint64 _tmp21_ = 0LL;
		_tmp20_ = new_page;
		tg_gui_set_page_number (self, (gint) (*_tmp20_));
		_tmp21_ = new_subpage;
		tg_gui_set_subpage_number (self, (gint) _tmp21_);
		tg_gui_get_the_page (self);
	}
	_g_free0 (new_page);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (entry_text);
}


static gboolean tg_gui_keyboard_timer (TgGui* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->kb_status = TG_INPUT_STATUS_NEW;
	_g_free0 (self->priv->kb_timer_id);
	self->priv->kb_timer_id = NULL;
	result = FALSE;
	return result;
}


static gboolean _tg_gui_keyboard_timer_gsource_func (gpointer self) {
	gboolean result;
	result = tg_gui_keyboard_timer ((TgGui*) self);
	return result;
}


static gboolean tg_gui_on_keypress (TgGui* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkEntry* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	TgInputStatus _tmp8_ = 0;
	guint* _tmp10_ = NULL;
	guint _tmp12_ = 0U;
	guint* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	if (_tmp1_ == ((guint) GDK_KEY_KP_Enter)) {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		tg_gui_on_goto_page (self);
		_tmp2_ = self->priv->_page_number;
		_tmp3_ = self->priv->_subpage_number;
		tg_gui_update_entry (self, _tmp2_, _tmp3_);
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->entry;
	g_object_get ((GtkWidget*) _tmp4_, "is-focus", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		GtkEntry* _tmp7_ = NULL;
		_tmp7_ = self->priv->entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
	}
	_tmp8_ = self->priv->kb_status;
	if (_tmp8_ == TG_INPUT_STATUS_NEW) {
		GtkEntry* _tmp9_ = NULL;
		_tmp9_ = self->priv->entry;
		gtk_entry_set_text (_tmp9_, "");
	}
	_tmp10_ = self->priv->kb_timer_id;
	if (_tmp10_ != NULL) {
		guint* _tmp11_ = NULL;
		_tmp11_ = self->priv->kb_timer_id;
		g_source_remove (*_tmp11_);
	}
	_tmp12_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) TG_kb_timeout, _tg_gui_keyboard_timer_gsource_func, g_object_ref (self), g_object_unref);
	_tmp13_ = __uint_dup0 (&_tmp12_);
	_g_free0 (self->priv->kb_timer_id);
	self->priv->kb_timer_id = _tmp13_;
	self->priv->kb_status = TG_INPUT_STATUS_CONTINUED;
	result = FALSE;
	return result;
}


gchar** tg_gui_get_channel_children (TgGui* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_channel_children;
	_tmp0__length1 = self->priv->_channel_children_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void tg_gui_set_channel_children (TgGui* self, gchar** value, int value_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_channel_children = (_vala_array_free (self->priv->_channel_children, self->priv->_channel_children_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_channel_children = _tmp1_;
	self->priv->_channel_children_length1 = _tmp1__length1;
	self->priv->__channel_children_size_ = self->priv->_channel_children_length1;
	g_object_notify ((GObject *) self, "channel-children");
}


const gchar* tg_gui_get_current_channel_uuid (TgGui* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_channel_uuid;
	result = _tmp0_;
	return result;
}


void tg_gui_set_current_channel_uuid (TgGui* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TgChannel* channel = NULL;
	const gchar* _tmp2_ = NULL;
	TgChannel* _tmp3_ = NULL;
	TgChannel* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_current_channel_uuid);
	self->priv->_current_channel_uuid = _tmp1_;
	_tmp2_ = value;
	_tmp3_ = tg_gui_channel_find_by_uuid (self, _tmp2_);
	channel = _tmp3_;
	_tmp4_ = channel;
	if (_tmp4_ != NULL) {
		TgChannel* _tmp5_ = NULL;
		_tmp5_ = channel;
		tg_gui_channel_select (self, _tmp5_);
	}
	_g_object_unref0 (channel);
	g_object_notify ((GObject *) self, "current-channel-uuid");
}


gint tg_gui_get_zoom_factor (TgGui* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_zoom_factor;
	result = _tmp0_;
	return result;
}


void tg_gui_set_zoom_factor (TgGui* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_zoom_factor = _tmp0_;
	g_object_notify ((GObject *) self, "zoom-factor");
}


gboolean tg_gui_get_paging_enabled (TgGui* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paging_enabled;
	result = _tmp0_;
	return result;
}


void tg_gui_set_paging_enabled (TgGui* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_paging_enabled = _tmp0_;
	g_object_notify ((GObject *) self, "paging-enabled");
}


gint tg_gui_get_paging_interval (TgGui* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_paging_interval;
	result = _tmp0_;
	return result;
}


void tg_gui_set_paging_interval (TgGui* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_paging_interval = _tmp0_;
	g_object_notify ((GObject *) self, "paging-interval");
}


gint tg_gui_get_page_number (TgGui* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page_number;
	result = _tmp0_;
	return result;
}


void tg_gui_set_page_number (TgGui* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_page_number = _tmp0_;
	g_object_notify ((GObject *) self, "page-number");
}


gint tg_gui_get_subpage_number (TgGui* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_subpage_number;
	result = _tmp0_;
	return result;
}


void tg_gui_set_subpage_number (TgGui* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_subpage_number = _tmp0_;
	g_object_notify ((GObject *) self, "subpage-number");
}


TgChannel* tg_gui_get_current_channel (TgGui* self) {
	TgChannel* result;
	TgChannel* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_channel;
	result = _tmp0_;
	return result;
}


GtkWindow* tg_gui_get_window (TgGui* self) {
	GtkWindow* result;
	GtkWindow* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}


static void tg_gui_set_window (TgGui* self, GtkWindow* value) {
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_window);
	self->priv->_window = _tmp1_;
	g_object_notify ((GObject *) self, "window");
}


static void tg_gui_class_init (TgGuiClass * klass) {
	tg_gui_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TgGuiPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tg_gui_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tg_gui_set_property;
	G_OBJECT_CLASS (klass)->finalize = tg_gui_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_CHANNEL_CHILDREN, g_param_spec_boxed ("channel-children", "Channel children", "List of relative settings paths at which channels are stored", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_CURRENT_CHANNEL_UUID, g_param_spec_string ("current-channel-uuid", "Current channel", "Current channel", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_ZOOM_FACTOR, g_param_spec_int ("zoom-factor", "Zoom factor", "Page zoom factor.  Larger numbers produce larger text.", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_PAGING_ENABLED, g_param_spec_boolean ("paging-enabled", "Paging enabled", "Automatically switch page at periodic intervals", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_PAGING_INTERVAL, g_param_spec_int ("paging-interval", "Paging interval", "Specifies the interval for the auto-pager, in milliseconds.", G_MININT, G_MAXINT, 12000, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_PAGE_NUMBER, g_param_spec_int ("page-number", "Current page number", "Current page number", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_SUBPAGE_NUMBER, g_param_spec_int ("subpage-number", "Current subpage number", "Current subpage number", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_CURRENT_CHANNEL, g_param_spec_object ("current-channel", "current-channel", "current-channel", TG_TYPE_CHANNEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_GUI_WINDOW, g_param_spec_object ("window", "window", "window", gtk_window_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tg_gui_instance_init (TgGui * self) {
	self->priv = TG_GUI_GET_PRIVATE (self);
	self->priv->_zoom_factor = 1;
	self->priv->_paging_enabled = FALSE;
	self->priv->_paging_interval = 12000;
	self->priv->_page_number = -1;
	self->priv->_subpage_number = -1;
}


static void tg_gui_finalize (GObject* obj) {
	TgGui * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TG_TYPE_GUI, TgGui);
	self->priv->_channel_children = (_vala_array_free (self->priv->_channel_children, self->priv->_channel_children_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_current_channel_uuid);
	_g_object_unref0 (self->priv->_current_channel);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->pixpack);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->status_bar);
	_g_object_unref0 (self->priv->channel_menu);
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->logo_timer_id);
	_g_free0 (self->priv->kb_timer_id);
	_g_free0 (self->priv->page_timer_id);
	__g_slist_free__g_object_unref0_0 (self->priv->channels);
	G_OBJECT_CLASS (tg_gui_parent_class)->finalize (obj);
}


GType tg_gui_get_type (void) {
	static volatile gsize tg_gui_type_id__volatile = 0;
	if (g_once_init_enter (&tg_gui_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TgGuiClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tg_gui_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TgGui), 0, (GInstanceInitFunc) tg_gui_instance_init, NULL };
		GType tg_gui_type_id;
		tg_gui_type_id = g_type_register_static (G_TYPE_OBJECT, "TgGui", &g_define_type_info, 0);
		g_once_init_leave (&tg_gui_type_id__volatile, tg_gui_type_id);
	}
	return tg_gui_type_id__volatile;
}


static void _vala_tg_gui_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TgGui * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TG_TYPE_GUI, TgGui);
	switch (property_id) {
		case TG_GUI_CHANNEL_CHILDREN:
		{
			int length;
			g_value_set_boxed (value, tg_gui_get_channel_children (self, &length));
		}
		break;
		case TG_GUI_CURRENT_CHANNEL_UUID:
		g_value_set_string (value, tg_gui_get_current_channel_uuid (self));
		break;
		case TG_GUI_ZOOM_FACTOR:
		g_value_set_int (value, tg_gui_get_zoom_factor (self));
		break;
		case TG_GUI_PAGING_ENABLED:
		g_value_set_boolean (value, tg_gui_get_paging_enabled (self));
		break;
		case TG_GUI_PAGING_INTERVAL:
		g_value_set_int (value, tg_gui_get_paging_interval (self));
		break;
		case TG_GUI_PAGE_NUMBER:
		g_value_set_int (value, tg_gui_get_page_number (self));
		break;
		case TG_GUI_SUBPAGE_NUMBER:
		g_value_set_int (value, tg_gui_get_subpage_number (self));
		break;
		case TG_GUI_CURRENT_CHANNEL:
		g_value_set_object (value, tg_gui_get_current_channel (self));
		break;
		case TG_GUI_WINDOW:
		g_value_set_object (value, tg_gui_get_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tg_gui_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TgGui * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TG_TYPE_GUI, TgGui);
	switch (property_id) {
		case TG_GUI_CHANNEL_CHILDREN:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			tg_gui_set_channel_children (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case TG_GUI_CURRENT_CHANNEL_UUID:
		tg_gui_set_current_channel_uuid (self, g_value_get_string (value));
		break;
		case TG_GUI_ZOOM_FACTOR:
		tg_gui_set_zoom_factor (self, g_value_get_int (value));
		break;
		case TG_GUI_PAGING_ENABLED:
		tg_gui_set_paging_enabled (self, g_value_get_boolean (value));
		break;
		case TG_GUI_PAGING_INTERVAL:
		tg_gui_set_paging_interval (self, g_value_get_int (value));
		break;
		case TG_GUI_PAGE_NUMBER:
		tg_gui_set_page_number (self, g_value_get_int (value));
		break;
		case TG_GUI_SUBPAGE_NUMBER:
		tg_gui_set_subpage_number (self, g_value_get_int (value));
		break;
		case TG_GUI_WINDOW:
		tg_gui_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



