/* twpsk  - A gui application for PSK
 * Copyright (C) 1999-2006 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 3.0 - Jul 2008
 */

#ifndef TWPSKWIDS_INCLUDED
#define TWPSKWIDS_INCLUDED

#define MAX_BUTTONS 9
#define SPACE_A 1
#define SPACE_B 4
#define ARROW_WIDTH 25
#define NUM_XMSTRINGS 8
#define SCROLLING 1

#include "GUI.h"
#include "twpskWF.h"
#include "twpskScope.h"
#include "server/server.h"


/*
 * Wids class
 */

class Wids {

   private:
      int i, j;
      XmString xs[20];
      int qpsk, lsb;
      char str[10];
      Arg args[20];  
      Pixmap saPixmap, wfPixmap;
      Pixel fg, bg;
      int fftSpeed;
      int fftSample;
      int rxFreqFocus;
      int rxScrollFlag;
      int brightness;
      int netmode;
      Boolean doLocalCaps;
      float nbVal;

      Widget mainForm;
      Widget   label1, menuBar, fileMenu, fileCas;
      Widget   controlsMenu, controlsCas;
      Widget     audioBtn, videoBtn;
      Widget     rxBtn, txBtn, tuneBtn, sep;
      Widget     broadBtn, mediumBtn, narrowBtn; 
      Widget     saBtn, wfBtn, wfDirTB, openBtn;
      Widget     localCapsTB;
      Widget   seekMenu, seekCas;
      Widget     upBtn, downBtn, haltBtn;
      Widget   helpMenu, helpCas;
      Widget     aboutBtn, helpBtn;
      
      Widget   bottomForm; 
      Widget     displayForm;
      Widget       f1;
      Widget         scopeDA;
      Widget         displayRC;
      Widget           displayLabel;
      Widget           bwRB;
      Widget             broadTB, mediumTB, narrowTB;
      Widget           displayRB;
      Widget             saTB, wfTB;
      Widget             nbTB;
      Widget             nbScale;
      
      Widget       f2;
      Widget         controlsForm;
      Widget           controlsRC;
      Widget             rxLabel;
      Widget             rxComboForm;
      Widget               rxFreqTF, rxUpArrow,rxDnArrow, afcTB;
      Widget             txLabel;
      Widget             txComboForm;
      Widget               txFreqTF, txUpArrow,txDnArrow, netTB;
      Widget         trLabel;
      Widget         trRB;
      Widget           rxTB, txTB, tuneTB;

      Widget       f3;
      Widget             modesRC;
      Widget                modeLabel, dcdTB, qpskTB, lsbTB, cwidTB;
      Widget                imdFrame, imdForm, imdTF, imdLabel;

      Widget   f4, wfDA;
      
      Widget   paneWin;
      Widget     rxTextSW;
      Widget       rxText;
      Widget       clrRxPopup;
      Widget     txTextSW;
      Widget       txText;
      Widget       clrTxPopup;
      
      Widget   audioDiag;
      Widget     mixerLabel;
      Widget     mixerFrame;
      Widget       mixerForm;
      Widget        mainLabel, mainScale;
      Widget        outLabel, pcmScale;
      Widget        inputLabel, inScale;
      Widget     configLabel;
      Widget     scFrame, scForm, scRC;
      Widget        chansOM;
      Widget     audioCloseBtn;

      Widget   videoDiag;
      Widget     videoLabel;
      Widget     videoFrame;
      Widget       videoForm;
      Widget         brightLabel,  brightScale;
      Widget         fftLabel, fftScale;
      Widget     displayCloseBtn;
      
      Widget rxScrollBar;
      Widget rxtTB[3];

      Widget genFrame;    /* used for all outlines */

      void createButtons (Widget shell, char **buttonNames);


   public:

      void buildWidgets (Widget shell, AppRes *appRes);

      Widget get_label1()
      {
         return label1;
      }


      Boolean getLSB(void)
      {
         return (XmToggleButtonGetState (lsbTB));
      }
    

      void setLSB(int value)
      {
         XtVaSetValues(lsbTB, XmNset, value, NULL);
      }


      Boolean getQPSK()
      {
	 return (XmToggleButtonGetState (qpskTB));
      }


      void setQPSK(Boolean value)
      {
	 XmToggleButtonSetState (qpskTB, value, 1);
      }


      Boolean getAFC()
      {
	 return (XmToggleButtonGetState (afcTB));
      }


      void setAFC(Boolean value)
      {
	 XmToggleButtonSetState (afcTB, value, 1);
      }


      int getNetmode()
      {
         return XmToggleButtonGetState (netTB);
      }


      void setNetmode(int value)
      {
         XmToggleButtonSetState (netTB, value, 1);
         netmode = value;
      }


      float getFreq()
      {
	 String str;
	 XtVaGetValues (rxFreqTF, XmNvalue, &str, NULL);  /* Get the freq */
	 float f = atof(str);                        /* convert to a float */
	 return f;
      }


      void setFreq(float freq)
      {
	      sprintf(str, "%4.1f", freq);
         XmTextFieldSetString (rxFreqTF, str);
	      commControl(COMM_RXCH, COMM_FREQ, (int)(freq*100));
      }


      Widget getShell(void)
      {
         return XtParent (mainForm);
      }


      Widget getScope(void)
      {
         return (scopeDA);
      }


      Widget getWF(void)
      {
         return (wfDA);
      }


      Widget getRxText(void)
      {
         return (rxText);
      }


      Widget getTxText(void)
      {
         return (txText);
      }


      Widget getDcdTB(void)
      {
         return (dcdTB);
      }


      Boolean getDCD()
      {
	 return (XmToggleButtonGetState (dcdTB));
      }


      Widget getRxFreqTF(void)
      {
         return (rxFreqTF);
      }


      Widget getTxFreqTF(void)
      {
         return (txFreqTF);
      }


      Widget getCwidTB(void)
      {
         return (cwidTB);
      }


      Widget getImdTF(void)
      {
         return (imdTF);
      }


      int getRxFreqFocus(void)
      {
         return (rxFreqFocus);
      }


      void setRxFreqFocus(int f)
      {
         rxFreqFocus = f;
      }


      void setRxScrollFlag(int x)
      {
         rxScrollFlag = x;
      }


      int getRxScrollFlag(void)
      {
         return (rxScrollFlag);
      }


      int getFFTspeed(void)
      {
         return (fftSpeed);
      }


      int getFFTsample(void)
      {
         return (fftSample);
      }
   

      Widget *get_rxtTB (void)
      {
         return (rxtTB);
      }

      float getNB(void)
      {
         int val;
 
         XmScaleGetValue (nbScale, &val);
         return (val / 100.0);
      }


      void setNB (float val)
      {
         int max;
         int min;

         /* verify that val is within the valid range. If too small or too */
         /* small, set to min or max */
         XtVaGetValues (nbScale,
            XmNmaximum, &max,
            XmNminimum, &min,
            NULL);

         if ((int)val > 100)
         {
            nbVal = 100;
            return;
         }
         if ((int)val < min)
         {
            nbVal = min;
            return;
         }
         nbVal = val;
      }      


      /* prints a string to stderr and inserts it into the rx text widget */
      int addText (char *str)
      {
         int pos;

         pos = XmTextGetLastPosition (rxText);
         XmTextInsert (rxText, pos, str);
         return (1);
      }


      Boolean setDoLocalCaps (int val)
      {
         if (val > 0)
         {
            doLocalCaps = TRUE;
         }
         else
         {
            doLocalCaps = FALSE;
         }
         return (doLocalCaps);
      }


      Boolean getDoLocalCaps (void)
      {
         return (doLocalCaps);
      }
};
#endif
