unclutter-xfixes(1)
===================
Ingo Bürk <ingo.buerk@airblader.de>

== NAME

unclutter-xfixes - rewrite of unclutter using the X11-Xfixes extension

== SYNOPSIS

unclutter [*--timeout* _seconds_] [*--jitter* _radius_] [*--exclude-root*] [*--ignore-scrolling*] [*--ignore-buttons* _buttons_] [*--hide-on-touch*] [*--fork*|*-b*] [*--help*|*-h*] [*--version*|*-v*] [*--start-hidden*]

Compatibility arguments:

unclutter [*--display*|*-d* _display_] [*--idle* _seconds_] [*--keystroke*] [*--grab*] [*--noevents*] [*--reset*] [*--root*] [*--onescreen*] [*--not*] _name …_

== DESCRIPTION

Hide the mouse cursor if it isn't being used.

This version of unclutter is a rewrite of the original and uses the x11-xfixes
extension, which means that no fake windows or pointer grabbing is needed. This
should work better with window managers and applications.

== OPTIONS

*--timeout* _seconds_::
Specifies the number of seconds after which the cursor should be hidden if
it was neither moved nor any button was pressed. (Default: 5)

*--jitter* _radius_::
Ignore cursor movements if the cursor hasn't moved at least _radius_ pixels.

*--exclude-root*::
Don't hide the mouse cursor if it is idling over the root window and not an
actual window since in this case it isn't obscuring anything important, but
rather just the desktop background.

*--ignore-scrolling*::
Ignore mouse scroll events (buttons 4 and 5) so that scrolling doesn't unhide
the cursor. This is a shortcut for *--ignore-buttons* '4,5'. If you want to
ignore horizontal scrolling as well, use *--ignore-buttons* instead by
specifying all buttons manually (e.g. '4,5,6,7').

*--ignore-buttons*::
Defines the mouse buttons which do not unhide the cursor when clicked. You can
pass multiple button numbers by separating them with ','.

*--hide-on-touch*::
Hides the mouse cursor on touch events.

*--start-hidden*::
Starts the cursor hidden.

*--fork*|*-b*::
Fork unclutter to the background.

*--help|-h*::
Display the usage and exit.

*--version*|*-v*::
Display the version and exit.

== TROUBLESHOOTING

=== *--ignore-scrolling* doesn't work

This can happen, especially on trackpoints, if other button events, e.g. for
horizontal scrolling, are sent as well. You can try adding some jitter, or
verify by using *xev -event button*. If you want to ignore horizontal scrolling
as well, use *--ignore-buttons* instead of *--ignore-scrolling*.

== COMPATIBILITY

In order to be used as a drop-in replacement of unclutter, unclutter-xfixes
accepts all command line arguments of unclutter, but ignores most of them.

*--display*|*-d* _display_::
Specifies the X display to use. The same effect can be achieved by setting the
*DISPLAY* environment variable.

*--idle* _seconds_::
This argument is mapped to *--timeout*.

*--keystroke*::
This argument is ignored.

*--grab*::
This argument is ignored.

*--noevents*::
This argument is ignored.

*--reset*::
This argument is ignored.

*--root*::
This argument does the opposite of *--exclude-root*.
Shouldn't need to be given, as this is the default behavior in unclutter-xfixes.

*--onescreen*::
This argument restricts unclutter to the single screen specified in *--display*
or to the default screen of the display.

*--not*::
This argument will result in all arguments that aren't options or option arguments, to be collected
into a list that specifies windows where the cursor shall not be removed. These will be the windows
where an element of the list matches, in a case insensitive comparison, the starting characters of
either the WM_NAME, or the name or class of the WM_CLASS, properties of the window. (Note that this
argument can be given anywhere on the command line.)
