
function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript(makeAuthorizer('username', 'passwd', this._login, this._password));
        } else if (this._state === 2) {
            this._browser.finish();
        }
        this._state++;
    },

    validateCallLog: function (log, out) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Yahoo Mail', log[0].args[0].name, 'Yahoo Mail');
        assertEquals('Unity.Launcher.addAction', log[1].func, 'Unity.Launcher.addAction');

        var found = false, i;
        for (i = 0; i < out.length; i++) {
            if (out[i] === 'PASS SELF TEST') {
                found = true;
            }
        }
        assertTrue('PASS SELF TEST', found);
    },

    scriptName: 'YahooMail.user.js'
};
