/*-------------------------------------------------------------------------*\

	FILE........: DTMFCNST.H
	TYPE........: C Header File
	COMPANY.....: VoiceTronix
	AUTHOR......: David Rowe
	DATE CREATED: 21/10/96

	Constants used throughout the DTMF decoder modules.

\*-------------------------------------------------------------------------*/

/* experimentally derived constants in float form ----------------------*/

#define LEVLO		3.87E9	/* cutoff level of -30dBm		*/
#define FWDTWST		63.1E-3	/* low tone > than high tone by 12dB	*/
#define REVTWST		0.1585	/* high tone > low tone by 8dB		*/
#define FRMHLF		0.5623	/* half frame energies within 2.5dB	*/
#define ETONES		0.631	/* tone energy cf energy in frame -2dB	*/
#define ENV		0.1	/* tone on/off envelope constant	*/

/* experimentally derived constants in fixed form ----------------------*/

#define FLT2WORD16L( X, Q)	(Word16)(X * (1l<<Q))
#define FLT2WORD16R( X, Q)	(Word16)(X / (1l<<Q))

#define	LEVLO_Q         28
#define	LEVLO_FIX	FLT2WORD16R(LEVLO, LEVLO_Q)

#define	FWDTWST_Q	15
#define	FWDTWST_FIX	FLT2WORD16L(FWDTWST, FWDTWST_Q)

#define	REVTWST_Q	15
#define	REVTWST_FIX	FLT2WORD16L(REVTWST, REVTWST_Q)

#define	FRMHLF_Q	15
#define	FRMHLF_FIX	FLT2WORD16L(FRMHLF, FRMHLF_Q)

#define	ETONES_Q	0
#define	ETONES_FIX	FLT2WORD16L((ETONES*NDTMF/2), ETONES_Q)

#define	ENV_Q		15
#define	ENV_FIX		FLT2WORD16L(ENV, ENV_Q)

