/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.terrain;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import org.j3d.renderer.java3d.navigation.FrameUpdateListener;
import org.j3d.renderer.java3d.terrain.AppearanceGenerator;
import org.j3d.renderer.java3d.terrain.J3DLandscape;
import org.j3d.terrain.Landscape;
import org.j3d.terrain.TerrainData;
import org.j3d.util.frustum.ViewFrustum;

public abstract class J3DAbstractLandscape
extends Landscape
implements FrameUpdateListener,
J3DLandscape {
    protected AppearanceGenerator appearanceGenerator;
    private Vector3f tmpPosition = new Vector3f();
    private Vector3f tmpOrientation = new Vector3f();
    private Matrix3f tmpMatrix = new Matrix3f();
    protected BranchGroup rootGroup = new BranchGroup();

    public J3DAbstractLandscape(ViewFrustum viewFrustum, TerrainData terrainData) {
        super(viewFrustum, terrainData);
    }

    public J3DAbstractLandscape(ViewFrustum viewFrustum, TerrainData terrainData, AppearanceGenerator appearanceGenerator) {
        this(viewFrustum, terrainData);
        this.appearanceGenerator = appearanceGenerator;
    }

    public void transitionEnded(Transform3D transform3D) {
        this.landscapeView.viewingPlatformMoved();
        this.setView(transform3D);
    }

    public void viewerPositionUpdated(Transform3D transform3D) {
        this.landscapeView.viewingPlatformMoved();
        this.setView(transform3D);
    }

    public void setView(Transform3D transform3D) {
        transform3D.get(this.tmpMatrix, this.tmpPosition);
        this.tmpOrientation.set(0.0f, 0.0f, -1.0f);
        this.tmpMatrix.transform(this.tmpOrientation);
        this.setView(this.tmpPosition, this.tmpOrientation);
    }

    public void setAppearanceGenerator(AppearanceGenerator appearanceGenerator) {
        this.appearanceGenerator = appearanceGenerator;
    }

    public AppearanceGenerator getAppearanceGenerator() {
        return this.appearanceGenerator;
    }

    public BranchGroup getSceneGraphObject() {
        return this.rootGroup;
    }
}

