/* showdircacheop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/* $Id: showdircacheop.h,v 1.6 2005/10/19 18:00:10 ralf Exp $ */

#ifndef SHOWDIRCACHEOP_H
#define SHOWDIRCACHEOP_H

#include "wdefines.h"
#include "functionproto.h"

class Worker;

class ShowDirCacheOp:public FunctionProto
{
public:
  ShowDirCacheOp();
  virtual ~ShowDirCacheOp();
  ShowDirCacheOp( const ShowDirCacheOp &other );
  ShowDirCacheOp &operator=( const ShowDirCacheOp &other );

  virtual ShowDirCacheOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  int run( WPUContext *wpu, ActionMessage* );
  virtual const char *getDescription();

  static const char *name;
protected:
  // Infos to save

  // temp variables
};

#endif
