<?php
/* **************************************************************************** *

 * cor-extensions.php								*
 * @package	Core								*
 * @copyright:	Copyright (c) 2008 Martin Novák. All rights reserved		*
 * @license	GNU/AGPL http://www.gnu.org/licenses/agpl.html			*

 * Albireo is free software! You can redistribute it and/or modify it under	*
 * the terms of the GNU Affero General Public License as published		*
 * by the Free Software Foundation, either version 3 of the License, or		*
 * (at your option) any later version.						*

 *	This program is distributed in the hope that it will be useful,		*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the		*
 *	GNU Affero General Public License for more details.			*

 This script description:
 Page for Extensions.

 Properties:
    array $page			// contains changes for array $page in ScriptPage

 Public Methods:
    none

 * **************************************************************************** */

class Extensions {

    public $page = array ( "text" => "" );
    private $forceInstall = false;

    public function __construct ()
    {
        if ( isset ( $_GET [ "continueinstall" ] ) && $_GET [ "continueinstall" ] == "true" ) {
            if ( file_exists ( "temporary/installer.php" ) ) {
                require_once ( "temporary/installer.php" );
                $this -> page [ "title" ] = $page [ "title" ];
                $this -> page [ "text" ] .= $page [ "text" ];
                return;
            }
        } elseif ( isset ( $_GET [ "action" ] ) && $_GET [ "action" ] == "upload" ) {
            $this -> uploadForm ();
        } elseif ( isset ( $_GET [ "action" ] ) && $_GET [ "action" ] == "albireocloud" ) {
            $this -> albireoCloud ();
        } elseif ( isset ( $_GET [ "action" ] ) && $_GET [ "action" ] == "update" ) {
            $this -> update ();
        } elseif ( isset ( $_GET [ "action" ] ) && $_GET [ "action" ] == "proceed" ) {
            $this -> proceed ();
        } elseif ( isset ( $_FILES [ "file" ] ) && !empty ( $_FILES [ "file" ][ "name" ] ) ) {
            $this -> uploadFile ();
        } else {
            $this -> firstPage ();
        }

    } // end __construct

    private function albireoCloud ()
    {
        $this -> page [ "title" ] = _( "Albireo Cloud" );
        $this -> page [ "text" ] .= '<p>'._( "Služba Albireo Cloud je nyní intenzivně dokončována, instalujte pravidelně aktulizace." ).'</p>';
    } // end albireoCloud

    private function postData ()
    {
        $data = "";
        foreach ( $_POST as $key => $value ) {
            $data .= "&$key=$value";
        }
        return substr ( $data, 1 );
    } // end postData

    private function securePage ()
    {
        if ( isset ( $_GET [ "webpage" ] ) ) {
            $page = $_GET [ "webpage" ];
            $secure_pages = array ( "acs-prihlaseni", "acs-registrace", "acs-katalog" );
            if ( in_array ( $page, $secure_pages ) ) {
                if ( count ( $_GET ) > 3 ) {
                    $i = 1;
                    $data = "";
                    foreach ( $_GET as $key => $value ) {
                        if ( $i > 3 ) {
                            $data .= "&$key=$value";
                        }
                        ++$i;
                    }
                    $page .= ".xml?". substr ( $data, 1 );
                    //$this -> page [ "text" ] .= $page;
                    return $page;
                }
                return "$page.xml";
            } else return "acs-prihlaseni.xml";
        } else {
            return "acs-prihlaseni.xml";
        }
    } // end securePage

    private function firstPage ()
    {
        $this -> page [ "text" ] .= '<link rel="stylesheet" type="text/css" href="styles/cor-extensions.css" charset="UTF-8" media="screen" />
            <div id="extensionscontrolmenu">
                    <a href="'. Tools::getFullPage () .'?action=albireocloud" onmouseover="$(this).fadeTo(1, 0.7);" onmouseout="$(this).fadeTo(1, 1);" style="text-decoration:none;" class="cor-newstylebutton" title="'. _( "Albireo Cloud" ) .'">
                    <img src="styles/cor-admin/albireocloud.jpg" /><span>'. _( "Albireo Cloud" ) .'</span></a>
                    <a href="#" onmouseover="$(this).fadeTo(1, 0.7);" onmouseout="$(this).fadeTo(1, 1);" style="text-decoration:none;" class="cor-newstylebutton" onclick="ajaxWidthDialogue(\''. Tools::getPage () .'.xml?action=upload\',550);return false;" title="'. _( "Nahrát" ) .'">
                    <img src="styles/cor-admin/install.jpg" /><span>'. _( "Nahrát" ) .'</span></a>
                    <a href="#" onmouseover="$(this).fadeTo(1, 0.7);" onmouseout="$(this).fadeTo(1, 1);" style="text-decoration:none;" class="cor-newstylebutton" onclick="ajaxWidthDialogue(\''. Tools::getPage () .'.xml?action=update\',550);return false;" title="'. _("Aktualizace") .'">
                    <img src="styles/cor-admin/internet.jpg" /><span>'. _( "Aktualizace" ) .'</span></a>
            </div>
            <hr class="cleaner" />
            <span>'._( "Nová rozšíření nebo grafiku vyhledejte pomocí služby Albireo Cloud." ).'<br/>'.
        _( "Před instalací doporučujeme <strong>provést zálohu databáze</strong> a tu stáhnout mimo server." ).'</span><br /><br /><br />
            <h2>'._( "Chat s vývojáři Albirea" ).'</h2>
            <p>'._( "Pokud potřebujete pomoc, radu nebo máte námět pro Albireo nebo nás jen chcete pochválit za naši práci, můžete nás kontaktovat pomocí chatu přímo z Albirea." ).'</p>
            <iframe src="http://www.google.com/talk/service/badge/Show?tk=z01q6amlqnvf3akfbiqiqd1u2uvsp3r6he3o5am3aan5kgnds81ldk6jmftvb6c8n5dfrs682eph4u266uf2mpjfo3tb2e185ceq2unrf1mvu3i45gpss8tc856ohhhuualjpcsva771icm9cot0mss896btmlaat0gvv4ov1nao1cl27rbad9j6pi3pv6c5rqg&amp;w=200&amp;h=60" allowtransparency="true" width="200" frameborder="0" height="60"></iframe>
            <iframe src="http://www.google.com/talk/service/badge/Show?tk=z01q6amlq6rgiqo98n10rgug7akk2uctdsrvp9um8j255gqdjuo76rakdiutuhoctig800llib1c5jgbihuuq6f1cr5cfsfb9m5d8mi7rkmjgh7g46oce2dbdnl1bbeas4gsdcq39gave13164e90bdbs10ct7pb2nn9vsjm0&w=200&h=60" allowtransparency="true" frameborder="0" height="60" width="200"></iframe>
            <hr class="cleaner" />
            <br /><br />';
        $extarray = Database::connection() -> fetchall_assoc ( "SELECT title,description FROM extensions WHERE type='extension';" );
        if ( isset ( $extarray [ 0 ] ) ) {
            $this -> page [ "text" ] .= '<table class="table">
            <caption>'._( "Instalovaná rozšíření" ).'</caption>';
            foreach ( $extarray as $links ) {
                $this -> page [ "text" ] .= '<th>'. $links [ "title" ] .'</th><td>'. $links [ "description" ] .'</td>';
            }
            $this -> page [ "text" ] .= '</table>';
        }

        $extarray = Database::connection() -> fetchall_assoc ( "SELECT title,description FROM extensions WHERE type='skin';" );
        if ( isset ( $extarray [ 0 ] ) ) {
            $this -> page [ "text" ] .= '<table class="table">
            <caption>'._( "Instalované skiny" ).'</caption>';
            foreach ( $extarray as $links ) {
                $this -> page [ "text" ] .= '<tr><th>'. $links [ "title" ] .'</th><td>'. $links [ "description" ] .'</td></tr>';
            }
            $this -> page [ "text" ] .= '</table>';
        }
    } // firstPage

    private function uploadForm ()
    {
        $this -> page [ "title" ] = _( "Nahrát a instalovat" );
        $this -> page [ "text" ] = '
        <form action="'. Tools::getFullPage () .'" method="post" enctype="multipart/form-data">
                <fieldset>
                    <label for="file">'. _( 'Soubor' ) .': </label><input type="file" name="file" /><br />
                    <input type="submit" class="dialoguebutton" value="'. _( "Nahrát a instalovat" ) .'" />
                </fieldset>
        </form>
        <p>'. _( 'Upozorňujeme, že je <strong class="warning">nebezpečné</strong> instalovat cokoli z neověřených zdrojů (může způsobit ztrátu dat nebo kompromitaci serveru). Svá data před instalací raději zálohujte a uložte mimo server.' ) .'</p>
        <input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( 'Zavřít' ) .'" />';
    } // end uploadForm

    private function uploadFile ()
    {

        $files = $_FILES [ "file" ];
        $physicalname = htmlspecialchars ( $files [ "name" ] );
        $type = substr ( strrchr ( $physicalname, "." ), 1 ); // find type of file
        if ( $type != "zip" ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Soubor s rozšířením nemá formát ZIP archivu!" ) .'</strong></p>';
            return;
        }

        if ( !@move_uploaded_file ( $files [ "tmp_name" ],  "temporary/". $physicalname ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Soubor nešlo přesunout do souborové struktury Albirea!" ) .'</strong></p>';
            return;
        }

        $this -> forceInstall = true;
        $this -> install ( $physicalname );

    } // end uploadFile

    private function update ()
    {

        $current = Tools::baseSettings () -> getSetting ( "version" );
        if ( empty ( $current ) ) {
            $current = "20090521235959";
            Tools::baseSettings () -> updateSetting ( "version", "20090521235959" );
        }
        if (!$_GET["f"]) {
            $this -> page [ "text" ] .= "Současná verze Albirea je $current<br />";
        }
        $xml_data = file_get_contents ( "http://ftp.fi.muni.cz/pub/local/albireo/updates.xml" );
        if ( $xml_data == "" ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se načíst obsah aktualizací. Aktualizace nebyly nainstalovány." ) .'</strong></p>';
            return false;
        }
        $DOM = new DOMDocument ();
        if ( !$DOM -> loadXML ( $xml_data ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se načíst informace o aktualizacích jako validní XML dokument. Instalace byla zastavena." ) .'</strong></p>';
            unset ( $xml_data );
            return false;
        }
        unset ( $xml_data );

        $updates = $DOM -> getElementsByTagName("update");
        $count = 0;
        for ( $i=0; $i<$updates->length; $i++ ) {
            $ver = $updates -> item($i) -> getElementsByTagName("version");
            if ($ver -> item (0) -> nodeValue > $current) {
                if ($count == 0) {
                    $update = $ver -> item (0) -> nodeValue.'.zip';
                }
                $count++;
            }
        }
        if (!$_GET["f"]) {
            if ($count==0) {
                $this -> page [ "text" ] .= _( "Všechny aktualizace byly nainstalovány." );
            }
            else {
                $this -> page [ "text" ] .= _( "Přejete si nainstalovat ". $count ." aktualizace?<br />" );
                $this -> page [ "text" ] .= '<input type="button" class="dialoguebutton" onclick="ajaxDialogue(\''. Tools::getPage () .'.xml?action=proceed&pack='.$update.'\');" value="Ano" /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="Ne" />';
            }
        } else {
            $this -> page [ "text" ] .= _( "<h1>Aktualizace byla nainstalována</h1>" );
            if ($count==0) {
                $this -> page [ "text" ] .= _( "Všechny aktualizace byly nainstalovány." );
            }
            else {
                $this -> page [ "text" ] .= '<script>ajaxWidthDialogue(\''. Tools::getPage () .'.xml?action=proceed&pack='.$update.'\',550);</script>';
            }


        }

    } // end update

    private function proceed ()
    {
        $this -> page [ "title" ] = _( "Aktualizuji" );
        $this -> page [ "text" ] = _( "Aktualizuji ".$_GET["pack"] );
        $PackageManager = new PackageManager ();
        $PackageManager -> download ( "ftp.fi.muni.cz", $_GET["pack"] );
        if ($this -> install($_GET["pack"], true)) {
            $this -> page [ "text" ] .= "<script> window.location='".Tools::getPage()."?action=update&f=true' </script>";
        }

    } // end proceed

    private function processManifest ()
    {
        $xml_data = file_get_contents ( "temporary/manifest.xml" );
        if ( $xml_data == "" ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se načíst obsah manifestu nebo je manifest prázdný. Doplněk nebyl nainstalován." ) .'</strong></p>';
            return false;
        }

        $DOM = new DOMDocument ();
        if ( !$DOM -> loadXML ( $xml_data ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Manifest se nepodařilo načíst jako validní XML dokument. Instalace byla zastavena." ) .'</strong></p>';
            unset ( $xml_data );
            return false;
        }
        unset ( $xml_data );

        $unmet_dependencies = array(
            "phpmodules" => array(),
            "packages" => array());

        $modules = $DOM -> getElementsByTagName("module");
        if ( $modules -> item(0) ) {
            for ( $i=0; $i<$modules->length; $i++ ) {
                $module = $modules -> item($i) -> nodeValue;
                if(!empty($module)&&(!extension_loaded($module))){
                    $unmet_dependencies["phpmodules"][] = $module;
                }
            }
        }

        $packageids = $DOM -> getElementsByTagName("packageid");
        if ( $packageids -> item(0) ) {
            for ( $i=0; $i<$packageids->length; $i++ ) {
                $packageid = $packageids -> item($i) -> nodeValue;
                if(!empty($packageid)&&(!extension_loaded($packageid))){
                    $unmet_dependencies["packages"][] = $packageid;
                }
            }
        }

        if ( isset ( $unmet_dependencies["phpmodules"][0] ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Následující PHP moduly je nutné nainstalovat nebo povolit pro instalaci tohoto doplňku. Instalace byla zastavena." ) .'</strong></p>';
            $this -> page [ "text" ] .= '<ul class="warning">';
            foreach ( $unmet_dependencies["phpmodules"] as $module ) {
                $this -> page [ "text" ] .= '<li>'. $module .'</li>';
            }
            $this -> page [ "text" ] .= '</ul>';
            return false;
        }
        if ( isset ( $unmet_dependencies["phpmodules"][0] ) ) {
            $number_of_packages = count ( $unmet_dependencies["phpmodules"] );
            $this -> page [ "text" ] .= '<p><strong class="warning">'. $number_of_packages .' '. _( "balíčků musí být nainstalováno před instalací tohoto doplňku. Instalace byla zastavena." ) .'</strong></p>';
            return false;
        }

        $id = $DOM->getElementsByTagName("id")->item(0)->nodeValue;
        $title = $DOM->getElementsByTagName("title")->item(0)->nodeValue;
        $version = $DOM->getElementsByTagName("version")->item(0)->nodeValue;
        $type = $DOM->getElementsByTagName("type")->item(0)->nodeValue;
        $description = $DOM->getElementsByTagName("description")->item(0)->nodeValue;

        if ( $id == "" || $title == "" || $version == "" || $type == "" || $description == ""  ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Objevila se chyba při zpracovávání manifestu. Instalace byla zastavena." ) .'</strong></p>';
            return false;
        }

        if ( !Database::connection() -> query ( "INSERT INTO extensions (albireoid,title,type,version,description) VALUES ('$id','$title','$type','$version','$description');" ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se vložit záznam o doplňku do databáze. Instalace byla zastavena." ) .'</strong></p>';
            return false;
        }
        unset ( $DOM );
        return true;
    } // end processManifest

    private function install ( $physicalname, $update = false )
    {

        $PackageManager = new PackageManager ();

        chdir ( "temporary" );
        $issue = $PackageManager -> extractZip ( $physicalname );
        chdir ( ".." );

        if ( $issue [ "errors" ] > 0 ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. $issue [ "error messages" ] .'</strong></p>';
            return false;
        }

        if (!update) {
            if ( !file_exists ( "temporary/manifest.xml" ) ) {
                if ( $this -> forceInstall == false ) {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Instalovaný balíček neobsahuje manifest, instalace byla stornována." ) .'</strong></p>';
                    return false;
                } else {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Instalovaný balíček neobsahuje manifest, ale instalace byla přinucena pokračovat.
                                                Záznam o doplňku nebude vložen do databáze." ) .'</strong></p>';
                }
            } else {
                if ( !$this -> processManifest () ) return false;
            }
        }

        if ( file_exists ( "temporary/installer.php" ) ) {
            $PackageManager -> forbidDestruct ();
            require_once ( "temporary/installer.php" );
            $this -> page [ "title" ] = $extension -> page [ "title" ];
            $this -> page [ "text" ] .= $extension -> page [ "text" ];
            return false;
        }

        if ( file_exists ( "temporary/mysql.sql" ) ) {
            $mysql_result = Database::connection () -> sql_from_file ( "temporary/mysql.sql" );
            if ( $mysql_result ) {
                if ( $mysql_result [ "errors" ] > 0 ) {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Během provádění SQL příkazů pro MySQL databázi při instalaci rozšíření se vyskytla chyba." ) .'</strong> '. _( "Počet chyb" ) .' <strong>'. $mysql_result [ "errors" ] .'</strong></p>';
                } else {
                    $this -> page [ "text" ] .= '<p><strong class="success">'. _( "Albireo úspěšně provedlo SQL dotazy na MySQL požadované rozšířením." ) .'</strong></p>';
                }
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Neočekávaná chyba při načítání SQL příkazů pro MySQL databázi při instalaci rozšíření." ) .'</strong></p>';
                return false;
            }
        }

        if ( file_exists ( "temporary/sqlite.sql" ) ) {
            $Settings = new Settings ( $physicalname );
            $sqlite_issue = $Settings -> SQLiteFromFile ( "temporary/sqlite.sql" );
            if ( $sqlite_issue ) {
                if ( $sqlite_issue [ "errors" ] > 0 ) {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Během provádění SQL příkazů pro SQLite databázi při instalaci rozšíření se vyskytla chyba." ) .'</strong> '. _( "Počet chyb" ) .' <strong>'. $sqlite_issue [ "errors" ] .'</strong></p>';
                } else {
                    $this -> page [ "text" ] .= '<p><strong class="success">'. _( "Albireo úspěšně provedlo SQL dotazy na SQlite požadované rozšířením." ) .'</strong></p>';
                }
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Neočekávaná chyba při načítání SQL příkazů pro SQLite databázi při instalaci rozšíření." ) .'</strong></p>';
                return false;
            }
        }

        $issue = $PackageManager -> installPackage ( $physicalname );

        if ( $issue [ "errors" ] > 0 ) {
            if ( $issue [ "installed" ] > 0 ) {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Podařilo se nainstalovat jen některé soubory rozšíření. Mohlo dojít k poškození integrity systému!" ) .'</strong></p>';
                $this -> page [ "text" ] .= $issue [ "error messages" ];
                return false;
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Instalace rozšíření selhala při přesunu souborů v rámci struktury Albirea." ) .'</strong></p>';
                return false;
            }
        } else {
            $this -> page [ "text" ] .= '<p><strong class="success">'. _( "Počet instalovaných souborů:" ) .' '. $issue [ "installed" ] .'</strong></p>';
            $this -> page [ "text" ] .= '<p><a href="#" onclick="$(\'#okmessages\').show(\'slow\');$(this).hide(\'fast\');return false;" title="'. _( "Ukázat seznam instalovaných souborů" ) .'">'. _( "Ukázat seznam instalovaných souborů" ) .'</a></p>';
            $this -> page [ "text" ] .= '<span id="okmessages" class="undisplayed"><div class="actionbar">';
            $this -> page [ "text" ] .= $issue [ "ok messages" ];
            $this -> page [ "text" ] .= '</div></span>';
        }

        $this -> page [ "text" ] .= '<p><strong class="success">'. _( "Doplněk byl nainstalován." ) .'</strong></p>';
        if ($update) {
            Tools::baseSettings() -> updateSetting('version',substr ( $physicalname, 0, -4 ));
        }
        return true;

    } // end install
}

$Extensions = new Extensions ();
$page = $Extensions -> page;
?>