<?php
/* **************************************************************************** *

 * cor-web-contents.php								*
 * @package	Core								*
 * @copyright	Copyright (c) 2008 Martin Novák. All rights reserved		*
 * @license	GNU/AGPL http://www.gnu.org/licenses/agpl.html			*

 * Albireo is free software! You can redistribute it and/or modify it under	*
 * the terms of the GNU Affero General Public License as published		*
 * by the Free Software Foundation, either version 3 of the License, or		*
 * (at your option) any later version.						*

 *	This program is distributed in the hope that it will be useful,		*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the		*
 *	GNU Affero General Public License for more details.			*

 This script description:
 Script for managing structure of articles in Albireo.

 Properties:
    array $page			// contains changes for array $page in ScriptPage
 	
 Public Methods:
    none
 	
 * **************************************************************************** */
require "cor-contents.php";

class WebContents extends Contents {

    public $page = array ( "text" => "" );
    private $corarticles;

    public function __construct ()
    {
    	
    	$this -> corarticles = Localization::session () -> getFile ( "cor-articles", false );
    	
    	if ( isset ( $_GET [ "contentdir" ], $_GET [ "side" ] ) && ( $_GET [ "side" ] == "left" || $_GET [ "side" ] == "right" )  ) {
    	    $this -> page [ "text" ] = $this -> showDir ( $_GET [ "contentdir" ], $_GET [ "side" ] );
    	} else {

	    // gets php code common to all pages of contents
    	    parent::__construct ();
    	    
    	    $this -> page [ "text" ] .= '
	    <script type="text/javascript" src="scripts/tool-man/core.js"></script>
	    <script type="text/javascript" src="scripts/tool-man/events.js"></script>
	    <script type="text/javascript" src="scripts/tool-man/css.js"></script>
	    <script type="text/javascript" src="scripts/tool-man/coordinates.js"></script>
	    <script type="text/javascript" src="scripts/tool-man/drag.js"></script>
	    <script type="text/javascript" src="scripts/tool-man/dragsort.js"></script>
	    <script type="text/javascript" src="scripts/tool-man/cookies.js"></script>
	    <script type="text/javascript" src="scripts/cor-toolman.js"></script>

	    <script type="text/javascript" src="scripts/cor-file-sorting.js.php"></script>
    	    <script type="text/javascript">
		
		function jsquery ( side ) {
		var baseorder = junkdrawer.inspectListOrder ( side +\'SortFiles\');
		var arraysplit = baseorder.split ( "|" );
		for ( var i = 0; i < arraysplit.length; i++ ) {
		    order = arraysplit [ i ];
		    var start = order.indexOf ( ">" );  
		    var end = order.lastIndexOf ( "<" );  
		    order = order.substring ( start+1, end );
		    start = order.indexOf ( ">" );
		    end = order.lastIndexOf ( "<" );
		    arraysplit [ i ] = order.substring ( start+1, end );
		} 
		    finish = arraysplit.join ( "|" );
		    ajaxDialogue ( "'.$this -> corarticles.'.xml?action=sort&list="+finish );
		    endsort ( side );
		}
	    </script>';

    	    if ( isset ( $_GET [ "action" ] ) ) { // creating and editing od articles
    	 	$this -> manageArticle ();
    	    }

        if ( empty ( $_GET [ "action" ] ) || $_GET [ "action" ] != "sort" ) {

	    $leftDirId = ( isset ( $_GET [ "leftdir" ] ) ) ? (int) $_GET [ "leftdir" ] : 2;
	    $rightDirId = ( isset ( $_GET [ "rightdir" ] ) ) ? (int) $_GET [ "rightdir" ] : 2;

	    $this -> page [ "text" ] .= '<script type="text/javascript">
	    directoryContent.leftDirId = '. $leftDirId .';
	    directoryContent.rightDirId = '. $rightDirId .';
	    </script>';

	    $this -> page [ "text" ] .= '<div class="floatLeft">
	    <a href="#" class="cor-button-small cor-filenew" onclick="directoryContent.destroyObjectActions();ajaxWidthDialogue(\''. $this -> corarticles .'.xml?action=newarticle&#038;dirid=\'+directoryContent.leftDirId,800);return false;"><span>'. _( 'Nový článek' ) .'</span></a><br />
	    <a href="#" class="cor-button-small cor-foldernew" onclick="directoryContent.destroyObjectActions();ajaxWidthDialogue(\''. $this -> corarticles .'.xml?action=newfolder&#038;dirid=\'+directoryContent.leftDirId,550);return false;"><span>'. _( 'Nová složka' ) .'</span></a>
		<div id="left-sorting">
		<a href="#" class="cor-button-small cor-order" onclick="sort(\'left\');junkdrawer.restoreListOrder(\'leftSortFiles\');dragsort.makeListSortable(document.getElementById(\'leftSortFiles\'));return false;"><span>'. _( 'Třídit obsah' ) .'</span></a>
		</div>
	    </div>

	    <div class="floatRight">
     	    <a href="#" class="cor-button-small cor-filenew" onclick="directoryContent.destroyObjectActions();ajaxWidthDialogue(\''. $this -> corarticles .'.xml?action=newarticle&#038;dirid=\'+directoryContent.rightDirId,800);return false;"><span>'. _( 'Nový článek' ) .'</span></a><br />
    	    <a href="#" class="cor-button-small cor-foldernew" onclick="directoryContent.destroyObjectActions();ajaxWidthDialogue(\''. $this -> corarticles .'.xml?action=newfolder&#038;dirid=\'+directoryContent.rightDirId,550);return false;"><span>'. _( 'Nová složka' ) .'</span></a>
	    <div id="right-sorting">
	    <a href="#" class="cor-button-small cor-order" onclick="sort(\'right\');junkdrawer.restoreListOrder(\'rightSortFiles\');dragsort.makeListSortable(document.getElementById(\'rightSortFiles\'));return false;"><span>'. _( 'Třídit obsah' ) .'</span></a>
	    </div>
    	    </div>

    	    <div id="cor-contentdir-head" onclick="directoryContent.destroyObjectActions();">
    	    <div class="floatLeft cor-contentdir"><div id="leftContentWindow">'. $this -> showDir ( $leftDirId, "left" ) .'</div></div>
    	    <div class="floatLeft cor-contentdir"><div id="rightContentWindow">'. $this -> showDir ( $rightDirId, "right" ) .'</div></div>
    	    </div>

    	    <img class="invisible" src="styles/cor-admin/folder_open.jpg" alt="hidden part of contents" />
    	    <img class="invisible" src="styles/cor-admin/article-over.jpg" alt="hidden part of contents" />
    	    <img class="invisible" src="styles/cor-admin/filenew-over.jpg" alt="hidden part of contents" />
    	    <img class="invisible" src="styles/cor-admin/order-over.jpg" alt="hidden part of contents" />
    	    <hr class="cleaner" />';
		}

    	}
    } // end __construct

    private function showDir ( $dirNumber, $side )
    {
    	$dirNumber = (int) $dirNumber;
        if ( $dirNumber != 0 ) {
            $parent_dir = Database::connection () -> fetch_assoc ( "SELECT * FROM `directory` WHERE `id`=$dirNumber;" );
            if ( !SecurityTools::check_read ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
                Error::ticket () -> notice ( 'cor00028', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
            $dir_content = Database::connection () -> fetchall_assoc ( "SELECT * FROM `directory` WHERE `parent`=$dirNumber ORDER BY `sequence`;" );
            $article_content = Database::connection () -> fetchall_assoc ( "SELECT * FROM `header` WHERE `directory`=$dirNumber ORDER BY `sequence`;" );
            $draft_content = Database::connection () -> fetchall_assoc ( "SELECT * FROM `drafts` WHERE `directory`=$dirNumber;" );
            $content = '';
            $content .= $this -> createHTMLDir ( $parent_dir, $side, $parent = true );
        } else {
            $parent_dir = Database::connection () -> fetch_assoc ( "SELECT * FROM `directory` WHERE `id` IS NULL;" );
            $dir_content = Database::connection () -> fetchall_assoc ( "SELECT * FROM `directory` WHERE `parent` IS NULL ORDER BY `sequence`;" );
            $article_content = Database::connection () -> fetchall_assoc ( "SELECT * FROM `header` WHERE `directory` IS NULL ORDER BY `sequence`;" );
            $draft_content = Database::connection () -> fetchall_assoc ( "SELECT * FROM `drafts` WHERE `directory` IS NULL;" );
        }

        if ( !is_array ( $dir_content ) && !is_array ( $article_content ) && !is_array ( $draft_content ) ) {
            return $content . _( '<p><strong class="warning">Složka je prázdná...</strong></p>' );
        }
        $content .= '<ul id="'.$side.'SortFiles">';
        if ( is_array ( $dir_content ) ) {
    	    foreach ( $dir_content as $dir ) {
    	    	$content .= $this -> createHTMLDir ( $dir, $side );
    	    }
    	}

    	if ( is_array ( $article_content ) ) {
    	    foreach ( $article_content as $article ) {
    	    	$content .= $this -> createHTMLArticle ( $article, $side );
    	    }
    	}

    	if ( is_array ( $draft_content ) ) {
    	    foreach ( $draft_content as $draft ) {
    	    	$content .= $this -> createHTMLDraft ( $draft, $side );
    	    }
    	}
		$content .= '</ul>';
    	return $content;
    } // end showDir

    private function createHTMLDraft ( $draft, $side ) {
    	if ( !SecurityTools::check_read ( "wr0", $draft [ "author" ], 2 ) ) {
    	    return; // user doesn`t have permission to read this directory
    	}
    	$title = ( strlen ( $draft [ "title" ] ) > 28 || ( strlen ( $draft [ "title" ] ) > 14 && stripos ( substr ( $draft [ "title" ], 0, 12 ), " " ) === false ) ) ? substr ( $draft [ "title" ], 0, 11 ) ."..." : $draft [ "title" ];
    	return '<li class="box"><a href="#" class="cor-button cor-articleDraftButton" onclick="return false;" oncontextmenu="directoryContent.onrightclickActions(event,\'draft\','. $draft [ "id" ] .',\''. $this -> corarticles .'\');return false;" ondblclick="ajaxDialogue(\''. $this -> corarticles .'.xml?action=showdraft&#038;id='. $draft [ "id" ] .'\');"><span>'. $title .'</span></a></li>';
    } // end createHTMLDraft

    private function createHTMLDir ( $dir, $side, $parent = false )
    {
    	if ( !SecurityTools::check_read ( $dir [ "access" ], $dir [ "author" ], $dir [ "groupid" ] ) ) {
    	    return; // user doesn`t have permission to read this directory
    	}
    	if ( $parent == true ) {
            if ( $dir [ "parent" ] == null ) $parent = 0; else $parent = $dir [ "parent" ];
    	    return '<a href="#" class="cor-button cor-dirButton" onclick="return false;" oncontextmenu="return false;" ondblclick="directoryContent.getDirectoryContent(\''.
    	    Tools::getPage () .'.xml?contentdir='. $parent .'&#038;side='. $side. '\',\''. $side .'\','. $parent .');endsort(\''. $side .'\');"><span>'.
    	    _( '..nahoru' ) .'</span></a>';
    	} else {
    	    $title = ( strlen ( $dir [ "title" ] ) > 28 || ( strlen ( $dir [ "title" ] ) > 14 && stripos ( substr ( $dir [ "title" ], 0, 12 ), " " ) === false ) ) ? substr ( $dir [ "title" ], 0, 11 ) ."..." : $dir [ "title" ];
    	    return '<li class="box"><a href="#" class="cor-button cor-dirButton" onclick="return false;" oncontextmenu="directoryContent.onrightclickActions(event,\'directory\','. $dir [ "id" ] .',\''. $this -> corarticles .'\');return false;" ondblclick="directoryContent.getDirectoryContent(\''.
    	    Tools::getPage () .'.xml?contentdir='. $dir [ "id" ] .'&#038;side='. $side. '\',\''. $side .'\','. $dir [ "id" ] .');endsort(\''. $side .'\');"><span>'. $title .'</span></a></li>';
    	}
    } // end createHTMLDir

    private function createHTMLArticle ( $article, $side )
    {
    	if ( !SecurityTools::check_read ( $article [ "access" ], $article [ "author" ], $article [ "groupid" ] ) ) {
    	    return; // user doesn`t have permission to read this article
    	}
    	$title = ( strlen ( $article [ "anchor" ] ) > 28 || ( strlen ( $article [ "anchor" ] ) > 14 && stripos ( substr ( $article [ "anchor" ], 0, 12 ), " " ) === false ) ) ? substr ( $article [ "anchor" ], 0, 11 ) ."..." : $article [ "anchor" ];
    	if ( $article [ "type" ] == "script" ) {
    	    return '<li class="box"><a href="#" class="cor-button cor-articleScriptButton" onclick="return false;" oncontextmenu="directoryContent.onrightclickActions(event,\'article\','. $article [ "id" ] .',\''. $this -> corarticles .'\');return false;" ondblclick="ajaxWidthDialogue(\''.
    	    $this -> corarticles .'.xml?id='. $article [ "id" ] .'\',550);"><span>'. $title .'</span></a></li>';
    	} else {
    	    return '<li class="box"><a href="#" class="cor-button cor-articleButton" onclick="return false;" oncontextmenu="directoryContent.onrightclickActions(event,\'article\','. $article [ "id" ] .',\''. $this -> corarticles .'\');return false;" ondblclick="ajaxWidthDialogue(\''.
    	    $this -> corarticles .'.xml?action=editarticlecontent&#038;id='. $article [ "id" ] .'\',800);"><span>'. $title .'</span></a></li>';
    	}
    } // end createHTMLArticle

    private function manageArticle ()
    {
    	if ( $_GET [ "action" ] == "newarticle" ) {
    	    switch ( $_GET [ "step" ] ) {
    	    	case "step2":
    	    	    $this -> articleBody ();
    	    	    break;
    	    }
    	}
    	if ( $_GET [ "action" ] == "editarticle" ) {
    	    $this -> editArticle ();
    	}
    } // end manageArticle

    private function editArticle () {
    	// access checking ///////////////////////////////////////////////////////////
    	$access_article = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM header WHERE id=". (int) $_GET [ "id" ] .";" );
        if ( !SecurityTools::check_write ( $access_article [ "access" ], $access_article [ "author" ], $access_article [ "groupid" ] ) ) {
            $this -> page [ "text" ] = '<p id="sysmessage" class="undisplayed"><strong class="warning">'. _( "Nemáte povolen zápis do této složky" ) .'!</strong></p>
                                    <script type="text/javascript">$(window).load(function () {$(\'#sysmessage\').fadeIn(500);});setTimeout(function(){$(\'#sysmessage\').fadeOut(500);},10000);</script>';
            return;
        }
        //////////////////////////////////////////////////////////////////////////////

        $title = strip_tags ( $_POST [ "title" ] );
    	$directory = (int) $_POST [ "directory" ];
    	$editorial = strip_tags ( $_POST [ "editorial" ] );
    	$text = $this -> clearTags ( $_POST [ "texts" ] );
        if ( $title == "" ) {
            $this -> page [ "text" ] .= '<p id="subsysmessage" class="undisplayed"><strong class="warning">'. _( "Článek nebyl vytvořen, protože jste nenapsali žádný nadpis článku." ) .'</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#subsysmessage\').fadeIn(500);});setTimeout(function(){$(\'#subsysmessage\').fadeOut(500);},10000);</script>';
            return;
        }

        if ( $editorial == "" && $text != "" ) {
            $begin = strpos( $text, "<p>" );
            $end = strpos ( $text, "</p>", $begin+3 );
            if ( $begin > 0 && $end > $begin ) {
                $editorial = substr ( $text, $begin+3, ($end-($begin+3)) );
            } else {
                $editorial = substr ( strip_tags($text), 0, 255 );
            }
            $editorial = str_replace ( "&nbsp;", " ", $editorial );
        } elseif ( $editorial == "" ) {
            $editorial = $title;
        }
        $anchor = strip_tags ( $_POST [ "anchor" ] );
        if ( $anchor == "" ) $anchor = strtolower ( $title );
        $access = strip_tags ( $_POST [ "access" ] );
        $group = (int) $_POST [ "usergroup" ];
        $file = htmlspecialchars ( $_POST [ "file" ] );
        if ( $file == "" ) $file = strtolower ( $title );
        $bad_chars = array ( " ", "%", "&", "?", ".", ";", ",", "\'", "`", "\"", "á", "ä", "č", "ď", "é", "ě", "í", "ĺ", "ľ", "ň", "ó", "ô", "ŕ", "ř", "š", "ť", "ú", "ů", "ý", "ž" );
        $asci_chars = array ( "-", "", "", "", "", "", "", "", "", "", "a", "a", "c", "d", "e", "e", "i", "l", "l", "n", "o", "o", "r", "r", "s", "t", "u", "u", "y", "z" );
        $file = str_replace ( $bad_chars, $asci_chars, $file );
        $publishdate = $_POST [ "publishdate" ];
        $publishtime = $_POST [ "publishtime" ];
        if( preg_match ( "/^[0-9]{2}\.[0-9]{2}\.[0-9]{4}$/", $publishdate ) ) {
            $publishdatetime = substr ( $publishdate, 6, 4 )."-".substr ( $publishdate, 3, 2 )."-".substr ( $publishdate, 0, 2 );
        } else {
            $publishdatetime = date ( "Y-m-d" );
        }
        if ( preg_match ( "/^[0-9]{2}:[0-9]{2}:[0-9]{2}$/", $publishtime ) ) {
            if ( (int) substr ( $publishtime, 0, 2 ) > 23 || (int) substr ( $publishtime, 3, 2 ) > 59 || (int) substr ( $publishtime, 5, 2 ) > 59 ) {
                $this -> page [ "text" ] .= '<p id="subsysmessage" class="undisplayed"><strong class="warning">'.$publishtime." ". _( "je nevhodný formát času. Zapisujte jej jako hh:mm:ss. Čas změněn na" )." ".date("H:i:s") .'.</strong></p>
                                             <script type="text/javascript">$(window).load(function () {$(\'#subsysmessage\').fadeIn(500);});setTimeout(function(){$(\'#subsysmessage\').fadeOut(500);},10000);</script>';
                $publishdatetime .= " ".date("H:i:s");
            } else {
                $publishdatetime .= " ".$publishtime;
            }
        } else {
            $this -> page [ "text" ] .= '<p id="subsysmessage" class="undisplayed"><strong class="warning">'. _( "Byl zadán nevhodný formát času. Zapisujte jej jako hh:mm:ss. Čas změněn na" ) ." ".date("H:i:s").'.</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#subsysmessage\').fadeIn(500);});setTimeout(function(){$(\'#subsysmessage\').fadeOut(500);},10000);</script>';
            $publishdatetime .= " ".date("H:i:s");
        }

        if ( $doubler = Database::connection () -> getResult ( "SELECT title FROM header WHERE file='$file' AND id<>". (int) $_GET [ "id" ] .";" ) ) {
    	    $this -> page [ "text" ] .= '<p id="sysmessage"><strong class="warning">'. _( "Článek s tímto jménem souboru nebo odkazu již existuje" ) .': '. $doubler .'.</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#sysmessage\').fadeIn(500);});setTimeout(function(){$(\'#sysmessage\').fadeOut(500);},10000);</script>';
    	    return;
        }
        if ( Database::connection () -> query ( "UPDATE header SET title='$title', anchor='$anchor', access='$access', groupid=$group, file='$file', publishtime='$publishdatetime' WHERE id=". (int) $_GET [ "id" ] .";" ) &&
            Database::connection () -> query ( "UPDATE content SET editorial='$editorial', text='$text' WHERE id_header=". (int) $_GET [ "id" ] .";" ) ) {
            $this -> page [ "text" ] .= '<p id="sysmessage" class="undisplayed"><strong class="success">'. _( "Článek byl úspěšně editován" ) .'</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#sysmessage\').fadeIn(500);});setTimeout(function(){$(\'#sysmessage\').fadeOut(500);},6000);</script>';
        } else {
            $this -> page [ "text" ] .= '<p id="sysmessage" class="undisplayed"><strong class="warning">'. _( "Nepodařilo se editovat článek" ) .' '. (int) $_GET [ "id" ] .'.</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#sysmessage\').fadeIn(500);});setTimeout(function(){$(\'#sysmessage\').fadeOut(500);},10000);</script>';
        }
    } // end editArticle

    private function articleBody ()
    {

    	// access checking ///////////////////////////////////////////////////////////
        $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". (int) $_POST [ "directory" ] .";" );
        if ( !SecurityTools::check_write ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
            Error::ticket () -> notice ( 'cor00029', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
        }
        //////////////////////////////////////////////////////////////////////////////

    	$title = strip_tags ( $_POST [ "title" ] );
    	$author = User::session () -> getId ();
    	$directory = (int) $_POST [ "directory" ];
    	$editorial = strip_tags ( $_POST [ "editorial" ] );
    	$text = $this -> clearTags ( addslashes ( $_POST [ "texts" ] ) );
        if ( $title == "" ) {
            $this -> page [ "text" ] .= '<p id="subsysmessage" class="undisplayed"><strong class="warning">'. _( "Článek nebyl vytvořen, protože jste nenapsali žádný nadpis článku." ) .'</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#subsysmessage\').fadeIn(500);});setTimeout(function(){$(\'#subsysmessage\').fadeOut(500);},10000);</script>';
            return;
        }

        if ( $editorial == "" && $text != "" ) {
            $begin = strpos( $text, "<p>" );
            $end = strpos ( $text, "</p>", $begin+3 );
            if ( $begin > 0 && $end > $begin ) {
                $editorial = substr ( $text, $begin+3, ($end-($begin+3)) );
            } else {
                $editorial = substr ( strip_tags($text), 0, 255 );
            }
            $editorial = str_replace ( "&nbsp;", " ", $editorial );
        } elseif ( $editorial == "" ) {
            $editorial = $title;
        }
        $anchor = strip_tags ( $_POST [ "anchor" ] );
        if ( $anchor == "" ) $anchor = strtolower ( $title );
        $access = strip_tags ( $_POST [ "access" ] );
        $group = (int) $_POST [ "usergroup" ];
        $lang = "cs";
        $file = htmlspecialchars ( $_POST [ "file" ] );
        if ( $file == "" ) $file = strtolower ( $title );
        $bad_chars = array ( " ", "%", "&", "?", ".", ";", ",", "\'", "`", "\"", "á", "ä", "č", "ď", "é", "ě", "í", "ĺ", "ľ", "ň", "ó", "ô", "ŕ", "ř", "š", "ť", "ú", "ů", "ý", "ž" );
        $asci_chars   = array ( "-", "", "", "", "", "", "", "", "", "", "a", "a", "c", "d", "e", "e", "i", "l", "l", "n", "o", "o", "r", "r", "s", "t", "u", "u", "y", "z" );
        $file = str_replace ( $bad_chars, $asci_chars, $file );
        $publishdate = $_POST [ "publishdate" ];
        $publishtime = $_POST [ "publishtime" ];
        if( preg_match ( "/^[0-9]{2}\.[0-9]{2}\.[0-9]{4}$/", $publishdate ) ) {
            $publishdatetime = substr ( $publishdate, 6, 4 )."-".substr ( $publishdate, 3, 2 )."-".substr ( $publishdate, 0, 2 );
            if ( date_create ( $publishdatetime ) < date ( "Y-m-d" ) ) {
                $publishdatetime = date ( "Y-m-d" );
            }
        } else {
            $publishdatetime = date ( "Y-m-d" );
        }
        if ( preg_match ( "/^[0-9]{2}:[0-9]{2}:[0-9]{2}$/", $publishtime ) ) {
            if ( (int) substr ( $publishtime, 0, 2 ) > 23 || (int) substr ( $publishtime, 3, 2 ) > 59 || (int) substr ( $publishtime, 5, 2 ) > 59 ) {
                $this -> page [ "text" ] .= '<p id="subsysmessage" class="undisplayed"><strong class="warning">'.$publishtime." ". _( "je nevhodný formát času. Zapisujte jej jako hh:mm:ss. Čas změněn na" )." ".date("H:i:s") .'.</strong></p>
                                             <script type="text/javascript">$(window).load(function () {$(\'#subsysmessage\').fadeIn(500);});setTimeout(function(){$(\'#subsysmessage\').fadeOut(500);},10000);</script>';
                $publishdatetime .= " ".date("H:i:s");
            } else {
                $publishdatetime .= " ".$publishtime;
            }
        } else {
            $this -> page [ "text" ] .= '<p id="subsysmessage" class="undisplayed"><strong class="warning">'. _( "Byl zadán nevhodný formát času. Zapisujte jej jako hh:mm:ss. Čas změněn na" ) ." ".date("H:i:s").'.</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#subsysmessage\').fadeIn(500);});setTimeout(function(){$(\'#subsysmessage\').fadeOut(500);},10000);</script>';
            $publishdatetime .= " ".date("H:i:s");
        }

        if ( $doubler = Database::connection () -> getResult ( "SELECT title FROM header WHERE title='$title' OR file='$file' OR anchor='$anchor';" ) ) {
    	    $this -> page [ "text" ] .= '<p id="sysmessage" class="undisplayed"><strong class="warning">'. _( "Článek s tímto nadpisem nebo jménem souboru nebo odkazu již existuje" ) .': '. $doubler .'.</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#sysmessage\').fadeIn(500);});setTimeout(function(){$(\'#sysmessage\').fadeOut(500);},10000);</script>';
    	    return;
        }

        if ( !Database::connection () -> query ( "INSERT INTO header VALUES ( 0, 'static', '$title', $author, $group, 0, CURRENT_TIMESTAMP(), '$publishdatetime', $directory, '$anchor', '$file', '$access', '$lang', 0 );" ) ||
             !Database::connection () -> query ( "UPDATE header SET sequence=LAST_INSERT_ID() WHERE id=LAST_INSERT_ID();" ) ) {
            $this -> page [ "text" ] .= '<p id="sysmessage" class="undisplayed"><strong class="warning">'. _( "Nepodařilo se vytvořit hlavičku článku." ) .'</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#sysmessage\').fadeIn(500);});setTimeout(function(){$(\'#sysmessage\').fadeOut(500);},10000);</script>';
            return;
        }

        if ( Database::connection () -> query ( "INSERT INTO content VALUES ( LAST_INSERT_ID(), '$editorial', '". stripslashes ( $text ) ."' );" ) ) {
            $this -> page [ "text" ] .= '<p id="sysmessage" class="undisplayed"><strong class="success">'. _( "Článek byl úspěšně vytvořen." ) .'</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#sysmessage\').fadeIn(500);});setTimeout(function(){$(\'#sysmessage\').fadeOut(500);},6000);</script>';
        } else {
            $this -> page [ "text" ] .= '<p id="sysmessage" class="undisplayed"><strong class="warning">'. _( "Nepodařilo se vytvořit obsah článku." ) .'</strong></p>
                                         <script type="text/javascript">$(window).load(function () {$(\'#sysmessage\').fadeIn(500);});setTimeout(function(){$(\'#sysmessage\').fadeOut(500);},10000);</script>';
        }
    } // end articleBody

    function clearTags ( $text )
    {
    	$begin = strpos ( $text, "<!--" );
    	$end = strpos ( $text, "-->", $begin );
    	while ( $begin !== false && $end !== false ) {
    	    $text = substr_replace ( $text, "", $begin, ( $end - $begin + 3 ) );
    	    $begin = strpos ( $text, "<!--" );
    	    $end = strpos ( $text, "-->", $begin );
    	}
    	$begin = strpos ( $text, "<style" );
    	$end = strpos ( $text, "</style>", $begin );
    	while ( $begin !== false && $end !== false ) {
    	    $text = substr_replace ( $text, "", $begin, ( $end - $begin + 8 ) );
 	    $begin = strpos ( $text, "<style" );
    	    $end = strpos ( $text, "</style>", $begin );
    	}
    	$begin = strpos ( $text, "<meta" );
    	$end = strpos ( $text, ">", $begin );
    	while ( $begin !== false && $end !== false ) {
    	    $text = substr_replace ( $text, "", $begin, ( $end - $begin + 1 ) );
	    $begin = strpos ( $text, "<meta" );
    	    $end = strpos ( $text, ">", $begin );
    	}
    	$begin = strpos ( $text, "<link" );
    	$end = strpos ( $text, ">", $begin );
    	while ( $begin !== false && $end !== false ) {
    	    $text = substr_replace ( $text, "", $begin, ( $end - $begin + 1 ) );
	    $begin = strpos ( $text, "<link" );
    	    $end = strpos ( $text, ">", $begin );
    	}
    	$text = str_replace ( "<o:p />", "", $text );
    	return $text;
    } // clearTags

}

$WebContents = new WebContents ();
$page = $WebContents -> page;
?>