/**
 cor-ajax-text-change.js
 @package      Core
 @copyright    Copyright (c) 2007 - 2009 Ragnar.cz. All rights reserved
 @license      GNU/GPL http://www.gnu.org/copyleft/gpl.html

 Albireo is free software!
*/

    function changeIdByGET ( url, id ) {

         $.ajax({
             type: "GET",
             dataType: "html",
             url: url,
             cache: false,
             success: function(html){
    	        changeIdByAjax ( html, id ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
             },
             error: function(html){
    	        ajaxError ( id ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
             }
         });

    }

    function changeIdByPost ( url, formulary, id ) {

    	POSTQuery = getUrlFromFormulary ( formulary );

	// we wait for request 5 seconds
	var successfulEnd = false;
	setTimeout ( function () {
	    successfulEnd = true;
	}, 5000 );
	
         $.ajax({
             type: "POST",
             dataType: "html",
             url: url,
             cache: false,
             data: POSTQuery,
             success: function(html){
    	        changeIdByAjax ( html, id ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
             },
             error: function(html){
    	        ajaxError ( id ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
             }
         });
    }

    function changeDialogueByPost ( url, formulary ) {
    	POSTQuery = getUrlFromFormulary ( formulary );
		
		// we wait for request 5 seconds
		var successfulEnd = false;
		setTimeout ( function () {
			successfulEnd = true;
		}, 5000 );

         $.ajax({
             type: "POST",
             dataType: "html",
             url: url,
             cache: false,
             data: POSTQuery,
             success: function(html){
				changeDialogue ( html );  // function changeIdByAjax comes from scripts/cor-ajax-base.js
             },
             error: function(html){
    	        //ajaxError ( id ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
             }
         });
    }

    function getUrlFromChildren ( formularyInnerNode ) {
	POSTQuery = "";
	for ( i = 0; i < formularyInnerNode.length; i++ ) {
	    if ( formularyInnerNode[i].value ) {
	    	if ( ( formularyInnerNode[i].type != "radio" && formularyInnerNode[i].type != "checkbox" ) ||
	    	    formularyInnerNode[i].checked == true ) {
	    	    	// there isn`t used escape function due to differences between javacript and PHP
	    		POSTQuery += "&" + formularyInnerNode[i].getAttribute( "name" ) + "=" + encodeURIComponent ( formularyInnerNode[i].value );
	    	}
	    } else if ( formularyInnerNode[i].hasChildNodes () && formularyInnerNode[i].childNodes.length > 1 ) {
		POSTQuery += getUrlFromChildren ( formularyInnerNode[i].childNodes );
	    }
	}
	return POSTQuery;
    }

    function getUrlFromFormulary ( formulary ) { // create url from form for Ajax

	POSTQuery = getUrlFromChildren ( document.getElementById ( formulary ).childNodes );
	return POSTQuery.substr ( 1, POSTQuery.length )
	
    }