/**
 cor-content.js
 @package      Core
 @copyright    Copyright (c) 2007 - 2009 Ragnar.cz. All rights reserved
 @license      GNU/GPL http://www.gnu.org/copyleft/gpl.html

 Albireo is free software!
*/
    function getDirectoryContent ( url, whoIsChanged, dirId ) { // gets contents of directories in MySQL database for cor-contents.php

	this.destroyObjectActions ();

    	if ( whoIsChanged == 'left' ) {
    	    // we wait for request 5 seconds
	    this.leftSuccessfulEnd = setTimeout ( function () {
                $( "#leftContentWindow" ).html('<p><strong class="warning">Server sends no response!</strong></p>');
	    }, 5000 );
    	    this.leftDirId = dirId;
    	    $( "#leftContentWindow" ).fadeOut ( 500 );
    	    setTimeout ( function () {
    	    	$( "#leftContentWindow" ).css ( "display", "block" );
                $( "#leftContentWindow" ).html('<img src="styles/cor-admin/loading.gif" class="center" />');
                $.ajax({
                    type: "GET",
                    dataType: "html",
                    url: url,
                    cache: false,
                    success: function(html){
	               clearTimeout ( directoryContent.leftSuccessfulEnd );
	    	       changeIdByAjax ( html, "leftContentWindow" ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
                    },
                    error: function(html){
    	               ajaxError ( "leftContentWindow" ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
                    }
                });
    	    }, 500 );
    	} else {
    	    // we wait for request 5 seconds
	    this.rightSuccessfulEnd = setTimeout ( function () {
                $( "#rightContentWindow" ).html('<p><strong class="warning">Server sends no response!</strong></p>');
	    }, 5000 );
    	    this.rightDirId = dirId;
    	    $( "#rightContentWindow" ).fadeOut ( 500 );
    	    setTimeout ( function () {
    	    	$( "#rightContentWindow" ).css ( "display", "block" );
                $( "#rightContentWindow" ).html('<img src="styles/cor-admin/loading.gif" class="center" />');
                $.ajax({
                    type: "GET",
                    dataType: "html",
                    url: url,
                    cache: false,
                    success: function(html){
	               clearTimeout ( directoryContent.rightSuccessfulEnd );
	    	       changeIdByAjax ( html, "rightContentWindow" ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
                    },
                    error: function(html){
    	               ajaxError ( "rightContentWindow" ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
                    }
                });
    	    }, 500 );
    	}

    }

    function onrightclickActions ( aEvent, type, objectID, pageName )
    {
    	var myEvent = aEvent ? aEvent : window.event;
	if ( myEvent.pageX ) {
      	    X_pos = myEvent.pageX;
            Y_pos = myEvent.pageY;
    	} else {
    	    X_pos = ( myEvent.clientX + document.body.scrollLeft );
    	    Y_pos = ( myEvent.clientY + document.body.scrollTop );
    	}
    	this.objectActions( X_pos, Y_pos, type, objectID, pageName );
    	if (aEvent.stopPropagation) aEvent.stopPropagation ();
	if (aEvent.preventDefault) aEvent.preventDefault ();
    }

    function destroyObjectActions ()
    {
    	clearTimeout ( this.timer );
    	
    	$( "#cor-buttonsWindow" ).remove();
    }
    
    function objectActions ( x, y, type, objectID, pageName )
    {

        this.destroyObjectActions ();
	this.timer = setTimeout ( "this.destroyObjectActions();", 6000 );

        buttons = "<div id='cor-buttonsWindow'>&nbsp;</div>";
        $("body").append(buttons);

  	if ( type != "directory" ) {
            copy = '<a href="#" title="copy" id="articlecopy" class="cor-button-edit cor-articlecopy">&nbsp;</a>';
            $("#cor-buttonsWindow").append(copy);
            $("#articlecopy").click(function () {
                ajaxWidthDialogue(pageName +".xml?action=copy&"+ type +"="+ objectID +"&leftdir="+ directoryContent.leftDirId +"&rightdir="+ directoryContent.rightDirId,550);
                directoryContent.destroyObjectActions();
                return false;
            });
            $("#articlecopy").css("top","-48px");
            $("#articlecopy").hide();
	}
        move = '<a href="#" title="move" id="articlemove" class="cor-button-edit cor-articlemove">&nbsp;</a>';
        $("#cor-buttonsWindow").append(move);
        $("#articlemove").click(function () {
             ajaxWidthDialogue(pageName +".xml?action=move&"+ type +"="+ objectID +"&leftdir="+ directoryContent.leftDirId +"&rightdir="+ directoryContent.rightDirId,550);
             directoryContent.destroyObjectActions();
             return false;
        });
        $("#articlemove").css("top","-75px");
        $("#articlemove").css("left","38px");
        $("#articlemove").hide();

	if ( type != "file" ) {
            info = '<a href="#" title="info" id="articleinfo" class="cor-button-edit cor-articleinfo" >&nbsp;</a>';
            $("#cor-buttonsWindow").append(info);  
	    switch ( type ) {
  	    	case "article":
                $("#articleinfo").click(function () {
                    ajaxWidthDialogue(pageName +".xml?id="+ objectID,550);
                    directoryContent.destroyObjectActions();
                    return false;
                });
  	    	    break;
  	    	case "draft":
                $("#articleinfo").click(function () {
                    ajaxWidthDialogue(pageName +".xml?action=showdraft&id="+ objectID,550);
                    directoryContent.destroyObjectActions();
                    return false;
                });
  	    	    break;
  	    	case "directory":
                $("#articleinfo").click(function () {
                    ajaxWidthDialogue(pageName +".xml?action=showdirinfo&id="+ objectID,550);
                    directoryContent.destroyObjectActions();
                    return false;
                });
  	    	    break;
  	    }
            $("#articleinfo").css("top","-75px");
            $("#articleinfo").css("left","38px");
            $("#articleinfo").hide();
	}
	trash = '<a href="#" title="delete" id="articledelete" class="cor-button-edit cor-articledelete">&nbsp;</a>';
        $("#cor-buttonsWindow").append(trash);
        $("#articledelete").click(function () {
             ajaxWidthDialogue(pageName +".xml?action=delete1&"+ type +"="+ objectID,550);
             directoryContent.destroyObjectActions();
             return false;
        });
        $("#articledelete").css("top","-99px");
        $("#articledelete").hide();

	var invisiblebutton1 = '<img class="invisible" src="styles/cor-admin/copy-over.gif" alt="hidden part of content" />';
	var invisiblebutton2 = '<img class="invisible" src="styles/cor-admin/move-over.gif" alt="hidden part of content" />';
	var invisiblebutton3 = '<img class="invisible" src="styles/cor-admin/info-over.gif" alt="hidden part of content" />';
	var invisiblebutton4 = '<img class="invisible" src="styles/cor-admin/delete-over.gif" alt="hidden part of content" />';
        $("#cor-buttonsWindow").append(invisiblebutton1);
        $("#cor-buttonsWindow").append(invisiblebutton2);
        $("#cor-buttonsWindow").append(invisiblebutton3);
        $("#cor-buttonsWindow").append(invisiblebutton4);

        $("#cor-buttonsWindow").css("top", ( y - 25 ) +"px");
  	if ( type == "directory" ) { 
            $("#cor buttonsWindow").css("top", ( y + 25 ) +"px");
            $("#articlemove").css("left", "0px");
            $("#articleinfo").css("top", "-85px"); 
        }
        $("#cor-buttonsWindow").css("left",( x - 25 ) +"px");
  	if ( type == "file" ) {
            $("#cor=-buttonsWindow").css("top", ( y + 25 ) +"px");
            $("#articlemove").css("top", "-85px");
            $("#articlecopy").css("top", "-75px");
        }

  	var time = 0;
  	if ( type != "directory" ) {
  	    setTimeout ( function () { $( "#articlecopy" ).fadeIn ( 500 ) }, time );
  	    time += 250;
  	}
  	setTimeout ( function () { $( "#articlemove" ).fadeIn ( 500 ) }, time );
  	time += 250;
  	if ( type != "file" ) {
  	    setTimeout ( function () { $( "#articleinfo" ).fadeIn ( 500 ) }, time );
  	    time += 250;
  	}
  	setTimeout ( function () { $( "#articledelete" ).fadeIn ( 500 ) }, time );
    }

    function reloadContent ( pageName )
    {
	this.getDirectoryContent ( "xml.php?page="+ pageName +"&contentdir="+ this.leftDirId +"&side=left", 'left', this.leftDirId );
	this.getDirectoryContent ( "xml.php?page="+ pageName +"&contentdir="+ this.rightDirId +"&side=right", 'right', this.rightDirId );
    }

    function directoryContent ()
    {
    	this.timer; // for destroying actions button
    	this.leftSuccessfulEnd;
    	this.rightSuccessfulEnd;
    	this.leftDirId = 0;
    	this.rightDirId = 0;
    	this.getDirectoryContent = getDirectoryContent;
    	this.objectActions = objectActions;
    	this.onrightclickActions = onrightclickActions;
    	this.destroyObjectActions = destroyObjectActions;
    	this.reloadContent = reloadContent;
    }

    var directoryContent = new directoryContent ();

    function changeAccessInformation ( access, textTagId ) {
        var infoText = "";
    	switch ( access ) {
    	    case "wwr":
    	    	infoText = "<strong class=\"success\"><?php echo _( "Autor a skupina mohou zapisovat a ostatní mohou číst." ); ?></strong>";
    	        break;
    	    case "ww0":
    	    	infoText = "<strong class=\"success\"><?php echo _( "Autor a skupina mohou zapisovat a ostatní nemohou nic." ); ?></strong>";
    	        break;
    	    case "wrr":
    	    	infoText = "<strong class=\"success\"><?php echo _( "Autor může zapisovat a skupina a ostatní mohou číst." ); ?></strong>";
    	        break;
    	    case "wr0":
    	    	infoText = "<strong class=\"success\"><?php echo _( "Autor může zapisovat, skupina může číst a ostatní nemohou nic." ); ?></strong>";
    	        break;
    	    case "w00":
    	    	infoText = "<strong class=\"success\"><?php echo _( "Autor může zapisovat a skupina a ostatní nemohou nic." ); ?></strong>";
    	        break;
    	    default:
    	   	infoText = "<strong class=\"warning\"><?php echo _( "Neznámá hodnota:" ); ?> "+ access +"</strong>";
    	}
    	document.getElementById ( textTagId ).innerHTML = infoText;
    }

    function clearfile (file) {
        fileValue = $("#"+file).val();
        fileValue = fileValue.toLowerCase();
        fileValue = fileValue.replace(/ /g,"-");
        fileValue = fileValue.replace(/%/g,"");
        fileValue = fileValue.replace(/\&/g,"");
        fileValue = fileValue.replace(/\?/g,"");
        fileValue = fileValue.replace(/\./g,"");
        fileValue = fileValue.replace(/,/g,"");
        fileValue = fileValue.replace(/`/g,"");
        fileValue = fileValue.replace(/"/g,"");
        fileValue = fileValue.replace(/'/g,"");
        fileValue = fileValue.replace(/;/g,"");
        fileValue = fileValue.replace(/á/g,"a");
        fileValue = fileValue.replace(/ä/g,"a");
        fileValue = fileValue.replace(/ě/g,"e");
        fileValue = fileValue.replace(/ĺ/g,"l");
        fileValue = fileValue.replace(/ľ/g,"l");
        fileValue = fileValue.replace(/ô/g,"o");
        fileValue = fileValue.replace(/š/g,"s");
        fileValue = fileValue.replace(/č/g,"c");
        fileValue = fileValue.replace(/ŕ/g,"r");
        fileValue = fileValue.replace(/ř/g,"r");
        fileValue = fileValue.replace(/ž/g,"z");
        fileValue = fileValue.replace(/ý/g,"y");
        fileValue = fileValue.replace(/í/g,"i");
        fileValue = fileValue.replace(/é/g,"e");
        fileValue = fileValue.replace(/ú/g,"u");
        fileValue = fileValue.replace(/ů/g,"u");
        fileValue = fileValue.replace(/ď/g,"d");
        fileValue = fileValue.replace(/ť/g,"t");
        fileValue = fileValue.replace(/ň/g,"n");
        $("#"+file).val(fileValue);
    }

    function articleTitle ( title, anchor, file ) {
        titleValue = $("#"+title).val();
        $("#"+anchor).val(titleValue);
        $("#"+file).val(titleValue);
        clearfile(file);
    }