/**
 cor-dialogue-window.js
 @package      Core
 @copyright    Copyright (c) 2007 - 2009 Ragnar.cz. All rights reserved
 @license      GNU/GPL http://www.gnu.org/copyleft/gpl.html

 Albireo is free software!
*/
	var w = 800;
    function ajaxDialogue ( dest ) { // creates dialogue with answer based on Ajax throught GET
        $( "#dialogueWindow" ).dialog( "option", "hide", "" );
        $( "#dialogueWindow" ).dialog("close");
        $( "#dialogueWindow" ).remove();
    	dialogueWindow ( "Albireo", '<img src="styles/cor-admin/loading.gif" class="center" /><br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="OK" />' );

		// we wait for request 5 seconds
		var successfulEnd = setTimeout ( function () {
			$("#dialogueWindow").html('<p><strong class="warning">Server sends no response!</strong></p>');
		}, 10000 );

         $.ajax({
             type: "GET",
             dataType: "html",
             url: dest,
             cache: false,
             success: function(html){
    	    	clearTimeout ( successfulEnd );			 
				changeDialogue ( html ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
             },
             error: function(html){
   	          $("#dialogueWindow").html( '<p>Error in communicating with server: '
	    	    +'</p><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="OK" />');
             }
         });		
    }
	
    function ajaxWidthDialogue ( dest, myw ) { // creates dialogue with answer based on Ajax throught GET
		w = myw;
        ajaxDialogue(dest);
    }
	
    function changeDialogue ( html ) {
        $( "#dialogueWindow" ).dialog( "option", "hide", "" );
        $("#dialogueWindow").dialog('close');
        $("#dialogueWindow").remove();
        $("body").append("<div id='dialogueWindow' class='flora'></div>");
	// we are working with xml as text because the world isn`t prepared for pure valid xml
	if ( html.indexOf ( "<body>" ) ) {
        $("#dialogueWindow").html(html.substring ( html.indexOf ( "<body>" )+6, html.indexOf ( "</body>" ) ) );
        $("#dialogueWindow").attr("title", html.substring ( html.indexOf ( "<title>" )+7, html.indexOf ( "</title>" ) ));
	} else {
	     $("#dialogueWindow").html( '<p><strong class="warning">Response has no contents!</strong></p><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="OK" />');
	}

        $("#dialogueWindow").dialog({ width: w, hide: "explode" });
        dialogueButtons();
    }

    function dialogueWindow ( title, content ) { // creates html of dialogue window
        $( "#dialogueWindow" ).remove();
        $("body").append("<div id='dialogueWindow' class='flora' title='"+title+"'>"+content+"</div>");
        $("#dialogueWindow").dialog({ width: w, hide: "explode" });
        dialogueButtons();
    }

    function closeDialogueWindow () { // close dialogue window
        if ($( "#dialogueWindow" ).dialog("isOpen")) {
            $( "#dialogueWindow" ).dialog("close");
            $( "#dialogueWindow" ).remove();
        }
    }

    $(document).keyup(function(event){
        if (event.keyCode == 27) {
            closeDialogueWindow ();
        }
    });

    function confirmDialogue ( title, text, dest ) { // creates confirm dialogue
        w = 550;
    	var diaText = '<p>' + text + '</p><input type="button" class="dialoguebutton" onclick="window.location=\''+ dest +'\';" value="Ano" /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="Ne" />';
    	dialogueWindow ( title, diaText );
    	return false;
    }
	
    function okDialogue ( title, text ) { // creates dialogue with OK button
        w = 550;
        var diaText = '<p>' + text + '</p><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="OK" />';
        dialogueWindow ( title, diaText );
    	return false;
    }

    function dialogueButtons () {
        $(".dialoguebutton").css("height","30px");
        $(".dialoguebutton").css("width","200px");
        $(".dialoguebutton").css("margin","10px 0px 5px 0px");
        $(".dialoguebutton").css("text-align","center");
        $(".dialoguebutton").css("background","#0078ae url(styles/jquerytheme/images/ui-bg_glass_45_0078ae_1x400.png) 50% 50% repeat-x");
        $(".dialoguebutton").css("border","1px solid #77d5f7");
        $(".dialoguebutton").css("color","#fff");
        $(".dialoguebutton").css("cursor","hand");
        $(".dialoguebutton").css("cursor","pointer");
        $(".dialoguebutton").mouseover(function(event){
            $(event.target).css("border","1px solid #448dae");
            $(event.target).css("background","#79c9ec url(styles/jquerytheme/images/ui-bg_glass_75_79c9ec_1x400.png) 50% 50% repeat-x");
            $(event.target).css("color","#026890");
        }).mouseout(function(event){
            $(event.target).css("border","1px solid #77d5f7");
            $(event.target).css("background","#0078ae url(styles/jquerytheme/images/ui-bg_glass_45_0078ae_1x400.png) 50% 50% repeat-x");
            $(event.target).css("color","#fff");
        });
    }