/**
 cor-youtubevideo.js
 @package      Core
 @copyright    Copyright (c) 2007 - 2009 Ragnar.cz. All rights reserved
 @license      GNU/GPL http://www.gnu.org/copyleft/gpl.html

 Albireo is free software!
*/

function showVideo ( link, width ) {
    switch ( width ) {
        case 480:
            height = 295;
            break;
        case 560:
            height = 340;
            break;
        case 640:
            height = 385;
            break;
        case 853:
            height = 505;
            break;
        default:
            width = 560;
            height = 340;
    }
    $( "body" ).append ( '<div id="youtubepagecover">&nbsp;</div>' );
    $( "#youtubepagecover" ).css ( "position", "absolute" );
    $( "#youtubepagecover" ).css ( "left", "0px" );
    $( "#youtubepagecover" ).css ( "top", "0px" );
    $( "#youtubepagecover" ).css ( "text-align", "center" );
    $( "#youtubepagecover" ).css ( "background-color", "black" );
    $( "#youtubepagecover" ).width ( $( "body" ).width () );
	$( "#youtubepagecover" ).height ( $( "body" ).height () );
    $( "#youtubepagecover" ).fadeTo ( 0, 0.0 );
    $( "#youtubepagecover" ).fadeTo ( 500, 0.9 );
    setTimeout ( function () {
        generateYouTubeBody ( link, width, height );
    }, 500 );
    $( "#youtubepagecover" ).click ( function () {
        destroyVideo ();
    });
}
function generateYouTubeBody ( link, width, height ) {
    indexOfVArg = link.indexOf('v=');
	vid = link.substring(indexOfVArg+2,(link.indexOf('&',indexOfVArg)!=-1 ? link.indexOf('&',indexOfVArg) : link.length ));
    youtubebody = '<div id="youtubepagecoverinside">\n\
    <object width="'+width+'" height="'+height+'">\n\
        <param name="movie" value="http://www.youtube.com/v/'+vid+'&hl=cs&fs=1&rel=0" />\n\
        <param name="allowFullScreen" value="true" />\n\
        <param name="allowscriptaccess" value="always" />\n\
        <embed src="http://www.youtube.com/v/'+vid+'&hl=cs&fs=1&rel=0" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" width="'+width+'" height="'+height+'"></embed>\n\
    </object>\n\
    <p>Velikost videa: <a href="#" onclick="changeVideoSize(\''+link+'\',480,295);return false;" title="480x295">480x295</a> |\n\
    <a href="#" onclick="changeVideoSize(\''+link+'\',560,340);return false;" title="560x340">560x340</a> |\n\
    <a href="#" onclick="changeVideoSize(\''+link+'\',640,385);return false;" title="640x385">640x385</a> |\n\
    <a href="#" onclick="changeVideoSize(\''+link+'\',853,505);return false;" title="853x505">853x505</a><br />\n\
       Sledovat na YouTube: <a href="'+link+'" title="YouTube">'+link+'</a></p>\n\
    </div>';
    $( "body" ).append ( youtubebody );
    $( "#youtubepagecoverinside" ).css ( "width", width );
    $( "#youtubepagecoverinside" ).css ( "color", "#fff" );
    $( "#youtubepagecoverinside" ).css ( "position", "absolute" );
    innerWidth = ( window.innerWidth ) ? window.innerWidth : document.documentElement.clientWidth;
    innerHeight = ( window.innerHeight ) ? window.innerHeight : document.documentElement.clientHeight;
    scrolledFromTop = (document.all) ? document.body.scrollTop : window.pageYOffset;
    scrOfX = 0;
    scrOfY = 0;
    if( typeof( window.pageYOffset ) == 'number' ) {
        scrOfY = window.pageYOffset;
        scrOfX = window.pageXOffset;
    } else if( document.body.scrollTop ) {
        scrOfY = document.body.scrollTop;
        scrOfX = document.body.scrollLeft;
    } else if( document.documentElement.scrollTop ) {
        scrOfY = document.documentElement.scrollTop;
        scrOfX = document.documentElement.scrollLeft;
    }
    $( "#youtubepagecoverinside" ).css ( "left", ( innerWidth - width ) / 2 + scrOfX );
    $( "#youtubepagecoverinside" ).css ( "top", ( innerHeight - height ) / 2 + scrOfY );
    var YouTubePVisible = false;
    setTimeout ( function () {
        if ( YouTubePVisible == false ) {
            $( "#youtubepagecoverinside > p" ).fadeTo ( 250, 0 );
        }
    }, 10000 );
    $( "#youtubepagecoverinside > p" ).mouseover ( function () {
        YouTubePVisible = true;
        $( "#youtubepagecoverinside > p" ).fadeTo ( 250, 1 );
    });
    $( "#youtubepagecoverinside > p" ).mouseout ( function () {
        YouTubePVisible = false;
        setTimeout ( function () {
            if ( YouTubePVisible == false ) {
                $( "#youtubepagecoverinside > p" ).fadeTo ( 250, 0.0 );
            }
        }, 5000 );
    });
}
function destroyVideo () {
    $( "#youtubepagecoverinside" ).remove ();
    $( this ).fadeTo ( 500, 0.0 );
    setTimeout ( function () {
        $( "#youtubepagecover" ).remove ();
    }, 500 );
}
function changeVideoSize ( link, width, height ) {
    $( "#youtubepagecoverinside" ).remove ();
    generateYouTubeBody ( link, width, height );
}