CREATE TABLE IF NOT EXISTS `comments` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `headerid` INT(10) UNSIGNED NOT NULL ,
  `time` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ,
  `userid` INT(10) UNSIGNED DEFAULT NULL ,
  `ip` CHAR(15) NOT NULL ,
  `host` VARCHAR(255) NOT NULL ,
  `agent` VARCHAR(255) NOT NULL ,
  `name` VARCHAR(255) NOT NULL ,
  `email` VARCHAR(255) DEFAULT NULL ,
  `text` TEXT NOT NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `comments users` (`userid` ASC) ,
  INDEX `comments articles` (`headerid` ASC) ,
  CONSTRAINT `comments articles`
	FOREIGN KEY (`headerid` )
	REFERENCES `header` (`id` )
	ON DELETE CASCADE
	ON UPDATE NO ACTION,
  CONSTRAINT `comments users`
	FOREIGN KEY (`userid` )
	REFERENCES `users` (`id` )
	ON DELETE SET NULL
	ON UPDATE NO ACTION)
ENGINE = InnoDB
DEFAULT CHARSET = utf8
COLLATE = utf8_general_ci;

INSERT INTO `header` (`type`,`title`,`author`,`groupid`,`authorizedby`,`publishtime`,`directory`,`anchor`,`file`,`access`,`lang`) VALUES
(  'script', 'Komentáře článků', 1, 1, 1, CURRENT_TIMESTAMP(), 2, 'Komentáře článků', 'cor-comments', 'wrr', 'cs' );
INSERT INTO `content` (`id_header`,`editorial`) VALUES ( LAST_INSERT_ID(), 'Komentáře článků' );
INSERT INTO `scriptpages` (`id_header`,`script`) VALUES ( LAST_INSERT_ID(), 'cor-comments' );