<?php
/* **************************************************************************** *

 * cor-articles.php								*
 * @package	Core								*
 * @copyright	Copyright (c) 2008 Martin Novák. All rights reserved		*
 * @license	GNU/AGPL http://www.gnu.org/licenses/agpl.html			*

 * Albireo is free software! You can redistribute it and/or modify it under	*
 * the terms of the GNU Affero General Public License as published		*
 * by the Free Software Foundation, either version 3 of the License, or		*
 * (at your option) any later version.						*

 *	This program is distributed in the hope that it will be useful,		*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the		*
 *	GNU Affero General Public License for more details.			*

 This script description:
 Page for managing articles of Albireo.

 Properties:
    array $page			// contains changes for array $page in ScriptPage

 Public Methods:
    none

 * **************************************************************************** */

class Articles {

    public $page = array ( "text" => "" );
    private $browser;

    public function __construct ()
    {
        $this -> browser = Localization::session () -> getFile ( "cor-browser", false );
        switch ( $_REQUEST [ "action" ] ) {
            case "text":
                $this -> showText ();
                break;
            case "showdraft":
                $this -> showDraft ();
                break;
            case "showdirinfo":
                $this -> showDir ();
                break;
            case "checkuniqueness":
                $this -> checkUniqueness ();
                break;
            case "articleextension":
                $this -> articleExtension ();
                break;
            case "newarticle":
                $this -> articleHeader ();
                break;
            case "articlestep2":
                $this -> articleStep2 ();
                break;
            case "createarticle":
                $this -> createarticle ();
                break;
            case "savedraft";
                $this -> saveDraft ();
                break;
            case "newfolder":
            case "editdirectory":
                $this -> folderEditor ();
                break;
            case "createfolder":
                $this -> createFolder ();
                break;
            case "copy":
                $this -> copyIt ();
                break;
            case "move":
                $this -> moveIt ();
                break;
            case "delete1":
                $this -> reallyDelete ();
                break;
            case "delete2":
                $this -> deleteIt ();
                break;
            case "editarticlecontent":
                $this -> articleHeader ();
                break;
            case "sort":
                $this -> sort ();
                break;
            default:
                $this -> page [ "text" ] .= $this -> showArticle ();
        }

    } // end __construct

    private function reallyDelete ()
    {
        $this -> page [ "title" ] = _( "Smazat" );
        $type = ( !empty ( $_GET [ "article" ] ) ) ? "article" : ( !empty ( $_GET [ "draft" ] ) ? "draft" : "directory" );
        if ( $type == "directory" && ( (int) $_GET [ $type ] == 1 || (int) $_GET [ $type ] == 2 ) ) {
            $this -> page [ "text" ] .= "<p><strong class=\"warning\">". _( "Nemůžete mazat složky WWW a Administrace!" ) ."</strong></p>";
            return;
        }
        if ( $type == "directory" ) {
            $objects_inside = Database::connection () -> getResult ( "SELECT (SELECT COUNT(*) FROM header WHERE directory=". (int) $_GET [ "directory" ] .") +
                                                            (SELECT COUNT(*) FROM drafts WHERE directory=". (int) $_GET [ "directory" ] .") +
                                                            (SELECT COUNT(*) FROM directory WHERE parent=". (int) $_GET [ "directory" ] .");" );
            if ( $objects_inside > 0 ) {
                $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Složka není prázdná, nelze ji proto smazat" ) .'!</strong></p>';
                return;
            }
        }
        $this -> page [ "text" ] .= "<p>". _( "Opravdu si přejete tento objekt vymazat?" ) ."</p>";
        $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="changeWidthDialogueByGET(\''. Tools::getPage () .'.xml?action=delete2&#038;'. $type .'='. (int) $_GET [ $type ] .'\',550);" value="'. _( "ano" ) .'" /> <input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "ne" ) .'" />';
    } // end reallyDelete

    private function deleteIt ()
    {
        $this -> page [ "title" ] = _( "Smazat" );

        $successfuldelete = "<p>". _( "Smazání proběhlo úspěšně." ) ."</p>";
        $unsuccessfuldelete = '<p><strong class="warning">'. _( "Smazání se nezdařilo." ) ."</strong>"."</p>";

        if ( !empty ( $_GET [ "article" ] ) ) {
            // access checking ///////////////////////////////////////////////////////////
            $article = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM header WHERE id=". (int) $_GET [ "article" ] .";" );
            if ( !SecurityTools::check_write ( $article [ "access" ], $article [ "author" ], $article [ "groupid" ] ) ) {
                $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povoleno mazání tohoto souboru" ) .'!</strong></p>';
                return;
            }
            //////////////////////////////////////////////////////////////////////////////
            if ( Database::connection () -> query ( "DELETE FROM header WHERE id=". (int) $_GET [ "article" ] .";" ) && Database::connection () -> query ( "DELETE FROM content WHERE id_header=". (int) $_GET [ "article" ] .";" ) ) {
                $this -> page [ "text" ] .= $successfuldelete;
            } else {
                $this -> page [ "text" ] .= $unsuccessfuldelete;
            }
        } elseif ( !empty ( $_GET [ "draft" ] ) ) {
            // access checking ///////////////////////////////////////////////////////////
            if ( !SecurityTools::check_write ( "wr0", Database::connection () -> getResult ( "SELECT author from drafts WHERE id=". (int) $_GET [ "draft" ] .";" ), 2 ) ) {
                $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povoleno mazání tohoto souboru" ) .'!</strong></p>';
                return;
            }
            //////////////////////////////////////////////////////////////////////////////
            if ( Database::connection () -> query ( "DELETE FROM drafts WHERE id=". (int) $_GET [ "draft" ] .";" ) ) {
                $this -> page [ "text" ] .= $successfuldelete;
            } else {
                $this -> page [ "text" ] .= $unsuccessfuldelete;
            }
        } elseif ( !empty ( $_GET [ "directory" ] ) ) {
            if ( (int) $_GET [ "directory" ] == 1 || (int) $_GET [ "directory" ] == 2 ) {
                $this -> page [ "text" ] .= "<p><strong class=\"warning\">". _( "Nemůžete mazat složky WWW a Administrace!" ) ."</strong></p>";
                return;
            }
            // access checking ///////////////////////////////////////////////////////////
            $directory = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". (int) $_GET [ "directory" ] .";" );
            if ( !SecurityTools::check_write ( $directory [ "access" ], $directory [ "author" ], $directory [ "groupid" ] ) ) {
                $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povoleno mazání tohoto souboru" ) .'!</strong></p>';
                return;
            }
            //////////////////////////////////////////////////////////////////////////////
            $objects_inside = Database::connection () -> getResult ( "SELECT (SELECT COUNT(*) FROM header WHERE directory=". (int) $_GET [ "directory" ] .") +
                                                            (SELECT COUNT(*) FROM drafts WHERE directory=". (int) $_GET [ "directory" ] .") +
                                                            (SELECT COUNT(*) FROM directory WHERE parent=". (int) $_GET [ "directory" ] .");" );
            if ( $objects_inside > 0 ) {
                $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Složka není prázdná, nelze ji proto smazat" ) .'!</strong></p>';
                return;
            }
            if ( Database::connection () -> query ( "DELETE FROM directory WHERE id=". (int) $_GET [ "directory" ] .";" ) ) {
                $this -> page [ "text" ] .= $successfuldelete;
            } else {
                $this -> page [ "text" ] .= $unsuccessfuldelete;
            }
        }

        $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="directoryContent.reloadContent(\''. Localization::session () -> getFile ( "cor-web-contents", false ) .'\');closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
    } // end deleteIt

    private function moveArticle ( $target_dir ) {
        if ( (int) $target_dir == 0 ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nelze provádět přesun do kořenové složky." ) .'</strong></p>';
            return;
        }
        // access checking ///////////////////////////////////////////////////////////
        $access_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". (int) $target_dir .";" );
        if ( !SecurityTools::check_write ( $access_dir [ "access" ], $access_dir [ "author" ], $access_dir [ "groupid" ] ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povolen zápis do této složky" ) .'!</strong></p>';
            return;
        }
        $access_object = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM header WHERE id=". (int) $_GET [ "article" ] .";" );
        if ( !SecurityTools::check_write ( $access_object [ "access" ], $access_object [ "author" ], $access_object [ "groupid" ] ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povoleno přesunování tohoto souboru" ) .'!</strong></p>';
            return;
        }
        //////////////////////////////////////////////////////////////////////////////
        if ( Database::connection () -> query ( "UPDATE header SET directory=". (int) $target_dir ." WHERE id=". (int) $_GET [ "article" ] .";" ) ) {
            $this -> page [ "text" ] .= "<p>". _( "Přesun článku proběhl úspěšně." ) ."</p>";
        } else {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Přesun článku se nezdařil." ) ."</strong>"."</p>";
        }
    } // end moveArticle

    private function moveDraft ( $target_dir ) {
        if ( (int) $target_dir == 0 ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nelze provádět přesun do kořenové složky." ) .'</strong></p>';
            return;
        }
        // access checking ///////////////////////////////////////////////////////////
        $access_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". (int) $target_dir .";" );
        if ( !SecurityTools::check_write ( $access_dir [ "access" ], $access_dir [ "author" ], $access_dir [ "groupid" ] ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povolen zápis do této složky" ) .'!</strong></p>';
            return;
        }
        $draft_author = Database::connection () -> getResult ( "SELECT author FROM drafts WHERE id=". (int) $_GET [ "draft" ] .";" );
        if ( !SecurityTools::check_write ( "wr0", $draft_author, 2 ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povoleno přesunování tohoto souboru" ) .'!</strong></p>';
            return;
        }
        //////////////////////////////////////////////////////////////////////////////
        if ( Database::connection () -> query ( "UPDATE drafts SET directory=". (int) $target_dir ." WHERE id=". (int) $_GET [ "draft" ] .";" ) ) {
            $this -> page [ "text" ] .= "<p>". _( "Přesun konceptu proběhl úspěšně." ) ."</p>";
        } else {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Přesun konceptu se nezdařil." ) ."</strong>"."</p>";
        }
    } // end moveDraft

    private function moveDirectory ( $target_dir ) {
        if ( (int) $target_dir == 0 ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nelze provádět přesun do kořenové složky." ) .'</strong></p>';
            return;
        }
        if ( (int) $_GET [ "directory" ] == 1 || (int) $_GET [ "directory" ] == 2 ) {
            $this -> page [ "text" ] .= "<p><strong class=\"warning\">". _( "Nemůžete přesouvat složky WWW a Administrace!" ) ."</strong></p>";
            return;
        }
        if ( (int) $_GET [ "directory" ] == $target_dir ) {
            $this -> page [ "text" ] .= "<p><strong class=\"warning\">". _( "Nemůžete složku přesunout samu do sebe!" ) ."</strong></p>";
            return;
        }
        // access checking ///////////////////////////////////////////////////////////
        $access_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". (int) $target_dir .";" );
        if ( !SecurityTools::check_write ( $access_dir [ "access" ], $access_dir [ "author" ], $access_dir [ "groupid" ] ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povolen zápis do této složky" ) .'!</strong></p>';
            return;
        }
        $access_object = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". (int) $_GET [ "directory" ] .";" );
        if ( !SecurityTools::check_write ( $access_object [ "access" ], $access_object [ "author" ], $access_object [ "groupid" ] ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povoleno přesunování tohoto souboru" ) .'!</strong></p>';
            return;
        }
        //////////////////////////////////////////////////////////////////////////////
        if ( Database::connection () -> query ( "UPDATE directory SET parent=". (int) $target_dir ." WHERE id=". (int) $_GET [ "directory" ] .";" ) ) {
            $this -> page [ "text" ] .= "<p>". _( "Přesun složky proběhl úspěšně." ) ."</p>";
        } else {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Přesun složky se nezdařil." ) ."</strong>"."</p>";
        }
    } // end moveDirectory

    private function moveIt ()
    {
        $this -> page [ "title" ] = _( "Přesun" );

        $successfulmove = "<p>". _( "Přesun proběhl úspěšně." ) ."</p>";
        $unsuccessfulmove = '<p><strong class="warning">'. _( "Přesun se nezdařil." ) ."</strong>"."</p>";

        if ( $_GET [ "leftdir" ] == $_GET [ "rightdir" ] ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nelze přesouvat ve stejných složkách." ) .'</strong></p>';
            return;
        }

        // moves article /////////////////////////////////////////////////////////////
        if ( !empty ( $_GET [ "article" ] ) && !empty ( $_GET [ "leftdir" ] ) && !empty ( $_GET [ "rightdir" ] ) ) {
            if ( $article = Database::connection () -> getResult ( "SELECT directory FROM header WHERE id=". (int) $_GET [ "article" ] .";" ) ) {
                // move article from left directory to right directory ///////////////////////
                if ( $article == $_GET [ "leftdir" ] ) {
                    $this -> moveArticle ( $_GET [ "rightdir" ] );
                    //////////////////////////////////////////////////////////////////////////////
                    // move article from right directory to left directory ///////////////////////
                } elseif ( $article == $_GET [ "rightdir" ] ) {
                    $this -> moveArticle ( $_GET [ "leftdir" ] );
                    //////////////////////////////////////////////////////////////////////////////
                } else {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se určit složky pro přesun." ) .'</strong></p>';
                }
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se načíst údaje z databáze." ) .'</strong></p>';
            }
            //////////////////////////////////////////////////////////////////////////////
            // moves draft ///////////////////////////////////////////////////////////////
        } elseif ( !empty ( $_GET [ "draft" ] ) && !empty ( $_GET [ "leftdir" ] ) && !empty ( $_GET [ "rightdir" ] ) ) {
            if ( $draft = Database::connection () -> getResult ( "SELECT directory FROM drafts WHERE id=". (int) $_GET [ "draft" ] .";" ) ) {
                // moves draft from left directory to right directory ////////////////////////
                if ( $draft == $_GET [ "leftdir" ] ) {
                    $this -> moveDraft ( $_GET [ "rightdir" ] );
                    //////////////////////////////////////////////////////////////////////////////
                    // moves draft from right directory to left directory ////////////////////////
                } elseif ( $draft == $_GET [ "rightdir" ] ) {
                    $this -> moveDraft ( $_GET [ "leftdir" ] );
                } else {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se určit složky pro přesun." ) .'</strong></p>';
                }
                //////////////////////////////////////////////////////////////////////////////
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se načíst údaje z databáze." ) .'</strong></p>';
            }
            //////////////////////////////////////////////////////////////////////////////
        } elseif ( !empty ( $_GET [ "directory" ] ) && !empty ( $_GET [ "leftdir" ] ) && !empty ( $_GET [ "rightdir" ] ) ) {
            if ( (int) $_GET [ "directory" ] == 1 || (int) $_GET [ "directory" ] == 2 ) {
                $this -> page [ "text" ] .= "<p><strong class=\"warning\">". _( "Nemůžete přesouvat složky WWW a Administrace!" ) ."</strong></p>";
                return;
            }
            if ( $directory = Database::connection () -> getResult ( "SELECT parent FROM directory WHERE id=". (int) $_GET [ "directory" ] .";" ) ) {
                // moves directory from left directory to right directory ////////////////////
                if ( $directory == $_GET [ "leftdir" ] ) {
                    $this -> moveDirectory ( $_GET [ "rightdir" ] );
                    //////////////////////////////////////////////////////////////////////////////
                    // moves directory from right directory to left directory ////////////////////
                } elseif ( $directory == $_GET [ "rightdir" ] ) {
                    $this -> moveDirectory ( $_GET [ "leftdir" ] );
                } else {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se určit složky pro přesun." ) .'</strong></p>';
                }
                //////////////////////////////////////////////////////////////////////////////
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se načíst údaje z databáze." ) .'</strong></p>';
            }
        }

        $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="directoryContent.reloadContent(\''. Localization::session () -> getFile ( "cor-web-contents", false ) .'\');closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
    } // end moveIt

    private function copyArticle ( $article, $directory )
    {

        // access checking ///////////////////////////////////////////////////////////
        $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". (int) $directory .";" );
        if ( !SecurityTools::check_write ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povolen zápis do této složky" ) .'!</strong></p>';
            return;
        }
        if ( !SecurityTools::check_write ( $article [ "access" ], $article [ "author" ], $article [ "groupid" ] ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povoleno kopírování tohoto souboru" ) .'!</strong></p>';
            return;
        }
        //////////////////////////////////////////////////////////////////////////////

        $copy = _( "kopie" );

        if ( $doubler = Database::connection () -> getResult ( "SELECT title FROM header WHERE ( title='$copy ". $article [ "title" ] ."' OR file='$copy-". $article [ "file" ] ."' OR anchor='$copy ". $article [ "anchor" ] ."' ) AND id<>". $article [ "id" ] .";" ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Článek s tímto nadpisem nebo jménem souboru nebo odkazu již existuje" ) .': '. $doubler .'.</strong></p>';
            return;
        }

        if ( Database::connection () -> query ( "INSERT INTO header VALUES ( 0, '". $article [ "type" ] ."', '$copy ". $article [ "title" ] ."', ". User::session () -> getId () .", ". $article [ "groupid" ] .", 0, CURRENT_TIMESTAMP(), CURRENT_TIMESTAMP(), ". $directory  .", '$copy ". $article [ "anchor" ] ."', '$copy-". $article [ "file" ] ."', '". $article [ "access" ] ."', '". $article [ "lang" ] ."', 0 );" ) &&
            Database::connection () -> query ( "UPDATE header SET sequence=LAST_INSERT_ID() WHERE id=LAST_INSERT_ID();" ) ) {
            if ( Database::connection () -> query ( "INSERT INTO content VALUES ( LAST_INSERT_ID(), '". $article [ "editorial" ] ."', '". $article [ "text" ] ."' );" ) ) {
                $this -> page [ "text" ] .= "<p>". $article [ "title" ] ." - ". _( "Kopírování článku proběhlo úspěšně." ) ."</p>";
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se vytvořit obsah kopie článku" ) .' '. $article [ "title" ] .'.</strong></p>';
            }
        } else {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se vytvořit hlavičku kopie článku" ) .' '. $article [ "title" ] .'.</strong></p>';
        }

    } // end copyArticle

    private function copyDraft ( $draft, $directory )
    {

        // access checking ///////////////////////////////////////////////////////////
        $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". (int) $directory .";" );
        if ( !SecurityTools::check_write ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povolen zápis do této složky" ) .'!</strong></p>';
            $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
            return;
        }
        if ( !SecurityTools::check_write ( "wr0", $draft [ "author" ], 2 ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povoleno kopírování tohoto souboru" ) .'!</strong></p>';
            return;
        }
        //////////////////////////////////////////////////////////////////////////////

        $copy = _( "kopie" );

        if ( $doubler = Database::connection () -> getResult ( "SELECT title FROM draft WHERE title='$copy ". $draft [ "title" ] ."' AND id<>". $draft [ "id" ] .";" ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Koncept s tímto nadpisem již existuje" ) .': '. $doubler .'.</strong></p>';
            return;
        }

        if ( Database::connection () -> query ( "INSERT INTO drafts VALUES ( 0, '". $draft [ "type" ] ."', '$copy ". $draft [ "title" ] ."', ". User::session () -> getId () .", CURRENT_TIMESTAMP(), ". (int) $directory .", '". $draft [ "editorial" ] ."', '$copy". $draft [ "text" ] ."', 'cs' );" ) ) {
            $this -> page [ "text" ] .= "<p>". $draft [ "title" ] ." - ". _( "Kopírování konceptu proběhlo úspěšně." ) ."</p>";
        } else {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se vytvořit kopii konceptu" ) .' '. $draft [ "title" ] .'.</strong></p>';
        }

    } // end copyDraft

    private function copyIt ()
    {
        $this -> page [ "title" ] = _( "Kopírování" );

        $successfulcopy = "<p>". _( "Kopírování proběhlo úspěšně." ) ."</p>";
        $copy = _( "kopie" );

        if ( !( empty ( $_GET [ "article" ] ) && empty ( $_GET [ "leftdir" ] ) && empty ( $_GET [ "rightdir" ] ) ) ) { // copy article (tables header and content)
            if ( $article = Database::connection () -> fetch_assoc ( "SELECT * FROM header, content WHERE header.id=". (int) $_GET [ "article" ] ." AND content.id_header=". (int) $_GET [ "article" ] .";" ) ) { // gets article from database
                // copy article from left window /////////////////////////////////////////////
                if ( $article [ "directory" ] == $_GET [ "leftdir" ] ) { // it`s article from left window
                    if ( (int) $_GET [ "rightdir" ] == 0 ) {
                        $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nelze provádět kopírování do kořenové složky." ) .'</strong></p>';
                        return;
                    }
                    $this -> copyArticle ( $article, (int) $_GET [ "rightdir" ] );
                    //////////////////////////////////////////////////////////////////////////////
                    // copy article from right window ////////////////////////////////////////////
                } elseif ( $article [ "directory" ] == $_GET [ "rightdir" ] ) { // it`s article from right window
                    if ( (int) $_GET [ "leftdir" ] == 0 ) {
                        $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nelze provádět kopírování do kořenové složky." ) .'</strong></p>';
                        return;
                    }
                    $this -> copyArticle ( $article, (int) $_GET [ "leftdir" ] );
                    //////////////////////////////////////////////////////////////////////////////
                } else {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se určit složky pro kopírování." ) .'</strong></p>';
                }
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se načíst článek." ) .'</strong></p>';
            }
        } elseif ( !empty ( $_GET [ "draft" ] ) && !empty ( $_GET [ "leftdir" ] ) && !empty ( $_GET [ "rightdir" ] ) ) { // copy draft
            if ( $draft = Database::connection () -> fetch_assoc ( "SELECT * FROM drafts WHERE id=". (int) $_GET [ "draft" ] .";" ) ) {
                // copy draft from left window to right window ///////////////////////////////
                if ( $draft [ "directory" ] == $_GET [ "leftdir" ] ) {
                    if ( (int) $_GET [ "rightdir" ] == 0 ) {
                        $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nelze provádět kopírování do kořenové složky." ) .'</strong></p>';
                        return;
                    }
                    $this -> copyDraft ( $draft, (int) $_GET [ "rightdir" ] );
                    //////////////////////////////////////////////////////////////////////////////
                    // copy draft from right window to right window //////////////////////////////
                } elseif ( $article [ "directory" ] == $_GET [ "rightdir" ] ) {
                    if ( (int) $_GET [ "leftdir" ] == 0 ) {
                        $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nelze provádět kopírování do kořenové složky." ) .'</strong></p>';
                        return;
                    }
                    $this -> copyDraft ( $draft, (int) $_GET [ "leftdir" ] );
                    //////////////////////////////////////////////////////////////////////////////
                } else {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se určit složky pro kopírování." ) .'</strong></p>';
                }
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se načíst koncept." ) .'</strong></p>';
            }
        }

        $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="directoryContent.reloadContent(\''. Localization::session () -> getFile ( "cor-web-contents", false ) .'\');closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
    } // end copyIt

    private function createarticle ()
    {

        if ( empty ( $_POST [ "anchor" ] ) || empty ( $_POST [ "access" ] ) || empty ( $_POST [ "usergroup" ] ) || empty ( $_POST [ "file" ] ) || empty ( $_POST [ "draftid" ] ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Některá políčka formuláře nebyla vyplněna" ) .'.</strong></p>';
            return;
        }

        $this -> page [ "title" ] = _( "Nový článek" );
        $anchor = htmlspecialchars ( $_POST [ "anchor" ] );
        $access = htmlspecialchars ( $_POST [ "access" ] );
        $group = (int) $_POST [ "usergroup" ];
        $file = htmlspecialchars ( str_replace ( " ", "-", $_POST [ "file" ] ) );
        $draftid = (int) $_POST [ "draftid" ];

        if ( !$draft = Database::connection () -> fetch_assoc ( "SELECT * FROM drafts WHERE id=$draftid;" ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nepodařilo se načíst udáje z konceptu." ) .'</strong></p>';
            return;
        }

        if ( $doubler = Database::connection () -> getResult ( "SELECT title FROM header WHERE title='". $draft [ "title" ] ."' OR file='$file' OR anchor='$anchor';" ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Článek s tímto nadpisem nebo jménem souboru nebo odkazu již existuje" ) .': '. $doubler .'.</strong></p>';
            return;
        }

        // access checking ///////////////////////////////////////////////////////////
        $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". $draft [ "directory" ] .";" );
        if ( !SecurityTools::check_write ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
            Error::ticket () -> notice ( 'cor00029', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
        }
        //////////////////////////////////////////////////////////////////////////////

        if ( Database::connection () -> query ( "INSERT INTO header VALUES ( 0, 'static', '". $draft [ "title" ] ."', ". $draft [ "author" ] .", $group, 0, CURRENT_TIMESTAMP(), CURRENT_TIMESTAMP(), ". $draft [ "directory" ] .", '$anchor', '$file', '$access', '". $draft [ "lang" ] ."', 0 );" ) &&
            Database::connection () -> query ( "UPDATE header SET sequence=LAST_INSERT_ID() WHERE id=LAST_INSERT_ID();" ) ) {
            $this -> page [ "text" ] .= '<p>'. _( "Úspěšně vytvořena hlavička článku." ) .'</p>';
        } else {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se vytvořit hlavičku článku." ) .'</strong></p>';
            return;
        }

        if ( Database::connection () -> query ( "INSERT INTO content VALUES ( LAST_INSERT_ID(), '". $draft [ "editorial" ] ."',
'". stripslashes ( $draft [ "text" ] ) ."' );" ) ) {
            $this -> page [ "text" ] .= '<p>'. _( "Úspěšně vytvořen obsah článku." ) .'</p>';
        } else {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se vytvořit obsah článku." ) .'</strong></p>';
        }

        if ( !Database::connection () -> query ( "DELETE FROM drafts WHERE id=$draftid;" ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se smazat koncept článku." ) .'</strong></p>';
        }

        $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="directoryContent.reloadContent(\''. Localization::session () -> getFile ( "cor-web-contents", false ) .'\');closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
    } // end createarticle

    private function checkUniqueness () {
        $title = addslashes ( strip_tags ( $_POST [ "title" ] ) );
        $file = addslashes ( strip_tags ( $_POST [ "file" ] ) );
        $titlecheck = "";
        $filecheck = "";

        if ( $title != "" ) $titlecheck = Database::connection () -> getResult ( "SELECT `title` FROM `header` WHERE `title`='$title' LIMIT 1;" );
        if ( $file != "" ) $filecheck = Database::connection () -> getResult ( "SELECT `file` FROM `header` WHERE `file`='$file' LIMIT 1;" );

        $this -> page [ "text" ] .= "<results><nadpis>$titlecheck</nadpis><file>$filecheck</file></results>";
    }

    private function articleExtension ()
    {
        $this -> page [ "text" ] .= "nic leda";
    }

    private function articleHeader ()
    {
        $id_preface = time ();
        // access checking ///////////////////////////////////////////////////////////
        if ( !empty ( $_GET [ "dirid" ] ) ) {
            $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". (int) $_GET [ "dirid" ] .";" );
            if ( !SecurityTools::check_write ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
                $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povolen zápis do této složky" ) .'!</strong></p>';
                $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
                return;
            }
        } elseif ( !empty ( $_GET [ "id" ] ) ) {
            $access_article = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM header WHERE id=". (int) $_GET [ "id" ] .";" );
            if ( !SecurityTools::check_write ( $access_article [ "access" ], $access_article [ "author" ], $access_article [ "groupid" ] ) ) {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nemáte povoleny změny tohot souboru!" ) .'</strong></p>';
                $disabled_changes = true;
            }
        } elseif ( !empty ( $_GET [ "draftid" ] ) ) {
            if ( User::session () -> getId () != Database::connection () -> getResult ( "SELECT `author` FROM `drafts` WHERE id=".(int)$_GET [ "draftid" ].";" ) ) {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nemáte povoleno zobrazení tohoto souboru!" ) .'</strong></p>';
                return;
            }
        } else {
            $this -> page [ "title" ] = _( "Chyba" );
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( 'Nelze zapisovat do kořenové složky!' ) .'</strong></p>
    <input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
            return;
        }
        //////////////////////////////////////////////////////////////////////////////

        // gets data from database for article editing ///////////////////////////////
        if ( !empty ( $_GET [ "id" ] ) ) {
            $article = Database::connection () -> fetch_assoc ( "SELECT * FROM header, content WHERE header.id=". (int) $_GET [ "id" ] ." AND content.id_header=". (int) $_GET [ "id" ] .";" );
        } elseif ( !empty ( $_GET [ "draftid" ] ) ) {
            $article = Database::connection () -> fetch_assoc ( "SELECT * FROM `drafts` WHERE id=". (int) $_GET [ "draftid" ] .";" );
        }
        //////////////////////////////////////////////////////////////////////////////

        if ( !empty ( $_GET [ "id" ] ) ) {
            $this -> page [ "title" ] = _( "Upravit text článku" );
        } elseif ( !empty ( $_GET [ "draftid" ] ) ) {
            $this -> page [ "title" ] = _( "Upravit text konceptu" );
        } else {
            $this -> page [ "title" ] = _( "Nový článek" );
        }

        if ( ( empty ( $_GET [ "id" ] ) && empty ( $_GET [ "draftid" ] ) ) && ( empty ( $_GET [ "dirid" ] ) || (int) $_GET [ "dirid" ] == 0 ) ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nelze vytvářet článek v kořenovém adresáři!" ) .'</strong></p>';
            $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
            return;
        }

        $action = isset ( $_GET [ "id" ] ) ? "editarticle&#038;id=". (int) $_GET [ "id" ] : "newarticle&#038;step=step2";

        $this -> page [ "text" ] .= '
<form action="'. Localization::session () -> getFile ( "cor-web-contents" ) .'?action='. $action .'" id="'.$id_preface.'ArticleEditorStep1" method="post" enctype="application/x-www-form-urlencoded" onsubmit="this.action=\''. Localization::session () -> getFile ( "cor-web-contents" ) .'?action='. $action .'&#038;leftdir=\'+directoryContent.leftDirId+\'&#038;rightdir=\'+directoryContent.rightDirId;">
<fieldset>
<label for="title">'. _( 'Nadpis' ) .': </label><input type="text" name="title" id="'.$id_preface.'title" value="'. $article [ "title" ] .'" maxlength="100" '.(isset ( $_GET [ "id" ] )?"":'onkeyup="articleTitle(\''.$id_preface.'title\',\''.$id_preface.'anchor\',\''.$id_preface.'file\');"').' onchange="checkUniqueness();" />
    <span style="display:inline;font-size:10px;margin-left:10px;" id="'.$id_preface.'uniquenessmessage">&nbsp;</span><br />
    <a href="#" onclick="additionalContents(\''.$id_preface.'editorialblock\',this);return false;"><img src="styles/cor-admin/arrow-right.gif" alt="'._("šipka").'" />'._("Úvodník").'</a><br />
<div id="'.$id_preface.'editorialblock" class="undisplayed"><label for="editorial">'. _( 'Úvodník' ) .': </label><br /><br />
<textarea id="'.$id_preface.'editorial" name="editorial" rows="3">'. $article [ "editorial" ] .'</textarea><br /></div>
<label for="'.$id_preface.'texts">'. _( 'Text' ) .': </label><br /><br />';

        include_once ( "fckeditor/fckeditor.php" );
        $oFCKeditor = new FCKeditor ( $id_preface ."texts" );
        $oFCKeditor -> Height = '500';
        $oFCKeditor -> BasePath = "fckeditor/";
        $oFCKeditor -> Config['BaseHref'] = "http://". $_SERVER [ "HTTP_HOST" ] . substr ( $_SERVER [ "SCRIPT_NAME" ], 0, strrpos ( $_SERVER [ "SCRIPT_NAME" ], "/" ) ) ."/";
        $oFCKeditor -> Config['albireoBrowser'] = $this -> browser;
        $oFCKeditor -> Value = $article [ "text" ];
        $this -> page [ "text" ] .= $oFCKeditor -> CreateHtml ();

        if ( isset ( $article [ "publishtime" ] ) ) {
            $datetime = date_create ( $article [ "publishtime" ] );
            $date = date_format ( $datetime, "d.m.Y" );
            $time = date_format ( $datetime, "H:i:s" );
        } else {
            $date = date ( "d.m.Y" );
            $time = date ( "H:i:s" );
        }

        if ( empty ( $_GET [ "id" ] ) ) { //koncepty se jeste nepouzivaji pri editovani clanku
            $this -> page [ "text" ] .= '
<script type="text/javascript">
    function saveDraft ()
    {
        var oEditor = FCKeditorAPI.GetInstance ( "'.$id_preface.'texts" );
        if ( !oEditor || !document.getElementById ( "'.$id_preface.'title" ) ) {
            return;
        }

        editorValue = encodeURIComponent ( oEditor.GetXHTML ( true ) );

        if ( editorValue.length == 0 ) {
            return false;
        }

        titleValue = encodeURIComponent ( document.getElementById ( "'.$id_preface.'title" ).value );
        editorialValue = encodeURIComponent ( document.getElementById ( "'.$id_preface.'editorial" ).value );
        directoryValue = encodeURIComponent ( document.getElementById ( "'.$id_preface.'dirid" ).value );
        draftidValue = encodeURIComponent ( document.getElementById ( "'.$id_preface.'draftid" ).value );

        POSTQuery = "unique_id='.$id_preface.'&title="+ titleValue +"&editorial="+ editorialValue +"&directory="+ directoryValue +"&draftid="+ draftidValue +"&texts="+ editorValue;

        $.ajax({
            type: "POST",
            dataType: "html",
            url: "'. Tools::getPage() .'.xml?action=savedraft",
            cache: false,
            data: POSTQuery,
            success: function(html){
                changeIdByAjax ( html, "'.$id_preface.'articlestatusmessage" ); // function changeIdByAjax comes from scripts/cor-ajax-base.js
                showAndHide ( "'.$id_preface.'articlestatusmessage" );  // function showAndHide comes from scripts/cor-ajax-base.js
            },
            error: function(html){
                ajaxError ( "'.$id_preface.'articlestatusmessage" );
            }
        });
    }

    function saveDraftAndAgain () {
        if (!document.getElementById ( "'.$id_preface.'title" )) {
            return;
        }
        saveDraft ();
        setTimeout ( function () {
            saveDraftAndAgain ();
        }, 30000 );
    }

    setTimeout ( function () {
        saveDraftAndAgain ();
        directoryContent.reloadContent(\''. Localization::session () -> getFile ( "cor-web-contents", false ) .'\');
    }, 10000 );

</script>';
        }

        $this -> page [ "text" ] .= '<script type="text/javascript">
var articleUniqueness'.$id_preface.' = "";
var originalTitle'.$id_preface.' = encodeURIComponent ( document.getElementById ( "'.$id_preface.'title" ).value );
var originalFile'.$id_preface.' = encodeURIComponent ( document.getElementById ( "'.$id_preface.'file" ).value );

function checkUniqueness () {
    titleValue = encodeURIComponent ( document.getElementById ( "'.$id_preface.'title" ).value );
    fileValue = encodeURIComponent ( document.getElementById ( "'.$id_preface.'file" ).value );
    articleUniqueness'.$id_preface.' = "";
    if ( originalTitle'.$id_preface.' == titleValue ) {
        titleValue = "";
        $("#'.$id_preface.'uniquenessmessage").html ( "&nbsp;" );
        fstArticleUniqueness'.$id_preface.' = "";
    }
    if ( originalFile'.$id_preface.' == fileValue ) {
        fileValue = "";
        $("#'.$id_preface.'fileuniquenessmessage").html ( "&nbsp;" );
    }
    if ( titleValue.length == 0 && fileValue == 0 ) {
        return;
    }
    POSTQuery = "title="+ titleValue +"&file="+ fileValue;
    $.ajax({
        type: "POST",
        dataType: "html",
        url: "'. Tools::getPage() .'.xml?action=checkuniqueness",
        cache: false,
        data: POSTQuery,
        success: function(html){
            var responseTitle = html.substring ( html.indexOf ( "<nadpis>" )+8, html.indexOf ( "</nadpis>" ) );
            var responseFile = html.substring ( html.indexOf ( "<file>" )+6, html.indexOf ( "</file>" ) );
            if ( responseTitle.length > 0 ) {
                $("#'.$id_preface.'uniquenessmessage").html ( \'<strong class="warning">'._("Takový nadpis již existuje.").'</strong>\' );
                fstArticleUniqueness'.$id_preface.' = "'._("Takový nadpis již existuje.").'";
            } else {
                $("#'.$id_preface.'uniquenessmessage").html ( "&nbsp;" );
                fstArticleUniqueness'.$id_preface.' = "";
            }
            if ( responseFile.length > 0 ) {
                $("#'.$id_preface.'fileuniquenessmessage").html ( \'<strong class="warning">'._("Takový název souboru již existuje.").'</strong>\' );
                articleUniqueness'.$id_preface.' = fstArticleUniqueness'.$id_preface.'+" '._("Takový název souboru již existuje.").'";
            } else {
                $("#'.$id_preface.'fileuniquenessmessage").html ( "&nbsp;" );
                articleUniqueness'.$id_preface.' = fstArticleUniqueness'.$id_preface.';
            }
        },
        error: function(html){
            ajaxError ( "'.$id_preface.'uniquenessmessage" );
        }
    });
}

function checkBeforeSend () {
    if ( articleUniqueness'.$id_preface.'.length > 0 ) {
        window.alert ( articleUniqueness'.$id_preface.' );
        return false;
    } else {
        return true;
    }
}
</script>';

        $dirid = ( empty ( $_GET [ "draftid" ] ) && empty ( $_GET [ "id" ] ) ) ? (int) $_GET [ "dirid" ] : $article [ "directory" ];
        $this -> page [ "text" ] .= '<input type="hidden" name="directory" id="'.$id_preface.'dirid" value="'. $dirid .'" />
<input type="hidden" name="draftid" id="'.$id_preface.'draftid" value="'. (int) $_GET [ "draftid" ] .'" />
<div><div style="display:inline;font-size:8pt;" id="'.$id_preface.'articlestatusmessage">&nbsp;</div>&nbsp;</div>';

/*$extensions = Database::connection () -> fetchall_assoc ( "SELECT `name`,`type` FROM `drivers` WHERE `type` LIKE 'albifile/%'" );
if ( !empty ( $extensions ) ) {
$this -> page [ "text" ] .= '<script type="text/javascript">
    function chooseArticleExtension () {
        content = \'';
foreach ( $extensions as $extension ) {
    $this -> page [ "text" ] .= '<a href="#" onclick="changeIdByGET(\\\''.Tools::getPage().'?action=articleextension&type='. $extension [ "type" ] .'\\\',\\\''.$id_preface.'articleExtension\\\');">'. $extension [ "name" ] .'</a><br />';
}
$this -> page [ "text" ] .= '\';
        title = "'. _( "Zvolte rozšíření článku" ) .'";
        id = "modalDialogueArticleExtension";
        w = 400;
        modalDialogueWindow ( id, title, content );
    }
</script>
<div id="'.$id_preface.'articleExtension"><a href="#" onclick="chooseArticleExtension();return false;">'. _( "Přidat k článku rozšíření" ) .'</a></div><br />';
}*/

        $this -> page [ "text" ] .= '<a href="#" onclick="additionalContents(\''.$id_preface.'advancedarticle\',this);return false;"><img src="styles/cor-admin/arrow-right.gif" alt="'._("šipka").'" />'._("Pokročilá nastavení").'</a><br />
    <div class="undisplayed" id="'.$id_preface.'advancedarticle">
    <label for="publishtime">'. _( 'Publikovat' ) .': </label><input style="width:135px;" type="text" name="publishdate" id="'.$id_preface.'publishdate" value="'.$date.'" />
   '. _( 'v' ) .' <input style="width:135px;" type="text" name="publishtime" id="'.$id_preface.'publishtime" value="'.$time.'" /><br />
    <script type="text/javascript">
        $(function() {
            $("#'.$id_preface.'publishdate").datepicker({
                dayNamesMin: ["Po", "Út", "St", "Čt", "Pá", "So", "Ne"],
                monthNames: ["Leden","Únor","Březen","Duben","Květen","Červen","Červenec","Srpen","Září","Říjen","Listopad","Prosinec"],
                dateFormat: "dd.mm.yy",
                minDate: 0
            });
            $("#ui-datepicker-div").css("z-index","5000");
        });
    </script>
    <label for="access">'. _( 'Přístup' ) .': </label>
        <select name="access" onchange="changeAccessInformation(this.value,\'accessInformation\');";>
            <option value="wwr"'. ( ( $article [ "access" ] == "wwr" ) ? " selected=\"selected\"" : "" ) .'>'. _( "Veřejný" ) .'</option>
            <option value="ww0"'. ( ( $article [ "access" ] == "ww0" ) ? " selected=\"selected\"" : "" ) .'>'. _( "Skupinový" ) .'</option>
            <option value="wrr"'. ( ( $article [ "access" ] == "wrr" ) ? " selected=\"selected\"" : ( $article [ "access" ] ? "" : " selected=\"selected\"" ) ) .'>'. _( "Chráněný" ) .'</option>
            <option value="wr0"'. ( ( $article [ "access" ] == "wr0" ) ? " selected=\"selected\"" : "" ) .'>'. _( "Soukromý" ) .'</option>
            <option value="w00"'. ( ( $article [ "access" ] == "w00" ) ? " selected=\"selected\"" : "" ) .'>'. _( "Zabezpečený" ) .'</option>
        </select><br />';

        $accessInfo = "";
        switch ( $article [ "access" ] ) {
            case 'wwr':
                $accessInfo = _( "Autor a skupina mohou zapisovat a ostatní mohou číst." );
                break;
            case 'ww0':
                $accessInfo = _( "Autor a skupina mohou zapisovat a ostatní nemohou nic." );
                break;
            case 'wrr':
                $accessInfo = _( "Autor může zapisovat a skupina a ostatní mohou číst." );
                break;
            case 'wr0':
                $accessInfo = _( "Autor může zapisovat, skupina může číst a ostatní nemohou nic." );
                break;
            case 'w00':
                $accessInfo = _( "Autor může zapisovat a skupina a ostatní nemohou nic." );
                break;
            default:
                $accessInfo = _( "Autor může zapisovat a skupina a ostatní mohou číst." );
        }
        $this -> page [ "text" ] .= '<span id="'.$id_preface.'accessInformation" class="floatLeft"><strong>'. $accessInfo .'</strong></span><br />
<label for="usergroup">'. _( 'Skupina' ) .': </label>
<select name="usergroup">';

        if ( isset ( $article [ "groupid" ] ) ) {
            $usergroups = Database::connection () -> fetchall_assoc ( "SELECT * FROM usergroups;" );
            if ( User::session () -> getPrimaryGroup () > 1 ) unset ( $usergroups [ 0 ] );
            if ( User::session () -> getPrimaryGroup () > 2 ) unset ( $usergroups [ 1 ] );
            if ( User::session () -> getPrimaryGroup () > 3 ) unset ( $usergroups [ 2 ] );
            foreach ( $usergroups as $group ) {
                $this -> page [ "text" ] .= '<option value="'. $group [ "id" ] .'"'. ( ( $article [ "groupid" ] == $group [ "id" ] ) ? " selected=\"selected\"" : "" ) .'>'. $group [ "usergroup" ] .'</option>';
            }
            if ( User::session () -> getPrimaryGroup () ) $this -> page [ "text" ] .= '<option value="4">'. _( "Uživatelé" ) .'</option>';
        } else {
            $usergroups = Database::connection () -> fetchall_assoc ( "SELECT * FROM usergroups;" );
            if ( User::session () -> getPrimaryGroup () > 1 ) unset ( $usergroups [ 0 ] );
            if ( User::session () -> getPrimaryGroup () > 2 ) unset ( $usergroups [ 1 ] );
            if ( User::session () -> getPrimaryGroup () > 3 ) unset ( $usergroups [ 2 ] );
            foreach ( $usergroups as $group ) {
                $this -> page [ "text" ] .= '<option value="'. $group [ "id" ] .'">'. $group [ "usergroup" ] .'</option>';
            }
        }
        $this -> page [ "text" ] .= '</select><br />';

        $this -> page [ "text" ] .= '
<label for="anchor">'. _( 'Text odkazu' ) .': </label><input type="text" name="anchor" id="'.$id_preface.'anchor" value="'. $article [ "anchor" ] .'" maxlength="100" /><br />
<label for="file">'. _( 'Název souboru' ) .': </label><input type="text" name="file" id="'.$id_preface.'file" onkeyup="clearfile(\''.$id_preface.'file\');" value="'.$article [ "file" ].'" maxlength="100" onchange="checkUniqueness();" />'. Tools::baseSettings () -> getSetting ( "file_extension" ) .'
<span style="display:inline;font-size:10px;margin-left:10px;" id="'.$id_preface.'fileuniquenessmessage">&nbsp;</span><br />
</div>';
        $this -> page [ "text" ] .= '<input'.((isset($disabled_changes)&&$disabled_changes==true)?' disabled="disabled"':'').' class="dialoguebutton" type="submit" value="'. ( !empty ( $_GET [ "id" ] ) ? _( "Uložit změny" ) : _( "Vytvořit článek" ) ) .'" onclick="return checkBeforeSend();" />
</fieldset>
</form>';
    } // end articleHeader

    private function saveDraft ()
    {
        $title = strip_tags ( $_POST [ "title" ] );
        $editorial = strip_tags ( $_POST [ "editorial" ] );
        $texts = str_replace ( "'", "\'", stripslashes ( $_POST [ "texts" ] ) );
        $directory = (int) $_POST [ "directory" ];
        $draftid = (int) $_POST [ "draftid" ];
        $unique_id = strip_tags ( $_POST [ "unique_id" ] );

        if ( $draftid != 0 ) {
            if ( User::session () -> getId () != Database::connection () -> getResult ( "SELECT `author` FROM `drafts` WHERE id=$draftid;" ) ) {
                return;
            }
            if ( Database::connection () -> query ( "UPDATE `drafts` SET `title`='$title', `editorial`='$editorial', `text`='$texts' WHERE id=$draftid;" ) ) {
                $this -> page [ "text" ] = _( "Uloženo..." );
            }
        } else {
            if ( Database::connection () -> query ( "INSERT INTO `drafts` ( `title`, `author`, `directory`, `editorial`, `text`, `lang` )
    VALUES ( '$title', ". User::session () -> getId () .", $directory, '$editorial', '$texts', 'cs' );" ) ) {
                $draftid = Database::connection () -> getResult ( "SELECT LAST_INSERT_ID();" );
                $this -> page [ "text" ] = _( "Uloženo..." ).
'<script type="text/javascript">document.getElementById ( "'.$unique_id.'draftid" ).value='. $draftid .'</script>';
            }
        }

    }

    private function createFolder ()
    {

        if ( !empty ( $_POST [ "editing_folder" ] ) && ( empty ( $_POST [ "title" ] ) ||
                empty ( $_POST [ "access" ] ) ||
                empty ( $_POST [ "usergroup" ] ) ||
                empty ( $_POST [ "headerhtml" ] ) ||
                empty ( $_POST [ "bodyhtml" ] ) ||
                empty ( $_POST [ "parent" ] ) ) ) { // form input checking for editing

            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Některé políčka pro editaci zůstala prázdná." ) .'</strong></p>';
            return;

        } elseif ( empty ( $_POST [ "title" ] ) || empty ( $_POST [ "parent" ] ) ) { // form input checking for creating of new folder
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nebylo vyplněno jméno nové složky." ) .'</strong></p>';
            return;
        }

        // it will get data of parent folder
        $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access, headerhtml, bodyhtml FROM directory WHERE id=". (int) $_POST [ "parent" ] .";" );

        // access checking ///////////////////////////////////////////////////////////
        if ( !SecurityTools::check_write ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
            Error::ticket () -> notice ( 'cor00029', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
        }
        if ( !empty ( $_POST [ "editing_folder" ] ) ) {
            $editing_folder = Database::connection () -> fetch_assoc ( "SELECT * FROM directory WHERE id=". (int) $_POST [ "editing_folder" ] .";" );
            if ( !SecurityTools::check_write ( $editing_folder [ "access" ], $editing_folder [ "author" ], $editing_folder [ "groupid" ] ) ) {
                Error::ticket () -> notice ( 'cor00029', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
        }
        //////////////////////////////////////////////////////////////////////////////

        $title = htmlspecialchars ( $_POST [ "title" ] );
        $parent = (int) $_POST [ "parent" ];

        if ( !empty ( $_POST [ "editing_folder" ] ) ) { // data for folder which is being edited
            $access = htmlspecialchars ( $_POST [ "access" ] );
            $group = (int) $_POST [ "usergroup" ];
            $headerhtml = htmlspecialchars ( $_POST [ "headerhtml" ] );
            $bodyhtml = htmlspecialchars ( $_POST [ "bodyhtml" ] );
        } else { // data for folder which is being created as new one
            $access = $parent_dir [ "access" ];
            $group = $parent_dir [ "groupid" ];
            $headerhtml = $parent_dir [ "headerhtml" ];
            $bodyhtml = $parent_dir [ "bodyhtml" ];
        }

        if ( isset ( $editing_folder ) && is_array ( $editing_folder ) && $doubler = Database::connection () -> getResult ( "SELECT title FROM directory WHERE title='$title' AND id<>". $editing_folder [ "id" ] .";" ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Složka s tímto jménem již existuje" ) .': '. $doubler .'.</strong></p>';
            return;
        } elseif ( (!isset ( $editing_folder ) || !is_array ( $editing_folder )) && $doubler = Database::connection () -> getResult ( "SELECT title FROM directory WHERE title='$title';" ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Složka s tímto jménem již existuje" ) .': '. $doubler .'.</strong></p>';
            return;
        }

        if ( isset ( $editing_folder ) && is_array ( $editing_folder ) ) {
            $this -> page [ "title" ] = _( "Úprava složky $title" );
            if ( Database::connection () -> query ( "UPDATE directory SET title='$title', access='$access', groupid=$group, headerhtml='$headerhtml', bodyhtml='$bodyhtml' WHERE id=". (int) $_POST [ "editing_folder" ] .";" ) ) {
                $this -> page [ "text" ] .= '<p>'. $title . _( " - složka byla úspěšně upravena." ) .'</p>';
            } else {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se upravit složku!" ) .'</strong></p>';
            }
            $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="directoryContent.reloadContent(\''. Localization::session () -> getFile ( "cor-web-contents", false ) .'\');closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
            return;
        }

        $this -> page [ "title" ] = _( "Nová složka $title" );

        if ( Database::connection () -> query ( "INSERT INTO directory VALUES ( 0, '$title', ". User::session () -> getId () .", '$group', '$access', $parent, '$headerhtml', '$bodyhtml', 'cs', 0 );" ) ) {
            $this -> page [ "text" ] .= '<p>'. $title . _( " - složka úspěšně vytvořena." ) .'</p>';
            if ( ! Database::connection () -> query ( "UPDATE directory SET sequence=LAST_INSERT_ID() WHERE id=LAST_INSERT_ID();" ) ) {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se nastavit pořadí pro složku!" ) .'</strong></p>';
            }
        } else {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se vytvořit složku!" ) .'</strong></p>';
        }
        $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="directoryContent.reloadContent(\''. Localization::session () -> getFile ( "cor-web-contents", false ) .'\');closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';

    } // end createFolder

    private function folderEditor ()
    {

        $id_preface = time ();

        $this -> page [ "title" ] = ( is_array ( $editing_folder ) ? _( "Upravit složku" ) : _( "Nová složka" ) );

        if ( ( empty ( $_GET [ "dirid" ] ) || (int) $_GET [ "dirid" ] == 0 ) && $_GET [ "action" ] != "editdirectory" ) {
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nelze vytvářet nové složky v kořenovém adresáři!" ) .'</strong></p>';
            $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
            return;
        }

        if ( $_GET [ "action" ] == "editdirectory" ) {
            $editing_folder = Database::connection () -> fetch_assoc ( "SELECT * FROM directory WHERE id=". (int) $_GET [ "id" ] .";" );
            // access checking ///////////////////////////////////////////////////////////
            if ( !SecurityTools::check_write ( $editing_folder [ "access" ], $editing_folder [ "author" ], $editing_folder [ "groupid" ] ) ) {
                $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povoleny úpravy této složky" ) .'!</strong></p>';
                $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
                return;
            }
            //////////////////////////////////////////////////////////////////////////////
        } else {
            $parent_dir = Database::connection () -> fetch_assoc ( "SELECT title, author, groupid, access, headerhtml, bodyhtml FROM directory WHERE id=". (int) $_GET [ "dirid" ] .";" );
            // access checking ///////////////////////////////////////////////////////////
            if ( !SecurityTools::check_write ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
                $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nemáte povolen zápis do této složky" ) .'!</strong></p>';
                $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
                return;
            }
            //////////////////////////////////////////////////////////////////////////////
        }

        $this -> page [ "text" ] .= '
<form action="'. Tools::getPage () .'.xml" id="'.$id_preface.'FolderEditorForm" method="post" enctype="application/x-www-form-urlencoded">
<fieldset>';
        if ( !is_array ( $editing_folder ) ) {
            $this -> page [ "text" ] .= '<img src="styles/cor-admin/folder_open.jpg" alt="'. _( "Složka" ) .'" class="objectLeft" />';
        }
        $this -> page [ "text" ] .= '<label for="title">'. _( 'Jméno' ) .': </label><input type="text" name="title" maxlength="100" value="'. $editing_folder [ "title" ] .'" /><br />';

        // parent folder
        $this -> page [ "text" ] .= '<input type="hidden" name="parent" value="'. ( is_array ( $editing_folder ) ? $editing_folder [ "parent" ] : (int) $_GET [ "dirid" ] ) .'" />'. _( "Rodičovská složka" ) . ': <strong>'. ( $parent_dir [ "title" ] ? $parent_dir [ "title" ] : Database::connection () -> getResult ( "SELECT title FROM directory WHERE id=". $editing_folder [ "parent" ] .";" ) ) .'</strong><br />';

        if ( is_array ( $editing_folder ) ) { // rest of the formulary is shown only during folder editing

            // access selection //////////////////////////////////////////////////////////
            $this -> page [ "text" ] .= '
<label for="access">'. _( 'Přístup' ) .': </label>
<select name="access" onchange="changeAccessInformation(this.value,\'accessInformation\');";>
<option value="wwr"'. ( ( $editing_folder [ "access" ] == "wwr" ) ? " selected=\"selected\"" : "" ) .'>'. _( "Veřejný" ) .'</option>
<option value="ww0"'. ( ( $editing_folder [ "access" ] == "ww0" ) ? " selected=\"selected\"" : "" ) .'>'. _( "Skupinový" ) .'</option>
<option value="wrr"'. ( ( $editing_folder [ "access" ] == "wrr" ) ? " selected=\"selected\"" : ( $editing_folder [ "access" ] ? "" : " selected=\"selected\"" ) ) .'>'. _( "Chráněný" ) .'</option>
<option value="wr0"'. ( ( $editing_folder [ "access" ] == "wr0" ) ? " selected=\"selected\"" : "" ) .'>'. _( "Soukromý" ) .'</option>
<option value="w00"'. ( ( $editing_folder [ "access" ] == "w00" ) ? " selected=\"selected\"" : "" ) .'>'. _( "Zabezpečený" ) .'</option>
</select><br />';

            $accessInfo = "";
            switch ( $folder [ "access" ] ) {
                case 'wwr':
                    $accessInfo = _( "Autor a skupina mohou zapisovat a ostatní mohou číst." );
                    break;
                case 'ww0':
                    $accessInfo = _( "Autor a skupina mohou zapisovat a ostatní nemohou nic." );
                    break;
                case 'wrr':
                    $accessInfo = _( "Autor může zapisovat a skupina a ostatní mohou číst." );
                    break;
                case 'wr0':
                    $accessInfo = _( "Autor může zapisovat, skupina může číst a ostatní nemohou nic." );
                    break;
                case 'w00':
                    $accessInfo = _( "Autor může zapisovat a skupina a ostatní nemohou nic." );
                    break;
                default:
                    $accessInfo = _( "Autor může zapisovat a skupina a ostatní mohou číst." );
            }
            $this -> page [ "text" ] .= '<span id="accessInformation" class="floatLeft"><strong>'. $accessInfo .'</strong></span><br />
<label for="usergroup">'. _( 'Skupina' ) .': </label>
<select name="usergroup">';
            //////////////////////////////////////////////////////////////////////////////

            // user groups selection /////////////////////////////////////////////////////
            if ( isset ( $editing_folder [ "groupid" ] ) ) {
                $usergroups = Database::connection () -> fetchall_assoc ( "SELECT * FROM usergroups;" );
                if ( User::session () -> getPrimaryGroup () > 1 ) unset ( $usergroups [ 0 ] );
                if ( User::session () -> getPrimaryGroup () > 2 ) unset ( $usergroups [ 1 ] );
                if ( User::session () -> getPrimaryGroup () > 3 ) unset ( $usergroups [ 2 ] );
                foreach ( $usergroups as $group ) {
                    $this -> page [ "text" ] .= '<option value="'. $group [ "id" ] .'"'. ( ( $editing_folder [ "groupid" ] == $group [ "id" ] ) ? " selected=\"selected\"" : "" ) .'>'. $group [ "usergroup" ] .'</option>';
                }
                if ( User::session () -> getPrimaryGroup () ) $this -> page [ "text" ] .= '<option value="4">'. _( "Uživatelé" ) .'</option>';
            } else {
                $usergroups = Database::connection () -> fetchall_assoc ( "SELECT * FROM usergroups;" );
                if ( User::session () -> getPrimaryGroup () > 1 ) unset ( $usergroups [ 0 ] );
                if ( User::session () -> getPrimaryGroup () > 2 ) unset ( $usergroups [ 1 ] );
                if ( User::session () -> getPrimaryGroup () > 3 ) unset ( $usergroups [ 2 ] );
                foreach ( $usergroups as $group ) {
                    $this -> page [ "text" ] .= '<option value="'. $group [ "id" ] .'">'. $group [ "usergroup" ] .'</option>';
                }
            }
            $this -> page [ "text" ] .= '</select><br />';
            //////////////////////////////////////////////////////////////////////////////

            // identifer of edited folder
            $this -> page [ "text" ] .= '<input type="hidden" name="editing_folder" value="'. (int) $_GET [ "id" ] .'" />';

            // html templates ////////////////////////////////////////////////////////////
            $listHeaders = $this -> getHTMLTemlates ( "/xhtml/headers/" );
            $listBodies = $this -> getHTMLTemlates ( "/xhtml/bodies/" );
            sort ( $listHeaders );
            sort ( $listBodies );

            $headerhtml = $editing_folder [ "headerhtml" ];
            $bodyhtml = $editing_folder [ "bodyhtml" ];

            $this -> page [ "text" ] .= '<label for="headerhtml">'. _( 'Šablona hlavičky' ) .': </label>
<select name="headerhtml">';
            foreach ( $listHeaders as $value ) {
                $this -> page [ "text" ] .= '<option value="'. $value .'"'. ( ( $headerhtml == $value ) ? " selected=\"selected\"" : "" ) .'>'. $value .'</option>';
            }
            $this -> page [ "text" ] .= '</select><br />';

            $this -> page [ "text" ] .= '<label for="bodyhtml">'. _( 'Šablona těla' ) .': </label>
<select name="bodyhtml">';
            foreach ( $listBodies as $value ) {
                $this -> page [ "text" ] .= '<option value="'. $value .'"'. ( ( $bodyhtml == $value ) ? " selected=\"selected\"" : "" ) .'>'. $value .'</option>';
            }
            $this -> page [ "text" ] .= '</select><br />';
            //////////////////////////////////////////////////////////////////////////////
        }

        $this -> page [ "text" ] .= '<input class="dialoguebutton" type="submit" value="'. ( is_array ( $editing_folder ) ? _( "Uložit změny" ) : _( "Vytvořit" ) ) .'" onclick="changeDialogueByPost(\''. Tools::getPage () .'.xml?action=createfolder\',\''.$id_preface.'FolderEditorForm\');return false;" />
</fieldset>
</form>';
    } // end newFolder

    private function getHTMLTemlates ( $folder )
    {
        $list_of_html_files = array ();
        $firstLevel = Database::connection () -> fetchall_assoc ( "SELECT * FROM `drivefilesv2` WHERE url='". $folder ."';" );
        foreach ( $firstLevel as $row ) {
            if ( SecurityTools::check_read ( $row [ "access" ], $row [ "author" ], $row [ "groupid" ] ) ) {
                $type = substr ( strrchr ( $row [ "physicalname" ], "." ), 1 );
                if ( $type == "html" ) {
                    $list_of_html_files [] = $row [ "physicalname" ];
                } elseif ( $type == "" ) {
                    $list_of_html_files = array_merge ( $list_of_html_files, $this -> getHTMLTemlates ( $folder.$row["physicalname"]."/" ) );
                }
            }
        }
        return $list_of_html_files;
    } // end getHTMLTemlates

    private function showDraft ()
    {
        $draft = Database::connection () -> fetch_assoc ( "SELECT * FROM drafts WHERE id=". (int) $_GET [ "id" ] .";" );

        // access checking ///////////////////////////////////////////////////////////
        if ( $draft [ "directory" ] == 0 ) { // page is in no directory, only article access will be checked
            if ( !SecurityTools::check_read ( "wr0", $draft [ "author" ], 2 ) ) {
                Error::ticket () -> notice ( 'cor00028', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
        } else { // system will check article and directory access
            $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". $draft [ "directory" ] .";" );
            if ( !SecurityTools::check_read ( "wr0", $draft [ "author" ], 2 ) ||
                !SecurityTools::check_read ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
                Error::ticket () -> notice ( 'cor00028', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
        }
        //////////////////////////////////////////////////////////////////////////////

        $this -> page [ "title" ] .= $draft [ "title" ];
        $this -> page [ "text" ] .= '<dir class="floatRight">
<a href="#" class="cor-button-small cor-articleEdit" onclick="changeDialogueByGET(\''. Tools::getPage () .'.xml?action=articlestep2&draftid='. (int) $_GET [ "id" ] .'\');return false;"><span>'. _( 'Dokončit článek' ) .'</span></a>
</dir>';
        $this -> page [ "text" ] .= '<p><strong>'. _( "Úvodník" ) .':</strong></p>';
        $this -> page [ "text" ] .= $draft [ "editorial" ];
        $this -> page [ "text" ] .= '<p><strong>'. _( "Text" ) .':</strong></p>';
        $this -> page [ "text" ] .= '<div class="dialogue-text">'. $draft [ "text" ] .'</div>';
        $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
    } // end showDraft

    private function showText ()
    {
        $article = Database::connection () -> fetch_assoc ( "SELECT * FROM header, content WHERE header.id=". (int) $_GET [ "id" ] ." AND content.id_header=". (int) $_GET [ "id" ] .";" );

        // access checking ///////////////////////////////////////////////////////////
        if ( $article [ "directory" ] == 0 ) { // page is in no directory, only article access will be checked
            if ( !SecurityTools::check_read ( $article [ "access" ], $article [ "author" ], $article [ "groupid" ] ) ) {
                Error::ticket () -> notice ( 'cor00028', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
        } else { // system will check article and directory access
            $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". $article [ "directory" ] .";" );
            if ( !SecurityTools::check_read ( $article [ "access" ], $article [ "author" ], $article [ "groupid" ] ) ||
                !SecurityTools::check_read ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
                Error::ticket () -> notice ( 'cor00028', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
        }
        //////////////////////////////////////////////////////////////////////////////

        $this -> page [ "title" ] = $article [ "title" ];
        $this -> page [ "text" ] = '<dir class="floatRight">
<a href="#" class="cor-button-small cor-articleEdit" onclick="changeWidthDialogueByGET(\''. Tools::getPage () .'.xml?action=editarticlecontent&#038;id='. (int) $_GET [ "id" ] .'\',800);return false;"><span>'. _( 'Upravit text' ) .'</span></a>
</dir>';
        $this -> page [ "text" ] .= '<p><strong>'. _( "Úvodník" ) .':</strong></p>';
        $this -> page [ "text" ] .= $article [ "editorial" ];
        $this -> page [ "text" ] .= '<hr class="cleaner" /><p><strong>'. _( "Text" ) .':</strong></p>';
        $this -> page [ "text" ] .= '<div class="dialogue-text">'. $article [ "text" ] .'</div>';
        $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
    } // end showText

    private function showArticle ()
    {
        if ( empty ( $_GET [ "id" ] ) ) {
            $this -> page [ "title" ] = _( "Chyba" );
            $this -> page [ "text" ] = '<p><strong class="warning">'. _( 'Není definován indentifikátor článku!' ) .'</strong></p>
<input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
            return;
        }

        $article = Database::connection () -> fetch_assoc ( "SELECT * FROM header WHERE id=". (int) $_GET [ "id" ] .";" );

        // access checking ///////////////////////////////////////////////////////////
        if ( $article [ "directory" ] == 0 ) { // page is in no directory, only article access will be checked
            if ( !SecurityTools::check_read ( $article [ "access" ], $article [ "author" ], $article [ "groupid" ] ) ) {
                Error::ticket () -> notice ( 'cor00028', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
        } else { // system will check article and directory access
            $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". $article [ "directory" ] .";" );
            if ( !SecurityTools::check_read ( $article [ "access" ], $article [ "author" ], $article [ "groupid" ] ) ||
                !SecurityTools::check_read ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
                Error::ticket () -> notice ( 'cor00028', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
        }
        //////////////////////////////////////////////////////////////////////////////

        $this -> page [ "title" ] = $article [ "title" ];
        $this -> page [ "text" ] = '<dir class="floatRight">
<a href="#" class="cor-button-small cor-articleText" onclick="changeWidthDialogueByGET(\''. Tools::getPage () .'.xml?id='. (int) $_GET [ "id" ] .'&#038;action=text\',800);return false;"><span>'. _( 'zobrazit text' ) .'</span></a>
<a href="#" class="cor-button-small cor-articleEdit" onclick="changeWidthDialogueByGET(\''. Tools::getPage () .'.xml?action=editarticlecontent&#038;id='. (int) $_GET [ "id" ] .'\',800);return false;"><span>'. _( 'Upravit' ) .'</span></a>
</dir>';
        $this -> page [ "text" ] .= '<ul><li>'. ( ( $article [ "type" ] == "static" ) ? _( "Statická stránka" ) : ( ( $article [ "type" ] == "script" ) ? _( "Obsah je řízený PHP skriptem" ) : _( "Text obsahuje dynamické prvky" ) ) ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( 'Identifikátor' ) .':</strong> '. $article [ "id" ] .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( 'Autor' ) .':</strong> '. Database::connection () -> getResult ( "SELECT nick FROM users WHERE id=". $article [ "author" ] .";" ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( 'Skupina' ) .':</strong> '. Database::connection () -> getResult ( "SELECT usergroup FROM usergroups WHERE id=". $article [ "groupid" ] .";" ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Přístupová práva" ) .':</strong> '. $article [ "access" ] .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Vytvořeno" ) .':</strong> '. Tools::getRightDate ( $article [ "created" ], "full" ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Publikováno" ) .':</strong> '. Tools::getRightDate ( $article [ "publishtime" ], "full" ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Schválil" ) .':</strong> '. Database::connection () -> getResult ( "SELECT nick FROM users WHERE id=". $article [ "authorizedby" ] .";" ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Složka" ) .':</strong> '. Database::connection () -> getResult ( "SELECT title FROM directory WHERE id=". $article [ "directory" ] .";" ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Soubor" ) .':</strong> '. urldecode ( $article [ "file" ] ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Odkaz" ) .':</strong> '. $article [ "anchor" ] .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Jazyk" ) .':</strong> '. $article [ "lang" ] .'</li></ul>';
        $this -> page [ "text" ] .= '<input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';

    } // end showArticle

    private function showDir ()
    {
        $directory = Database::connection () -> fetch_assoc ( "SELECT * FROM directory WHERE id=". (int) $_GET [ "id" ] .";" );

        // access checking ///////////////////////////////////////////////////////////
        if ( $directory [ "parent" ] == 0 ) { // directory is in no parent directory, only directory access will be checked
            if ( !SecurityTools::check_read ( $directory [ "access" ], $directory [ "author" ], $directory [ "groupid" ] ) ) {
                Error::ticket () -> notice ( 'cor00028', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
        } else { // system will check directory and parent directory access
            $parent_dir = Database::connection () -> fetch_assoc ( "SELECT author, groupid, access FROM directory WHERE id=". $directory [ "parent" ] .";" );
            if ( !SecurityTools::check_read ( $directory [ "access" ], $directory [ "author" ], $directory [ "groupid" ] ) ||
                !SecurityTools::check_read ( $parent_dir [ "access" ], $parent_dir [ "author" ], $parent_dir [ "groupid" ] ) ) {
                Error::ticket () -> notice ( 'cor00028', 'in '. __FILE__ .' on line '. __LINE__ , Tools::getFullPage () ." ". User::session () -> getNick () );
            }
        }
        //////////////////////////////////////////////////////////////////////////////

        $this -> page [ "title" ] = $directory [ "title" ];
        $this -> page [ "text" ] = '<dir class="floatRight">
<a href="#" class="cor-button-small cor-articleEdit" onclick="changeDialogueByGET(\''. Tools::getPage () .'.xml?action=editdirectory&#038;id='. (int) $_GET [ "id" ] .'\');return false;"><span>'. _( 'Upravit' ) .'</span></a>
</dir>';
        $this -> page [ "text" ] .= '<ul><li><strong>'. _( 'Identifikátor' ) .':</strong> '. $directory [ "id" ] .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( 'Autor' ) .':</strong> '. Database::connection () -> getResult ( "SELECT nick FROM users WHERE id=". $directory [ "author" ] .";" ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( 'Skupina' ) .':</strong> '. Database::connection () -> getResult ( "SELECT usergroup FROM usergroups WHERE id=". $directory [ "groupid" ] .";" ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Přístupová práva" ) .':</strong> '. $directory [ "access" ] .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Mateřská složka" ) .':</strong> '. Database::connection () -> getResult ( "SELECT title FROM directory WHERE id=". $directory [ "parent" ] .";" ) .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Šablona hlavičky" ) .':</strong> '. $directory [ "headerhtml" ] .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Šablona těla" ) .':</strong> '. $directory [ "bodyhtml" ] .'</li>';
        $this -> page [ "text" ] .= '<li><strong>'. _( "Jazyk" ) .':</strong> '. $directory [ "lang" ] .'</li></ul>';
        $this -> page [ "text" ] .= '<input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
    } // end showDir

    private function sort ()
    {

        $this -> page [ "title" ] = _( "Třídění obsahu" );
        $pieces = explode ( "|", $_GET [ "list" ] );
        $i = 1;
        foreach ( $pieces as $one ) {
            $type = substr($one,0,1);
            $one = substr($one,1);
            if ($type == "d") {
                if ( ! Database::connection () -> query ( "UPDATE directory SET sequence=$i WHERE id = '".$one."';" ) ) {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. $one . _( "Nepodařilo se upravit pořadí!" ) .'</strong></p>';
                }
            }
            if ($type == "a") {
                if ( ! Database::connection () -> query ( "UPDATE header SET sequence=$i WHERE id = '".$one."';" ) ) {
                    $this -> page [ "text" ] .= '<p><strong class="warning">'. $one . _( "Nepodařilo se upravit pořadí!" ) .'</strong></p>';
                }
            }
            $i++;
        }
        $this -> page [ "text" ] .= "<br />"._( "Třídění dokončeno!" ) ;
        $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "Zavřít" ) .'" />';
    } // end sort

}

$Articles = new Articles ();
$page = $Articles -> page;
?>