<?php
/* **************************************************************************** *

 * cor-source-editor.php							*
 * @package	Core								*
 * @copyright:	Copyright (c) 2008 Martin Novák. All rights reserved		*
 * @license	GNU/AGPL http://www.gnu.org/licenses/agpl.html			*

 * Albireo is free software! You can redistribute it and/or modify it under	*
 * the terms of the GNU Affero General Public License as published		*
 * by the Free Software Foundation, either version 3 of the License, or		*
 * (at your option) any later version.						*

 *	This program is distributed in the hope that it will be useful,		*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the		*
 *	GNU Affero General Public License for more details.			*

 This script description:
 Page for editing source.

 Properties:
    array $page			// contains changes for array $page in ScriptPage
 Public Methods:
    none

 * **************************************************************************** */

class Editor {

    public $page = array ( "text" => "" );
    //protected $create_content;

    public function __construct ()
    {
	if ( isset ( $_GET [ "action" ], $_POST [ "source" ], $_POST [ "src" ] ) && $_GET [ "action" ] == "createfile" ) {
	    $this -> createContent ();
	} elseif ( isset ( $_GET [ "src" ] ) ) {
	    $this -> formular ();
	} else {
	    $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Nejsou dostupná žádná pracovní data!" ) .'</strong></p>';
	}

    } // end __construct

    private function createContent ()
    {

	$src = htmlspecialchars ( $_POST [ "src" ] );
	$type = substr ( $src, strpos ( $src, ".", 1 ) +1 ); // find type of file

	switch ( $type ) {
	    case "html":
	    	$this -> createXHTMLContent ();
	    	break;
	    case "css":
	    	$this -> createCSSContent ();
	    	break;
	    default:
	    	$this -> page [ "text" ] = '<p><strong class="warning">'. _( "Soubor má neznámou koncovku!" ) .'</strong></p>';
	}

    } // end createContent

    private function createCSSContent ()
    {

    	$src = htmlspecialchars ( $_POST [ "src" ] );
    	$source = stripslashes ( $_POST [ "source" ] );

    	$this -> backup ( $src );

    	if ( @file_put_contents ( $src, $source ) ) {
    	    $this -> page [ "text" ] .= '<p><strong class="success">'. $src .' - '. _( "css soubor byl uložen." ) .'</strong></p>';
    	} else {
    	    $this -> page [ "text" ] .= '<p><strong class="warning">'. $src .' - '. _( "soubor se nepodařilo uložit!" ) .'</strong></p>';
    	}

    } // end createCSSContent

    private function createXHTMLContent ()
    {

	$src = htmlspecialchars ( $_POST [ "src" ] );
    	$source = stripslashes ( trim ( $_POST [ "source" ] ) );

        if ( substr ( $src, 0, 13 ) == "xhtml/bodies/" ) {
            if ( !preg_match ( "/^<body>[\d\D]*<\/body>$/", $source ) ) {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. $src .' - '. _( "html soubor nebyl uložen!" ) .'</strong><br />
                    '. _( "každá XHTML šablona těla musí být vložena mezi značky <br /><em>&lt;body&gt;</em> a <em>&lt;/body&gt;</em>." ) .'</p>';
                return;
            }
            if ( !preg_match ( "/<extension>(\s*)<article( notfound=\"(.*?)*\"){1}( comments=\"(.*?)*\")? \/>(\s*)<\/extension>/", $source ) ) {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. $src .' - '. _( "html soubor nebyl uložen!" ) .'</strong><br />
                    '. _( "každá XHTML šablona těla musí obsahovat značku <br /><em>&lt;extension&gt;&lt;article notfound=\"nenalezeno\" /&gt;&lt;/extension&gt;</em><br />pro generování textu." ) .'</p>';
                return;
            }
        } elseif ( substr ( $src, 0, 14 ) == "xhtml/headers/" ) {
            if ( !preg_match ( "/^<head>[\d\D]*<\/head>$/", $source ) ) {
                $this -> page [ "text" ] .= '<p><strong class="warning">'. $src .' - '. _( "html soubor nebyl uložen!" ) .'</strong><br />
                    '. _( "každá XHTML šablona hlavičky musí být vložena mezi značky <br /><em>&lt;head&gt;</em> a <em>&lt;/head&gt;</em>." ) .'</p>';
                return;
            }
        } else {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. $src .' - '. _( "soubor nebyl uložen neboď je požadována podivná cílová adresa." ) .'</strong></p>';
            return;
        }

	$this -> backup ( $src );

	if ( @file_put_contents ( $src , $source ) ) {
    	    $this -> page [ "text" ] .= '<p><strong class="success">'. $src .' - '. _( "html soubor byl uložen." ) .'</strong></p>';
    	    $this -> parse ( $src );
	} else {
	    $this -> page [ "text" ] .= '<p><strong class="warning">'. $src .' - '. _( "html soubor se nepodařilo uložit!" ) .'</strong></p>';
	}

    } // end createXHTMLContent

    private function formular ()
    {
        $id_preface = time ();
	$src = htmlspecialchars ( $_GET [ "src" ] );
	$physicalname = substr ( $src, strpos ( $src, "/", 1 ) +1 );

	if ( file_exists ( $src ) ) {

	    $content = @file_get_contents ( $src );

	    $type = substr ( $src, strpos ( $src, ".", 1 ) +1 ); // find type of file

	    switch ( $type ) {
	    	case "html":
	    	    $type = "XHTML";
	    	    break;
	    	case "css":
	    	    $type = "CSS";
	    	    break;
	    }

	    $this -> page [ "text" ] .= '<dir class="floatRight">
 		<a href="#" class="cor-button-small cor-articleEdit" onclick="changeWidthDialogueByGET(\''. Localization::session () -> getFile ( "cor-drive", false ) .'.xml?action=editfile&#038;physicalname='. $src .'\',550);return false;"><span>'. _( 'editovat' ) .'</span></a>
		</dir>';
	    $this -> page [ "text" ] .= '
            <script type="text/javascript">
                currentPrefaceSourceForm = "'.$id_preface.'";
                $("#++dialogueID++").bind("dialogfocus", function(event, ui) {
                    currentPrefaceSourceForm = "'.$id_preface.'";
                });
                function saveSourceDocument () {
                    changeIdByPost(\''. Tools::getPage () .'.xml?action=createfile\',\''.$id_preface.'EditorForm\',\''.$id_preface.'editorResponses\');
                    $(document).ajaxSuccess(function(evt, request, settings){
                        if ( settings [ "url" ] == "'. Tools::getPage () .'.xml?action=createfile" ) {
                            showAndHide(\''.$id_preface.'editorResponses\');
                        }
                    });
                }
            </script>
            <script type="text/javascript" src="scripts/jqr-tabby.js"></script>
            <strong class="floatLeft">'. _( "Akce editoru" ) .':</strong><br />
	    	<a href="#" onclick="increaseFont(\''.$id_preface.'source\');return false;" class="cor-32button cor-plus floatLeft" title="'. _( "zvětšit písmo" ) .'"><span class="undisplayed">'. _( "plus" ) .'</span></a>
	    	<a href="#" onclick="decreaseFont(\''.$id_preface.'source\');return false;" class="cor-32button cor-minus floatLeft" title="'. _( "zmenšit písmo" ) .'"><span class="undisplayed">'. _( "mínus" ) .'</span></a>
	    	<a href="#" onclick="saveSourceDocument();return false;" class="cor-32button cor-filesave floatLeft" title="'. _( "uložit" ) .'"><span class="undisplayed">'. _( "uložit" ) .'</span></a>
	    	<span id="'.$id_preface.'editorResponses" class="floatLeft"></span>
	    	<hr class="cleaner" />
		<form id="'.$id_preface.'EditorForm" action="'. Localization::session () -> getFile ( "cor-source-editor" ) .'" method="post" enctype="application/x-www-form-urlencoded">
		<fieldset>
            <div>'. _( "Zdrojový kód" ) .' <em>'. $src .'</em></div>
		    <label for="source">'. $type .':</label><br /><br />
		    <textarea id="'.$id_preface.'source" name="source" rows="30" cols="100">'. htmlspecialchars ( $content ) .'</textarea><br />
		    <input type="hidden" name="src" value="'. $src .'" />
		    <input class="dialoguebutton" type="submit" value="'. _( "Uložit do" ) .' '. $src .'" onclick="changeDialogueByPost(\''. Tools::getPage () .'.xml?action=createfile\',\''.$id_preface.'EditorForm\');return false;" />
		</fieldset>
		</form>
                <script type="text/javascript">$("#'.$id_preface.'source").tabby();</script>
		<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="'. _( "neukládat" ) .'" />';

	} else {
	    $this -> page [ "text" ] = '<p><strong class="warning">'. _( "Soubor se nepodařilo nalést na disku." ) .'</strong></p>';
	    $this -> page [ "text" ] .= '<br /><input type="button" class="dialoguebutton" onclick="closeDialogueWindow();" value="OK" />';
	    return;
	}

    } // end formular

    private function backup ( $file )
    {
	if ( !copy ( $file, $file.".bak" ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se vytvořit zálohu!" ) .'</strong></p>';
	}
    } // end backup

    private function fromBackup ( $file )
    {
	if ( !copy ( $file.".bak", $file ) ) {
            $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Nepodařilo se obnovit soubor ze zálohy!" ) .'</strong></p>';
	} else {
	    $this -> page [ "text" ] .= '<p><strong class="success">'. _( "Soubor byl obnoven ze zálohy" ) .'</strong></p>';
	}
    } // end fromBackup

    private function parse ( $file )
    {

	$save = Parser::session () -> parserStart ( $file, "extension" );

	if ( $save == false ) {
	    $this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Chyba při parsování" ) .' '. $file .'!</strong></p>';
		$this -> page [ "text" ] .= Parser::$err;
	    $this -> fromBackup ( $file );
	    return false;
	} else {
	    $file = substr ( $file, 0, -4 ) ."php";
    	    if ( @file_put_contents ( "xhtml/". substr ( strrchr ( $file, "/" ), 1 ) , $save ) ) {
    	    	$this -> page [ "text" ] .= '<p><strong class="success">'. _( "Soubor byl úspěšně naparsován a uložen v PHP formátu." ) .'</strong></p>';
    	    	@php_strip_whitespace ( "xhtml/". substr ( strrchr ( $file, "/" ), 1 ) );
    	    } else {
    	    	$this -> page [ "text" ] .= '<p><strong class="warning">'. _( "Soubor se nepodařilo uložit v PHP formátu" ) .'!</strong></p>';
    	    }
	}

    } // parse

}

$Editor = new Editor ();
$page = $Editor -> page;