<?php
/* **************************************************************************** *

 * cor-overview.php								*
 * @version: 	1.0.0								*
 * @package	Core								*
 * @copyright:	Copyright (c) 2007 - 2008 Ragnar.cz. All rights reserved	*
 * @license	GNU/GPL http://www.gnu.org/copyleft/gpl.html			*
 
 * Albireo is free software! This file may have been modified pursuant to the	*
 * GNU General Public License, and as distributed it includes or is derivative	*
 * of works licensed under the GNU General Public License or other free or open	*
 * source software licenses.							*

 This script description:
 Home page for administration of Albireo showing statistics and similar.

 Properties:
    array $page			// contains changes for array $page in ScriptPage
 	
 Public Methods:
    none
 	
 * **************************************************************************** */

class Overview {

    public $page = array ( "text" => "" );

    public function __construct ()
    {
	if ( isset ( $_SERVER [ "HTTPS" ] ) ) {
            header ( Tools::getHttpAddress (). Tools::getFullPage () );
        }
        if ( isset ( $_GET [ "portlet" ] ) ) {
            $portletsorder = "";
            foreach ( $_GET [ "portlet" ] as $value ) {
                $portletsorder .= $value.';';
            }
            if(!Database::connection()->query("DELETE FROM `portlets` WHERE `userid`=".User::session()->getId()." AND `pcolumn`='".addslashes($_GET["column"])."';") ||
               !Database::connection()->query("INSERT INTO `portlets` (`userid`,`pcolumn`,`apps`) VALUES (".User::session()->getId().",'".addslashes($_GET["column"])."','".$portletsorder."');")){
                $this -> page [ "text" ] .= '<strong class="warning">'._("Chyba při aktualizování databáze portletů.").'</strong>';
            }
            return;
        }
    	$this -> checkBrowser ();
        $this -> default_contents ();
    } // end __construct

    private function default_contents ()
    {
        $this -> page [ "title" ] = _( "Vítejte zpět, " ). User::session () -> getFullName ();
        $this -> page [ "text" ] .= '<h2 style="text-align:center;">'. _( "Albireo I" ) .'</h2>
        <div>'._("Albireo je svobodný software šířený pod licencí").' <a href="license.txt">GNU/AGPL</a>.</div><br />
        <span id="portletsorder1"></span> <span id="portletsorder2"></span> <span id="portletsorder3"></span>
        <script type="text/javascript" src="scripts/cor-ajax-change.js"></script>
        <script type="text/javascript">
            $(function() {
                $(".column").sortable({
                    connectWith: \'.column\',
                    tolerance: \'pointer\',
                    handle: \'.portlet-header\'
                });
                $(".column").bind(\'sortstop\', function(event, ui) {
                    $(".column").each(function() {
                        $(this).sortable("toArray");
                    });
                    if($("#portletcol1").sortable("serialize")!="") {
                        changeIdByGET("'. Tools::getPage() .'.xml?column=column1&"+$("#portletcol1").sortable("serialize"),"portletsorder1");
                    } else {
                        changeIdByGET("'. Tools::getPage() .'.xml?column=column1&portlet[]=","portletsorder1");
                    }
                    if($("#portletcol2").sortable("serialize")!="") {
                        changeIdByGET("'. Tools::getPage() .'.xml?column=column2&"+$("#portletcol2").sortable("serialize"),"portletsorder2");
                    } else {
                        changeIdByGET("'. Tools::getPage() .'.xml?column=column2&portlet[]=","portletsorder2");
                    }
                    if($("#portletcol3").sortable("serialize")!="") {
                        changeIdByGET("'. Tools::getPage() .'.xml?column=column3&"+$("#portletcol3").sortable("serialize"),"portletsorder3");
                    } else {
                        changeIdByGET("'. Tools::getPage() .'.xml?column=column3&portlet[]=","portletsorder3");
                    }
                });

                $(".portlet").addClass("ui-widget ui-widget-content ui-helper-clearfix ui-corner-all")
                    .find(".portlet-header")
                    .addClass("ui-widget-header ui-corner-all")
                    .prepend(\'<span class="ui-icon ui-icon-plusthick"></span>\')
                    .end()
                    .find(".portlet-content");

                $(".portlet-header .ui-icon").click(function() {
                    $(this).toggleClass("ui-icon-minusthick");
                    $(this).parents(".portlet:first").find(".portlet-content").toggle();
                });

                $(".column").disableSelection();
            });
        </script>
        <div style="width:900px;margin:0px auto;">
            <div class="column" id="portletcol1">';
        $portlets = Database::connection () -> getResult ( "SELECT apps FROM portlets WHERE userid=".User::session()->getId()." AND pcolumn='column1';" );
        if ( $portlets == "" ) {
            $portletsarray = array ( "visitorsstats", "latestarticles" );
        } else {
            $portletsarray = explode (";",$portlets);
        }
        if ( $portlets != ";" ) {
            foreach ( $portletsarray as $value ) {
                if ( $value != "" ) {
                    require ( "extensions/portlets/cor-".$value."portlet.php" );
                    $this -> page [ "text" ] .= $portlet;
                }
            }
        }
        $this -> page [ "text" ] .= '</div>
            <div class="column" id="portletcol2">';
        $portlets = Database::connection () -> getResult ( "SELECT `apps` FROM `portlets` WHERE `userid`=".User::session()->getId()." AND `pcolumn`='column2';" );
        if ( $portlets == "" ) {
	    if ( User::session() -> getPrimaryGroup() == 1 ) {
		$portletsarray = array ( "updatescheck","logins" ); // updatescheck is only for administrators
	    } else {
		$portletsarray = array ( "logins" );
	    }
        } else {
            $portletsarray = explode (";",$portlets);
        }
        if ( $portlets != ";" ) {
            foreach ( $portletsarray as $value ) {
                if ( $value != "" ) {
                    require ( "extensions/portlets/cor-".$value."portlet.php" );
                    $this -> page [ "text" ] .= $portlet;
                }
            }
        }
        $this -> page [ "text" ] .= '</div>
            <div class="column" id="portletcol3">';
        $portlets = Database::connection () -> getResult ( "SELECT `apps` FROM `portlets` WHERE `userid`=".User::session()->getId()." AND `pcolumn`='column3';" );
        if ( $portlets == "" ) {
            $portletsarray = array ( "rssnovinky", "rssclanky" );
        } else {
            $portletsarray = explode (";",$portlets);
        }
        if ( $portlets != ";" ) {
            foreach ( $portletsarray as $value ) {
                if ( $value != "" ) {
                    require ( "extensions/portlets/cor-".$value."portlet.php" );
                    $this -> page [ "text" ] .= $portlet;
                }
            }
        }
        $this -> page [ "text" ] .= '</div>
        </div>';
        $this -> page [ "text" ] .= '<hr class="cleaner">';
    } // end default_contents

    private function checkBrowser ()
    {
    	if ( !stripos ( $_SERVER [ "HTTP_USER_AGENT" ], "firefox" ) && !stripos ( $_SERVER [ "HTTP_USER_AGENT" ], "opera" ) && !stripos ( $_SERVER [ "HTTP_USER_AGENT" ], "safari" ) ) {
    	    $this -> page [ "text" ] .= '<div id="firefox" class="border center"><p>'.
    	    _( "Pro lepší kompatibilitu se systémem Albireo používejte moderní <strong>prohlížeč Mozilla Firefox</strong>. Sami brzo zjistíte, že Vám dává při pohybu na internetu mnohem <strong>větší možnosti</strong>." )
    	    .'</p><hr class="cleaner" /></div>';
    	}
    } // end checkBrowser

}

$Overview = new Overview ();
$page = $Overview -> page;
?>