<?php
/**
 * Class for Albireo users
 * @package    Albireo I
 * @subpackage Core
 * @copyright  Copyright (c) 2009 Martin Novák. All rights reserved
 * @license    GNU/AGPL http://www.gnu.org/licenses/agpl.html
 *
 * Albireo is free software! You can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *	GNU Affero General Public License for more details.
 */

/**
 * Class for Albireo users
 * @package    Albireo I
 * @subpackage Core
 */
class AlbireoUser implements UserInterface {

    private $user;
    private static $isLogedOut = array ();

    /**
     * construct AlbireoUser class
     * if the user has alreadz logged in, he is send to cor-overview page
     * @return void|false
     */
    public function __construct () {
    	
    	if ( self::isLogedIn () ) {

	    $primarygroup = Database::connection () -> getResult ( "SELECT `groupid` FROM `membersofgroups` WHERE `userid`=". (int) $_SESSION [ "sessionid" ] ." AND `groupid`<=4;" );

    	    if ( Tools::getPage () == Localization::session () -> getFile ( "cor-log-in" ) ) {
		if ( $primarygroup < 4 ) {
		    header ( "Location:". Localization::session () -> getFile ( "cor-overview" ) );
		} else {
		    header ( "Location:cs_index" );
		}
    	    }

    	    if ( Tools::baseSettings () -> getSetting ( "first_administrator_created" ) == "true" &&
    	    	 Database::connection () -> is_connected () ) {
    	    	$this -> user = Database::connection () -> fetch_assoc ( "SELECT * FROM `users` WHERE `id`='". (int) $_SESSION [ "sessionid" ] ."';" );
		$this -> user [ "primarygroup" ] = $primarygroup;
                return false;
    	    }
    	    
    	}
    	    
    } // end __construct

    public static function openIdLogin ( $openid )
    {
        $userid = Database::connection () -> getResult ( "SELECT `userid` FROM `openids` WHERE `openid`='$openid';" );
        if ( $userid > 0 ) {
            $_SESSION [ "sessionid" ] = $userid;
            if ( Database::connection () -> query ( "UPDATE `users` SET `logedout`=0 WHERE `id`=$userid;" ) ) {
                if ( Database::connection () -> query ( "INSERT INTO `logins` VALUES ('". $_SESSION [ "sessionid" ] ."', '". $_SERVER [ "REMOTE_ADDR" ] ."', '". getHostByADDR ( $_SERVER [ "REMOTE_ADDR" ] ) ."', '". $_SERVER [ "HTTP_USER_AGENT" ] ."', CURRENT_TIMESTAMP() );" ) ) {
		    if ( Database::connection () -> getResult ( "SELECT `groupid` FROM `membersofgroups` WHERE `userid`=". $_SESSION [ "sessionid" ] ." AND `groupid`<=4;" ) < 4 ) {
			if ( empty ( $_GET [ "loginpage" ] ) ) {
			    header ( "Location:". Localization::session () -> getFile ( "cor-overview" ) );
			} else {
			    header ( "Location:". Tools::getHttpAddress () . $_GET [ "loginpage" ] . Tools::baseSettings () -> getSetting ( "file_extension" ) );
			}
		    } else {
			header ( "Location:cs_index" );
		    }
                } else {
    	    	  	return '<p><strong class="warning">'. _( "Nepodařilo se vložit údaje o vašem přihlášení!" ) .'</strong></p>';
    	    	}
            } else {
    	        return '<p><strong class="warning">'. _( "Nepodařilo se vložit záznam o vašem přihlášení!" ) .'</strong></p>';
    	    }
        } else {
            return '<p><strong class="warning">'. _( "Vaše OpenID není spojeno s žádným uživatelem v databázi. Přihlašte se pomocí svého uživatelského účtu a spojení s OpenID proveďte v nastavení uživatele." ) .'</strong></p>';
        }
    } // end openIdLogin

    public static function login ( $name, $password )
    {

	$user_name = htmlspecialchars ( $name );
	$user_password = md5 ( $password );

    	if ( $database_password = Database::connection () -> getResult ( "SELECT `password` FROM `users` WHERE `nick`='$user_name';" ) ) {
    	    if ( $database_password == $user_password ) {
    	    	$_SESSION [ "sessionid" ] = Database::connection () -> getResult ( "SELECT `id` FROM `users` WHERE `nick`='$user_name';" );
    	    	if ( Database::connection () -> query ( "UPDATE `users` SET `logedout`=0 WHERE `nick`='$user_name';" ) ) {
		    if ( Database::connection () -> query ( "INSERT INTO `logins` VALUES ('". $_SESSION [ "sessionid" ] ."', '". $_SERVER [ "REMOTE_ADDR" ] ."', '". getHostByADDR ( $_SERVER [ "REMOTE_ADDR" ] ) ."', '". $_SERVER [ "HTTP_USER_AGENT" ] ."', CURRENT_TIMESTAMP () );" ) ) {
			if ( Database::connection () -> getResult ( "SELECT `groupid` FROM `membersofgroups` WHERE `userid`=". $_SESSION [ "sessionid" ] ." AND `groupid`<=4;" ) < 4 ) {
			    if ( empty ( $_GET [ "loginpage" ] ) ) {
				header ( "Location:". Localization::session () -> getFile ( "cor-overview" ) );
			    } else {
				header ( "Location:". $_GET [ "loginpage" ] . Tools::baseSettings () -> getSetting ( "file_extension" ) );
			    }
			} else {
			    header ( "Location:cs_index" );
			}
    	    	    } else {
    	    	    	return '<p><strong class="warning">'. _( "Nepodařilo se vložit údaje o vašem přihlášení!" ) .'</strong></p>';
    	    	    }
    	    	} else {
    	    	    return '<p><strong class="warning">'. _( "Nepodařilo se vložit záznam o vašem přihlášení!" ) .'</strong></p>';
    	    	}    	    	
    	    } else {
    	    	return '<p><strong class="warning">'. _( "Špatné heslo nebo jméno!" ) .'</strong></p>';
    	    }
    	} else {
    	    return '<p><strong class="warning">'. _( "Špatné heslo nebo jméno!" ) .'</strong></p>';
    	}
    	
    }

    public static function isLogedIn ()
    {
    	if ( !isset ( $_SESSION ) ) {
    	    if ( !self::ini_session () ) {
    	    	Error::ticket () -> notice ( 'cor00005', 'in '. __FILE__ .' on line '. __LINE__ );
    	    }
    	}
    	if ( isset ( $_SESSION [ "sessionid" ] ) && self::userIsLogedIn ( $_SESSION [ "sessionid" ] ) ) {
    	    return true;
    	} else {
    	    return false;
    	}
    }

    public static function userIsLogedIn ( $userid )
    {
    	if ( isset ( self::$isLogedOut [ $userid ] ) ) {
            if ( self::$isLogedOut [ $userid ] == 0 ) {
                return true;
            } else {
                return false;
            }
        }
    	if ( Database::connection () -> getResult ( "SELECT `logedout` FROM `users` WHERE `id`='$userid' LIMIT 1;" ) == 0 ) {
            self::$isLogedOut [ $userid ] = 0;
    	    return true;
    	} else {
            self::$isLogedOut [ $userid ] = 1;
    	    return false;
    	}
    }

    private static function ini_session ()
    {
    	@ini_set ( "session.use_only_cookies", 1 );
    	@ini_set ( "session.use_cookies", 1 );
    	if ( session_start () ) {
    	    return true;
    	} else {
    	    return false;
    	}
    } // end ini_session

    public function getFullName ()
    {
    	return $this -> user [ "fullname" ];
    } // end getFullName

    public function getId ()
    {
    	return $this -> user [ "id" ];
    } // end getId

    public function getNick ()
    {
    	return $this -> user [ "nick" ];
    } // end getNick

    public function getType ()
    {
    	return "AlbireoUser";
    } // end getType

    public function getPrimaryGroup ()
    {
    	return $this -> user [ "primarygroup" ];
    } // end getPrimaryGroup

    public function getLanguage ()
    {
    	return $this -> user [ "language" ];
    } // end getLanguage

    public function getEmail ()
    {
    	return $this -> user [ "email" ];
    } // end getEmail
    
}

?>