#!/bin/bash

DESTDIR="$1"

CONFIG_PATH="none"
for i in /etc/XF86Config /usr/X11R6/lib/X11/XF86Config.`hostname` \
	/usr/X11R6/lib/X11/XF86Config
do
	if test -r $i
	then
		CONFIG_PATH=$i
		break
	fi
done

[ "$CONFIG_PATH" = none ] && exit 1

TEMP=/tmp/XF86Config.$$
awk '/^[ \t]*Section[ \t]+"Files"/ { in_files = 1 }
	in_files==1 && $1=="FontPath" && $2 ~ "'${DESTDIR}'" { found = 1 }
	in_files==1 && /^[ \t]*EndSection/ { in_files=0;
		if (!found) { print "	FontPath	\"'${DESTDIR}'\""; }
	}
	{ print }' <$CONFIG_PATH >$TEMP && cat $TEMP >$CONFIG_PATH

rm -f $TEMP

exit 0

