#!/usr/bin/env perl

use strict qw(vars refs subs);
use Meta::Utils::System qw();
use Meta::Utils::Opts::Opts qw();
use Meta::Utils::Output qw();
use Meta::IO::File qw();

my($services,$verbose);
my($opts)=Meta::Utils::Opts::Opts->new();
$opts->set_standard();
$opts->def_file("services","where is your services file ?","/etc/services",\$services);
$opts->def_bool("verbose","should I be noisy ?",1,\$verbose);
$opts->set_free_allo(0);
$opts->analyze(\@ARGV);

my($io)=Meta::IO::File->new($services,"r");
my($line)=$io->getline();
while(!$io->eof()) {
	chop($line);
	# parse the line
	# the line is not a comment
	if($line=~/^#/) {
		$line=$io->getline();
		next;
	}
	if($line eq "") {
		$line=$io->getline();
		next;
	}
	Meta::Utils::Output::verbose($verbose,"got [".$line."]\n");
	$line=$io->getline();
}
$io->close();

Meta::Utils::System::exit_ok();

__END__

=head1 NAME

nettools_import_services.pl - import services data from /etc/services to an RDBMS.

=head1 COPYRIGHT

Copyright (C) 2001, 2002 Mark Veltzer;
All rights reserved.

=head1 LICENSE

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

=head1 DETAILS

	MANIFEST: nettools_import_services.pl
	PROJECT: meta
	VERSION: 0.00

=head1 SYNOPSIS

	nettools_import_services.pl [options]

=head1 DESCRIPTION

This script will read the /etc/services file found on a standard UNIX system, will parse
it and will store it in an RDBMS which has the particular set of tables designed
to store this information. Why is this good for ?!? For working with the data in an RDBMS
and not in some text file which you need to build a parser for.

=head1 OPTIONS

=over 4

=item B<help> (type: bool, default: 0)

display help message

=item B<pod> (type: bool, default: 0)

display pod options snipplet

=item B<man> (type: bool, default: 0)

display manual page

=item B<quit> (type: bool, default: 0)

quit without doing anything

=item B<gtk> (type: bool, default: 0)

run a gtk ui to get the parameters

=item B<license> (type: bool, default: 0)

show license and exit

=item B<copyright> (type: bool, default: 0)

show copyright and exit

=item B<description> (type: bool, default: 0)

show description and exit

=item B<history> (type: bool, default: 0)

show history and exit

=item B<services> (type: file, default: /etc/services)

where is your services file ?

=item B<verbose> (type: bool, default: 1)

should I be noisy ?

=back

no free arguments are allowed

=head1 BUGS

None.

=head1 AUTHOR

	Name: Mark Veltzer
	Email: mailto:veltzer@cpan.org
	WWW: http://www.veltzer.org
	CPAN id: VELTZER

=head1 HISTORY

	0.00 MV md5 issues

=head1 SEE ALSO

Meta::IO::File(3), Meta::Utils::Opts::Opts(3), Meta::Utils::Output(3), Meta::Utils::System(3), strict(3)

=head1 TODO

Nothing.
