# -*- cperl -*-
# ABSTRACT: LaTeX group object


use strict;
use warnings;
package SpeL::Object::Group;

use parent 'Exporter';
use Carp;

use Data::Dumper;

use SpeL::Object::ElementList;



sub read {
  my $self = shift;
  my ( $level ) = @_;

  return $self->{ElementList}->read( $level + 1 );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Group - LaTeX group object

=head1 VERSION

version 20240619.1055

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX group

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
