# makefile for libpng
INCLUDE=$(INCLUDE);../../win32
# Copyright (C) 1995 Guy Eric Schalnat, Group 42, Inc.
# For conditions of distribution and use, see copyright notice in png.h
!include <make/paths.mak>
!include <make/common.mak>
!include <make/library.mak>
!include <make/programs.mak>

XCPPFLAGS= -I../zlib$(zlibver)
XLDFLAGS= $(zlib)

DEFS= $(DEFS) -D__FLAT__ -I. -I../..         \
	-DMAKE_PNG_DLL -DPNG_USE_PNGVCRD     \
	-DPNG_BUILD_DLL                      \
	-DPNG_NO_GLOBAL_ARRAYS               \
	$(ZLIB_FLAGS) $(PNG_FLAGS)

c_auto_h_dir = $(kpathsea_srcdir)

OBJS = $(objdir)\png.obj $(objdir)\pngset.obj $(objdir)\pngget.obj           \
	$(objdir)\pngrutil.obj $(objdir)\pngtrans.obj $(objdir)\pngwutil.obj \
	$(objdir)\pngread.obj $(objdir)\pngrio.obj $(objdir)\pngwio.obj      \
	$(objdir)\pngwrite.obj $(objdir)\pngrtran.obj $(objdir)\pngwtran.obj \
	$(objdir)\pngmem.obj $(objdir)\pngerror.obj $(objdir)\pngpread.obj   \
	$(objdir)\pngvcrd.obj

!IFDEF PNG_DLL
LIBPNG = $(objdir)\libpng.lib $(objdir)\libpng.dll

all: $(objdir) $(objdir)\libpng.lib $(objdir)\libpng.dll

$(objdir)\libpng.lib: $(objdir) $(OBJS)
	$(archive_command) /DEF $(OBJS)

$(objdir)\libpng.dll: $(OBJS) $(zlib) $(objdir)\libpng.lib  $(objdir)\libpng.res $(gnuw32lib)
	$(dll_command) $(**) $(objdir)\libpng.exp $(XLDFLAGS) $(LIBS)
!ELSE
LIBPNG = $(objdir)\libpng.lib

all: $(objdir) $(objdir)\libpng.lib

$(objdir)\libpng.lib: $(objdir) $(OBJS)
	$(archive_command) $(OBJS)
!ENDIF

$(objdir)\pngtest.exe: $(objdir)\pngtest.obj $(LIBPNG) $(zlib)
	$(link_command) /OUT:$@ $(objdir)\pngtest.obj $(objdir)\libpng.lib $(LIBS)

$(objdir)\pngtest.obj: pngtest.c $(LIBPNG)
	$(compile) -UMAKE_PNG_DLL pngtest.c	

test: $(objdir)\pngtest.exe
	.\$(objdir)\pngtest.exe

!include <make/libsrul.mak>

install: $(LIBPNG)
#	set TEXMFCNF=$(TEXMFCNF)
	$(mktexdir) $(toolsprefix)\bin $(toolsprefix)\lib $(toolsprefix)\include \
	$(bindir) $(libdir) $(includedir) $(man3dir) $(man5dir)
	$(CP) png.h $(toolsprefix)\include
	$(CP) pngconf.h $(toolsprefix)\include
	$(CP) $(objdir)\libpng.lib $(toolsprefix)\lib
	$(CP) png.h $(includedir)
	$(CP) pngconf.h $(includedir)
	$(CP) $(objdir)\libpng.lib $(libdir)
!IFDEF PNG_DLL
	$(CP) $(objdir)\libpng.dll $(toolsprefix)\bin
	$(CP) $(objdir)\libpng.dll $(bindir)
!ENDIF
	$(CP) libpng.3 $(man3dir)
	$(CP) libpngpf.3 $(man3dir)
	$(CP) png.5 $(man5dir)

!include <make/man.mak>
!include <make/clean.mak>
!include <make/tkpathsea.mak>
!include <make/version.mak>

clean::
	-@$(RM) $(objdir)\libpng.lib $(objdir)\libpng.dll \
		$(objdir)\pngtest.exe pngout.png

!include <make/rdepend.mak>
!include "./depend.mak"

# 
# Local Variables:
# mode: makefile
# End:
