# Makefile for web2c --kb@mail.tug.org. Public domain.
INCLUDE=$(INCLUDE);../../win32

version = 7.3.2.2

# These lines define the memory dumps that fmts/bases/mems/efmts will make
# and install-fmts/install-bases/install-mems/install-efmts will install.
# plain.* is created automatically (as a link).  See the Formats node in
# doc/web2c.texi for details on the fmts.
fmts = latex.fmt mltex.fmt # amstex.fmt eplain.fmt texinfo.fmt
efmts = elatex.efmt
cfmts = latex.efmt
pdffmts = pdflatex.fmt
pdfefmts = pdfelatex.efmt
ofmts = lambda.fmt
bases = # I do not recommend building cmmf.base.
mems =  # mfplain.mem is probably not generally useful.

# The name of the file that defines your local devices for Metafont.
# (Only relevant during `make bases'.)  I recommend `modes.mf', which
# defines all known modes, plus useful definitions for all fonts.  It's
# available from ftp://ftp.tug.org/tex/modes.mf, among other places.
localmodes = modes

!include <make/paths.mak>

# Used for triptrap.
DIFF = diff
DIFFFLAGS =

.SUFFIXES: # get rid of .p.o
!include <make/common.mak>
!include <make/library.mak>
!include <make/programs.mak>

#ifeq ($(CC), gcc)
#XDEFS = -Wimplicit -Wreturn-type -Wcomment -Wformat -D__USE_FIXED_PROTOTYPES__
#endif

# Compilation options.
DEFS = $(DEFS) -DMAKE_TEX_DLL -DHAVE_CONFIG_H -DOEM

# pdfTeX version
verpdftexdir = pdftexdir
verpdfetexdir = pdfetexdir

# Make `#include <X11/...>' and `-lX...' work.
# This matches xdvik.
# wlibs is substituted by web2c's configure, LIBS by general configure
# routines, and the others by AC_PATH_XTRA.
# All the x_... variables will be empty if we aren't supporting X.
x_cppflags = 
x_ldflags = 
x_pre_libs = 
x_extra_libs = 
x_tool_libs = gdi32.lib user32.lib
x_ext_lib = 
wlibs = 
# Follow the library order used in X11R6 itself:
#   -lXaw -lXmu -lXt -lSM -lICE -lXext -lX11 (some may not be present).
windowlink = $(windowlib) $(x_ldflags) $(x_tool_libs) $(x_pre_libs) $(x_ext_lib) $(wlibs) $(x_extra_libs)

# With --enable-ipc, TeX may need to link with -lsocket.
socketlibs = # @socketlibs@

common_makeargs = -$(MFLAGS) # CC='$(CC)' CFLAGS='$(CFLAGS)' $(XMAKEARGS)
window_makeargs = x_cppflags=$(x_cppflags) $(common_makeargs)
#install_makeargs = INSTALL="$(INSTALL)" INSTALL_DATA="$(INSTALL_DATA)" \
#  INSTALL_PROGRAM="$(INSTALL_PROGRAM)" $(makevars) $(common_makeargs) 
install_makeargs = $(makevars) $(common_makeargs) 

proglib = lib\$(objdir)\lib.lib
windowlib = window\$(objdir)\window.lib
pdflib = $(verpdftexdir)\$(objdir)\libpdf.lib
pdftoepdflib = $(verpdftexdir)\$(objdir)\libpdftoepdf.lib

pdftexlibs = $(pdflib) $(pnglib) $(zlib) $(pdftoepdflib) $(tifflib) 
pdftexlibsdep = $(pdflib) $(pdftexlibs) $(pdftoepdflib) $(pngdll) $(zdll) \
	$(xpdfdll) $(xpdfextradll) $(tiffdll) # @pdftexlibsdep@

# The sh script that does the conversion:
web2c = $(win32)\convert.bat $(objdir)
# Additional dependencies:
web2c_aux = $(win32)/convert.bat web2c/common.defines
web2c_programs = web2c/$(objdir)/fixwrites.exe web2c/$(objdir)/splitup.exe \
	web2c/$(objdir)/web2c.exe

# Unfortunately, suffix rules can't have dependencies, or multiple
# targets, and we can't assume all makes supports pattern rules.
.SUFFIXES: .p .c .ch .p .res .rc
.p.c: # really depends on $(web2c_programs), and generates .h.
	 $(web2c) $*
.ch.p: # really depends on ./tangle; for mf/mp/tex, also generates .pool
	.\$(objdir)\tangle $(srcdir)\$*.web $<

# These definitions have to come before the rules that expand them.
# The *{ini,[0-2]}.c files are created by splitup, run as part of convert.
# {mf,mp,tex}extra.c are created from lib/texmfmp.c, below.
mf_c = mfini.c mf0.c mf1.c mf2.c
mf_o = $(objdir)\mfini.obj $(objdir)\mf0.obj $(objdir)\mf1.obj $(objdir)\mf2.obj $(objdir)\mfextra.obj
mf_nowin_o = $(objdir)\mfini.obj $(objdir)\mf0.obj $(objdir)\mf1.obj $(objdir)\mf2.obj $(objdir)\mfnowin.obj
mp_c = mpini.c mp0.c mp1.c mp2.c
mp_o = $(objdir)\mpini.obj $(objdir)\mp0.obj $(objdir)\mp1.obj $(objdir)\mp2.obj $(objdir)\mpextra.obj
tex_c = texini.c tex0.c tex1.c tex2.c
tex_o = $(objdir)\texini.obj $(objdir)\tex0.obj $(objdir)\tex1.obj $(objdir)\tex2.obj $(objdir)\texextra.obj

other_c = bibtex.c dvicopy.c dvitomp.c dvitype.c gftodvi.c gftopk.c gftype.c \
  mft.c  patgen.c pktogf.c pktype.c pltotf.c pooltype.c  tangle.c tftopl.c   \
  vftovp.c vptovf.c weave.c
all_c = $(other_c) $(mf_c) $(mp_c) $(tex_c) $(etex_c) $(pdftex_c) $(omega_c) \
  $(omegaware_c)

# Prevent Make from deleting the intermediate forms.
.PRECIOUS: %.ch %.p %.c

tex = $(objdir)\tex.exe
etex = $(objdir)\etex.exe
pdftex = $(objdir)\pdftex.exe
ttf2afm = $(objdir)\ttf2afm.exe
pdftosrc = $(objdir)\pdftosrc.exe
pdfetex = $(objdir)\pdfetex.exe
omega = $(objdir)\omega.exe
odvicopy = $(objdir)\odvicopy.exe
odvitype = $(objdir)\odvitype.exe
otangle = $(objdir)\otangle.exe
mfw = mfw
mfn = mf
programs = $(objdir)\tie.exe $(objdir)\bibtex.exe $(objdir)\dvicopy.exe  \
	$(objdir)\dvitomp.exe $(objdir)\dvitype.exe $(etex)              \
	$(objdir)\gftodvi.exe $(objdir)\gftopk.exe $(objdir)\gftype.exe  \
	$(objdir)\$(mfn).exe $(objdir)\$(mfw).exe $(objdir)\mft.exe      \
	$(objdir)\mpost.exe $(odvicopy) $(odvitype) $(omega) $(otangle)  \
	$(objdir)\patgen.exe                                             \
	$(pdfetex) $(pdftex) $(objdir)\pktogf.exe $(objdir)\pktype.exe   \
	$(objdir)\pltotf.exe $(objdir)\pooltype.exe $(objdir)\tangle.exe \
	$(tex) $(objdir)\tftopl.exe $(ttf2afm) $(objdir)\vftovp.exe      \
	$(objdir)\vptovf.exe $(objdir)\weave.exe $(pdftosrc)

mpware = mpware\$(objdir)\dmp.exe mpware\$(objdir)\makempx.exe \
	mpware\$(objdir)\mpto.exe mpware\$(objdir)\newer.exe
mpware_sources = mpware/dmp.c mpware/makempx.in mpware/mpto.c mpware/newer.c

otps_programs = otps\$(objdir)\otp2ocp.exe otps\$(objdir)\outocp.exe
omegafonts_programs = omegafonts\$(objdir)\omfonts.exe

#  
default all: $(objdir) programs formats # manpages doc/web2c.info
programs: $(objdir) $(programs) $(mpware) $(otps_programs) $(omegafonts_programs)

# Makefile fragments:
!include <make/etex.mak>
!include <make/omega.mak>
!include <make/pdftex.mak>
!include <make/pdfetex.mak>

# Rules to link each program. I wish we could use a suffix rule for
# this, since it's so repetitive, but null suffixes don't work. And old
# makes don't support pattern rules. Doomed to forever cater to obsolesence.
$(objdir)\bibtex.exe:: $(objdir)\bibtex.obj $(objdir)\bibtex.res
	$(kpathsea_link) $(objdir)\bibtex.obj $(objdir)\bibtex.res $(LOADLIBES)
$(objdir)\dvicopy.exe:: $(objdir)\dvicopy.obj $(objdir)\dvicopy.res
	$(kpathsea_link) $(objdir)\dvicopy.obj $(objdir)\dvicopy.res $(LOADLIBES)
$(objdir)\dvitomp.exe:: $(objdir)\dvitomp.obj $(objdir)\dvitomp.res
	$(kpathsea_link) $(objdir)\dvitomp.obj $(objdir)\dvitomp.res $(LOADLIBES)
$(objdir)\dvitype.exe:: $(objdir)\dvitype.obj $(objdir)\dvitype.res
	$(kpathsea_link) $(objdir)\dvitype.obj $(objdir)\dvitype.res $(LOADLIBES)
!ifdef TEX_DLL
$(objdir)\etex.lib: $(etex_o)
	$(archive_command) /DEF $(etex_o)
$(objdir)\etex.dll: $(etex_o) $(objdir)\etex.lib $(objdir)\etex.res
	$(dll_command) $(etex_o) $(socketlibs) $(objdir)\etex.res $(objdir)\etex.exp  $(LOADLIBES)
$(objdir)\etex.exe:: $(objdir)\win32main.obj $(objdir)\etex.lib $(objdir)\etex.dll
	$(link_command) $(objdir)\win32main.obj $(objdir)\etex.lib $(LIBS)
!else
$(objdir)\etex.exe:: $(etex_o) $(objdir)\win32main.obj $(objdir)\etex.res
	$(kpathsea_link) $(etex_o) $(objdir)\win32main.obj $(objdir)\etex.res $(socketlibs) $(LOADLIBES)
!endif
$(objdir)\gftodvi.exe:: $(objdir)\gftodvi.obj $(objdir)\gftodvi.res
	$(kpathsea_link) $(objdir)\gftodvi.obj $(objdir)\gftodvi.res $(LOADLIBES)
$(objdir)\gftopk.exe:: $(objdir)\gftopk.obj $(objdir)\gftopk.res
	$(kpathsea_link) $(objdir)\gftopk.obj $(objdir)\gftopk.res $(LOADLIBES)
$(objdir)\gftype.exe:: $(objdir)\gftype.obj $(objdir)\gftype.res
	$(kpathsea_link) $(objdir)\gftype.obj $(objdir)\gftype.res $(LOADLIBES)
!ifdef TEX_DLL
$(objdir)\$(mfw).lib: $(mf_o)
	$(archive_command) /DEF $(mf_o)
$(objdir)\$(mfw).dll: $(mf_o) $(mfextra_o) $(objdir)\$(mfw).lib $(objdir)\mf.res $(windowlib)
	$(dll_command) $(mf_o) $(mfextra_o) $(windowlink) $(socketlibs) $(objdir)\mf.res $(LOADLIBES)
$(objdir)\$(mfw).exe:: $(objdir)\win32main.obj $(objdir)\$(mfw).lib $(objdir)\$(mfw).dll
	$(link_command) $(objdir)\win32main.obj $(objdir)\$(mfw).lib $(LIBS)
!else
$(objdir)\$(mfw).exe:: $(mf_o) $(objdir)\win32main.obj $(windowlib) $(objdir)\mf.res
	$(kpathsea_link) $(mf_o) $(objdir)\win32main.obj $(windowlink) $(objdir)\mf.res $(LOADLIBES)
!endif
!ifdef TEX_DLL
$(objdir)\$(mfn).lib: $(mf_nowin_o) window\$(objdir)\trap.obj
	$(archive_command) /DEF $(mf_nowin_o) window\$(objdir)\trap.obj
$(objdir)\$(mfn).dll: $(mf_nowin_o) window\$(objdir)\trap.obj $(objdir)\mf.res
	$(dll_command) $(mf_nowin_o) window\$(objdir)\trap.obj $(socketlibs) $(objdir)\mf.res $(LOADLIBES)
$(objdir)\$(mfn).exe:: $(objdir)\win32main.obj $(objdir)\$(mfn).lib $(objdir)\$(mfn).dll
	$(link_command) $(objdir)\win32main.obj $(objdir)\$(mfn).lib $(LIBS)
!else
$(objdir)\$(mfn).exe:: $(mf_nowin_o) $(objdir)\win32main.obj window\$(objdir)\trap.obj $(objdir)\mf.res
	$(kpathsea_link) $(mf_nowin_o) $(objdir)\win32main.obj window\$(objdir)\trap.obj $(objdir)\mf.res $(LOADLIBES)
!endif
$(objdir)\mft.exe:: $(objdir)\mft.obj $(objdir)\mft.res
	$(kpathsea_link) $(objdir)\mft.obj $(objdir)\mft.res $(LOADLIBES)
!ifdef TEX_DLL
$(objdir)\mpost.lib: $(mp_o)
	$(archive_command) /DEF $(mp_o)
$(objdir)\mpost.dll: $(mp_o) $(mpostextra_o) $(objdir)\mpost.lib $(objdir)\mpost.res
	$(dll_command) $(mp_o) $(mpostextra_o) $(socketlibs) $(objdir)\mpost.res $(LOADLIBES)
$(objdir)\mpost.exe:: $(objdir)\win32main.obj $(objdir)\mpost.lib $(objdir)\mpost.dll
	$(link_command) $(objdir)\win32main.obj $(objdir)\mpost.lib $(LIBS)
!else
$(objdir)\mpost.exe:: $(mp_o) $(objdir)\win32main.obj $(objdir)\mpost.res
	$(kpathsea_link) $(mp_o) $(objdir)\win32main.obj $(objdir)\mpost.res $(LOADLIBES)
!endif
$(objdir)\odvicopy.exe:: $(objdir)\odvicopy.obj
	$(kpathsea_link) $(objdir)\odvicopy.obj $(LOADLIBES)
$(objdir)\odvitype.exe:: $(objdir)\odvitype.obj
	$(kpathsea_link) $(objdir)\odvitype.obj $(LOADLIBES)
!ifdef TEX_DLL
$(objdir)\omega.lib: $(omega_o)
	$(archive_command) /DEF $(omega_o)
$(objdir)\omega.dll: $(omega_o) $(omegaextra_o) $(objdir)\omega.lib $(objdir)\omega.res $(omegalibsdep)
	$(dll_command) $(omega_o) $(omegaextra_o) $(omegalibs) $(socketlibs) $(objdir)\omega.res $(LOADLIBES)
$(objdir)\omega.exe:: $(objdir)\win32main.obj $(objdir)\omega.lib $(objdir)\omega.dll
	$(link_command) $(objdir)\win32main.obj $(objdir)\omega.lib $(LIBS)
!else
$(objdir)\omega.exe:: $(omega_o) $(objdir)\win32main.obj 
	$(kpathsea_link) $(omega_o) $(objdir)\win32main.obj $(socketlibs) $(LOADLIBES)
!endif
$(objdir)\patgen.exe:: $(objdir)\patgen.obj $(objdir)\patgen.res
	$(kpathsea_link) $(objdir)\patgen.obj $(objdir)\patgen.res $(LOADLIBES)
!ifdef TEX_DLL
$(objdir)\pdftex.lib: $(pdftex_o)
	$(archive_command) /DEF $(pdftex_o)
$(objdir)\pdftex.dll: $(pdftex_o) $(pdftexextra_o) $(objdir)\pdftex.lib $(objdir)\pdftex.res $(pdftexlibs)
	$(dll_command) $(pdftex_o) $(pdftexextra_o) $(pdftexlibs) $(socketlibs) $(objdir)\pdftex.res $(LOADLIBES)
$(objdir)\pdftex.exe:: $(objdir)\win32main.obj $(objdir)\pdftex.lib $(objdir)\pdftex.dll
	$(link_command) $(objdir)\win32main.obj $(objdir)\pdftex.lib $(LOADLIBES)
!else
$(objdir)\pdftex.exe:: $(pdftex_o) $(pdftexextra_o) $(objdir)\win32main.obj $(objdir)\pdftex.res $(pdftexlibs)
	$(kpathsea_link) $(pdftex_o) $(pdftexextra_o) $(objdir)\win32main.obj $(objdir)\pdftex.res $(pdftexlibs) $(socketlibs) $(LOADLIBES)
!endif
!ifdef TEX_DLL
$(objdir)\pdfetex.lib: pdftexd.h $(pdfetex_o)
	$(archive_command) /DEF $(pdfetex_o)
$(objdir)\pdfetex.dll: $(pdfetex_o) $(pdfetexextra_o) $(objdir)\pdfetex.lib $(objdir)\pdfetex.res $(pdftexlibs)
	$(dll_command) $(pdfetex_o) $(pdfetexextra_o) $(pdftexlibs) $(socketlibs) $(objdir)\pdfetex.res $(objdir)\pdfetex.exp  $(LOADLIBES)
$(objdir)\pdfetex.exe:: pdftexd.h $(objdir)\win32main.obj $(objdir)\pdfetex.lib $(objdir)\pdfetex.dll
	$(link_command) $(objdir)\win32main.obj $(objdir)\pdfetex.lib $(LIBS)
!else
$(objdir)\pdfetex.exe:: pdftexd.h $(pdfetex_o) $(pdfetexextra_o) $(objdir)\win32main.obj $(objdir)\pdfetex.res $(pdftexlibs)
	$(kpathsea_link) $(pdfetex_o) $(pdfetexextra_o) $(objdir)\win32main.obj $(objdir)\pdfetex.res $(pdftexlibs) $(socketlibs) $(LOADLIBES)
!endif
$(objdir)\pktogf.exe:: $(objdir)\pktogf.obj $(objdir)\pktogf.res
	$(kpathsea_link) $(objdir)\pktogf.obj $(objdir)\pktogf.res $(LOADLIBES)
$(objdir)\pktype.exe:: $(objdir)\pktype.obj $(objdir)\pktype.res
	$(kpathsea_link) $(objdir)\pktype.obj $(objdir)\pktype.res $(LOADLIBES)
$(objdir)\pltotf.exe:: $(objdir)\pltotf.obj $(objdir)\pltotf.res
	$(kpathsea_link) $(objdir)\pltotf.obj $(objdir)\pltotf.res $(LOADLIBES)
$(objdir)\pooltype.exe:: $(objdir)\pooltype.obj $(objdir)\pooltype.res
	$(kpathsea_link) $(objdir)\pooltype.obj $(objdir)\pooltype.res $(LOADLIBES)
!ifdef TEX_DLL
$(objdir)\tex.lib: $(tex_o)
	$(archive_command) /DEF $(tex_o)
$(objdir)\tex.dll: $(tex_o) $(objdir)\tex.lib $(objdir)\tex.res
	$(dll_command) $(tex_o) $(socketlibs) $(objdir)\tex.res $(objdir)\tex.exp  $(LOADLIBES)
$(objdir)\tex.exe:: $(objdir)\win32main.obj $(objdir)\tex.lib $(objdir)\tex.dll
	$(link_command) $(objdir)\win32main.obj $(objdir)\tex.lib $(LIBS)
!else
$(objdir)\tex.exe:: $(tex_o) $(objdir)\win32main.obj $(objdir)\tex.res
	$(kpathsea_link) $(tex_o) $(objdir)\win32main.obj $(socketlibs) $(objdir)\tex.res $(LOADLIBES)
!endif
$(objdir)\tie.exe:: $(objdir) $(objdir)\tie.obj
	$(kpathsea_link) $(objdir)\tie.obj $(LIBS)
$(objdir)\tftopl.exe:: $(objdir)\tftopl.obj $(objdir)\tftopl.res
	$(kpathsea_link) $(objdir)\tftopl.obj $(objdir)\tftopl.res $(LOADLIBES)
$(objdir)\vftovp.exe:: $(objdir)\vftovp.obj $(objdir)\vftovp.res
	$(kpathsea_link) $(objdir)\vftovp.obj $(objdir)\vftovp.res $(LOADLIBES)
$(objdir)\vptovf.exe:: $(objdir)\vptovf.obj $(objdir)\vptovf.res
	$(kpathsea_link) $(objdir)\vptovf.obj $(objdir)\vptovf.res $(LOADLIBES)
$(objdir)\weave.exe:: $(objdir)\weave.obj $(objdir)\weave.res
	$(kpathsea_link) $(objdir)\weave.obj $(objdir)\weave.res $(LOADLIBES)

# The stub with main() for win32
$(objdir)\win32main.obj: $(objdir) ./lib/win32main.c config.h
	$(compile) -UMAKE_TEX_DLL ./lib/win32main.c

# We put some programs (written directly in C) in a subdirectory.
$(mpware): $(mpware_sources)
	pushd mpware & $(MAKE) $(common_makeargs) & popd

# Additional dependencies for retangling.
bibtex.p dvicopy.p dvitomp.p dvitype.p etex.p gftopk.p gftodvi.p gftype.p \
  mf.p mft.p mp.p odvicopy.p odvitype.p omega.p patgen.p                  \
  pdfetex.p pdftex.p pktogf.p pktype.p pltotf.p  \
  pooltype.p tex.p tftopl.p vftovp.p vptovf.p weave.p: $(objdir)\tangle.exe
# We need to be explicit for a number of programs because there is a
# $(srcdir) in the suffix rule.  This also means we can use a different
# suffix for the change file than .ch, if we want to.
bibtex.p: bibtex.web bibtex.ch
dvicopy.p: dvicopy.web dvicopy.ch
dvitomp.p: dvitomp.web dvitomp.ch
dvitype.p: dvitype.web dvitype.ch
etex.p etex.pool: etex.web etex.ch
	$(objdir)\tangle etex.web etex.ch
gftodvi.p: gftodvi.web gftodvi.ch
gftopk.p: gftopk.web gftopk.ch
gftype.p: gftype.web gftype.ch
mf.p mf.pool: mf.web mf-web2c.ch
	$(objdir)\tangle mf.web mf-web2c.ch
mp.p mp.pool: mp.web mp-web2c.ch
	$(objdir)\tangle mp.web mp-web2c.ch
mft.p: mft.web mft.ch
odvicopy.p: odvicopy.web odvicopy.ch
	.\$(objdir)\tangle odvicopy.web odvicopy.ch
odvitype.p: odvitype.web odvitype.ch
	.\$(objdir)\tangle odvitype.web odvitype.ch
omega.p omega.pool: $(objdir)\otangle.exe omega.web omega.ch
	$(objdir)\otangle omega.web omega.ch
patgen.p: patgen.web patgen.ch
pdftex.p pdftex.pool: pdftex.web pdftex.ch
	$(objdir)\tangle pdftex.web pdftex.ch
pdfetex.p pdfetex.pool: pdfetex.web pdfetex.ch
	$(objdir)\tangle pdfetex.web pdfetex.ch
pktogf.p: pktogf.web pktogf.ch
pktype.p: pktype.web pktype.ch
pltotf.p: pltotf.web pltotf.ch
pooltype.p: pooltype.web pooltype.ch
tex.p tex.pool: tex.web tex-web2c.ch
	$(objdir)\tangle tex.web tex-web2c.ch
tftopl.p: tftopl.web tftopl.ch
vftovp.p: vftovp.web vftovp.ch
vptovf.p: vptovf.web vptovf.ch
weave.p: weave.web weave.ch

tex-web2c.ch: tex.web tex.ch tex-src-special.ch tex-c-style.ch $(objdir)\tie.exe
	$(objdir)\tie.exe -c $@ tex.web tex.ch tex-src-special.ch tex-c-style.ch

mf-web2c.ch: mf.web mf.ch mf-c-style.ch $(objdir)\tie.exe
	$(objdir)\tie.exe -c $@ mf.web mf.ch mf-c-style.ch

mp-web2c.ch: mp.web mp.ch mp-c-style.ch $(objdir)\tie.exe
	$(objdir)\tie.exe -c $@ mp.web mp.ch mp-c-style.ch

# Additional dependencies for reconverting to C.
$(other_c): $(web2c_aux) $(web2c_programs)
bibtex.c: web2c/cvtbib.sed
c-sources: $(all_c)

# Metafont and TeX generate more than .c file.
web2c_texmf = $(web2c_aux) $(web2c_programs) web2c/texmf.defines
$(etex_c) etexcoerce.h etexd.h: etex.p $(web2c_texmf)
	$(web2c) etex
$(mf_c) mfcoerce.h mfd.h: mf.p $(web2c_texmf) web2c/cvtmf1.sed web2c/cvtmf2.sed
	$(web2c) mf
$(mp_c) mpcoerce.h mpd.h: mp.p $(web2c_texmf) web2c/cvtmf1.sed web2c/cvtmf2.sed
	$(web2c) mp
$(omega_c) omegacoerce.h omegad.h: omega.p $(web2c_texmf)
	$(web2c) omega
$(pdftex_c) pdftexcoerce.h pdftexd.h: pdftex.p $(web2c_texmf)
	$(web2c) pdftex
$(pdfetex_c) pdfetexcoerce.h pdfetexd.h: pdfetex.p $(web2c_texmf)
	$(web2c) pdfetex
$(tex_c) texcoerce.h texd.h: tex.p $(web2c_texmf)
	$(web2c) tex

# As long as we have to have separate rules to create these, might as well do
# a little work to avoid separate compilation rules, too.
etexextra.c: lib/texmfmp.c
	$(SED) s/TEX-OR-MF-OR-MP/etex/ $(srcdir)/lib/texmfmp.c >$@
mfextra.c: lib/texmfmp.c
	$(SED) s/TEX-OR-MF-OR-MP/mf/ $(srcdir)/lib/texmfmp.c >$@
mfnowin.c: lib/texmfmp.c
	$(SED) s/TEX-OR-MF-OR-MP/mf/ $(srcdir)/lib/texmfmp.c >$@
mpextra.c: lib/texmfmp.c
	$(SED) s/TEX-OR-MF-OR-MP/mp/ $(srcdir)/lib/texmfmp.c >$@
omegaextra.c: lib/texmfmp.c
	$(SED) s/TEX-OR-MF-OR-MP/omega/ $(srcdir)/lib/texmfmp.c >$@
pdftexextra.c: lib/texmfmp.c
	$(SED) s/TEX-OR-MF-OR-MP/pdftex/ $(srcdir)/lib/texmfmp.c >$@
pdfetexextra.c: lib/texmfmp.c
	$(SED) s/TEX-OR-MF-OR-MP/pdfetex/ $(srcdir)/lib/texmfmp.c >$@
texextra.c: lib/texmfmp.c
	$(SED) s/TEX-OR-MF-OR-MP/tex/ $(srcdir)/lib/texmfmp.c >$@

# A special rule for tie
tie.c: tiedir/tie.c
	-@$(RM) -f $@
	$(LN) $(srcdir)\tiedir\tie.c $@

# Dependencies for recompiling the C code, needed for i386 based systems.
$(objdir)\mfextra.obj $(objdir)\mpextra.obj: lib/mfmpw32.c

$(objdir)\mfnowin.obj: mfnowin.c lib/mfmpw32.c
	$(compile) -DMFNOWIN mfnowin.c

# Additional dependencies for recompiling the C code are generated
# automatically, included at the end.

# Additional dependencies for relinking.
$(web2c_programs) $(programs) $(objdir)\otangle.exe $(objdir)\otangleboot.exe $(objdir)\tangle.exe $(objdir)\tangleboot.exe:: $(kpathsea) $(proglib)

# 
# Bootstrapping tangle requires making it with itself.  We use the opportunity
# to create an up-to-date tangleboot as well.
$(objdir)\tangle.exe:: $(objdir)\tangle.obj $(objdir)\tangle.res
	$(kpathsea_link) $(objdir)\tangle.obj $(objdir)\tangle.res $(LOADLIBES)
	$(MAKE) $(common_makeargs) tangleboot.p
# tangle.p is a special case, since it is needed to compile itself.  We
# convert and compile the (distributed) tangleboot.p to make a tangle
# which we use to make the other programs.
tangle.p: $(objdir)\tangleboot.exe tangle.web tangle.ch
	.\$(objdir)\tangleboot $(srcdir)\tangle.web $(srcdir)\tangle.ch
tangle.web:
	@echo "You seem to be missing tangle.web, perhaps because you" >&2
	@echo "didn't retrieve web.tar.gz, only web2c.tar.gz." >&2
	@echo "You need both." >&2
	@echo >&2
	@echo "web.tar.gz should be available from the" >&2
	@echo "same place that you got web2c.tar.gz." >&2
	@echo "In any case, you can get it from" >&2
	@echo "ftp://ftp.tug.org/tex/web.tar.gz." >&2
	false

$(objdir)\tangleboot.exe:: $(objdir) $(objdir)\tangleboot.obj
	$(kpathsea_link) $(objdir)\tangleboot.obj $(LOADLIBES)
tangleboot.c tangleboot.h: stamp-tangle $(web2c_programs) $(web2c_aux)
	$(web2c) tangleboot
# tangleboot.p is in the distribution
stamp-tangle: tangleboot.p
	date /t >stamp-tangle & time /t >>stamp-tangle
# This is not run unless tangle.web or tangle.ch is changed.
tangleboot.p: tangle.web tangle.ch
	tangle $(srcdir)/tangle.web $(srcdir)/tangle.ch
	copy tangle.p tangleboot.p & $(RM) tangle.p
	date /t >stamp-tangle & time /t >>stamp-tangle
	$(MAKE) $(common_makeargs) tangle

# Even web2c itself uses the library.
# It's annoying to have to give all the filenames here, 
# but texmfmp.c is an exception.
lib_sources = lib/alloca.c lib/basechsuffix.c lib/chartostring.c \
  lib/eofeoln.c lib/fprintreal.c lib/input2int.c lib/inputint.c lib/main.c \
  lib/openclose.c lib/printversion.c lib/uexit.c lib/usage.c lib/version.c \
  lib/zround.c 
$(proglib): $(lib_sources) c-auto.h # stamp-auto
	cd lib & $(MAKE) $(common_makeargs) & cd ..

# No exceptions in this library.
window_sources = $(srcdir)/window/*.c
$(windowlib): mfd.h $(window_sources)
	cd window & $(MAKE) $(window_makeargs) & cd ..
window\$(objdir)\trap.obj: $(srcdir)/window/trap.c
	cd window & $(MAKE) $(common_makeargs) $(objdir)\trap.obj & cd ..
pdflib_sources = $(srcdir)/$(verpdftexdir)/*.c
$(pdflib): $(pdflib_sources)
	cd $(verpdftexdir) & $(MAKE) $(common_makeargs) all
pdftoepdflib_sources = $(verpdftexdir)/pdftoepdf.cc $(verpdftexdir)/epdf.h \
	 $(XPDFDIR)/*.c* $(XPDFDIR)/*.h \
	 $(XPDFEXTRADIR)/*.c* $(XPDFEXTRADIR)/*.h
$(pdftoepdflib): $(pdftoedflib_sources)
        pushd $(verpdftexdir) & $(MAKE) $(common_makeargs) libpdftoepdf & popd
pnglib_sources = $(PNGLIBDIR)/*.c $(win32defdir)/libpng.def
$(pnglib): $(pnglib_sources)
	cd $(PNGLIBDIR) & $(MAKE) $(common_makeargs) all
tifflib_sources = $(TIFFLIBDIR)/*.c $(win32defdir)/libtiff.def
$(tifflib): $(tifflib_sources)
	cd $(TIFFLIBDIR) & $(MAKE) $(common_makeargs) all
zlib_sources = $(ZLIBDIR)/*.c $(win32defdir)/zlib.def
$(zlib): $(zlib_sources)
	cd $(ZLIBDIR) & $(MAKE) $(common_makeargs) all
#$(xpdflib): $(XPDFDIR)/*.c*
#	-(RM) $(XPDFDIR)\pdftoepdf.cc $(XPDFDIR)\epdf.h
#	$(CP) $(srcdir)\pdftexdir\epdf.h $(XPDFDIR)
#	$(CP) $(srcdir)\pdftexdir)\pdftoepdf.cc $(XPDFDIR)
#	pushd $(XPDFDIR) & $(MAKE) $(common_makeargs) $(xpdflib) & popd
#$(xpdfextralib): $(XPDFEXTRADIR)/*.c*
#	pushd $(XPDFEXTRADIR) & $(MAKE) $(common_makeargs) $(xpdfextralib) & popd

# The web2c program consists of several executables.
web2c/$(objdir)/fixwrites.exe:: web2c/fixwrites.c c-auto.h
	cd web2c & $(MAKE) $(common_makeargs) $(objdir)\fixwrites.exe & cd ..
web2c/$(objdir)/splitup.exe:: web2c/splitup.c c-auto.h
	cd web2c & $(MAKE) $(common_makeargs) $(objdir)\splitup.exe & cd ..
web2c/$(objdir)/web2c.exe:: web2c/main.c web2c/web2c.h web2c/web2c.l web2c/web2c.y c-auto.h
	cd web2c & $(MAKE) $(common_makeargs) $(objdir)\web2c.exe & cd ..

!include <make/tkpathsea.mak>
!include <make/version.mak>

# 
# Making formats and bases.
all_fmts = tex.fmt $(fmts)
all_efmts = etex.efmt $(efmts)
all_cfmts = tex.efmt $(cfmts)
all_ofmts = # omega.fmt $(ofmts)
all_pdffmts = pdftex.fmt $(pdffmts)
all_pdfefmts = pdfetex.efmt $(pdfefmts)
all_bases = mf.base $(bases)
all_mems = mpost.mem $(mems)

# Win32 Only. Stamp formats, to not rebuild them every time.
# Does not work. Instead, set dummy vars before running nmake
# and rely on vars defines in make/w2cwin32.mk.
dumpenv = # set TEXMFCNF=../kpathsea & set TEXMF=$(texmf)

formats: fmts efmts cfmts ofmts pdffmts pdfefmts bases mems
fmts: $(all_fmts)
efmts: $(all_efmts)
cfmts: $(all_cfmts)
ofmts: $(all_ofmts)
pdffmts: $(all_pdffmts)
pdfefmts: $(all_pdfefmts)
bases: $(all_bases)
mems: $(all_mems)

tex.fmt: $(objdir)\tex.exe
	$(MAKE) $(makeargs) files="--progname=tex plain.tex cmr10.tfm" prereq-check
	.\$(objdir)\tex --fmt=tex --ini "\input plain \dump" < nul

latex.fmt: $(objdir)\tex.exe
	$(MAKE) $(makeargs) files="--progname=latex latex.ltx" prereq-check
	.\$(objdir)\tex --progname=latex --ini "\input latex.ltx" < nul

etex.efmt: $(objdir)\etex.exe
	$(MAKE) files="--progname=etex etex.src plain.tex cmr10.tfm" prereq-check
	.\$(objdir)\etex --efmt=etex --ini "*\input etex.src \dump" <nul

elatex.efmt: $(objdir)\etex.exe
	$(MAKE) files="--progname=elatex latex.ltx" prereq-check
	.\$(objdir)\etex --efmt=elatex --ini "*\input latex.ltx" <nul

tex.efmt: $(objdir)\etex.exe
	$(MAKE) files="--progname=tex plain.tex cmr10.tfm" prereq-check
	.\$(objdir)\etex --efmt=tex --ini "\input plain \dump" <nul

latex.efmt: $(objdir)\etex.exe
	$(MAKE) files="--progname=latex latex.ltx" prereq-check
	.\$(objdir)\etex --progname=latex --ini "\input latex.ltx" <nul

omega.fmt: $(objdir)\omega.exe
	$(MAKE) files="--progname=omega omega.tex" prereq-check
	.\$(objdir)\omega --ini "\input omega.tex \dump" <nul

lambda.fmt: $(objdir)\omega.exe
	$(MAKE) files="--progname=lambda lambda.tex" prereq-check
	.\$(objdir)\omega --ini --progname=lambda "\input lambda.tex" <nul

pdftex.fmt: $(objdir)\pdftex.exe
	$(MAKE) files="--progname=pdftex plain.tex cmr10.tfm" prereq-check
	.\$(objdir)\pdftex --fmt=pdftex --ini "\pdfoutput=1 \input plain \dump" <nul

pdflatex.fmt: $(objdir)\pdftex.exe
	$(MAKE) files="--progname=pdflatex latex.ltx" prereq-check
	.\$(objdir)\pdftex --fmt=pdflatex --ini "\pdfoutput=1 \input latex.ltx" <nul

pdftexinfo.fmt: $(objdir)\pdftex.exe
	$(MAKE) files="--progname=pdftexinfo pdftexinfo.ini" prereq-check
	.\$(objdir)\pdftex --progname=pdftexinfo --ini pdftexinfo.ini <nul

pdfetex.efmt: $(objdir)\pdfetex.exe
	$(MAKE) files="--progname=pdfetex etex.src plain.tex cmr10.tfm" prereq-check
	.\$(objdir)\pdfetex --efmt=pdfetex --ini "*\input etex.src \dump" <nul

pdfelatex.efmt: $(objdir)\pdfetex.exe
	$(MAKE) files="--progname=pdfelatex latex.ltx" prereq-check
	.\$(objdir)\pdfetex --efmt=pdfelatex --ini "*\input latex.ltx" <nul

mltex.fmt: $(objdir)\tex.exe
	$(MAKE) files="--progname=mltex plain.tex cmr10.tfm" prereq-check
	.\$(objdir)\tex --mltex --fmt=mltex --ini "\input plain \dump" <nul

mllatex.fmt: $(objdir)\tex.exe
	$(MAKE) files="--progname=mllatex latex.ltx" prereq-check
	.\$(objdir)\tex --mltex --fmt=mllatex --ini \input latex.ltx <nul

mf.base: $(objdir)\mf.exe
	$(MAKE) $(makeargs) files="plain.mf cmr10.mf $(localmodes).mf" prereq-check
	.\$(objdir)\mf --base=mf --ini "\input plain input $(localmodes) dump" < nul

mpost.mem: $(objdir)\mpost.exe
	$(MAKE) $(makeargs) files=plain.mp prereq-check
	.\$(objdir)\mpost --mem=mpost --ini "\input plain dump" < nul

# This is meant to be called recursively, with $(files) set.
prereq-check: $(kpathsea_dir)\$(objdir)\kpsewhich.exe
	-$(kpathsea_dir)\$(objdir)\kpsewhich $(files) > nul
	if ERRORLEVEL 1 $(MAKE) prereq-lose

prereq-lose:
	@echo "You seem to be missing input files necessary to make the" >&2
	@echo "basic formats (some or all of: $(files))." >&2
	@echo "Perhaps you've defined the default paths incorrectly, or" >&2
	@echo "perhaps you have environment variables set pointing" >&2
	@echo "to an incorrect location.  See ../kpathsea/BUGS." >&2
	@echo >&2
	@echo "If you simply do not have the files, you can" >&2
	@echo "retrieve a minimal set of input files from" >&2
	@echo "ftp://ftp.tug.org/tex/texklib.tar.gz, mirrored on" >&2
	@echo "CTAN hosts in systems/web2c." >&2
	false

$(kpathsea_dir)/kpsewhich: $(kpathsea)

amstex.fmt: $(objdir)\tex.exe
	.\$(objdir)\tex --progname=amstex --ini amstex.ini </dev/null

# Texinfo changes the escape character from `\' to `@'.
texinfo.fmt: tex.fmt
	.\$(objdir)\tex --progname=texinfo --ini texinfo @dump </dev/null

eplain.fmt: tex.fmt
	$(TOUCH) eplain.aux # Makes cross-reference warnings work right.
	.\$(objdir)\tex --progname=eplain --ini &./tex eplain \dump <nul

# 
install: $(mktexdir) install-exec install-data install-aux install-doc install-man
install-exec:: install-links
install-data:: install-formats

# The actual binary executables and pool files.
install-programs: $(programs)
	$(mktexdir) $(bindir) $(texpooldir) \
	  $(mfpooldir) $(mppooldir)
	pushd mpware & $(MAKE) $(install_makeargs) install-exec & popd
	pushd $(verpdftexdir) & $(MAKE) $(install_makeargs) install & popd
	for %%i in ($(programs)) do $(INSTALL_PROGRAM) %%i $(bindir)\%%~nxi
!ifdef TEX_DLL
	for %%i in ($(objdir)\*.dll) do $(INSTALL_PROGRAM) %%i $(bindir)\%%~nxi
!endif	
	pushd otps & $(MAKE) $(install_makeargs) install-programs & popd
	pushd omegafonts & $(MAKE) $(install_makeargs) install-programs & popd

#Correct this one for pdftex, etex, omega.
# The links to {mf,mp,tex} for each format and for {ini,vir}{mf,mp,tex}.
!ifdef TEX_DLL
LNEXE=$(CP)
lnprog=
!endif
install-links: $(lnprog) install-programs
# TeX
	pushd $(bindir) \
	& $(RM) .\initex.exe .\virtex.exe \
	& $(LNEXE) .\tex.exe $(bindir)\initex.exe \
	& $(LNEXE) .\tex.exe $(bindir)\virtex.exe \
	& popd
# e-TeX
	pushd $(bindir) \
	& $(RM) .\einitex.exe $(bindir)\evirtex.exe \
	& $(LNEXE) .\etex.exe $(bindir)\einitex.exe \
	& $(LNEXE) .\etex.exe $(bindir)\evirtex.exe \
	& popd
# e-TeX in compatible mode
!ifdef eTeX_as_TeX
	pushd $(bindir) \
	& $(RM) .\tex.exe .\initex.exe .\virtex.exe \
	& $(LNEXE) .\etex.exe $(bindir)\tex.exe \
	& $(LNEXE) .\etex.exe $(bindir)\initex.exe \
	& $(LNEXE) .\etex.exe $(bindir)\virtex.exe \
	& popd
!endif
# Omega	
	pushd $(bindir) \
	& $(RM) .\iniomega.exe .\viromega.exe \
	& $(LNEXE) .\omega.exe $(bindir)\iniomega.exe \
	& $(LNEXE) .\omega.exe $(bindir)\viromega.exe \
	& popd
# pdfTeX
	pushd $(bindir) \
	& $(RM) .\pdfinitex.exe .\pdfvirtex.exe \
	& $(LNEXE) .\pdftex.exe $(bindir)\pdfinitex.exe \
	& $(LNEXE) .\pdftex.exe $(bindir)\pdfvirtex.exe \
	& popd
# pdfeTeX
	pushd $(bindir) \
	& $(RM) .\pdfeinitex.exe .\pdfevirtex.exe \
	& $(LNEXE) .\pdfetex.exe $(bindir)\pdfeinitex.exe \
	& $(LNEXE) .\pdfetex.exe $(bindir)\pdfevirtex.exe \
	& popd
# MF
	pushd $(bindir) \
	& $(RM) .\inimf.exe .\virmf.exe \
	& $(LNEXE) .\mf.exe $(bindir)\inimf.exe \
	& $(LNEXE) .\mf.exe $(bindir)\virmf.exe \
	& popd
# MPost
	pushd $(bindir) \
	& $(RM) .\inimpost.exe .\virmpost.exe \
	& $(LNEXE) .\mpost.exe $(bindir)\inimpost.exe \
	& $(LNEXE) .\mpost.exe $(bindir)\virmpost.exe \
	& popd
	if NOT "$(fmts)"=="" \
	for %%i in ($(fmts)) do \
          pushd $(bindir)       \
	  & $(RM) $(bindir)\%%~ni.exe \
	  & $(LNEXE) .\tex.exe $(bindir)\%%~ni.exe \
	  & popd
	if NOT "$(efmts)"=="" \
	for %%i in ($(efmts)) do \
          pushd $(bindir)       \
          & $(RM) $(bindir)\%%~ni.exe \
	  & $(LNEXE) .\etex.exe $(bindir)\%%~ni.exe \
	  & popd
# FIXME : e-TeX in compatible mode
!ifdef eTeX_as_TeX
	if not "$(cfmts)"=="" \
	for %%i in ($(cfmts)) do \
          pushd $(bindir)       \
          & $(RM) $(bindir)\%%~ni.exe \
	  & $(LNEXE) .\etex.exe $(bindir)\%%~ni.exe \
	  & popd
!endif
	if not "$(ofmts)"=="" \
	for %%i in ($(ofmts)) do \
          pushd $(bindir)       \
          & $(RM) $(bindir)\%%~ni.exe \
	  & $(LNEXE) .\omega.exe $(bindir)\%%~ni.exe \
	  & popd
	if not "$(pdffmts)"=="" \
	for %%i in ($(pdffmts)) do \
          pushd $(bindir)       \
          & $(RM) $(bindir)\%%~ni.exe \
	  & $(LNEXE) .\pdftex.exe $(bindir)\%%~ni.exe \
	  & popd
	if not "$(pdfefmts)"=="" \
	for %%i in ($(pdfefmts)) do \
          pushd $(bindir)       \
          & $(RM) $(bindir)\%%~ni.exe \
	  & $(LNEXE) .\pdfetex.exe $(bindir)\%%~ni.exe \
	  & popd
	if not "$(bases)"=="" \
	for %%i in ($(bases)) do \
          pushd $(bindir)       \
          & $(RM) $(bindir)\%%~ni.exe \
	  & $(LNEXE) .\mf.exe $(bindir)\%%~ni.exe \
	  & popd
	if not "$(mems)"=="" \
	for %%i in ($(mems)) do \
          pushd $(bindir)       \
          & $(RM) $(bindir)\%%~ni.exe \
	  & $(LNEXE) .\mpost.exe $(bindir)\%%~ni.exe \
	  & popd

# Always do plain.*, so examples from the TeXbook (etc.) will work.
install-formats: install-fmts install-bases install-mems
install-fmts: $(all_fmts) $(all_efmts) $(all_cfmts) $(all_ofmts) $(all_pdffmts) $(all_pdfefmts)
	$(mktexdir) $(fmtdir)
	for %%f in ($(all_fmts) $(all_efmts) $(all_cfmts) $(all_ofmts) \
		$(all_pdffmts) $(all_pdfefmts)) \
	do $(INSTALL_DATA) %%f $(fmtdir)\%%f
	$(RM) -f $(fmtdir)\plain.fmt & $(LN) tex.fmt $(fmtdir)\plain.fmt
# FIXME e-TeX / compatible mode	
#	$(RM) -f $(fmtdir)\plain.efmt & $(LN) tex.efmt $(fmtdir)\plain.efmt

install-bases: $(all_bases)
	$(mktexdir) $(basedir)
	for %%f in ($(all_bases)) do $(INSTALL_DATA) %%f $(basedir)\%%f
	$(RM) -f $(basedir)\plain.base & $(LN) mf.base $(basedir)\plain.base

install-mems: $(all_mems)
	$(mktexdir) $(memdir)
	for %%f in ($(all_mems)) do $(INSTALL_DATA) %%f $(memdir)\%%f
	$(RM) -f $(memdir)\plain.mem & $(LN) mpost.mem $(memdir)\plain.mem

# Auxiliary files.
install-data::
	$(mktexdir) $(texpooldir) $(mfpooldir) \
	$(mppooldir) $(web2cdir) $(fontnamedir)
	$(INSTALL_DATA) tex.pool $(texpooldir)\tex.pool
	$(INSTALL_DATA) etex.pool $(texpooldir)\etex.pool
	$(INSTALL_DATA) omega.pool $(texpooldir)\omega.pool
	$(INSTALL_DATA) pdftex.pool $(texpooldir)\pdftex.pool
	$(INSTALL_DATA) pdfetex.pool $(texpooldir)\pdfetex.pool
	$(INSTALL_DATA) mf.pool $(mfpooldir)\mf.pool
	$(INSTALL_DATA) mp.pool $(mppooldir)\mp.pool
	pushd $(srcdir)\share & for %%f in (*.tcx) do \
	  $(INSTALL_DATA) %%f $(web2cdir)\%%f
	pushd $(srcdir)\share & for %%f in (*.map) do \
	  $(INSTALL_DATA) %%f $(fontnamedir)\%%f

install-doc::
	pushd doc & $(MAKE) $(install_makeargs) $@ & popd

install-man::
	pushd man & $(MAKE) $(install_makeargs) $@ & popd

install-aux:: $(web2cdir) fmtutil.cnf
	$(mktexdir) $(web2cdir)
	$(INSTALL_DATA) fmtutil.cnf $(web2cdir)\fmtutil.cnf

fmtutil.cnf: fmtutil.in
	$(SED) -e "1,$$s/@TEXBIN@/tex/g" < fmtutil.in \
	| $(SED) "1,$$s/^@[^@]*@//g" > $@

# The distribution comes with up-to-date .info* files,
# so this should never be used unless something goes wrong
# with the unpacking, or you modify the manual.
doc/web2c.info:
	cd doc & $(MAKE) info
info dvi:
	cd doc & $(MAKE) $@

# Manual pages
manpages:
	cd man & $(MAKE) all

# 
# make dist won't work for anyone but me. Sorry.
!IFDEF MAINT
distname = web2c
program_files = PROJECTS *.ac *.ch tangleboot.p

# The files that omega places in the main directory.
omega_files = omegamem.h otangleboot.p \
 {odvicopy,odvitype,otangle}.{web,ch}

triptrapdiffs: triptrap/trip.diffs triptrap/mftrap.diffs \
  triptrap/mptrap.diffs 
triptrap/trip.diffs: tex
	$(MAKE) trip | tail +1 >triptrap/trip.diffs
triptrap/mftrap.diffs: mf
	$(MAKE) trap | tail +1 >triptrap/mftrap.diffs
triptrap/mptrap.diffs: mpost
	$(MAKE) mptrap | tail +1 >triptrap/mptrap.diffs

tests/check.log: $(programs)
	$(MAKE) check | tail +1 >tests/check.log

dist_subdirs = doc lib mpware share tests web2c window
pre-dist-$(distname): depend triptrapdiffs tests/check.log tangleboot.p
	cd web2c && $(MAKE) lex.yy.c y_tab.c
	cd doc && $(MAKE) doc dvi

post-dist-$(distname): 
# Make the subdirectories.
#	for d in $(dist_subdirs); do \
#	  mkdir -p $(top_distdir)/$(distname)/$$d; done
# Link files in subdirectories.
#	for f in `find $(dist_subdirs)		\
#		       \(    -name README	\
#			  -o -name convert	\
#			  -o -name ChangeLog	\
#			  -o -name coerce.\*	\
#			  -o -name ref.aux	\
#			  -o -name ref.bbl	\
#			  -o -name ref.tex	\
#			  -o -name ref.txi	\
#			  -o -name texinfo.bst	\
#			  -o -name web2c.cps	\
#			  -o -name web2c.aux	\
#			  -o -name \*.asm	\
#			  -o -name '*.[chly]'	\
#			  -o -name \*.defines	\
#			  -o -name \*.in	\
#			  -o -name \*.info\*	\
#			  -o -name \*.sed	\
#			  -o -name \*.tcx	\
#			  -o -name \*.texi	\
#		       \) -print`; do		\
#	  ln $$f $(distdir)/`dirname $$f`; done
# Handle the dependeny files in the subdirectories.
#	for d in lib mpware web2c window; do \
#          cp -p $$d/depend.mk $(top_distdir)/$(distname)/$$d; done
# Other subdirectories.
#	mkdir $(distdir)/triptrap && cd $(distdir)/triptrap && \
#	  for i in ../../../triptrap/*; do \
#	    if test -f $$i; then ln -s $$i .; fi; done
#	mkdir $(distdir)/tiedir && cd $(distdir)/tiedir && \
#	  for i in ../../../tiedir/*; do \
#	    if test -f $$i; then ln -s $$i .; fi; done
#	rm -f $(distdir)/window/x11.c
#	rm -f $(distdir)/tests/patgen.in
#	cd $(distdir)/tests && (rm just.texi; ln -s ../../../tests/* .; rm -f x*)
#	cd $(distdir)/tests && ln -s $klib/bibtex/bib/xampl.bib
#	cd $(distdir)/tests && rm -f missfont.log ptmr.mpx io.tex exampl.b??
# We supply the flex/bison output in case the user can't generate them.
#	cd $(distdir)/web2c; rename 's/$$/-dist/' lex.yy.c y_tab.[ch]
# Remove cruft.
#	cd $(distdir); rm -f $(addsuffix .c, $(programs) tangleboot otangleboot)
#	cd $(distdir); rm -f $(addsuffix .h, $(programs) tangleboot otangleboot)
#	cd $(distdir); rm -f etex.ch pdftex.ch omega.ch
#	cd $(distdir); bash -c "rm -f *{coerce,d,0,1,2,extra,ini}.[ch]"
#	cd $(distdir); bash -c "rm -f tests/x* tests/allbib.{bbl,blg,dvi,log}"
#	cd $(distdir); bash -c "rm -f $(omega_files)"
#	touch $(distdir)/doc/*.info*

#web-dist:
#	rm -rf $(top_distdir)
#	mkdir -p $(distdir)
#	for f in *.web; do ln $$f $(distdir); done
#	rm -f $(distdir)/etex.web $(distdir)/omega.web $(distdir)/pdftex.web
#	cd $(distdir); bash -c "rm -f $(omega_files)"
#	chmod -w $(distdir)/*
#	GZIP=-9 tar czf web-$(version).tar.gz $(top_distdir)
#	rm -rf $(top_distdir)

#etex-dist:
#	rm -rf $(top_distdir)
#	mkdir -p $(distdir)/etexdir
#	cp -rp etexdir/* $(distdir)/etexdir
#	rm -rf $(distdir)/etexdir/CVS $(distdir)/etexdir/*/CVS
#	GZIP=-9 tar czf eweb2c-$(version).tar.gz $(top_distdir)
#	rm -rf $(top_distdir)

#omega-dist:
#	rm -rf $(top_distdir)
#	mkdir -p $(distdir)/omegadir $(distdir)/otps
#	for f in `bash -c "echo $(omega_files)"`; do ln $$f $(distdir); done
#	cp -p omegadir/* $(distdir)/omegadir
#	rm -rf $(distdir)/omegadir/CVS
#	cd otps && $(MAKE) lex.yy.c y_tab.c
#	for f in otps/*.[chly] otps/*.in; do cp -p $$f $(distdir)/otps; done
## We supply the flex/bison output in case the user can't generate them.
#	cd $(distdir)/otps; ../../../../rename 's/$$/-dist/' lex.yy.c y_tab.[ch]
#	GZIP=-9 tar czf oweb2c-$(version).tar.gz $(top_distdir)
#	rm -rf $(top_distdir)

#pdftex-dist:
#	rm -rf $(distdir)
#	mkdir -p $(distdir)/$(verpdftexdir)
#	cp -rp $(verpdftexdir)/* $(distdir)/$(verpdftexdir)
#	rm -rf $(distdir)/$(verpdftexdir)/CVS $(distdir)/$(verpdftexdir)/*/CVS
#	rm -f $(distdir)/$(verpdftexdir)/*.[oa] $(distdir)/$(verpdftexdir)/*/*.[oa]
#	rm -f $(distdir)/$(verpdftexdir)/Makefile $(distdir)/$(verpdftexdir)/*/Makefile
#	GZIP=-9 tar czf pweb2c-$(version).tar.gz $(top_distdir)
#	rm -rf $(top_distdir)
!ENDIF

!include <make/dist.mak>

!include <make/config.mak>

# 
# Testing, including triptrap. The `x' filenames are for output.
tex_check = tex-check
etex_check = etex-check
check: bibtex-check dvicopy-check dvitomp-check dvitype-check \
       $(etex_check) gftodvi-check gftopk-check gftype-check \
       mf-check mft-check mpost-check patgen-check pktogf-check \
       pktype-check pltotf-check pooltype-check $(tex_check) tftopl-check \
       vftovp-check vptovf-check weave-check

trip = trip
etrip = etrip
triptrap: $(trip) trap mptrap $(etrip)
testdir = $(srcdir)\triptrap
testenv = set TEXMFCNF=$(testdir)
dvitype_args = -output-level=2 -dpi=72.27 -page-start=*.*.*.*.*.*.*.*.*.*
trip: $(objdir)\pltotf.exe $(objdir)\tftopl.exe $(objdir)\tex.exe $(objdir)\dvitype.exe
	@echo ">>> See $(testdir)/trip.diffs for example of acceptable diffs."
	set TEXMFCNFOLD=$(TEXMFCNF)
	set TEXMFCNF=$(testdir)
	.\$(objdir)\pltotf $(testdir)/trip.pl trip.tfm
	.\$(objdir)\tftopl ./trip.tfm trip.pl
	-diff $(testdir)/trip.pl trip.pl
# get same filename in log
	$(RM) -f trip.tex & $(LN) $(testdir)\trip.tex . 
	echo $(PATH)
	-.\$(objdir)\tex -progname=initex < $(testdir)\trip1.in >tripin.fot
	$(MV) trip.log tripin.log
	-diff $(testdir)/tripin.log tripin.log
# May as well test non-ini second time through.
	-.\$(objdir)\tex < $(testdir)\trip2.in >trip.fot
	-diff $(testdir)/trip.fot trip.fot
# We use $(DIFF) instead of `diff' only for those files where there
# might actually be legitimate numerical differences.
	-$(DIFF) $(DIFFFLAGS) $(testdir)/trip.log trip.log
	-.\$(objdir)\dvitype $(dvitype_args) trip.dvi >trip.typ
	-$(DIFF) $(DIFFFLAGS) $(testdir)/trip.typ trip.typ
	set TEXMFCNF=$(TEXMFCNFOLD)

# Can't run trap and mptrap in parallel, because both write trap.{log,tfm}.
trap: $(objdir)\mf.exe $(objdir)\tftopl.exe $(objdir)\gftype.exe
	@echo ">>> See $(testdir)/mftrap.diffs for example of acceptable diffs."
	set TEXMFCNFOLD=$(TEXMFCNF)
	set TEXMFCNF=$(testdir)
	$(RM) -f trap.mf & $(LN) $(testdir)\trap.mf .
	-.\$(objdir)\mf -progname=inimf < $(testdir)\mftrap1.in > mftrapin.fot
	$(MV) trap.log mftrapin.log
	-diff $(testdir)/mftrapin.log mftrapin.log
	-.\$(objdir)\mf <$(testdir)\mftrap2.in >mftrap.fot
	$(MV) trap.log mftrap.log
	$(MV) trap.tfm mftrap.tfm
	-diff $(testdir)/mftrap.fot mftrap.fot
	-diff $(testdir)/mftrap.log mftrap.log
	.\$(objdir)\tftopl ./mftrap.tfm mftrap.pl
	-diff $(testdir)/mftrap.pl mftrap.pl
	-.\$(objdir)\gftype -m -i ./trap.72270gf >trap.typ
	-diff $(testdir)\trap.typ trap.typ
	set TEXMFCNF=$(TEXMFCNFOLD)

mptrap: $(objdir)\pltotf.exe $(objdir)\mpost.exe $(objdir)\tftopl.exe
	@echo ">>> See $(testdir)/mptrap.diffs for example of acceptable diffs." >&2
	set TEXMFCNFOLD=$(TEXMFCNF)
	set TEXMFCNF=$(testdir)
# get same filename in log
	$(RM) -f mtrap.mp & $(LN) $(testdir)\mtrap.mp .
	.\$(objdir)\pltotf $(testdir)/trapf.pl trapf.tfm
	-.\$(objdir)\mpost -progname=inimpost mtrap
	-diff $(testdir)/mtrap.log mtrap.log
	-diff $(testdir)/mtrap.0 mtrap.0
	-diff $(testdir)/mtrap.1 mtrap.1
	-diff $(testdir)/writeo writeo
	-diff $(testdir)/writeo.2 writeo.2
	$(RM) -f trap.mp & $(LN) $(testdir)\trap.mp .
	$(RM) -f trap.mpx & $(LN) $(testdir)\trap.mpx .
	-.\$(objdir)\mpost -progname=inimpost<$(testdir)\mptrap1.in >mptrapin.fot
	-$(MV) trap.log mptrapin.log
	-diff $(testdir)/mptrapin.log mptrapin.log
# Must run inimp or font_name[null_font] is not initialized, leading to diffs.
	-.\$(objdir)\mpost -progname=inimpost<$(testdir)\mptrap2.in >mptrap.fot
	-$(MV) trap.log mptrap.log
	-$(MV) trap.tfm mptrap.tfm
	-diff $(testdir)/mptrap.fot mptrap.fot
	-diff $(testdir)/mptrap.log mptrap.log
	-diff $(testdir)/trap.5 trap.5
	-diff $(testdir)/trap.6 trap.6
	-diff $(testdir)/trap.148 trap.148
	-diff $(testdir)/trap.149 trap.149
	-diff $(testdir)/trap.150 trap.150
	-diff $(testdir)/trap.151 trap.151
	-diff $(testdir)/trap.197 trap.197
	-diff $(testdir)/trap.200 trap.200
	.\$(objdir)\tftopl ./mptrap.tfm mptrap.pl
	-diff $(testdir)/mptrap.pl mptrap.pl
	set TEXMFCNF=$(TEXMFCNFOLD)

# Ad hoc tests.
bibtex-check: $(objdir)\bibtex.exe
#	if EXIST tests\exampl.aux $(CP) $(srcdir)\tests\exampl.aux tests\exampl.aux
	@set BSTINPUTS=$(srcdir)\tests 
	.\$(objdir)\bibtex tests\exampl
	@set BSTINPUTS=

dvicopy-check: $(objdir)\dvicopy.exe
	.\$(objdir)\dvicopy $(srcdir)\tests\story tests\xstory.dvi
# Redirect stderr so the terminal output will end up in the log file.
	@set TFMFONTS=$(srcdir)/tests;
	.\$(objdir)\dvicopy < $(srcdir)\tests\pplr.dvi > tests\xpplr.dvi
	@set TFMFONTS=

dvitomp-check: $(objdir)\dvitomp.exe
	set TFMFONTS=$(srcdir)/tests;$(texmf)/fonts/tfm//
	set VFFONTS=$(srcdir)/tests;$(texmf)/fonts/vf//
	.\$(objdir)\dvitomp $(srcdir)\tests\story.dvi tests\xstory.mpx
	.\$(objdir)\dvitomp $(srcdir)\tests\ptmr
	$(MV) ptmr.mpx tests\xptmr.mpx

dvitype-check: $(objdir)\dvitype.exe
	.\$(objdir)\dvitype -show-opcodes $(srcdir)\tests\story >tests\xstory.dvityp
	.\$(objdir)\dvitype --p=*.*.2 $(srcdir)\tests\pagenum.dvi >tests\xpagenum.typ

gftodvi-check: $(objdir)\gftodvi.exe
	set TFMFONTS=$(srcdir)/tests;$(texmf)/fonts/tfm//
	.\$(objdir)\gftodvi -verbose $(srcdir)/tests/cmr10.600gf
	$(MV) cmr10.dvi tests\xcmr10.dvi

gftopk-check: $(objdir)\gftopk.exe
	.\$(objdir)\gftopk -verbose $(srcdir)\tests\cmr10.600gf tests\xcmr10.600pk
	.\$(objdir)\gftopk $(srcdir)\tests\cmr10.600gf cmr10.pk & rm cmr10.pk

gftype-check: $(objdir)\gftype.exe
	.\$(objdir)\gftype $(srcdir)\tests\cmr10.600gf >tests\xcmr10.gft1
	.\$(objdir)\gftype -m -i $(srcdir)\tests\cmr10.600gf >tests\xcmr10.gft2

mf-check: trap mf.base
	.\$(objdir)\mf "&./mf \tracingstats:=1; end."
	.\$(objdir)\mf "&./mf $(srcdir)\tests\online"
	.\$(objdir)\mf "&./mf $(srcdir)\tests\one.two"
	.\$(objdir)\mf "&./mf $(srcdir)\tests\uno.dos"

mft-check: $(objdir)\mft.exe
	.\$(objdir)\mft $(srcdir)/tests/io & $(MV) io.tex tests\io.tex

mpost-check: mptrap mpost.mem
	.\$(objdir)\mpost "&./mpost \tracingstats:=1 ; end." & cd..
	set TFMFONTS=$(srcdir)/tests;$(texmf)/fonts/tfm//
	set MAKEMPX_BINDIR=.;..\contrib\$(objdir)
	set MPXCOMMAND=..\contrib\$(objdir)\makempx.exe
	.\$(objdir)\mpost $(srcdir)/tests/mptest
	set MAKEMPX_BINDIR=
	set MPXCOMMAND=
	.\$(objdir)\mpost $(srcdir)\tests\one.two
	.\$(objdir)\mpost $(srcdir)\tests\uno.dos

patgen-check: $(objdir)\patgen.exe
	.\$(objdir)\patgen $(srcdir)/tests/dict $(srcdir)/tests/patterns \
	 $(srcdir)/tests/xout $(srcdir)/tests/translate <$(srcdir)/tests/patgen.in

pktogf-check: $(objdir)\pktogf.exe
	.\$(objdir)\pktogf -verbose $(srcdir)\tests\cmr10.pk tests\xcmr10.600gf
	.\$(objdir)\pktogf $(srcdir)\tests\cmr10.pk & rm cmr10.gf

pktype-check: $(objdir)\pktype.exe
	.\$(objdir)\pktype $(srcdir)\tests\cmr10.pk >tests\xcmr10.pktyp

pltotf-check: $(objdir)\pltotf.exe
	.\$(objdir)\pltotf -verbose $(srcdir)\tests\cmr10 tests\xcmr10

# When tex.pool has not been generated we pooltype etex.pool
pooltype-check: $(objdir)\pooltype.exe
	.\$(objdir)\pooltype tex.pool >tests\xtexpool.typ
# FIXME: etex compatible mode
#	.\$(objdir)\pooltype etex.pool >tests\xtexpool.typ

# No need for tangle-check, since we run it to make everything else.

outcom = "Here are some things left to do.  If you would like to contribute, send mail to me (kb@mail.tug.org) first."

tex-check: trip tex.fmt
# Test truncation (but don't bother showing the warning msg).
	.\$(objdir)\tex --output-comment=$(outcom) $(srcdir)/tests/hello > nul \
	  & .\$(objdir)\dvitype hello.dvi | grep kb@mail.tug.org > nul
# \openout should show up in \write's.
	.\$(objdir)\tex $(srcdir)/tests/openout
	grep xfoo openout.log
# one.two.tex -> one.two.log
	.\$(objdir)\tex $(srcdir)/tests/one.two
	dir one.two.log
# uno.dos -> uno.log
	.\$(objdir)\tex $(srcdir)/tests/uno.dos
	dir uno.log
	.\$(objdir)\tex $(srcdir)/tests/just.texi
	dir just.log
	-.\$(objdir)\tex $(srcdir)/tests/batch.tex
	.\$(objdir)\tex --shell $(srcdir)/tests/write18 | grep echo
# tcx files test (to be included)
#	.\$(objdir)\tex --translate-file=$(srcdir)/share/isol1-t1.tcx tests/eight
#	.\$(objdir)\dvitype eight.dvi > eigh.typ
	.\$(objdir)\tex --mltex --progname=initex $(srcdir)/tests/mltextst
#	-.\$(objdir)\tex <nul
	set PATH=$(kpathsea_dir);$(kpathsea_srcdir);$(PATH)
	set WEB2C=$(kpathsea_srcdir)
	set TMPDIR=..
	-.\$(objdir)\tex "\nonstopmode\font\foo=nonesuch\end"

tftopl-check: $(objdir)\tftopl.exe
	.\$(objdir)\tftopl -verbose $(srcdir)\tests\cmr10 tests\xcmr10

vftovp-check: $(objdir)\vftovp.exe
	set TFMFONTS=$(srcdir)/tests;$(texmf)/fonts/tfm//
	.\$(objdir)\vftovp -verbose $(srcdir)\tests\ptmr ptmr tests\xptmr
	set TFMFONTS=

vptovf-check: $(objdir)\vptovf.exe
	.\$(objdir)\vptovf $(srcdir)\tests\ptmr $(srcdir)\tests\xptmr $(srcdir)\tests\xptmr

weave-check: $(objdir)\weave.exe
	.\$(objdir)\weave $(srcdir)\pooltype

installcheck:
	cd $(srcdir)\tests &  bibtex allbib & cd..
	mf "\mode:=ljfour; input logo10" & tftopl logo10.tfm >nul
	tex "\nonstopmode \tracingstats=1 \input story \bye"

# 
# Cleaning.
$(verpdftexdir) = $(verpdftexdir)
otps = otps
omegafonts = omegafonts
all_subdirs = doc lib man mpware web2c window $(otps) $(omegafonts) $(verpdftexdir) $(verpdfetexdir)

# Having a multiple-target rule with the subdir loop fails because of
# the dependencies introduced by clean.mk.  Yet, we want the
# dependencies here at the top level so that distclean will run the
# clean rules, etc.  So, sigh, put the subdir loop in each target and
# only run it if we have a Makefile.  Alternatively, we could do as
# Automake does.

mostlyclean::
	-@echo $(verbose) & for %%d in ($(all_subdirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) -$(MAKEFLAGS) $@ & popd
	-@$(RM) $(objdir)\otangleboot.exe $(objdir)\tangleboot.exe
clean::
	-@echo $(verbose) & for %%d in ($(all_subdirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) -$(MAKEFLAGS) $@ & popd
	-@$(RM) *.aux *.c *.dvi *.fot *.log *.pl *.tfm *.typ 
	-@$(RM) *.base *.fmt *.efmt *.mem
	-@$(RM) -rf tfm
# Have to list generated .h's explicitly since our real headers,
# e.g., help.h, are in this directory too.
	-@$(RM) *coerce.h *d.h bibtex.h dvicopy.h dvitomp.h dvitype.h gftodvi.h 
	-@$(RM) gftopk.h gftype.h  mft.h  odvicopy.h odvitype.h
	-@$(RM) otangle.h patgen.h pktogf.h
	-@$(RM) pktype.h pltotf.h pooltype.h tangle.h tftopl.h vftovp.h 
	-@$(RM) vptovf.h weave.h
# Cleanup from triptrap.
	-@$(RM) trip.tex trap.mf mtrap.mp trap.mp trap.mpx
	-@$(RM) trip.* tripin.* tripos.tex 8terminal.tex
	-@$(RM) trap.* mftrap.* mftrapin.* mptrap.* mptrapin.*
	-@$(RM) trapf.* mtrap.* writeo* missfont.log
distclean::
	-@echo $(verbose) & for %%d in ($(all_subdirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) -$(MAKEFLAGS) $@ & popd
	-@$(RM) *.pool *extra.c *.fm
# Have to list .p's explicitly because we can't remove tangleboot.p.
	-@$(RM) bibtex.p dvicopy.p dvitomp.p dvitype.p etex.p gftodvi.p gftopk.p
	-@$(RM) gftype.p mf.p mft.p mp.p odvicopy.p odvitype.p omega.p
	-@$(RM) otangle.p patgen.p pdftex.p pdfetex.p
	-@$(RM) pktogf.p pktype.p pltotf.p pooltype.p tangle.p tex.p tftopl.p
	-@$(RM) vftovp.p vptovf.p weave.p
	-@$(RM) otangleboot.c otangleboot.h tangleboot.c tangleboot.h
# And we clean up generated web and change files.
	-@$(RM) etex.web omega.web pdftex.web pdfetex.web
	-@$(RM) etex.ch  omega.ch  pdftex.ch pdfetex.ch
	-@$(RM) odvicopy.web odvitype.web otangle.web
	-@$(RM) odvicopy.ch  odvitype.ch  otangle.ch 
# And some miscellaneous files
	-@$(RM) mf-web2c.ch mp-web2c.ch tex-web2c.ch
	-@$(RM) etrip.tex otangleboot.p omega.c omegamem.h
	-@$(RM) macnames.c ttf2afm.c
	-@$(RM) c-auto.h tiedir\tie.ps
	-@echo $(verbose) & echo Entering $(XPDFDIR) \
	& pushd $(XPDFDIR) & $(RM) .\pdftoepdf.cc .\epdf.h .\config.log .\config.status & popd
	-@$(RM) fmtutil.cnf

extraclean::
	-@echo $(verbose) & for %%d in ($(all_subdirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) -$(MAKEFLAGS) $@ & popd
# Remove triptrap junk here too.
	-@$(RM) trip.tex trap.mf mtrap.mp trap.mp trap.mpx
	-@$(RM) trip.* tripin.* tripos.tex 8terminal.tex
	-@$(RM) trap.* mftrap.* mftrapin.* mptrap.* mptrapin.*
	-@$(RM) trapf.* mtrap.* writeo* missfont.log
	-@$(RM) *.out *.typ *.fot
# And etrip junk as well.
	-@$(RM) etrip.tex
	-@$(RM) etrip.* etripin.*
maintainer-clean::
	-@echo $(verbose) & for %%d in ($(all_subdirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) -$(MAKEFLAGS) $@ & popd

!include <make/clean.mak>

!ifdef MAINT
depend:: c-sources
	for %%i in (lib mpware web2c window pdftexdir $(otps)) do \
	  pushd %%i & $(MAKE) depend & popd
!endif

!include <make/rdepend.mak>
!include "./depend.mak"

#  
# Local variables:
# page-delimiter: "^# \f"
# mode: Makefile
# End:
